/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.home.operate;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.PollAwsFpyService;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.lang3.StringUtils;

public class WXCardOperateService
extends AbstractOperateService {
    private static Log logger = LogFactory.getLog(WXCardOperateService.class);

    public WXCardOperateService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        Map<String, Object> params = this.getCustomParams();
        String indexPageId = (String)params.get("indexPageId");
        Long orgId = BigDecimalUtil.transDecimal((Object)params.get("orgId")).longValue();
        MobileFormShowParameter frameParameter = new MobileFormShowParameter();
        frameParameter.setFormId("rim_mobile_iframe");
        frameParameter.getOpenStyle().setShowType(ShowType.Floating);
        frameParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "rim_mobile_iframe"));
        String wxUrl = this.getWxMiniScheme(indexPageId, orgId);
        String framePageId = frameParameter.getPageId();
        this.plugin.getPageCache().put("frame_page_id", framePageId);
        if (StringUtils.isEmpty((CharSequence)wxUrl)) {
            return;
        }
        logger.info("\u5fae\u4fe1\u5361\u5305\u9996\u9875pageId" + indexPageId);
        frameParameter.setCustomParam("url", (Object)wxUrl);
        this.plugin.getView().showForm((FormShowParameter)frameParameter);
    }

    private String getWxMiniScheme(String indexPageId, Long orgId) {
        if (StringUtils.isEmpty((CharSequence)indexPageId)) {
            indexPageId = this.plugin.getView().getPageId();
        }
        String linkKey = WXCardOperateService.getIndexWebsocketId(indexPageId);
        String socketVersion = "2";
        socketVersion = "1";
        String wxMiniUrl = CacheHelper.get((String)linkKey);
        if (StringUtils.isEmpty((CharSequence)wxMiniUrl)) {
            AwsFpyService service = AwsFpyService.newInstance();
            RequestContext request = RequestContext.get();
            if (orgId < 1L) {
                orgId = request.getOrgId();
            }
            String webSocketId = linkKey.substring(0, linkKey.length() - 2);
            JSONObject config = service.getAwsConfig(orgId);
            String timestamp = String.valueOf(System.currentTimeMillis());
            String sign = MD5.md5Hex((String)(config.getString("client_id") + config.getString("client_secret") + timestamp));
            JSONObject map = new JSONObject();
            map.put("tin", (Object)TenantUtils.getTaxNoByOrgId((Long)orgId));
            map.put("eid", (Object)request.getUserId());
            map.put("client_id", (Object)config.getString("client_id"));
            map.put("sign", (Object)sign);
            map.put("timestamp", (Object)timestamp);
            map.put("linkKey", (Object)webSocketId);
            map.put("random", (Object)System.currentTimeMillis());
            map.put("billNumber", (Object)webSocketId);
            map.put("bxd_key", (Object)webSocketId);
            map.put("ticketParam", (Object)"00000");
            String url = service.getUrl("get_user_key");
            JSONObject userKeyResult = null;
            try {
                userKeyResult = service.postAppJson(url, map.toJSONString());
            }
            catch (IOException e) {
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25:%1$s", (String)"WXCardOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
                return wxMiniUrl;
            }
            String reqUrl = service.getUrl("get_url_scheme");
            StringBuilder sb = new StringBuilder();
            sb.append(reqUrl);
            sb.append("?sourceType=2&socketVersion=").append(socketVersion);
            sb.append("&pushData=1&linkKey=").append(webSocketId);
            if (ResultContant.isSuccess((JSONObject)userKeyResult).booleanValue()) {
                JSONObject wxMiniResult;
                JSONObject userKeyResultData = userKeyResult.getJSONObject("data");
                if (userKeyResultData == null) {
                    return wxMiniUrl;
                }
                String userKey = userKeyResultData.getString("userKey");
                sb.append("&userKey=").append(userKey);
                logger.info("showMiniUrl:{}", (Object)sb);
                try {
                    wxMiniResult = service.getAppJson(sb.toString());
                    logger.info("showMiniUrl-result:{}", (Object)wxMiniResult);
                }
                catch (IOException e) {
                    this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u5730\u5740\u5931\u8d25:%1$s", (String)"WXCardOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
                    return wxMiniUrl;
                }
                if (wxMiniResult == null) {
                    this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u5730\u5740\u5931\u8d25", (String)"WXCardOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return wxMiniUrl;
                }
                JSONObject wxMiniResultData = wxMiniResult.getJSONObject("data");
                if (wxMiniResultData == null) {
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u5730\u5740\u5931\u8d25", (String)"WXCardOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return wxMiniUrl;
                }
                wxMiniUrl = wxMiniResultData.getString("miniUrlLink");
                if (StringUtils.isEmpty((CharSequence)wxMiniUrl)) {
                    this.plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u5730\u5740\u5931\u8d25\uff1a%1$s", (String)"WXCardOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), wxMiniResult.getString("description")));
                    return wxMiniUrl;
                }
                CacheHelper.put((String)linkKey, (String)wxMiniUrl, (int)600);
                PollAwsFpyService pollService = new PollAwsFpyService();
                pollService.receive(config, indexPageId, linkKey);
            } else {
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25:%1$s", (String)"WXCardOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), userKeyResult.toJSONString()));
            }
        }
        return wxMiniUrl;
    }

    private String buildWxCardUrl(JSONObject config) {
        AwsFpyService service = AwsFpyService.newInstance();
        RequestContext request = RequestContext.get();
        long orgId = request.getOrgId();
        if (orgId < 1L) {
            orgId = request.getOrgId();
        }
        String pageId = this.plugin.getView().getPageId();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5Hex((String)(config.getString("client_id") + config.getString("client_secret") + timestamp));
        JSONObject map = new JSONObject();
        map.put("tin", (Object)TenantUtils.getTaxNoByOrgId((Long)orgId));
        map.put("eid", (Object)request.getUserId());
        map.put("client_id", (Object)config.getString("client_id"));
        map.put("sign", (Object)sign);
        map.put("timestamp", (Object)timestamp);
        map.put("random", (Object)System.currentTimeMillis());
        map.put("ticketParam", (Object)"00000");
        map.put("billNumber", (Object)pageId);
        map.put("bxd_key", (Object)pageId);
        String url = service.getUrl("get_user_key");
        JSONObject userKeyResult = null;
        try {
            userKeyResult = service.postAppJson(url, map.toJSONString());
        }
        catch (Exception e) {
            this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25:%1$s", (String)"WXCardOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
            return "";
        }
        if (!ResultContant.isSuccess((JSONObject)userKeyResult).booleanValue()) {
            if (userKeyResult == null) {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25", (String)"WXCardOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25:%1$s", (String)"WXCardOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), userKeyResult.getString("description")));
            }
            return "";
        }
        String baseUrl = service.getBaseUrl();
        if (baseUrl.contains("api-sit")) {
            baseUrl = baseUrl.concat("test");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl).append("/m4-web/thirdApp/wap/getTicket");
        String userKey = userKeyResult.getJSONObject("data").getString("userKey");
        sb.append("?userKey=").append(userKey);
        return sb.toString();
    }
}

