/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.mailcollect;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.utils.AwsFpyService;
import org.apache.commons.lang.StringUtils;

public class BindMailPlugin
extends AbstractFormPlugin
implements CountDownListener {
    private static Log LOGGER = LogFactory.getLog(BindMailPlugin.class);
    private static final String RIM_MOBILE_BIND_MAIL = "rim_mobile_bind_mail";
    private static final String SEND_CODE = "send_code";
    private static final String BIND_BUTTON = "bind_button";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SEND_CODE, BIND_BUTTON});
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.addCountDownListener((CountDownListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"countdownap"});
    }

    public void onCountDownEnd(CountDownEvent evt) {
        this.getView().setVisible(Boolean.TRUE, new String[]{SEND_CODE});
        this.getView().setVisible(Boolean.FALSE, new String[]{"countdownap"});
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Control control = (Control)eventObject.getSource();
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String openId = (String)parentCustomParams.get("openId");
        String showAttach = (String)parentCustomParams.get("showAttach");
        JSONObject awsConfig = AwsFpyService.newInstance().getAwsConfig(Long.valueOf(RequestContext.get().getOrgId()));
        String clientId = awsConfig.getString("client_id");
        String mailForwardFlag = (String)parentCustomParams.get("mailForwardFlag");
        if (StringUtils.equals((String)control.getKey(), (String)SEND_CODE)) {
            String mailUser = (String)this.getModel().getValue("mail_address");
            JSONObject msg = this.checkMailAddressValid(mailUser);
            if (msg != null) {
                this.getView().showErrorNotification(msg.getString("msg"));
                return;
            }
            JSONObject param = new JSONObject();
            param.put("mailUser", (Object)mailUser);
            param.put("openId", (Object)openId);
            param.put("clientId", (Object)clientId);
            JSONObject resData = AwsFpyService.newInstance().postAppJson("send_verify_code", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
            LOGGER.info("\u79fb\u52a8\u7aef\u53d1\u9001\u9a8c\u8bc1\u7801\u8fd4\u56de\u4fe1\u606f\uff1a" + resData);
            if (ResultContant.isSuccess((JSONObject)resData).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"BindMailPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{"countdownap"});
                CountDown countdown = (CountDown)this.getView().getControl("countdownap");
                countdown.setDuration(60);
                countdown.start();
                this.getView().setVisible(Boolean.FALSE, new String[]{SEND_CODE});
            } else if (resData != null) {
                this.getView().showErrorNotification(resData.getString("description"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u53d1\u9001\u9a8c\u8bc1\u7801\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"BindMailPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((String)control.getKey(), (String)BIND_BUTTON)) {
            String verifyCode = (String)this.getModel().getValue("verifycode");
            this.checkVerifyCodeValid(verifyCode);
            String mailUser = (String)this.getModel().getValue("mail_address");
            JSONObject msg = this.checkMailAddressValid(mailUser);
            if (msg != null) {
                this.getView().showErrorNotification(msg.getString("msg"));
                return;
            }
            JSONObject param = new JSONObject();
            param.put("mailUser", (Object)mailUser);
            param.put("openId", (Object)openId);
            param.put("verifyCode", (Object)verifyCode);
            JSONObject resData = AwsFpyService.newInstance().postAppJson("bind_mail", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
            if (ResultContant.isSuccess((JSONObject)resData).booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed1\u5b9a\u6210\u529f", (String)"BindMailPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                if (StringUtils.isEmpty((String)mailForwardFlag)) {
                    this.getView().close();
                    return;
                }
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("rim_mobile_mail_collect2");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap customParams = Maps.newHashMap();
                customParams.put("openId", openId);
                customParams.put("showAttach", showAttach);
                showParameter.setCustomParams((Map)customParams);
                this.getView().showForm((FormShowParameter)showParameter);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(resData.getString("description"));
            }
        }
    }

    private void checkVerifyCodeValid(String verifycode) {
        if (StringUtils.isEmpty((String)verifycode)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u9519\u8bef", (String)"BindMailPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private JSONObject checkMailAddressValid(String mailUser) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isEmpty((String)mailUser)) {
            jsonObject.put("errcode", (Object)"0001");
            jsonObject.put("msg", (Object)ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u90ae\u7bb1\u5730\u5740", (String)"BindMailPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return jsonObject;
        }
        String check = "^[a-z0-9]+([._\\-]*[a-z0-9])*@([a-z0-9]+[-a-z0-9]*[a-z0-9]+.){1,63}[a-z0-9]+$";
        if (!Pattern.matches(check, mailUser)) {
            jsonObject.put("errcode", (Object)"0002");
            jsonObject.put("msg", (Object)ResManager.loadKDString((String)"\u90ae\u7bb1\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BindMailPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return jsonObject;
        }
        return null;
    }
}

