/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.mailcollect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.h5.H5InvoiceListService;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.MobileIndexMinUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.lang.StringUtils;

public class MailInvoiceCollectPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
PullRefreshListener,
EntryGridBindDataListener,
ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(MailInvoiceCollectPlugin.class);
    public static final String MY_MAIL = "my_mail";
    public static final String QUERY_PROGRESS = "query_progress";
    public static final String QUERY_FAILTASK = "query_failtask";
    public static final String CONFIRM_ADD = "confirm_add";
    public static final String CHOOSE_ALL = "all_btn";
    public static final String CHOOSE_NOT_ALL = "not_all_btn";
    public static final String DONEENTRY = "doneentry";
    public static final String CHOOSECARD = "cardentryflexpanelap21";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(DONEENTRY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addPullRefreshlisteners((PullRefreshListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
        this.addClickListeners(new String[]{CONFIRM_ADD, CHOOSE_ALL, CHOOSE_NOT_ALL, CHOOSECARD});
        Label myMail = (Label)this.getControl(MY_MAIL);
        myMail.addClickListener((ClickListener)this);
        Label queryProgress = (Label)this.getControl(QUERY_PROGRESS);
        queryProgress.addClickListener((ClickListener)this);
        Label failTask = (Label)this.getControl(QUERY_FAILTASK);
        failTask.addClickListener((ClickListener)this);
        ProgressBar pb = (ProgressBar)this.getControl("probarupdateclass");
        if (pb != null) {
            pb.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"MailInvoiceCollectPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        this.getView().setVisible(Boolean.FALSE, new String[]{CHOOSE_ALL});
        this.getView().setVisible(Boolean.TRUE, new String[]{CHOOSE_NOT_ALL});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51"});
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String openId = (String)parentCustomParams.get("openId");
        if (StringUtils.isEmpty((String)openId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237OpenId\u4e3a\u7a7a", (String)"MailInvoiceCollectPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().getPageCache().put("openId", openId);
        long startTime = System.currentTimeMillis();
        this.initAll(openId);
        long endTime = System.currentTimeMillis();
        LOGGER.info("\u90ae\u7bb1\u53d6\u7968\u9875\u9762\u521d\u59cb\u5316\u603b\u8017\u65f6\uff1a" + (endTime - startTime));
        this.getView().hideLoading();
    }

    private void initAll(String openId) {
        JSONObject awsConfig = AwsFpyService.newInstance().getAwsConfig(Long.valueOf(RequestContext.get().getOrgId()));
        if (awsConfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"awsConfig\u914d\u7f6e\u4e3a\u7a7a", (String)"MailInvoiceCollectPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String clientId = awsConfig.getString("client_id");
        this.initHead(openId, clientId);
        this.initMailInvoiceTask(openId, clientId);
    }

    private void initMailInvoiceTask(String openId, String clientId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51"});
        this.getModel().deleteEntryData(DONEENTRY);
        JSONObject param = new JSONObject();
        param.put("openId", (Object)openId);
        param.put("clientId", (Object)clientId);
        param.put("taskStatus", (Object)"4");
        long startTime = System.currentTimeMillis();
        JSONObject resData = AwsFpyService.newInstance().postAppJson("mail_task", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
        LOGGER.info("\u90ae\u7bb1\u53d6\u7968\u7ed3\u679c\uff1a" + resData);
        long endTime = System.currentTimeMillis();
        LOGGER.info("\u90ae\u7bb1\u53d6\u7968\u8c03\u7528\u53d1\u7968\u4e91\u4efb\u52a1\u63a5\u53e3\u8017\u65f6\uff1a" + (endTime - startTime));
        if (ResultContant.isSuccess((JSONObject)resData).booleanValue()) {
            Label label;
            JSONObject taskResult = resData.getJSONObject("data");
            JSONArray runningArray = taskResult.getJSONArray("runningInfo");
            JSONArray failArray = taskResult.getJSONArray("failInfo");
            JSONArray invoiceArray = taskResult.getJSONArray("finishInfo");
            if (!ObjectUtils.isEmpty((Object)runningArray)) {
                this.getView().getPageCache().put("runningTask" + openId, runningArray.toJSONString());
                int runningNum = runningArray.size();
                label = (Label)this.getControl(QUERY_PROGRESS);
                label.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6709%1$s\u5c01\u90ae\u4ef6\u6b63\u5728\u5904\u7406\uff0c\u70b9\u51fb\u67e5\u770b", (String)"MailInvoiceCollectPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]), runningNum));
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
            } else {
                Label label2 = (Label)this.getControl(QUERY_PROGRESS);
                label2.setText(ResManager.loadKDString((String)"\u6682\u65e0\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1", (String)"MailInvoiceCollectPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
                this.getView().getPageCache().remove("runningTask" + openId);
            }
            if (!ObjectUtils.isEmpty((Object)failArray)) {
                this.getView().getPageCache().put("failTask" + openId, failArray.toJSONString());
                int failNum = failArray.size();
                label = (Label)this.getControl(QUERY_FAILTASK);
                label.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6709%1$s\u5c01\u90ae\u4ef6\u5904\u7406\u5931\u8d25\uff0c\u70b9\u51fb\u67e5\u770b", (String)"MailInvoiceCollectPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]), failNum));
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap51"});
            } else {
                this.getView().getPageCache().remove("failTask" + openId);
                Label label3 = (Label)this.getControl(QUERY_FAILTASK);
                label3.setText(ResManager.loadKDString((String)"\u6682\u65e0\u5931\u8d25\u7684\u4efb\u52a1", (String)"MailInvoiceCollectPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51"});
            }
            if (!ObjectUtils.isEmpty((Object)invoiceArray)) {
                LOGGER.info("\u90ae\u7bb1\u53d6\u7968\u5df2\u5b8c\u6210\u6570\u636e\uff1a" + invoiceArray.size() + "," + invoiceArray);
                Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < invoiceArray.size(); ++i) {
                    JSONObject invoice = invoiceArray.getJSONObject(i);
                    if (ObjectUtils.isEmpty((Object)invoice)) continue;
                    String indexPageId = (String)parentCustomParams.get("indexPageId");
                    JSONObject businessParam = FpzsMainService.getBusinessParam((String)indexPageId, (String)CollectTypeEnum.H5_MAIL.getCode());
                    businessParam.put("resource", (Object)ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u90ae\u7bb1\u53d6\u7968", (String)"MailInvoiceCollectPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    invoice.putAll((Map)businessParam);
                    String verifySaveFlag = RimConfigUtils.getConfig((String)"verify_save");
                    if ("0".equals(verifySaveFlag)) {
                        invoice.put("delete", (Object)"2");
                    }
                    try {
                        InvoiceSaveResult result = this.saveInvoice(invoice);
                        invoice.put("id", result.getMainId());
                        invoice.put("serial_no", (Object)result.getSerialNo());
                        continue;
                    }
                    catch (MsgException e) {
                        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u53d1\u7968\u5904\u7406\u5931\u8d25:%2$s", (String)"MailInvoiceCollectPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0]), i + 1, e.getMessage());
                        sb.append(msg).append(';');
                    }
                }
                if (sb.length() > 0) {
                    this.getView().showTipNotification(sb.toString());
                }
                H5InvoiceListService h5InvoiceListService = new H5InvoiceListService((AbstractFormPlugin)this, DONEENTRY, "");
                List invoiceList = h5InvoiceListService.arrayToListMap(invoiceArray, Boolean.TRUE);
                h5InvoiceListService.setInvoiceData(invoiceList);
                h5InvoiceListService.fillEntryEntity();
            }
        } else {
            if (!StringUtils.isEmpty((String)resData.getString("description"))) {
                this.getView().showErrorNotification(resData.getString("description"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90ae\u4ef6\u9644\u4ef6\u8d85\u51fa\u5927\u5c0f\uff0c\u4e0d\u89e3\u6790", (String)"MailInvoiceCollectPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            return;
        }
    }

    private InvoiceSaveResult saveInvoice(JSONObject invoiceInfo) {
        InvoiceSaveResult result = new InvoiceSaveResult();
        String awsInvoiceType = invoiceInfo.getString("invoiceType");
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)awsInvoiceType);
        InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)awsInvoiceType);
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("downloadUrl"))) {
            invoiceInfo.put("downloadUrl", (Object)invoiceInfo.getString("downloadUrl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("pdfurl"))) {
            invoiceInfo.put("pdfurl", (Object)invoiceInfo.getString("pdfurl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("ofdUrl"))) {
            invoiceInfo.put("ofdUrl", (Object)invoiceInfo.getString("ofdUrl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("snapshotUrl"))) {
            invoiceInfo.put("snapshotUrl", (Object)invoiceInfo.getString("snapshotUrl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("kdcloudUrl"))) {
            invoiceInfo.put("kdcloudUrl", (Object)invoiceInfo.getString("kdcloudUrl").replace("https", "http"));
        }
        if (!InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            result = invoiceSaveService.save(invoiceInfo);
        }
        return result;
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
        String allowFlag = CacheHelper.get((String)("allowFlag" + this.getView().getPageId()));
        if (StringUtils.isEmpty((String)allowFlag)) {
            CacheHelper.put((String)("allowFlag" + this.getView().getPageId()), (String)"1", (int)30);
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            String openId = (String)parentCustomParams.get("openId");
            this.initAll(openId);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String pageId = this.getView().getPageId();
        String mailCardLock = CacheHelper.get((String)("mailCardLock" + pageId));
        if (StringUtils.isEmpty((String)mailCardLock)) {
            CacheHelper.put((String)("mailCardLock" + pageId), (String)(row + ""), (int)1);
            CardEntry cardEntry = (CardEntry)this.getView().getControl(DONEENTRY);
            int[] selectRows = cardEntry.getSelectRows();
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 0; i < selectRows.length; ++i) {
                BigDecimal childNum = BigDecimal.ZERO;
                if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("total_amount", selectRows[i]))) {
                    childNum = (BigDecimal)this.getModel().getValue("total_amount", selectRows[i]);
                }
                sum = sum.add(childNum);
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumFractionDigits(2);
            String format = nf.format(sum);
            Label invoice_num = (Label)this.getControl("invoice_num");
            Label sum_amount = (Label)this.getControl("sum_amount");
            invoice_num.setText(selectRows.length + "");
            sum_amount.setText("\uffe5" + format);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            String showAttach = null;
            if (params != null) {
                showAttach = (String)params.get("showAttach");
            }
            HashMap customParams = Maps.newHashMap();
            boolean allowEdit = false;
            boolean allowDel = false;
            String mainId = (String)this.getModel().getValue("id", row);
            customParams.put("allowEdit", allowEdit);
            customParams.put("allowDel", allowDel);
            customParams.put("mainIds", mainId);
            customParams.put("showAttach", showAttach);
            customParams.put("row", row);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_h5_inv_update");
            H5PluginService.setCommonParam((Map)customParams, (Map)this.getView().getFormShowParameter().getCustomParams());
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams((Map)customParams);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        e.getRows().stream().forEach(row -> {
            int rowIndex = row.getRowIndex();
            DynamicObject dynamicObject = row.getDataEntity();
            H5InvoiceListService h5InvoiceListSevice = new H5InvoiceListService((AbstractFormPlugin)this, DONEENTRY, "");
            String invoiceInfoStr = dynamicObject.getString("invoice_info");
            JSONObject invoiceInfoJson = JSONObject.parseObject((String)invoiceInfoStr);
            Map invoice = invoiceInfoJson.getInnerMap();
            h5InvoiceListSevice.setTag(invoice, rowIndex);
        });
    }

    private void initHead(String openId, String clientId) {
        this.getView().getPageCache().remove("myMail" + openId);
        Label label = (Label)this.getControl(MY_MAIL);
        JSONObject param = new JSONObject();
        param.put("openId", (Object)openId);
        param.put("clientId", (Object)clientId);
        param.put("clientType", (Object)"2");
        JSONObject resData = AwsFpyService.newInstance().postAppJson("mymail_list", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
        LOGGER.info("\u6211\u7684\u90ae\u7bb1\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:" + resData);
        if (ResultContant.isSuccess((JSONObject)resData).booleanValue()) {
            JSONArray mailList = resData.getJSONArray("data");
            if (ObjectUtils.isEmpty((Object)mailList)) {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("rim_mobile_bind_mail");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap customParams = Maps.newHashMap();
                customParams.put("openId", openId);
                showParameter.setCustomParams((Map)customParams);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "freshAll");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().getPageCache().put("myMail" + openId, mailList.toJSONString());
                JSONObject mailInfo = (JSONObject)mailList.get(0);
                String defaultMail = mailInfo.getString("mailUser");
                label.setText(defaultMail);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("import".equals(closedCallBackEvent.getReturnData()) || "cancel".equals(closedCallBackEvent.getReturnData())) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((String)actionId, (String)"freshAll")) {
            String openId = this.getView().getPageCache().get("openId");
            this.initAll(openId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"choose_all")) {
            Boolean allCheckValue = (Boolean)this.getModel().getValue("choose_all");
            if (allCheckValue.booleanValue()) {
                this.choiceAll();
            } else {
                this.cancelAll();
            }
        }
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Control control = (Control)eventObject.getSource();
        String openId = this.getView().getPageCache().get("openId");
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        if (StringUtils.equals((String)control.getKey(), (String)CHOOSECARD)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(DONEENTRY);
            int[] selectRows = cardEntry.getSelectRows();
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 0; i < selectRows.length; ++i) {
                BigDecimal childNum = BigDecimal.ZERO;
                if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("total_amount", selectRows[i]))) {
                    childNum = (BigDecimal)this.getModel().getValue("total_amount", selectRows[i]);
                }
                sum = sum.add(childNum);
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumFractionDigits(2);
            String format = nf.format(sum);
            Label invoice_num = (Label)this.getControl("invoice_num");
            Label sum_amount = (Label)this.getControl("sum_amount");
            invoice_num.setText(selectRows.length + "");
            sum_amount.setText("\uffe5" + format);
        } else if (StringUtils.equals((String)control.getKey(), (String)MY_MAIL)) {
            HashMap customParams = Maps.newHashMap();
            customParams.put("mailList", this.getView().getPageCache().get("myMail" + openId));
            customParams.put("openId", openId);
            showParameter.setFormId("rim_mobile_my_mail");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams((Map)customParams);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "freshAll");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((String)control.getKey(), (String)QUERY_PROGRESS)) {
            HashMap customParams = Maps.newHashMap();
            customParams.put("runningTask", this.getView().getPageCache().get("runningTask" + openId));
            customParams.put("openId", openId);
            showParameter.setFormId("rim_mobile_mail_running");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams((Map)customParams);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((String)control.getKey(), (String)QUERY_FAILTASK)) {
            HashMap customParams = Maps.newHashMap();
            customParams.put("failTask", this.getView().getPageCache().get("failTask" + openId));
            customParams.put("openId", openId);
            showParameter.setFormId("rim_mobile_mail_fail");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams((Map)customParams);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "freshAll");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((String)control.getKey(), (String)CONFIRM_ADD)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(DONEENTRY);
            int[] selectRows = cardEntry.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"MailInvoiceCollectPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            LinkedHashMap<Long, BigDecimal> invoiceIds = new LinkedHashMap<Long, BigDecimal>(8);
            ArrayList attachIds = Lists.newArrayList();
            for (int i = 0; i < selectRows.length; ++i) {
                String serial_no = (String)this.getModel().getValue("serial_no", selectRows[i]);
                String mainId = (String)this.getModel().getValue("id", selectRows[i]);
                BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("total_amount", selectRows[i]);
                invoiceIds.put(Long.parseLong(mainId), totalAmount);
                if (StringUtils.isEmpty((String)serial_no)) continue;
                QFilter idfilter = new QFilter("relation_id", "=", (Object)serial_no);
                DynamicObjectCollection ids = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])new QFilter[]{idfilter});
                if (CollectionUtils.isEmpty((Collection)ids)) continue;
                ids.stream().forEach(f -> attachIds.add(f.getLong("attach_id")));
            }
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            String indexPageId = (String)parentCustomParams.get("indexPageId");
            LOGGER.info("\u90ae\u7bb1\u53d6\u7968\u5e26\u56de\u9996\u9875\u53c2\u6570invoiceIds\uff1a" + invoiceIds + ",attachIds:" + attachIds);
            if (StringUtils.isEmpty((String)indexPageId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9996\u9875ID", (String)"MailInvoiceCollectPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            AbstractOperateService.addSelected(indexPageId, invoiceIds, attachIds);
            String pageId = MobileIndexMinUtils.mobileIndex((IFormView)this.getView());
            if (pageId != null) {
                Map params = FpzsMainService.getCustomParam((String)this.getView().getPageId());
                String indexPageId2 = (String)params.get("indexPageId");
                if (StringUtils.isBlank((String)indexPageId2)) {
                    indexPageId2 = this.getView().getPageId();
                    params.put("indexPageId", indexPageId2);
                    FpzsMainService.cacheCustomParam((AbstractFormPlugin)this, (String)JSONObject.toJSONString((Object)params));
                }
                AbstractOperateService.addSelected(indexPageId2, invoiceIds, attachIds);
                AbstractOperateService operate = AbstractOperateService.newInstance("push_pc", this);
                operate.operate();
            } else {
                this.getView().close();
            }
        }
    }

    private void choiceAll() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(DONEENTRY);
        cardEntry.clearEntryState();
        ((FormView)this.getView()).getClientProxy().invokeControlMethod(DONEENTRY, "clearSelRows", new Object[0]);
        LinkedList arr = Lists.newLinkedList();
        int endIndex = cardEntry.getEntryData().getEndIndex();
        for (int i = 0; i < endIndex; ++i) {
            arr.add(i);
        }
        int[] arr1 = arr.stream().mapToInt(Integer::valueOf).toArray();
        cardEntry.selectRows(arr1, 1);
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < arr1.length; ++i) {
            BigDecimal childNum = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("total_amount", i))) {
                childNum = (BigDecimal)this.getModel().getValue("total_amount", i);
            }
            sum = sum.add(childNum);
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(2);
        String format = nf.format(sum);
        LOGGER.info("\u90ae\u7bb1\u53d6\u7968\u5f53\u524dpageId\uff1a" + this.getView().getPageId());
        Label invoice_num = (Label)this.getControl("invoice_num");
        Label sum_amount = (Label)this.getControl("sum_amount");
        invoice_num.setText(arr1.length + "");
        sum_amount.setText("\uffe5" + format);
    }

    private void cancelAll() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(DONEENTRY);
        cardEntry.clearEntryState();
        ((FormView)this.getView()).getClientProxy().invokeControlMethod(DONEENTRY, "clearSelRows", new Object[0]);
        Label invoice_num = (Label)this.getControl("invoice_num");
        Label sum_amount = (Label)this.getControl("sum_amount");
        invoice_num.setText("0");
        sum_amount.setText("\uffe50.00");
    }

    public void onProgress(ProgressEvent progressEvent) {
        InvoiceClassService.getInstance().refreshListRow((AbstractFormPlugin)this, "invoice_class", "invoice_class_show", "id");
    }
}

