/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.msgcollect;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.utils.AwsFpyService;
import org.apache.commons.lang.StringUtils;

public class MsgCollectHomePlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(MsgCollectHomePlugin.class);
    private static final String QUERY_BTN = "query_btn";
    private static final String CONFIRM_BTN = "confirm_btn";
    private static final String CLEAR_BTN = "clear_btn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{QUERY_BTN, CONFIRM_BTN});
        Label controlLabel = (Label)this.getControl(CLEAR_BTN);
        controlLabel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String openId = (String)parentCustomParams.get("openId");
        String indexPageId = (String)parentCustomParams.get("indexPageId");
        if (StringUtils.isEmpty((String)openId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237OpenId\u4e3a\u7a7a", (String)"MsgCollectHomePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().getPageCache().put("openId", openId);
        this.getView().getPageCache().put("indexPageId", indexPageId);
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Control control = (Control)eventObject.getSource();
        String openId = this.getView().getPageCache().get("openId");
        String indexPageId = this.getView().getPageCache().get("indexPageId");
        if (StringUtils.equals((String)control.getKey(), (String)CLEAR_BTN)) {
            this.getModel().setValue("msgdesc", (Object)"");
        } else if (StringUtils.equals((String)control.getKey(), (String)CONFIRM_BTN)) {
            String msgdesc = (String)this.getModel().getValue("msgdesc");
            boolean flag = this.checkMsgDescVail(msgdesc);
            if (!flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u77ed\u4fe1\u5185\u5bb9", (String)"MsgCollectHomePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject result = this.msgCollectConfirm(openId, msgdesc);
            LOGGER.info("\u77ed\u4fe1\u53d6\u7968\u786e\u8ba4\u53d6\u7968\u63a5\u53e3\u8fd4\u56de\uff1a" + result);
            if (!ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                this.getView().showErrorNotification(result.getString("description"));
                return;
            }
            String isFirstTime = this.getView().getPageCache().get(this.getView().getPageId() + "isFirstTime");
            if (StringUtils.isEmpty((String)isFirstTime)) {
                this.getView().getPageCache().put(this.getView().getPageId() + "isFirstTime", "1");
                MobileFormShowParameter parameter = new MobileFormShowParameter();
                parameter.setFormId("rim_mobile_msg_confirm");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, String> myOwnOpenStyle = new HashMap<String, String>(1);
                myOwnOpenStyle.put("position", "center");
                parameter.getOpenStyle().setCustParam(myOwnOpenStyle);
                HashMap<String, String> customerParam = new HashMap<String, String>();
                customerParam.put("openId", openId);
                customerParam.put("indexPageId", indexPageId);
                parameter.setCustomParams(customerParam);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closePage");
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)parameter);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u53d6\u7968\u4efb\u52a1\u6210\u529f", (String)"MsgCollectHomePlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.equals((String)control.getKey(), (String)QUERY_BTN)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String showAttach = null;
            if (customParams != null) {
                showAttach = (String)customParams.get("showAttach");
            }
            HashMap formParams = Maps.newHashMap();
            formParams.put("openId", openId);
            formParams.put("indexPageId", indexPageId);
            formParams.put("showAttach", showAttach);
            showParameter.setFormId("rim_mobile_msg_process");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams((Map)formParams);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closePage");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("import".equals(closedCallBackEvent.getReturnData()) || "cancel".equals(closedCallBackEvent.getReturnData())) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if (StringUtils.equals((String)actionId, (String)"closePage")) {
            String isClose = "1";
            String queryProcess = "";
            if (callBackData != null) {
                queryProcess = (String)callBackData.get("queryProcess");
                isClose = (String)callBackData.get("close");
            }
            String openId = this.getView().getPageCache().get("openId");
            String indexPageId = this.getView().getPageCache().get("indexPageId");
            if (StringUtils.isNotEmpty((String)queryProcess)) {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                HashMap customParams = Maps.newHashMap();
                customParams.put("openId", openId);
                customParams.put("indexPageId", indexPageId);
                showParameter.setFormId("rim_mobile_msg_process");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                showParameter.setCustomParams((Map)customParams);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closePage");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
            }
            if (!"0".equals(isClose)) {
                this.getView().close();
            }
        }
    }

    private JSONObject msgCollectConfirm(String openId, String msgdesc) {
        JSONObject param = new JSONObject();
        param.put("openId", (Object)openId);
        param.put("clientType", (Object)"2");
        param.put("content", (Object)msgdesc);
        LOGGER.info("\u77ed\u4fe1\u53d6\u7968-\u786e\u8ba4\u53d6\u7968\u5165\u53c2\uff1a" + param);
        return AwsFpyService.newInstance().postAppJson("msg_collect_confirm", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
    }

    private boolean checkMsgDescVail(String msgdesc) {
        return !StringUtils.isEmpty((String)msgdesc) && (msgdesc.contains("\u53d1\u7968") || msgdesc.contains("http"));
    }
}

