/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.msgcollect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.h5.H5InvoiceListService;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MobileIndexMinUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.lang.StringUtils;

public class MsgCollectTaskInfoPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
PullRefreshListener,
EntryGridBindDataListener,
ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(MsgCollectTaskInfoPlugin.class);
    private static final String RUNNINGENTITY = "runningentity";
    private static final String FINISHENTITY = "finishentity";
    private static final String FAILENTITY = "failentity";
    public static final String CHOOSECARD = "single_choose";
    public static final String CONFIRM_ADD = "confirm_add";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(FINISHENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addPullRefreshlisteners((PullRefreshListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
        this.addClickListeners(new String[]{CONFIRM_ADD, CHOOSECARD});
        Label controlLabel = (Label)this.getControl("control_label");
        controlLabel.addClickListener((ClickListener)this);
        ProgressBar pb = (ProgressBar)this.getControl("probarupdateclass");
        if (pb != null) {
            pb.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String openId = (String)parentCustomParams.get("openId");
        this.getView().getPageCache().put("openId", openId);
        this.initTaskList(openId);
    }

    private void initRunningFailTaskList(String openId) {
        this.getModel().deleteEntryData(RUNNINGENTITY);
        this.getModel().deleteEntryData(FAILENTITY);
        JSONObject param = new JSONObject();
        param.put("openId", (Object)openId);
        param.put("clientType", (Object)"2");
        JSONObject result = AwsFpyService.newInstance().postAppJson("msg_task_list", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
        if (!ResultContant.isSuccess((JSONObject)result).booleanValue()) {
            this.getView().showErrorNotification(result.getString("description"));
            return;
        }
        JSONObject data = result.getJSONObject("data");
        JSONArray failTaskInfo = data.getJSONArray("failInfo");
        this.initFailList(failTaskInfo);
        JSONArray runningInfo = data.getJSONArray("runningInfo");
        this.initRunningList(runningInfo);
    }

    private void initTaskList(String openId) {
        this.getModel().deleteEntryData(RUNNINGENTITY);
        this.getModel().deleteEntryData(FINISHENTITY);
        this.getModel().deleteEntryData(FAILENTITY);
        JSONObject param = new JSONObject();
        param.put("openId", (Object)openId);
        JSONObject result = AwsFpyService.newInstance().postAppJson("msg_task_list", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
        if (!ResultContant.isSuccess((JSONObject)result).booleanValue()) {
            this.getView().showErrorNotification(result.getString("description"));
            return;
        }
        JSONObject data = result.getJSONObject("data");
        JSONArray failTaskInfo = data.getJSONArray("failInfo");
        LOGGER.info("\u77ed\u4fe1\u53d6\u7968-\u5931\u8d25\u4efb\u52a1\u5217\u8868\uff1a" + failTaskInfo);
        this.initFailList(failTaskInfo);
        JSONArray finishInfo = data.getJSONArray("finishInfo");
        LOGGER.info("\u77ed\u4fe1\u53d6\u7968-\u5df2\u5b8c\u6210\u4efb\u52a1\u5217\u8868\uff1a" + finishInfo);
        this.initFinishList(finishInfo);
        JSONArray runningInfo = data.getJSONArray("runningInfo");
        LOGGER.info("\u77ed\u4fe1\u53d6\u7968-\u8fdb\u884c\u4e2d\u4efb\u52a1\u5217\u8868\uff1a" + runningInfo);
        this.initRunningList(runningInfo);
    }

    private void initRunningList(JSONArray runningInfo) {
        if (!ObjectUtils.isEmpty((Object)runningInfo)) {
            for (int i = 0; i < runningInfo.size(); ++i) {
                JSONObject info = runningInfo.getJSONObject(i);
                int row = this.getModel().createNewEntryRow(RUNNINGENTITY);
                String content = info.getString("content");
                if (content.length() > 70) {
                    content = content.substring(0, 70) + "...";
                }
                this.getModel().setValue("msginfo", (Object)content, row);
                this.getModel().setValue("tasktime", (Object)DateUtils.format((Date)info.getDate("updateTime"), (String)"yyyy-MM-dd HH:mm:ss"), row);
            }
        }
    }

    private void initFinishList(JSONArray finishInfo) {
        if (!ObjectUtils.isEmpty((Object)finishInfo)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < finishInfo.size(); ++i) {
                JSONObject invoice = finishInfo.getJSONObject(i);
                if (ObjectUtils.isEmpty((Object)invoice)) continue;
                String verifySaveFlag = RimConfigUtils.getConfig((String)"verify_save");
                if ("0".equals(verifySaveFlag)) {
                    invoice.put("delete", (Object)"2");
                }
                try {
                    InvoiceSaveResult result = this.saveInvoice(invoice);
                    invoice.put("id", result.getMainId());
                    invoice.put("serial_no", (Object)result.getSerialNo());
                    continue;
                }
                catch (MsgException e) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u53d1\u7968\u5904\u7406\u5931\u8d25:%2$s", (String)"MsgCollectTaskInfoPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), i + 1, e.getMessage());
                    sb.append(msg).append(';');
                }
            }
            if (sb.length() > 0) {
                this.getView().showTipNotification(sb.toString());
            }
            H5InvoiceListService h5InvoiceListService = new H5InvoiceListService((AbstractFormPlugin)this, FINISHENTITY, "");
            List invoiceList = h5InvoiceListService.arrayToListMap(finishInfo, Boolean.TRUE);
            h5InvoiceListService.setInvoiceData(invoiceList);
            h5InvoiceListService.fillEntryEntity();
        }
    }

    private InvoiceSaveResult saveInvoice(JSONObject invoiceInfo) {
        InvoiceSaveResult result = new InvoiceSaveResult();
        String awsInvoiceType = invoiceInfo.getString("invoiceType");
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)awsInvoiceType);
        InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)awsInvoiceType);
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("downloadUrl"))) {
            invoiceInfo.put("downloadUrl", (Object)invoiceInfo.getString("downloadUrl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("pdfurl"))) {
            invoiceInfo.put("pdfurl", (Object)invoiceInfo.getString("pdfurl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("ofdUrl"))) {
            invoiceInfo.put("ofdUrl", (Object)invoiceInfo.getString("ofdUrl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("snapshotUrl"))) {
            invoiceInfo.put("snapshotUrl", (Object)invoiceInfo.getString("snapshotUrl").replace("https", "http"));
        }
        if (!StringUtils.isEmpty((String)invoiceInfo.getString("kdcloudUrl"))) {
            invoiceInfo.put("kdcloudUrl", (Object)invoiceInfo.getString("kdcloudUrl").replace("https", "http"));
        }
        if (!InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            result = invoiceSaveService.save(invoiceInfo);
        }
        return result;
    }

    private void initFailList(JSONArray failTaskInfo) {
        ArrayList distinctFailList = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)failTaskInfo)) {
            for (int i = 0; i < failTaskInfo.size(); ++i) {
                JSONObject failInfo = failTaskInfo.getJSONObject(i);
                String content = failInfo.getString("content");
                if (distinctFailList.contains(content)) continue;
                distinctFailList.add(content);
                int row = this.getModel().createNewEntryRow(FAILENTITY);
                this.getModel().setValue("taskid", (Object)failInfo.getString("id"), row);
                this.getModel().setValue("create_time", (Object)DateUtils.format((Date)failInfo.getDate("updateTime"), (String)"yyyy-MM-dd HH:mm:ss"), row);
                if (content.length() > 70) {
                    content = content.substring(0, 70) + "...";
                }
                this.getModel().setValue("content", (Object)content, row);
                this.getModel().setValue("fail_reason", (Object)failInfo.getString("failReason"), row);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"choose_all")) {
            Boolean allCheckValue = (Boolean)this.getModel().getValue("choose_all");
            if (allCheckValue.booleanValue()) {
                this.choiceAll();
            } else {
                this.cancelAll();
            }
        }
    }

    private void choiceAll() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(FINISHENTITY);
        cardEntry.clearEntryState();
        ((FormView)this.getView()).getClientProxy().invokeControlMethod(FINISHENTITY, "clearSelRows", new Object[0]);
        LinkedList arr = Lists.newLinkedList();
        int endIndex = cardEntry.getEntryData().getEndIndex();
        for (int i = 0; i < endIndex; ++i) {
            arr.add(i);
        }
        int[] arr1 = arr.stream().mapToInt(Integer::valueOf).toArray();
        cardEntry.selectRows(arr1, 1);
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < arr1.length; ++i) {
            BigDecimal childNum = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("total_amount", i))) {
                childNum = (BigDecimal)this.getModel().getValue("total_amount", i);
            }
            sum = sum.add(childNum);
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(2);
        String format = nf.format(sum);
        Label invoice_num = (Label)this.getControl("invoice_num");
        Label sum_amount = (Label)this.getControl("sum_amount");
        invoice_num.setText(arr1.length + "");
        sum_amount.setText("\uffe5" + format);
    }

    private void cancelAll() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(FINISHENTITY);
        cardEntry.clearEntryState();
        ((FormView)this.getView()).getClientProxy().invokeControlMethod(FINISHENTITY, "clearSelRows", new Object[0]);
        Label invoice_num = (Label)this.getControl("invoice_num");
        Label sum_amount = (Label)this.getControl("sum_amount");
        invoice_num.setText("0");
        sum_amount.setText("\uffe50.00");
    }

    public void click(EventObject eventObject) {
        Control control = (Control)eventObject.getSource();
        String openId = this.getView().getPageCache().get("openId");
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        if (StringUtils.equals((String)control.getKey(), (String)CHOOSECARD)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(FINISHENTITY);
            int[] selectRows = cardEntry.getSelectRows();
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 0; i < selectRows.length; ++i) {
                BigDecimal childNum = BigDecimal.ZERO;
                if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("total_amount", selectRows[i]))) {
                    childNum = (BigDecimal)this.getModel().getValue("total_amount", selectRows[i]);
                }
                sum = sum.add(childNum);
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumFractionDigits(2);
            String format = nf.format(sum);
            Label invoice_num = (Label)this.getControl("invoice_num");
            Label sum_amount = (Label)this.getControl("sum_amount");
            invoice_num.setText(selectRows.length + "");
            sum_amount.setText("\uffe5" + format);
        } else if (StringUtils.equals((String)control.getKey(), (String)"control_label")) {
            int index = this.getModel().getEntryCurrentRowIndex(FAILENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(FAILENTITY, index);
            String taskId = entryRowEntity.getString("taskid");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("clientType", (Object)"2");
            jsonObject.put("openId", (Object)openId);
            jsonObject.put("id", (Object)taskId);
            jsonObject.put("index", (Object)index);
            HashMap customParams = Maps.newHashMap();
            customParams.put("taskInfo", jsonObject);
            showParameter.setFormId("rim_mobile_msg_fail");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams((Map)customParams);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "controlCallback");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((String)control.getKey(), (String)CONFIRM_ADD)) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(FINISHENTITY);
            int[] selectRows = cardEntry.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"MsgCollectTaskInfoPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            LinkedHashMap<Long, BigDecimal> invoiceIds = new LinkedHashMap<Long, BigDecimal>(8);
            ArrayList attachIds = Lists.newArrayList();
            for (int i = 0; i < selectRows.length; ++i) {
                String serial_no = (String)this.getModel().getValue("serial_no", selectRows[i]);
                String mainId = (String)this.getModel().getValue("id", selectRows[i]);
                BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("total_amount", selectRows[i]);
                invoiceIds.put(Long.parseLong(mainId), totalAmount);
                QFilter idfilter = new QFilter("relation_id", "=", (Object)serial_no);
                DynamicObjectCollection ids = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])new QFilter[]{idfilter});
                if (CollectionUtils.isEmpty((Collection)ids)) continue;
                ids.stream().forEach(f -> attachIds.add(f.getLong("attach_id")));
            }
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            String indexPageId = (String)parentCustomParams.get("indexPageId");
            LOGGER.info("\u77ed\u4fe1\u53d6\u7968\u5e26\u56de\u9996\u9875\u53c2\u6570invoiceIds\uff1a" + invoiceIds + ",attachIds:" + attachIds);
            if (StringUtils.isEmpty((String)indexPageId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9996\u9875ID", (String)"MsgCollectTaskInfoPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            AbstractOperateService.addSelected(indexPageId, invoiceIds, attachIds);
            String pageId = MobileIndexMinUtils.mobileIndex((IFormView)this.getView());
            if (pageId != null) {
                Map params = FpzsMainService.getCustomParam((String)this.getView().getPageId());
                String indexPageId2 = (String)params.get("indexPageId");
                if (StringUtils.isBlank((String)indexPageId2)) {
                    indexPageId2 = this.getView().getPageId();
                    params.put("indexPageId", indexPageId2);
                    FpzsMainService.cacheCustomParam((AbstractFormPlugin)this, (String)JSONObject.toJSONString((Object)params));
                }
                AbstractOperateService.addSelected(indexPageId2, invoiceIds, attachIds);
                AbstractOperateService operate = AbstractOperateService.newInstance("push_pc", this);
                operate.operate();
            } else {
                this.getView().close();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("import".equals(closedCallBackEvent.getReturnData()) || "cancel".equals(closedCallBackEvent.getReturnData())) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
            return;
        }
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)callBackData)) {
            return;
        }
        String index = (String)callBackData.get("index");
        this.getModel().deleteEntryRow(FAILENTITY, Integer.parseInt(index));
        String openId = this.getView().getPageCache().get("openId");
        this.initRunningFailTaskList(openId);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String pageId = this.getView().getPageId();
        String msgCardLock = CacheHelper.get((String)("msgCardLock" + pageId));
        if (StringUtils.isEmpty((String)msgCardLock)) {
            CacheHelper.put((String)("msgCardLock" + pageId), (String)(row + ""), (int)1);
            CardEntry cardEntry = (CardEntry)this.getView().getControl(FINISHENTITY);
            int[] selectRows = cardEntry.getSelectRows();
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 0; i < selectRows.length; ++i) {
                BigDecimal childNum = BigDecimal.ZERO;
                if (!ObjectUtils.isEmpty((Object)this.getModel().getValue("total_amount", selectRows[i]))) {
                    childNum = (BigDecimal)this.getModel().getValue("total_amount", selectRows[i]);
                }
                sum = sum.add(childNum);
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumFractionDigits(2);
            String format = nf.format(sum);
            Label invoice_num = (Label)this.getControl("invoice_num");
            Label sum_amount = (Label)this.getControl("sum_amount");
            invoice_num.setText(selectRows.length + "");
            sum_amount.setText("\uffe5" + format);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            HashMap formParams = Maps.newHashMap();
            boolean allowEdit = false;
            boolean allowDel = false;
            String mainId = (String)this.getModel().getValue("id", row);
            formParams.put("allowEdit", allowEdit);
            formParams.put("allowDel", allowDel);
            formParams.put("mainIds", mainId);
            if (customParams != null) {
                formParams.put("showAttach", customParams.get("showAttach"));
            }
            formParams.put("row", row);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_h5_inv_update");
            H5PluginService.setCommonParam((Map)formParams, (Map)this.getView().getFormShowParameter().getCustomParams());
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams((Map)formParams);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        e.getRows().stream().forEach(row -> {
            int rowIndex = row.getRowIndex();
            DynamicObject dynamicObject = row.getDataEntity();
            H5InvoiceListService h5InvoiceListSevice = new H5InvoiceListService((AbstractFormPlugin)this, FINISHENTITY, "");
            String invoiceInfoStr = dynamicObject.getString("invoice_info");
            JSONObject invoiceInfoJson = JSONObject.parseObject((String)invoiceInfoStr);
            Map invoice = invoiceInfoJson.getInnerMap();
            h5InvoiceListSevice.setTag(invoice, rowIndex);
        });
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
        String allowFlag = CacheHelper.get((String)("allowFlag" + this.getView().getPageId()));
        if (StringUtils.isEmpty((String)allowFlag)) {
            CacheHelper.put((String)("allowFlag" + this.getView().getPageId()), (String)"1", (int)30);
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            String openId = (String)parentCustomParams.get("openId");
            this.initTaskList(openId);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        InvoiceClassService.getInstance().refreshListRow((AbstractFormPlugin)this, "invoice_class", "invoice_class_show", "id");
    }
}

