/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.fpzs.ExpenseStatusLogService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.query.OpenInvoiceDetailService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DelExpenseRelationPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(DelExpenseRelationPlugin.class);
    private static final String INVOICE_TYPE_TXT = "invoice_type";
    private static final String EXPENSE_NUM_TXT = "expense_num";
    private static final String INVOICE_CODE_TXT = "invoice_code";
    private static final String INVOICE_NO_TXT = "invoice_no";
    private static final String INVOICE_DATE_TXT = "invoice_date";
    private static final String INVOICE_DATE4_TXT = "invoice_date4";
    private static final String PRINTING_SEQUENCE_NO_TXT = "sequence_no";
    private static final String PASSENGER_NAME_TXT = "passenger_name";
    private static final String TRAIN_NUM_TXT = "train_num";
    private static final String ELECTRONIC_TICKET_NUM_TXT = "eticket_no";
    private static final String PRINT_NUM_TXT = "print_num";
    private static final String INVOICE_DATE3_TXT = "invoice_date3";
    private static final String DYNAMICTEXT_EXIT_TXT = "exit";
    private static final String TAX_PAID_PROOF_NO_TXT = "tax_paid_proof_no";
    private static final String CUSTOM_DECLARATION_NO_TXT = "custom_declaration_no";
    private static final String NUMBER_TXT = "number";
    private static final String INVOICE_LIST_ENTRYENTITY = "entryentity2";
    private static final String KEY_POP_FORM = "rim_confirm_status";
    private static final Long INVOICE_TYPE_ALL = 1L;
    protected String type;

    private static String UNBUNDLING_CONFIRM_TIPS() {
        return ResManager.loadKDString((String)"\u60a8\u597d\uff01\u53d1\u7968\u89e3\u7ed1\u540e\u5c06\u5220\u9664\u62a5\u9500\u5355\u4e0e\u9009\u4e2d\u53d1\u7968\u7684\u5bf9\u5e94\u5173\u7cfb\uff0c\u53d1\u7968\u7684\u62a5\u9500\u72b6\u6001\u5c06\u5168\u90e8\u4fee\u6539\u4e3a\u201c\u672a\u7528\u201d\u72b6\u6001\u3002\u8bf7\u786e\u8ba4\u4fee\u6539", (String)"DelExpenseRelationPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(INVOICE_LIST_ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit base = (MulBasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void initFormStyle() {
        Long invoiceTypeCode = ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_TYPE_TXT)) ? null : Long.valueOf(this.getModel().getValue(INVOICE_TYPE_TXT).toString());
        this.showOrHideFileds(invoiceTypeCode);
        Object[] list = new Object[]{RequestContext.get().getOrgId()};
        this.getModel().setValue("org", (Object)list);
    }

    private void showOrHideFileds(Long invoiceTypeCode) {
        if (Arrays.asList(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.ORDINARY_PAPER.getCode(), InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.ORDINARY_ROLL.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.MOTOR_INVOICE.getCode(), InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode(), InputInvoiceTypeEnum.BOAT_INVOICE.getCode(), InputInvoiceTypeEnum.GENERAL_PAPER.getCode(), InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode(), InputInvoiceTypeEnum.TAXI_INVOICE.getCode(), InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode(), InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode()).contains(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT, INVOICE_DATE_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, DYNAMICTEXT_EXIT_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT, INVOICE_DATE_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, DYNAMICTEXT_EXIT_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(INVOICE_NO_TXT, null);
            this.getModel().setValue(INVOICE_DATE_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PASSENGER_NAME_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT, INVOICE_DATE_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, TRAIN_NUM_TXT, DYNAMICTEXT_EXIT_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(INVOICE_NO_TXT, null);
            this.getModel().setValue(INVOICE_DATE_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        } else if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_DATE_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, DYNAMICTEXT_EXIT_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_DATE_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        } else if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INVOICE_NO_TXT, INVOICE_DATE_TXT, DYNAMICTEXT_EXIT_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        } else if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TAX_PAID_PROOF_NO_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT, DYNAMICTEXT_EXIT_TXT, INVOICE_DATE_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, CUSTOM_DECLARATION_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(INVOICE_NO_TXT, null);
            this.getModel().setValue(INVOICE_DATE_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOM_DECLARATION_NO_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT, DYNAMICTEXT_EXIT_TXT, INVOICE_DATE_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, TAX_PAID_PROOF_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(INVOICE_NO_TXT, null);
            this.getModel().setValue(INVOICE_DATE_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        } else if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{NUMBER_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT, DYNAMICTEXT_EXIT_TXT, INVOICE_DATE_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(INVOICE_NO_TXT, null);
            this.getModel().setValue(INVOICE_DATE_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
        } else if (Arrays.asList(InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()).contains(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INVOICE_NO_TXT, INVOICE_DATE_TXT});
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, NUMBER_TXT, DYNAMICTEXT_EXIT_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
        }
        if (INVOICE_TYPE_ALL.equals(invoiceTypeCode)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INVOICE_CODE_TXT, INVOICE_NO_TXT, INVOICE_DATE_TXT, DYNAMICTEXT_EXIT_TXT, INVOICE_DATE4_TXT, PRINTING_SEQUENCE_NO_TXT, PASSENGER_NAME_TXT, TRAIN_NUM_TXT, ELECTRONIC_TICKET_NUM_TXT, PRINT_NUM_TXT, INVOICE_DATE3_TXT, TAX_PAID_PROOF_NO_TXT, CUSTOM_DECLARATION_NO_TXT, NUMBER_TXT});
            this.getModel().setValue(INVOICE_CODE_TXT, null);
            this.getModel().setValue(INVOICE_NO_TXT, null);
            this.getModel().setValue(INVOICE_DATE_TXT, null);
            this.getModel().setValue(DYNAMICTEXT_EXIT_TXT, null);
            this.getModel().setValue(INVOICE_DATE4_TXT, null);
            this.getModel().setValue(PRINTING_SEQUENCE_NO_TXT, null);
            this.getModel().setValue(PASSENGER_NAME_TXT, null);
            this.getModel().setValue(TRAIN_NUM_TXT, null);
            this.getModel().setValue(ELECTRONIC_TICKET_NUM_TXT, null);
            this.getModel().setValue(PRINT_NUM_TXT, null);
            this.getModel().setValue(INVOICE_DATE3_TXT, null);
            this.getModel().setValue(TAX_PAID_PROOF_NO_TXT, null);
            this.getModel().setValue(CUSTOM_DECLARATION_NO_TXT, null);
            this.getModel().setValue(NUMBER_TXT, null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initFormStyle();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDatas;
        Object newData;
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)INVOICE_TYPE_TXT, (CharSequence)fieldKey) && (newData = (changeDatas = e.getChangeSet())[0].getNewValue()) != null) {
            Long newInvoiceType = Long.valueOf(newData.toString());
            this.showOrHideFileds(newInvoiceType);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_invoice_debinding", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idQFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("query".equals(itemKey)) {
            this.queryInvoiceList();
        } else if ("reset".equals(itemKey)) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if ("unbunding".equals(itemKey)) {
            EntryGrid qrEntry = (EntryGrid)this.getControl(INVOICE_LIST_ENTRYENTITY);
            int[] selectRows = qrEntry.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u89e3\u7ed1\u7684\u53d1\u7968", (String)"DelExpenseRelationPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            HashMap<Integer, String> btnMap = new HashMap<Integer, String>(2);
            btnMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DelExpenseRelationPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DelExpenseRelationPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(DelExpenseRelationPlugin.UNBUNDLING_CONFIRM_TIPS(), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("bar_save"), btnMap);
        } else if ("updatestatus".equals(itemKey)) {
            EntryGrid qrEntry = (EntryGrid)this.getControl(INVOICE_LIST_ENTRYENTITY);
            int[] selectRows = qrEntry.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u72b6\u6001\u7684\u53d1\u7968", (String)"DelExpenseRelationPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(KEY_POP_FORM);
            showParameter.setShowTitle(false);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updatestatus"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)"updatestatus", (CharSequence)closedCallBackEvent.getActionId()) && null != closedCallBackEvent.getReturnData()) {
            List<String> serialNos;
            ArrayList<String> recordedSerialNos;
            EntryGrid qrEntry;
            int[] selectRows;
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String currentStatus = (String)returnData.get("status");
            if (!this.validateChangeStatus(currentStatus, selectRows = (qrEntry = (EntryGrid)this.getControl(INVOICE_LIST_ENTRYENTITY)).getSelectRows())) {
                return;
            }
            HashMap<String, ArrayList<String>> serialNosMap = new HashMap<String, ArrayList<String>>(8);
            HashMap<String, ArrayList<String>> recordedSerialNosMap = new HashMap<String, ArrayList<String>>(8);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(INVOICE_LIST_ENTRYENTITY, selectRows[i]);
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                String serialNo = dynamicObject.getString("serial_no2");
                String expenseStatus = dynamicObject.getString("expense_status2");
                if (currentStatus.equals(expenseStatus)) continue;
                String expenseId = dynamicObject.getString("expense_id2");
                if ("65".equals(expenseStatus)) {
                    recordedSerialNos = (ArrayList<String>)recordedSerialNosMap.get(expenseId);
                    if (recordedSerialNos == null) {
                        recordedSerialNos = new ArrayList<String>(8);
                    }
                    recordedSerialNos.add(serialNo);
                    recordedSerialNosMap.put(expenseId, recordedSerialNos);
                    continue;
                }
                serialNos = (List)serialNosMap.get(expenseId);
                if (serialNos == null) {
                    serialNos = new ArrayList<String>(8);
                }
                serialNos.add(serialNo);
                serialNosMap.put(expenseId, (ArrayList<String>)serialNos);
            }
            if (ObjectUtils.isEmpty(serialNosMap) && ObjectUtils.isEmpty(recordedSerialNosMap)) {
                return;
            }
            ExpenseStatusLogService expenseStatusLogService = new ExpenseStatusLogService();
            ExpenseRelationService expenseRelationService = new ExpenseRelationService();
            ExpenseService expenseService = new ExpenseService();
            if (!ObjectUtils.isEmpty(serialNosMap)) {
                for (Map.Entry entry : serialNosMap.entrySet()) {
                    serialNos = (ArrayList<String>)entry.getValue();
                    expenseStatusLogService.insertExpenseFormExpense(null, Collections.emptyList(), null, (List)serialNos, "update", Integer.valueOf(currentStatus));
                    expenseRelationService.batchUpdateStatus(serialNos, Integer.valueOf(currentStatus), (String)entry.getKey());
                    expenseService.updateInvoiceMain(serialNos, null);
                }
            }
            if (!ObjectUtils.isEmpty(recordedSerialNosMap)) {
                for (Map.Entry entry2 : recordedSerialNosMap.entrySet()) {
                    recordedSerialNos = (List)entry2.getValue();
                    expenseStatusLogService.insertExpenseFormExpense(null, Collections.emptyList(), null, recordedSerialNos, "update", Integer.valueOf(currentStatus));
                    expenseRelationService.batchUpdateStatus(recordedSerialNos, Integer.valueOf(currentStatus), (String)entry2.getKey());
                    VoucherService voucherService = new VoucherService();
                    voucherService.deleteVouchAndInvoiceMain(recordedSerialNos, null);
                }
            }
            this.queryInvoiceList();
        }
    }

    private boolean validateChangeStatus(String currentStatus, int[] selectRows) {
        if (StringUtils.isBlank((CharSequence)currentStatus)) {
            return false;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(INVOICE_LIST_ENTRYENTITY, selectRows[i]);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
            String expenseNum = dynamicObject.getString("expense_num2");
            String invoiceNo = dynamicObject.getString("invoice_no2");
            if (Integer.parseInt(currentStatus) <= 1 || !StringUtils.isBlank((CharSequence)expenseNum)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff0c\u53d1\u7968\u53f7\u7801 %s \u672a\u5173\u8054\u5355\u636e\uff0c\u4e0d\u80fd\u4fee\u6539\u4e3a\u5176\u4ed6\u72b6\u6001\uff01", (String)"DelExpenseRelationPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo), Integer.valueOf(5000));
            return false;
        }
        return true;
    }

    private void queryInvoiceList() {
        Long invoiceTypeCode;
        this.clearListData();
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        List<Long> orgIds = orgs.stream().map(c -> c.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\uff01", (String)"DelExpenseRelationPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Long l = invoiceTypeCode = ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_TYPE_TXT)) ? null : Long.valueOf(this.getModel().getValue(INVOICE_TYPE_TXT).toString());
        if (invoiceTypeCode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u7968\u7c7b\u578b\uff01", (String)"DelExpenseRelationPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String expenseNum = (String)this.getModel().getValue("expense_num_tag");
        List<QFilter> qFilters2 = this.getqFilters(invoiceTypeCode);
        if (CollectionUtils.isEmpty(qFilters2) && ObjectUtils.isEmpty((Object)expenseNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u6761\u4ef6\uff01", (String)"DelExpenseRelationPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (!Arrays.asList(InputInvoiceTypeEnum.ROAD_BRIDGE.getCode(), InputInvoiceTypeEnum.TRAIN_INVOICE.getCode(), InputInvoiceTypeEnum.AIR_INVOICE.getCode(), InputInvoiceTypeEnum.TAX_PROOF.getCode(), InputInvoiceTypeEnum.HGJKS.getCode(), InputInvoiceTypeEnum.TRAIN_REFUND.getCode(), InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()).contains(invoiceTypeCode) && StringUtils.isBlank((CharSequence)expenseNum)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_CODE_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d1\u7968\u4ee3\u7801\uff01", (String)"DelExpenseRelationPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_NO_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d1\u7968\u53f7\u7801\uff01", (String)"DelExpenseRelationPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceTypeCode) && StringUtils.isBlank((CharSequence)expenseNum)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(TRAIN_NUM_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8f66\u6b21\uff01", (String)"DelExpenseRelationPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(PRINTING_SEQUENCE_NO_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5370\u5237\u5e8f\u53f7\uff01", (String)"DelExpenseRelationPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceTypeCode) && StringUtils.isBlank((CharSequence)expenseNum)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(ELECTRONIC_TICKET_NUM_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7535\u5b50\u5ba2\u7968\u53f7\u7801\uff01", (String)"DelExpenseRelationPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(PRINT_NUM_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5370\u5237\u5e8f\u53f7\uff01", (String)"DelExpenseRelationPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceTypeCode) && StringUtils.isBlank((CharSequence)expenseNum)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_NO_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d1\u7968\u53f7\u7801\uff01", (String)"DelExpenseRelationPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(DYNAMICTEXT_EXIT_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u51fa\u53e3\uff01", (String)"DelExpenseRelationPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceTypeCode) && StringUtils.isBlank((CharSequence)expenseNum)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(CUSTOM_DECLARATION_NO_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f34\u6b3e\u4e66\u53f7\u7801\uff01", (String)"DelExpenseRelationPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(invoiceTypeCode) && StringUtils.isBlank((CharSequence)expenseNum)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(NUMBER_TXT))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6536\u636e\u53f7\u7801\uff01", (String)"DelExpenseRelationPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
        } else if (Arrays.asList(InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()).contains(invoiceTypeCode) && StringUtils.isBlank((CharSequence)expenseNum) && ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_NO_TXT))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d1\u7968\u53f7\u7801\uff01", (String)"DelExpenseRelationPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        List<Map<String, Object>> resultList = this.getResultMaps(orgIds, invoiceTypeCode, qFilters2, expenseNum);
        this.getModel().beginInit();
        for (Map<String, Object> map : resultList) {
            int row = this.getModel().createNewEntryRow(INVOICE_LIST_ENTRYENTITY);
            for (Map.Entry<String, Object> modelEntry : map.entrySet()) {
                this.getModel().setValue(modelEntry.getKey() + "2", modelEntry.getValue(), row);
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
        if (CollectionUtils.isEmpty(resultList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01", (String)"DelExpenseRelationPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
    }

    private List<Map<String, Object>> getResultMaps(List<Long> orgIds, Long invoiceTypeCode, List<QFilter> qFilters, String expenseNum) {
        List invoiceList;
        InvoiceQueryService invoiceQueryService = new InvoiceQueryService();
        ExpenseRelationService expenseRelationService = new ExpenseRelationService();
        List<Object> serialNos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)expenseNum)) {
            if (expenseNum.contains(",")) {
                List expenseNums = Arrays.stream(expenseNum.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                List expenseRelations = expenseRelationService.querySerialNoByExpenseNums(expenseNums);
                serialNos = expenseRelations.stream().map(c -> MapUtils.getString((Map)c, (Object)"serial_no")).collect(Collectors.toList());
            } else {
                List expenseRelations = expenseRelationService.querySerialNoByExpenseNum(expenseNum);
                serialNos = expenseRelations.stream().map(c -> MapUtils.getString((Map)c, (Object)"serial_no")).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)serialNos)) {
                return Collections.emptyList();
            }
        }
        String tenantNo = TenantUtils.getTenantNo();
        if (Arrays.asList(InputInvoiceTypeEnum.TRAIN_INVOICE.getCode(), InputInvoiceTypeEnum.AIR_INVOICE.getCode(), InputInvoiceTypeEnum.ROAD_BRIDGE.getCode(), InputInvoiceTypeEnum.TAX_PROOF.getCode(), InputInvoiceTypeEnum.HGJKS.getCode(), InputInvoiceTypeEnum.TRAIN_REFUND.getCode()).contains(invoiceTypeCode)) {
            List childInvoiceList = invoiceQueryService.queryChildInvoiceData(invoiceTypeCode, (List)serialNos, qFilters);
            serialNos = childInvoiceList.stream().map(c -> MapUtils.getString((Map)c, (Object)"serial_no")).collect(Collectors.toList());
            invoiceList = invoiceQueryService.queryBySerialNos(orgIds, tenantNo, (List)serialNos);
        } else {
            invoiceList = invoiceQueryService.queryBySerialNosAndFilter(orgIds, invoiceTypeCode, tenantNo, (List)serialNos, qFilters);
        }
        LinkedList resultList = Lists.newLinkedList();
        this.fillPassengerName(invoiceList);
        invoiceList.stream().forEach(invoice -> {
            String serialNo = MapUtils.getString((Map)invoice, (Object)"serial_no", null);
            List expenseRelationList = expenseRelationService.queryExpenseRelationData(expenseNum, serialNo);
            if (CollectionUtils.isEmpty((Collection)expenseRelationList)) {
                LinkedHashMap temMap = Maps.newLinkedHashMap();
                temMap.putAll(invoice);
                temMap.put("status", null);
                temMap.put("expense_id", null);
                temMap.put(EXPENSE_NUM_TXT, null);
                temMap.put("create_time", null);
                temMap.put("view_invoice", ResManager.loadKDString((String)"\u67e5\u770b\u53d1\u7968", (String)"DelExpenseRelationPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                resultList.add(temMap);
            }
            expenseRelationList.stream().forEach(relation -> {
                LinkedHashMap temMap = Maps.newLinkedHashMap();
                temMap.putAll(invoice);
                temMap.put("status", MapUtils.getString((Map)relation, (Object)"status", (String)""));
                temMap.put("expense_id", MapUtils.getString((Map)relation, (Object)"expense_id", (String)""));
                temMap.put(EXPENSE_NUM_TXT, MapUtils.getString((Map)relation, (Object)EXPENSE_NUM_TXT, (String)""));
                temMap.put("create_time", MapUtils.getString((Map)relation, (Object)"create_time", (String)""));
                temMap.put("view_invoice", ResManager.loadKDString((String)"\u67e5\u770b\u53d1\u7968", (String)"DelExpenseRelationPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                resultList.add(temMap);
            });
        });
        return resultList;
    }

    private List<QFilter> getqFilters(Long invoiceTypeCode) {
        LinkedList qFilters2 = Lists.newLinkedList();
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_CODE_TXT))) {
            qFilters2.add(new QFilter(INVOICE_CODE_TXT, "=", this.getModel().getValue(INVOICE_CODE_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_NO_TXT))) {
            qFilters2.add(new QFilter(INVOICE_NO_TXT, "=", this.getModel().getValue(INVOICE_NO_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_DATE_TXT))) {
            qFilters2.add(new QFilter(INVOICE_DATE_TXT, "=", this.getModel().getValue(INVOICE_DATE_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_DATE4_TXT))) {
            qFilters2.add(new QFilter(INVOICE_DATE_TXT, "=", this.getModel().getValue(INVOICE_DATE4_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(PRINTING_SEQUENCE_NO_TXT))) {
            qFilters2.add(new QFilter(PRINTING_SEQUENCE_NO_TXT, "=", this.getModel().getValue(PRINTING_SEQUENCE_NO_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(PASSENGER_NAME_TXT))) {
            if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceTypeCode)) {
                qFilters2.add(new QFilter("customer_name", "=", this.getModel().getValue(PASSENGER_NAME_TXT)));
            } else {
                qFilters2.add(new QFilter(PASSENGER_NAME_TXT, "=", this.getModel().getValue(PASSENGER_NAME_TXT)));
            }
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(TRAIN_NUM_TXT))) {
            qFilters2.add(new QFilter(TRAIN_NUM_TXT, "=", this.getModel().getValue(TRAIN_NUM_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(ELECTRONIC_TICKET_NUM_TXT))) {
            qFilters2.add(new QFilter(ELECTRONIC_TICKET_NUM_TXT, "=", this.getModel().getValue(ELECTRONIC_TICKET_NUM_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(PRINT_NUM_TXT))) {
            qFilters2.add(new QFilter(PRINT_NUM_TXT, "=", this.getModel().getValue(PRINT_NUM_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(INVOICE_DATE3_TXT))) {
            qFilters2.add(new QFilter(INVOICE_DATE_TXT, "=", this.getModel().getValue(INVOICE_DATE3_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(DYNAMICTEXT_EXIT_TXT))) {
            qFilters2.add(new QFilter(DYNAMICTEXT_EXIT_TXT, "=", this.getModel().getValue(DYNAMICTEXT_EXIT_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(TAX_PAID_PROOF_NO_TXT))) {
            qFilters2.add(new QFilter(TAX_PAID_PROOF_NO_TXT, "=", this.getModel().getValue(TAX_PAID_PROOF_NO_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(CUSTOM_DECLARATION_NO_TXT))) {
            qFilters2.add(new QFilter(CUSTOM_DECLARATION_NO_TXT, "=", this.getModel().getValue(CUSTOM_DECLARATION_NO_TXT)));
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(NUMBER_TXT))) {
            qFilters2.add(new QFilter(NUMBER_TXT, "=", this.getModel().getValue(NUMBER_TXT)));
        }
        return qFilters2;
    }

    private void fillPassengerName(List<Map<String, Object>> invoiceList) {
        InvoiceQueryService invoiceQueryService = new InvoiceQueryService();
        invoiceList.stream().filter(c -> Arrays.asList(InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode(), InputInvoiceTypeEnum.TRAIN_INVOICE.getCode(), InputInvoiceTypeEnum.AIR_INVOICE.getCode(), InputInvoiceTypeEnum.BOAT_INVOICE.getCode()).contains(MapUtils.getLong((Map)c, (Object)INVOICE_TYPE_TXT, (Long)0L))).forEach(invoice -> {
            Long invoiceTypeCode1 = MapUtils.getLong((Map)invoice, (Object)INVOICE_TYPE_TXT, (Long)0L);
            Map mainMap = invoiceQueryService.queryNoVatInvoiceData(invoiceTypeCode1, MapUtils.getString((Map)invoice, (Object)"serial_no", (String)""));
            if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceTypeCode1)) {
                invoice.put(PASSENGER_NAME_TXT, mainMap.get("customer_name"));
            } else {
                invoice.put(PASSENGER_NAME_TXT, mainMap.get(PASSENGER_NAME_TXT));
            }
        });
    }

    private void clearListData() {
        this.getModel().deleteEntryData(INVOICE_LIST_ENTRYENTITY);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("bar_save".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            EntryGrid qrEntry = (EntryGrid)this.getControl(INVOICE_LIST_ENTRYENTITY);
            int[] selectRows = qrEntry.getSelectRows();
            if (!this.valiteEntityProperties(selectRows)) {
                return;
            }
            ArrayList<String> serialList = new ArrayList<String>(2);
            ArrayList<String> expenseIdList = new ArrayList<String>(2);
            ArrayList<String> recordedSerialNos = new ArrayList<String>(2);
            ArrayList<String> recordedExpenseIds = new ArrayList<String>(2);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(INVOICE_LIST_ENTRYENTITY, selectRows[i]);
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                String serialNo = dynamicObject.getString("serial_no2");
                String expenseStatus = dynamicObject.getString("expense_status2");
                String expenseId = dynamicObject.getString("expense_id2");
                if ("65".equals(expenseStatus)) {
                    recordedSerialNos.add(serialNo);
                    recordedExpenseIds.add(expenseId);
                    continue;
                }
                serialList.add(serialNo);
                expenseIdList.add(expenseId);
            }
            ExpenseStatusLogService expenseStatusLogService = new ExpenseStatusLogService();
            ExpenseRelationService expenseRelationService = new ExpenseRelationService();
            ExpenseService expenseService = new ExpenseService();
            if (CollectionUtils.isNotEmpty(serialList)) {
                expenseStatusLogService.insertExpenseFormExpense(null, expenseIdList, null, serialList, "delete", Integer.valueOf(1));
                expenseRelationService.deleteBySerialNoAndExpenseId(serialList, expenseIdList);
                expenseService.updateInvoiceMain(serialList, null);
            }
            if (CollectionUtils.isNotEmpty(recordedSerialNos)) {
                expenseStatusLogService.insertExpenseFormExpense(null, Collections.emptyList(), null, recordedSerialNos, "delete", Integer.valueOf(1));
                expenseRelationService.deleteBySerialNoAndExpenseId(recordedSerialNos, recordedExpenseIds);
                VoucherService voucherService = new VoucherService();
                voucherService.deleteVouchAndInvoiceMain(recordedSerialNos, null);
            }
            this.queryInvoiceList();
        }
    }

    private boolean valiteEntityProperties(int[] selectRows) {
        for (int i = 0; i < selectRows.length; ++i) {
            String expenseNum;
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(INVOICE_LIST_ENTRYENTITY, selectRows[i]);
            if (ObjectUtils.isEmpty((Object)dynamicObject) || !StringUtils.isBlank((CharSequence)(expenseNum = dynamicObject.getString("expense_num2"))) || selectRows[i] <= -1) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u89e3\u9664\u7ed1\u5b9a\u5931\u8d25\uff0c\u7b2c %s \u884c\u53d1\u7968\u6ca1\u6709\u5173\u8054\u62a5\u9500\u5355\uff0c\u65e0\u9700\u89e3\u7ed1\uff01", (String)"DelExpenseRelationPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), selectRows[i] + 1), Integer.valueOf(2000));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if (StringUtils.equals((CharSequence)"view_invoice2", (CharSequence)arg0.getFieldName())) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(INVOICE_LIST_ENTRYENTITY, arg0.getRowIndex());
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                return;
            }
            String serialNo = dynamicObject.getString("serial_no2");
            OpenInvoiceDetailService.openEditViewBySerialNo(this, serialNo);
        }
    }
}

