/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceListConstant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.compress.utils.Lists;

public class InvoiceQueryMainPlugin
extends LicenseFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TYPE_TREE = "typetree";
    private static final String KEY_DATA_FLEX = "data_flex";

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object queryType = customParams.get("querytype");
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        List<Object> list = new ArrayList(8);
        list = "person_ticket".equals(queryType) ? InvoiceQueryMainPlugin.getInvoiceClassNodeList() : this.getInvoiceTypeNodeList(queryType);
        tree.addNodes(list);
        tree.focusNode((TreeNode)list.get(0));
        tree.treeNodeClick(null, ((TreeNode)list.get(0)).getId());
    }

    public static List<TreeNode> getInvoiceClassNodeList() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(8);
        long userId = RequestContext.get().getCurrUserId();
        String sql = "select distinct c.fname, c.fid from t_rim_invoice a \nright join t_rim_inv_collect_user d on d.fid = a.fid and d.fcollect_user = %s\nleft join t_rim_invoice_mul_class b on a.fid = b.fid \nleft join t_rim_invoice_class c on b.fbasedataid = c.fid \nwhere a.fdelete = '1' and c.fname != ' ' and c.fenable != '0'";
        List result = DBUtils.query((String)"taxc", (String)String.format(sql, userId));
        TreeNode node = new TreeNode();
        node.setId("0");
        node.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"InputInvoiceTypeEnum_0", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(node);
        for (Map map : result) {
            TreeNode nodesub = new TreeNode();
            nodesub.setId(map.get("FID") + "");
            nodesub.setText(map.get("FNAME") + "");
            list.add(nodesub);
        }
        return list;
    }

    private List<TreeNode> getInvoiceTypeNodeList(Object queryType) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(8);
        InputInvoiceTypeEnum[] invoiceTypes = InvoiceListConstant.getInvoiceType((Object)queryType);
        Map map = InputInvoiceTypeEnum.getInvoiceTypeFormBaseData();
        for (InputInvoiceTypeEnum type : invoiceTypes) {
            TreeNode node = new TreeNode();
            node.setId(type.getCode() + "");
            if (map.get(type.getCode()) != null) {
                node.setText((String)map.get(type.getCode()));
            } else {
                node.setText(type.getName());
            }
            list.add(node);
        }
        return list;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Long nodeId = Long.parseLong((String)evt.getNodeId());
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setFormId("bos_list");
        HashMap customParams = new HashMap();
        Map parameter = this.getView().getFormShowParameter().getCustomParams();
        customParams.putAll(parameter);
        String formId = "rim_invoice";
        Object mainFormId = parameter.get("mainformid");
        if (StringUtils.isNotBlank(mainFormId)) {
            formId = mainFormId.toString();
        }
        showParameter.setBillFormId(formId);
        Object queryType = parameter.get("querytype");
        JSONObject parentFilters = (JSONObject)parameter.get("filters");
        customParams.put("querytype", queryType);
        customParams.put("invoicetype", nodeId);
        if ("person_ticket".equals(queryType)) {
            customParams.put("invoicetype", "0");
            if (nodeId.equals(0L)) {
                TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
                tree.deleteAllNodes();
                List<TreeNode> list = InvoiceQueryMainPlugin.getInvoiceClassNodeList();
                tree.addNodes(list);
                tree.focusNode(list.get(0));
            }
        }
        customParams.put("filters", parentFilters);
        customParams.put("treePageId", this.getView().getPageId());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        if (InputInvoiceTypeEnum.ALL_INVOICE.getCode().equals(nodeId) && ("deduction".equals(queryType) || "undeduction".equals(queryType))) {
            filters.add(new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionTypes()));
        } else if (InputInvoiceTypeEnum.ALL_INVOICE.getCode().equals(nodeId) && ("taxdeduction".equals(queryType) || "readyselect_taxdeduction".equals(queryType))) {
            filters.add(new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getTransportTypes()));
        } else if (!InputInvoiceTypeEnum.ALL_INVOICE.getCode().equals(nodeId)) {
            if ("person_ticket".equals(queryType)) {
                filters.add(new QFilter("mul_class.fbasedataid_id", "=", (Object)nodeId));
            } else {
                filters.add(new QFilter("invoice_type", "=", (Object)nodeId));
            }
        }
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        String showUncheckConfig = RimConfigUtils.getConfig((String)"show_uncheck");
        Boolean needShow = Boolean.TRUE;
        if (!"person_ticket".equals(queryType) && (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig))) {
            needShow = Boolean.FALSE;
        }
        if (!needShow.booleanValue()) {
            QFilter checkFilter = new QFilter("check_status", "in", (Object)new String[]{"1", "4"});
            filters.add(checkFilter);
        }
        filters.add(tenantFilter);
        filters.add(delFilter);
        Long orgId = RequestContext.get().getOrgId();
        if (!CollectionUtils.isEmpty((Map)parentFilters)) {
            QFilter taxPeriodFilter = new QFilter("tax_period", "=", (Object)parentFilters.getDate("tax_period"));
            filters.add(taxPeriodFilter);
            orgId = parentFilters.getLong("org");
            if (orgId != null) {
                QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
                filters.add(orgfilter);
            }
            QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
            filters.add(taxAmountFilter);
            QFilter dtflagFilter = new QFilter("deduction_flag", "=", (Object)"1");
            filters.add(dtflagFilter);
            String transport_flag = parentFilters.getString("transport_flag");
            if (!StringUtils.isEmpty((CharSequence)transport_flag)) {
                String transport_deduction = parentFilters.getString("transport_deduction");
                if (StringUtils.isNotEmpty((CharSequence)transport_deduction)) {
                    QFilter tranflagFilter = new QFilter("transport_deduction", "=", (Object)transport_deduction);
                    filters.add(tranflagFilter);
                } else {
                    ArrayList tranDeductList = Lists.newArrayList();
                    tranDeductList.add("1");
                    tranDeductList.add("2");
                    QFilter tranflagFilter = new QFilter("transport_deduction", "in", (Object)tranDeductList);
                    filters.add(tranflagFilter);
                }
            }
            if (parentFilters.getLong("tax_org") != null) {
                QFilter taxOrgIdfilter = new QFilter("tax_org", "=", (Object)parentFilters.getLong("tax_org"));
                filters.add(taxOrgIdfilter);
            }
        }
        listFilterParameter.setQFilters(filters);
        showParameter.setShowTitle(false);
        customParams.put("hideColumn", parameter.get("hideColumn"));
        showParameter.setCustomParams(customParams);
        if ("ticket_pool".equals(queryType)) {
            showParameter.setCaption(InputInvoiceTypeEnum.getInvoiceType((Long)nodeId).getName());
        } else if ("deduction".equals(queryType) || "undeduction".equals(queryType)) {
            String caption = this.getView().getFormShowParameter().getCaption();
            String dkType = DeductionConstant.getDkType();
            DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)orgId, (AbstractFormPlugin)this);
            if (deductService != null) {
                deductService.getTaxPeriod();
            }
            showParameter.setCaption(caption);
        } else {
            showParameter.setCaption(this.getView().getFormShowParameter().getCaption());
        }
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_DATA_FLEX);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bos_list");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("close".equals(returnData)) {
            this.getView().close();
        } else if ("refresh".equals(returnData)) {
            TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
            tree.deleteAllNodes();
            List<TreeNode> list = InvoiceQueryMainPlugin.getInvoiceClassNodeList();
            tree.addNodes(list);
            tree.focusNode(list.get(0));
            tree.treeNodeClick(null, "0");
        }
    }
}

