/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.LqConvertUtil;
import org.apache.commons.lang3.StringUtils;

public class InvoiceSaveTestPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InvoiceSaveTestPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().showSuccessNotification("save test");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("baritemap".equals(itemKey)) {
            this.save();
        } else if ("baritemap1".equals(itemKey)) {
            this.update();
        } else if ("baritemap3".equals(itemKey)) {
            this.operate();
        }
    }

    private void save() {
        String json = (String)this.getModel().getValue("largetextfield_tag");
        if (json == null || "".equals(json)) {
            json = this.getPageCache().get("largetextfield_tag");
        } else {
            this.getPageCache().put("largetextfield_tag", json);
        }
        JSONObject queryData = JSONObject.parseObject((String)json);
        if ("0000".equals(queryData.getString("errcode"))) {
            JSONArray data = queryData.getJSONArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JSONObject invoiceJson = data.getJSONObject(i);
                String checkStatus = invoiceJson.getString("checkStatus");
                InvoiceSaveService service = InvoiceSaveService.newInstance((String)invoiceJson.getString("invoiceType"));
                if (service == null) continue;
                if (!"1".equals(checkStatus) && InputInvoiceTypeEnum.needCheck((Long)service.getInvoiceType()).booleanValue()) {
                    service.saveUncheckInvoice(invoiceJson, "unittest");
                    continue;
                }
                service.save(invoiceJson);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InvoiceSaveTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private void update() {
        String json = (String)this.getModel().getValue("largetextfield_tag");
        if (json == null || "".equals(json)) {
            json = this.getPageCache().get("largetextfield_tag");
        } else {
            this.getPageCache().put("largetextfield_tag", json);
        }
        JSONObject queryData = JSONObject.parseObject((String)json);
        String tab = queryData.getString("tab");
        if (!(!StringUtils.isEmpty((CharSequence)tab) && (tab.startsWith("rim_") || tab.startsWith("bdm_") || tab.startsWith("sim_") || tab.startsWith("dim_") || tab.startsWith("iim_") || tab.startsWith("invsm_")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9519\u8bef1", (String)"InvoiceSaveTestPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        JSONArray data = queryData.getJSONArray("data");
        ArrayList<Long> pkList = new ArrayList<Long>(16);
        HashMap<String, JSONObject> dataMap = new HashMap<String, JSONObject>(16);
        for (int i = 0; i < data.size(); ++i) {
            JSONObject invoiceJson = data.getJSONObject(i);
            if (invoiceJson.size() <= 2) continue;
            pkList.add(invoiceJson.getLong("id"));
            dataMap.put(invoiceJson.getString("id"), invoiceJson);
        }
        DynamicObject[] objList = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tab));
        try (TXHandle h = TX.required();){
            try {
                for (DynamicObject obj : objList) {
                    String id = obj.getPkValue().toString();
                    JSONObject val = (JSONObject)dataMap.get(id);
                    for (Map.Entry entry : val.entrySet()) {
                        String fileId = (String)entry.getKey();
                        if ("id".equals(fileId)) continue;
                        DynamicProperty property = obj.getDynamicObjectType().getProperty(fileId);
                        if (property instanceof DateTimeProp) {
                            obj.set(fileId, (Object)val.getDate(fileId));
                            continue;
                        }
                        if (property instanceof BasedataProp) {
                            obj.set(fileId, (Object)val.getLong(fileId));
                            continue;
                        }
                        if (property instanceof LongProp) {
                            obj.set(fileId, (Object)val.getLong(fileId));
                            continue;
                        }
                        if (property instanceof DecimalProp) {
                            obj.set(fileId, (Object)val.getBigDecimal(fileId));
                            continue;
                        }
                        obj.set(fileId, (Object)val.getString(fileId));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        logger.info("invoice:" + json);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InvoiceSaveTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
    }

    private void operate() {
        String json = (String)this.getModel().getValue("largetextfield_tag");
        if (json == null || "".equals(json)) {
            json = this.getPageCache().get("largetextfield_tag");
        } else {
            this.getPageCache().put("largetextfield_tag", json);
        }
        JSONObject queryData = JSONObject.parseObject((String)json);
        String operateType = queryData.getString("operateType");
        if ("updateTaxperiod".equals(operateType)) {
            DynamicObjectCollection lqptLogs;
            String reqKeyword;
            String taxNo;
            String billType = queryData.getString("billType");
            Long invoiceType = 0L;
            if ("1".equals(billType)) {
                invoiceType = InputInvoiceTypeEnum.HGJKS.getCode();
            } else if ("2".equals(billType)) {
                invoiceType = InputInvoiceTypeEnum.WITHHOLDING.getCode();
            }
            JSONObject data = queryData.getJSONObject("data");
            if (data != null) {
                this.updateInvoice(queryData, invoiceType, data);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InvoiceSaveTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            String service = queryData.getString("service");
            if (StringUtils.isEmpty((CharSequence)service)) {
                service = "203065HQDQSKSSQFPDKGXCLJG";
                if ("1".equals(billType)) {
                    service = "203065HQDQSKSSQHGJKSDKGXCLJG";
                } else if ("2".equals(billType)) {
                    service = "203065HQDQSKSSQDKDJWSPZDKGXCLJG";
                }
            }
            QFilter qFilter = new QFilter("service", "=", (Object)service);
            String traceid = queryData.getString("traceid");
            if (StringUtils.isNotEmpty((CharSequence)traceid)) {
                qFilter.and("traceid", "=", (Object)traceid);
            }
            if (StringUtils.isNotEmpty((CharSequence)(taxNo = queryData.getString("taxNo")))) {
                qFilter.and("tax_no", "=", (Object)taxNo);
            }
            Date timeStart = queryData.getDate("createTimeStart");
            Date timeEnd = queryData.getDate("createTimeEnd");
            if (timeStart != null) {
                qFilter.and("create_time", ">=", (Object)timeStart);
            }
            if (timeEnd != null) {
                qFilter.and("create_time", "<", (Object)timeEnd);
            }
            if (StringUtils.isNotEmpty((CharSequence)(reqKeyword = queryData.getString("reqKeyword")))) {
                qFilter.and("req_keyword", "=", (Object)reqKeyword);
            }
            if (!CollectionUtils.isEmpty((Collection)(lqptLogs = QueryServiceHelper.query((String)"bdm_lqpt_log", (String)"tax_no,request_tag,response_tag", (QFilter[])new QFilter[]{qFilter})))) {
                for (DynamicObject lqptLog : lqptLogs) {
                    String response_tag = lqptLog.getString("response_tag");
                    if (StringUtils.isEmpty((CharSequence)response_tag)) continue;
                    data = JSONObject.parseObject((String)response_tag);
                    this.updateInvoice(queryData, invoiceType, data);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InvoiceSaveTestPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u6570\u636e", (String)"InvoiceSaveTestPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        } else if ("compare".equals(operateType)) {
            JSONObject periodInvoices;
            JSONArray invoices;
            String reqKeyword;
            String taxNo;
            String taxPeriod = queryData.getString("taxPeriod");
            String billType = queryData.getString("billType");
            String service = queryData.getString("service");
            if (StringUtils.isEmpty((CharSequence)service)) {
                service = "203065HQDQSKSSQFPDKGXCLJG";
                if ("1".equals(billType)) {
                    service = "203065HQDQSKSSQHGJKSDKGXCLJG";
                } else if ("2".equals(billType)) {
                    service = "203065HQDQSKSSQDKDJWSPZDKGXCLJG";
                }
            }
            QFilter qFilter = new QFilter("service", "=", (Object)service);
            String traceid = queryData.getString("traceid");
            if (StringUtils.isNotEmpty((CharSequence)traceid)) {
                qFilter.and("traceid", "=", (Object)traceid);
            }
            if (StringUtils.isNotEmpty((CharSequence)(taxNo = queryData.getString("taxNo")))) {
                qFilter.and("tax_no", "=", (Object)taxNo);
            }
            Date timeStart = queryData.getDate("createTimeStart");
            Date timeEnd = queryData.getDate("createTimeEnd");
            if (timeStart != null) {
                qFilter.and("create_time", ">=", (Object)timeStart);
            }
            if (timeEnd != null) {
                qFilter.and("create_time", "<", (Object)timeEnd);
            }
            if (StringUtils.isNotEmpty((CharSequence)(reqKeyword = queryData.getString("reqKeyword")))) {
                qFilter.and("req_keyword", "=", (Object)reqKeyword);
            }
            if (CollectionUtils.isEmpty((Collection)(invoices = (periodInvoices = DeductStatisticsService.queryTaxPeriodInvoices((String)taxNo, (String)taxPeriod)).getJSONArray("data")))) {
                this.getModel().setValue("largetextfield1", (Object)"local invoices is empty");
                return;
            }
            DynamicObjectCollection lqptLogs = QueryServiceHelper.query((String)"bdm_lqpt_log", (String)"tax_no,request_tag,response_tag", (QFilter[])new QFilter[]{qFilter});
            ArrayList<String> taxcodenos = new ArrayList<String>(8);
            for (DynamicObject lqptLog : lqptLogs) {
                String responsetag = lqptLog.getString("response_tag");
                if (StringUtils.isEmpty((CharSequence)responsetag)) continue;
                JSONObject data = JSONObject.parseObject((String)responsetag);
                JSONArray invs = LqConvertUtil.getPeriodInvoices((Long)0L, (JSONObject)data);
                for (int i = 0; i < invs.size(); ++i) {
                    JSONObject object = invs.getJSONObject(i);
                    String invoiceCodeNoGroup = CommonUtils.getInvoiceCodeNoGroup((String)object.getString("fpdm"), (String)object.getString("fphm"));
                    taxcodenos.add(invoiceCodeNoGroup);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject object = invoices.getJSONObject(i);
                String invoiceCodeNoGroup = CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoiceCode"), (String)object.getString("invoiceNo"));
                if (taxcodenos.contains(invoiceCodeNoGroup)) continue;
                stringBuilder.append(invoiceCodeNoGroup).append('\n');
            }
            String msg = stringBuilder.toString();
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = "OK";
            }
            this.getModel().setValue("largetextfield1", (Object)msg);
        }
    }

    private void updateInvoice(JSONObject queryData, Long invoiceType, JSONObject data) {
        String zt = queryData.getString("zt");
        String authenticateTime = queryData.getString("authenticateTime");
        JSONArray periodInvoices = LqConvertUtil.getPeriodInvoices((Long)invoiceType, (JSONObject)data);
        JSONArray invoices = LqConvertUtil.convertPeriodInvoice((JSONArray)periodInvoices, (Long)invoiceType);
        if ("2".equals(zt)) {
            for (int i = 0; i < invoices.size(); ++i) {
                invoices.getJSONObject(i).put("authenticateTime", (Object)authenticateTime);
            }
        }
        DeductStatisticsService.updateInvoiceStatus((JSONArray)invoices, (String)zt, (Long)RequestContext.get().getOrgId());
    }
}

