/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections.CollectionUtils;

public class OpenVoucherDetailService {
    public static void openVoucherViewByMainId(AbstractFormPlugin plugin, Long mainId, String type) {
        QFilter filter = new QFilter("id", "=", (Object)mainId);
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no,vouch_no", (QFilter[])new QFilter[]{filter});
        OpenVoucherDetailService.openView(plugin, invoice, type);
    }

    public static void openVoucherViewBySerialNo(AbstractFormPlugin plugin, String serialNo, String type) {
        QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,serial_no,vouch_no", (QFilter[])new QFilter[]{filter});
        OpenVoucherDetailService.openView(plugin, invoice, type);
    }

    private static void openView(AbstractFormPlugin plugin, DynamicObject invoice, String type) {
        String serialNo;
        if (invoice != null && StringUtils.isNotEmpty((CharSequence)(serialNo = invoice.getString("serial_no")))) {
            QFilter billidFilter = new QFilter("billid", "=", (Object)serialNo);
            DynamicObjectCollection list = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"resource,vouch_no,vouchid,billid,account_date,account_time", (QFilter[])new QFilter[]{billidFilter});
            if (CollectionUtils.isEmpty((Collection)list)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u51ed\u8bc1\u5355\u4fe1\u606f", (String)"OpenVoucherDetailService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                ArrayList<Long> voucherIdList = new ArrayList<Long>(list.size());
                ArrayList<String> voucherEnterList = new ArrayList<String>(list.size());
                for (DynamicObject vouch : list) {
                    String vouchid = vouch.getString("vouchid");
                    if ("1".equals(vouch.getString("resource"))) {
                        voucherEnterList.add(vouchid);
                        continue;
                    }
                    Long pkId = BigDecimalUtil.transDecimal((Object)vouchid).longValue();
                    if (pkId <= 0L) continue;
                    voucherIdList.add(pkId);
                }
                if (!voucherEnterList.isEmpty()) {
                    OpenVoucherDetailService.showEnterVouch(plugin, list, serialNo, type);
                    return;
                }
                OpenVoucherDetailService.showStandardVouch(plugin, voucherIdList);
            }
        }
    }

    private static void showEnterVouch(AbstractFormPlugin plugin, DynamicObjectCollection list, String serialNo, String type) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u51ed\u8bc1\u5355\u4fe1\u606f", (String)"OpenVoucherDetailService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        if ("openInvoice".equals(type)) {
            customParams.put("openInvoice", type);
        }
        customParams.put("serials", serialNo);
        List vouchList = DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)list);
        customParams.put("vouch", vouchList);
        ViewUtil.openDialog((AbstractFormPlugin)plugin, null, customParams, (String)"rim_vouch_list", (String)type);
    }

    private static void showStandardVouch(AbstractFormPlugin plugin, List<Long> voucherIdList) {
        if (!CollectionUtils.isEmpty(voucherIdList)) {
            QFilter filter1 = new QFilter("id", "in", voucherIdList);
            List pkList = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{filter1}, null, (int)voucherIdList.size());
            if (CollectionUtils.isEmpty((Collection)pkList)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u51ed\u8bc1\u5355\u4fe1\u606f", (String)"OpenVoucherDetailService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (pkList.size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId(pkList.get(0));
                showParameter.setFormId("gl_voucher");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                plugin.getView().showForm((FormShowParameter)showParameter);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("gl_voucher");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
                qFilters.add(new QFilter("id", "in", (Object)pkList));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                showParameter.getCustomParams().put("org", "");
                showParameter.getCustomParams().put("booktype", "");
                plugin.getView().showForm((FormShowParameter)showParameter);
            }
        } else {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u51ed\u8bc1\u5355\u4fe1\u606f", (String)"OpenVoucherDetailService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
    }

    public static void updateVouch(Map<String, Object> returnData) {
        if (returnData != null) {
            String oldVouchid = (String)returnData.get("old_vouchid");
            String vouchid = (String)returnData.get("vouchid");
            String vouchNo = (String)returnData.get("vouch_no");
            String serials = (String)returnData.get("serials");
            List serialNos = CommonUtils.getMultiValues((String)serials);
            if (StringUtils.isNotEmpty((CharSequence)oldVouchid) && oldVouchid.equals(vouchid)) {
                QFilter vouchidFilter = new QFilter("vouchid", "=", (Object)oldVouchid);
                QFilter billidFilter = new QFilter("resource", "=", (Object)"1");
                Object[] vouchRelation = BusinessDataServiceHelper.load((String)"rim_vouch_relation", (String)"id,account_date,account_time,billid", (QFilter[])new QFilter[]{vouchidFilter, billidFilter});
                if (!ObjectUtils.isEmpty((Object[])vouchRelation)) {
                    Date accountDate = (Date)returnData.get("account_date");
                    if (accountDate != null) {
                        accountDate = DateUtils.getFirstDateOfMonth((Date)accountDate);
                    }
                    Date accountTime = OpenVoucherDetailService.getAccountTime(accountDate, (Date)returnData.get("account_time"));
                    for (Object dynamicObject : vouchRelation) {
                        dynamicObject.set("account_date", (Object)accountDate);
                        dynamicObject.set("account_time", (Object)accountTime);
                        String serial = dynamicObject.getString("billid");
                        if (serialNos.contains(serial)) continue;
                        serialNos.add(serial);
                    }
                } else {
                    throw new MsgException("0101", ResManager.loadKDString((String)"\u51ed\u8bc1\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a", (String)"OpenVoucherDetailService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                SaveServiceHelper.save((DynamicObject[])vouchRelation);
                ExpenseService expenseService = new ExpenseService();
                expenseService.updateInvoiceMain(serialNos, null);
                return;
            }
            String isVouchSerialsStr = (String)returnData.get("isVouchSerials");
            if (StringUtils.isNotEmpty((CharSequence)isVouchSerialsStr)) {
                String[] isVouchSerials = isVouchSerialsStr.split(",");
                OpenVoucherDetailService.deleteVouch(isVouchSerials);
            }
            VoucherService voucherService = new VoucherService();
            if (StringUtils.isNotEmpty((CharSequence)oldVouchid)) {
                JSONObject delParam = new JSONObject();
                delParam.put("vouchId", (Object)oldVouchid);
                delParam.put("resource", (Object)"1");
                delParam.put("serialNoArray", (Object)serialNos);
                voucherService.deleteVoucher((Map)delParam);
            }
            HashMap param = new HashMap(8);
            param.put("serialNoArray", serialNos);
            JSONObject voucherInfo = new JSONObject();
            voucherInfo.put("vouchId", (Object)vouchid);
            voucherInfo.put("vouchNo", (Object)vouchNo);
            String accountDateStr = "";
            Date accountDate = (Date)returnData.get("account_date");
            if (accountDate != null) {
                accountDate = DateUtils.getFirstDateOfMonth((Date)accountDate);
                accountDateStr = DateUtils.format((Date)accountDate);
            }
            Date accountTime = OpenVoucherDetailService.getAccountTime(accountDate, (Date)returnData.get("account_time"));
            voucherInfo.put("accountTime", (Object)DateUtils.format((Date)accountTime));
            voucherInfo.put("accountDate", (Object)accountDateStr);
            voucherInfo.put("resource", (Object)"1");
            param.put("voucherInfo", voucherInfo);
            voucherService.saveVoucher(param);
            InvoiceLog.insert((String)"voucher", (List)serialNos, (String)vouchNo);
        }
    }

    private static Date getAccountTime(Date accountDate, Date accountTime) {
        if (accountTime != null) {
            if (accountTime.compareTo(DateUtils.getLastDateOfMonth((Date)accountDate)) > 0) {
                return DateUtils.getFirstDateOfMonth((Date)accountDate);
            }
            return accountTime;
        }
        return DateUtils.getFirstDateOfMonth((Date)accountDate);
    }

    public static void showVouchDetail(AbstractFormPlugin plugin, Map<String, Object> returnData, String type) {
        if (returnData != null) {
            String resource = (String)returnData.get("resource");
            String vouchid = (String)returnData.get("vouchid");
            if ("1".equals(resource)) {
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                customParams.put("vouchid", vouchid);
                customParams.put("vouch_no", returnData.get("vouch_no"));
                customParams.put("serials", returnData.get("serials"));
                Date accountDate = (Date)returnData.get("account_date");
                String accountDateStr = accountDate != null ? DateUtils.format((Date)accountDate) : "";
                customParams.put("account_date", accountDateStr);
                Date accountTime = (Date)returnData.get("account_time");
                if (accountTime == null) {
                    accountTime = accountDate;
                }
                String accountTimeStr = accountTime != null ? DateUtils.format((Date)accountTime) : "";
                customParams.put("account_time", accountTimeStr);
                customParams.put("openInvoice", returnData.get("openInvoice"));
                ViewUtil.openDialog((AbstractFormPlugin)plugin, (String)ResManager.loadKDString((String)"\u67e5\u770b\u5165\u8d26\u4fe1\u606f", (String)"OpenVoucherDetailService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), customParams, (String)"rim_add_vouch", (String)type);
                return;
            }
            ArrayList<Long> voucherIdList = new ArrayList<Long>(1);
            Long pkId = BigDecimalUtil.transDecimal((Object)vouchid).longValue();
            if (pkId > 0L) {
                voucherIdList.add(pkId);
            }
            OpenVoucherDetailService.showStandardVouch(plugin, voucherIdList);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteVouch(String[] isVouchSerials) {
        if (ObjectUtils.isEmpty((Object[])isVouchSerials)) {
            return;
        }
        QFilter serialNoFilter = new QFilter("billid", "in", (Object)isVouchSerials);
        DynamicObjectCollection billList = QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id,vouchid,vouch_no,resource,billid", (QFilter[])new QFilter[]{serialNoFilter});
        ArrayList<Object> pkIds = new ArrayList<Object>(billList.size());
        HashMap<Object, void> vouchMap = new HashMap<Object, void>(billList.size());
        HashMap<Object, String> vouchNoMap = new HashMap<Object, String>(billList.size());
        for (DynamicObject obj : billList) {
            void var9_9;
            pkIds.add(obj.get("id"));
            String vouchid = obj.getString("vouchid");
            List list = (List)vouchMap.get(vouchid);
            if (list == null) {
                ArrayList arrayList = new ArrayList(8);
            }
            var9_9.add(obj.getString("billid"));
            vouchMap.put(vouchid, var9_9);
            vouchNoMap.put(vouchid, obj.getString("vouch_no"));
        }
        QFilter deleteFlilter = new QFilter("id", "in", pkIds);
        DeleteServiceHelper.delete((String)"rim_vouch_relation", (QFilter[])deleteFlilter.toArray());
        VoucherService voucherService = new VoucherService();
        for (Map.Entry entry : vouchMap.entrySet()) {
            List serialNos = (List)entry.getValue();
            String vouchid = (String)entry.getKey();
            voucherService.deleteInvoiceVouchEntry(serialNos, "1", vouchid);
            InvoiceLog.insert((String)"voucher", (List)serialNos, (String)("delete:" + vouchNoMap.getOrDefault(vouchid, vouchid)));
        }
        ExpenseService expenseService = new ExpenseService();
        expenseService.updateInvoiceMain(Arrays.asList(isVouchSerials), null);
    }

    public static void openAddVouch(AbstractFormPlugin plugin, String callBackKey, Object[] mainInvoiceKeys) {
        QFilter filte = new QFilter("id", "in", (Object)mainInvoiceKeys);
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,expense_status,total_amount,billno", (QFilter[])new QFilter[]{filte});
        StringBuilder serialNos = new StringBuilder();
        HashSet<String> vouchSerialNos = new HashSet<String>(8);
        HashMap<String, String> invoiceMap = new HashMap<String, String>(invoiceCollection.size());
        for (DynamicObject object : invoiceCollection) {
            String expense_status = object.getString("expense_status");
            String serial_no = object.getString("serial_no");
            if (!StringUtils.isEmpty((CharSequence)expense_status) && "65".equals(expense_status)) {
                vouchSerialNos.add(serial_no);
            }
            if (invoiceMap.containsKey(serial_no)) continue;
            serialNos.append(serial_no).append(',');
            invoiceMap.put(serial_no, object.getString("billno"));
        }
        plugin.getPageCache().put("add_vouch_serials", serialNos.toString());
        plugin.getPageCache().put("is_vouch_serials", String.join((CharSequence)",", vouchSerialNos));
        if (!CollectionUtils.isEmpty(vouchSerialNos)) {
            String str;
            VoucherService voucherService = new VoucherService();
            DynamicObjectCollection collection = voucherService.queryVouchRelationBySerialNos((List)JSONArray.parseArray((String)JSON.toJSONString(vouchSerialNos)));
            StringBuilder message = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                for (DynamicObject dynamicObject : collection) {
                    String resource = dynamicObject.getString("resource");
                    if ("1".equals(resource)) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s \u975e\u5168\u7968\u6c60\u624b\u5de5\u7ef4\u62a4\u5165\u8d26\u4fe1\u606f,\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"OpenVoucherDetailService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceMap.get(dynamicObject.getString("billid")));
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(str = message.toString()))) {
                ViewUtil.showMessage((AbstractFormPlugin)plugin, (String)message.toString());
                return;
            }
            plugin.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u90e8\u5206\u53d1\u7968\u5df2\u5165\u8d26\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fee\u6539\u5165\u8d26\u4fe1\u606f?", (String)"OpenVoucherDetailService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(callBackKey), null);
        } else {
            HashMap<String, String> customParams = new HashMap<String, String>(1);
            customParams.put("serials", serialNos.toString());
            ViewUtil.openDialog((AbstractFormPlugin)plugin, null, customParams, (String)"rim_add_vouch", (String)callBackKey);
        }
    }
}

