/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.expense;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.fpzs.ExpenseStatusLogService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AbnormalSignInListPlugin
extends LicenseFormPlugin
implements RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(AbnormalSignInListPlugin.class);
    public static final String ENTRYENTITY = "entryentity";
    private static final String toolBarExit = "close";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit base = (MulBasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initFormStyle();
        ViewUtil.hideToolbar((AbstractFormPlugin)this, (String[])new String[]{toolBarExit});
    }

    private void initFormStyle() {
        Object[] list = new Object[]{RequestContext.get().getOrgId()};
        this.getModel().setValue("org", (Object)list);
        DynamicObjectCollection coll = BaseDataServiceHelper.queryBaseData((String)"rim_expense_type", null, null, (String)"id,number,name");
        ComboEdit comboEdit = (ComboEdit)this.getControl("expense_type1");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        for (DynamicObject dy : coll) {
            data.add(new ComboItem(new LocaleString(dy.getString("name")), dy.getString("number")));
        }
        comboEdit.setComboItems(data);
        ComboEdit comboEdit2 = (ComboEdit)this.getControl("expense_type_drop");
        comboEdit2.setComboItems(data);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("query".equals(itemKey)) {
            this.queryList();
        } else if ("ignore".equals(itemKey)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_IGNORE, (String)"ignore");
            EntryGrid qrEntry = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = qrEntry.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5ffd\u7565\u7684\u4e1a\u52a1\u5355\u636e", (String)"AbnormalSignInListPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u6211\u518d\u60f3\u60f3", (String)"AbnormalSignInListPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5ffd\u7565", (String)"AbnormalSignInListPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6807\u8bc6\u5ffd\u7565\u7684\u5355\uff0c\u5c06\u4e0d\u5728\u7b7e\u6536\u5f02\u5e38\u5217\u8868\u4e2d\u5c55\u793a", (String)"AbnormalSignInListPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener("expense_ignore"), btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("expense_ignore".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            EntryGrid qrEntry = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = qrEntry.getSelectRows();
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRows[i]);
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                JSONObject json = new JSONObject();
                json.put("expense_id", dynamicObject.get("expense_id"));
                json.put("expense_num", dynamicObject.get("expense_num"));
                json.put("serial_no", null);
                json.put("prev_status", null);
                json.put("entry_id", dynamicObject.get("entityid"));
                jSONArray.add((Object)json);
            }
            ExpenseStatusLogService expenseStatusLogService = new ExpenseStatusLogService();
            expenseStatusLogService.newExpenseStatusLog(jSONArray, "ignore", null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ffd\u7565\u6210\u529f", (String)"AbnormalSignInListPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.queryList();
        }
    }

    private void queryList() {
        ExpenseService expenseService;
        DynamicObjectCollection collection;
        this.clearListData();
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        List orgIds = orgs.stream().map(c -> c.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\uff01", (String)"AbnormalSignInListPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter expenseFilters = new QFilter("orgid", "in", orgIds);
        String expenseType = (String)this.getModel().getValue("expense_type1");
        String expenseNum = (String)this.getModel().getValue("expense_num1");
        if (StringUtils.isNotBlank((CharSequence)expenseType)) {
            expenseFilters.and("expense_type", "=", (Object)expenseType);
        }
        if (StringUtils.isNotBlank((CharSequence)expenseNum)) {
            expenseFilters.and("expense_num", "=", (Object)expenseNum);
        }
        if (CollectionUtils.isEmpty((Collection)(collection = (expenseService = new ExpenseService()).findByFilter("expense_id, expense_num, expense_type, creator_id, expense_amount, entityid", expenseFilters)))) {
            LOGGER.info("\u62a5\u9500\u5355\u7ed3\u679c\u4e3a\u7a7a");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u62a5\u9500\u5355\u7ed3\u679c\u4e3a\u7a7a\uff01", (String)"AbnormalSignInListPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        List expenseIds = collection.stream().map(c -> c.getString("expense_id")).collect(Collectors.toList());
        ExpenseStatusLogService expenseStatusLogService = new ExpenseStatusLogService();
        QFilter logFilters = new QFilter("expense_id", "in", expenseIds);
        logFilters.and("operate_type", "=", (Object)"ignore");
        DynamicObjectCollection logCollection = expenseStatusLogService.findByFilter("expense_id", logFilters);
        List ignoreExpenseIds = logCollection.stream().map(c -> c.getString("expense_id")).collect(Collectors.toList());
        List expenses = collection.stream().filter(c -> !ignoreExpenseIds.contains(c.getString("expense_id"))).collect(Collectors.toList());
        expenseIds = expenses.stream().map(c -> c.getString("expense_id")).collect(Collectors.toList());
        QFilter qFilters = new QFilter("1", "=", (Object)1);
        qFilters.and("expense_id", "in", expenseIds);
        ExpenseRelationService expenseRelationService = new ExpenseRelationService();
        DynamicObject[] relCollection = expenseRelationService.findByFilter2("expense_id, serial_no, expense_amount", qFilters);
        if (relCollection == null || relCollection.length == 0) {
            LOGGER.info("\u62a5\u9500\u5355\u5173\u7cfb\u7ed3\u679c\u4e3a\u7a7a");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u62a5\u9500\u5355\u5173\u7cfb\u7ed3\u679c\u4e3a\u7a7a\uff01", (String)"AbnormalSignInListPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Map<String, List<DynamicObject>> groupByExpenseId = Arrays.stream(relCollection).collect(Collectors.groupingBy(e -> e.getString("expense_id")));
        List serialNos = Arrays.stream(relCollection).map(c -> c.getString("serial_no")).collect(Collectors.toList());
        QFilter invFilters = new QFilter("serial_no", "in", serialNos);
        invFilters.and(new QFilter("original_state", "=", (Object)"1"));
        InvoiceQueryService invoiceQueryService = new InvoiceQueryService();
        DynamicObjectCollection invCollection = invoiceQueryService.findByFilter("serial_no, original_time", invFilters);
        List finalSerialNos = invCollection.stream().map(c -> c.getString("serial_no")).collect(Collectors.toList());
        HashMap totalSerialNosMap = new HashMap(groupByExpenseId.size());
        HashMap signInSerialNosMap = new HashMap(groupByExpenseId.size());
        HashMap totalAmountMap = new HashMap(groupByExpenseId.size());
        HashMap minOriginalTimeMap = new HashMap(groupByExpenseId.size());
        groupByExpenseId.forEach((k, v) -> {
            List totalSerialNos = v.stream().map(c -> c.getString("serial_no")).collect(Collectors.toList());
            List signInSerialNos = totalSerialNos.stream().filter(num -> finalSerialNos.contains(num)).collect(Collectors.toList());
            if (totalSerialNos.size() == signInSerialNos.size()) {
                return;
            }
            BigDecimal totalAmount = v.stream().filter(expenseRel -> expenseRel.getBigDecimal("expense_amount") != null).map(c -> c.getBigDecimal("expense_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalAmountMap.put(k, totalAmount);
            totalSerialNosMap.put(k, totalSerialNos);
            signInSerialNosMap.put(k, signInSerialNos);
            Optional<Date> minOriginalTimeOptional = invCollection.stream().filter(c -> signInSerialNos.contains(c.getString("serial_no"))).filter(inv -> !ObjectUtils.isEmpty((Object)inv.getDate("original_time"))).map(inv -> inv.getDate("original_time")).min(Date::compareTo);
            if (!minOriginalTimeOptional.isPresent()) {
                return;
            }
            minOriginalTimeMap.put(k, minOriginalTimeOptional.get());
        });
        List resultList = expenses.stream().filter(c -> totalSerialNosMap.containsKey(c.getString("expense_id"))).map(expense -> {
            LinkedHashMap temMap = Maps.newLinkedHashMap();
            temMap.put("expense_id", expense.getString("expense_id"));
            temMap.put("expense_num", expense.getString("expense_num"));
            temMap.put("expense_type", expense.getString("expense_type"));
            temMap.put("expense_type_drop", expense.getString("expense_type"));
            temMap.put("creator_id", expense.getString("creator_id"));
            temMap.put("serial_no", CollectionUtils.isEmpty((Collection)((Collection)totalSerialNosMap.get(temMap.get("expense_id")))) ? null : String.join((CharSequence)",", (Iterable)totalSerialNosMap.get(temMap.get("expense_id"))));
            temMap.put("invoice_cnt", CollectionUtils.isEmpty((Collection)((Collection)totalSerialNosMap.get(temMap.get("expense_id")))) ? 0 : ((List)totalSerialNosMap.get(temMap.get("expense_id"))).size());
            List signSerials = (List)signInSerialNosMap.get(temMap.get("expense_id"));
            temMap.put("sign_in_serial_no", CollectionUtils.isEmpty((Collection)signSerials) ? null : String.join((CharSequence)",", signSerials));
            temMap.put("sign_in_cnt", CollectionUtils.isEmpty((Collection)signSerials) ? 0 : signSerials.size());
            temMap.put("original_time", minOriginalTimeMap.get(temMap.get("expense_id")));
            temMap.put("expense_amount", totalAmountMap.get(temMap.get("expense_id")));
            temMap.put("entityid", expense.getString("entityid"));
            return temMap;
        }).collect(Collectors.toList());
        this.getModel().beginInit();
        resultList.stream().forEach(map -> {
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            map.entrySet().stream().forEach(modelEntry -> this.getModel().setValue((String)modelEntry.getKey(), modelEntry.getValue(), row));
        });
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void clearListData() {
        this.getModel().deleteEntryData(ENTRYENTITY);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, arg0.getRowIndex());
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"expense_num", (CharSequence)arg0.getFieldName())) {
            String expenseId = dynamicObject.getString("expense_id");
            this.operate(expenseId);
        } else if (StringUtils.equals((CharSequence)"invoice_cnt", (CharSequence)arg0.getFieldName())) {
            this.viewInvoice(dynamicObject);
        } else if (StringUtils.equals((CharSequence)"sign_in_cnt", (CharSequence)arg0.getFieldName())) {
            this.viewSignInInvoice(dynamicObject);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_abnormal_sign_in_list", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idQFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }

    public void operate(String mainId) {
        QFilter filter = new QFilter("expense_id", "=", (Object)mainId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_expense_relation", (String)"resource,view_page,entityid,expense_id,expense_num,expense_type,create_time,reimbursingid", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u9500\u5355\u4fe1\u606f", (String)"AbnormalSignInListPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            DynamicObject expense = dynamicObject;
            String expenseId = expense.getString("expense_id");
            String entityid = expense.getString("entityid");
            if (MetadataUtil.exists((String)(entityid = ExpenseConstant.getExpenseEntityId((String)expenseId, (String)entityid))).booleanValue()) {
                String expenseid = expense.getString("expense_id");
                String reimbursingid = expense.getString("reimbursingid");
                if (StringUtils.isEmpty((CharSequence)reimbursingid)) {
                    reimbursingid = ExpenseConstant.getExpenseReimbursingid((String)expenseid, (String)entityid);
                }
                LOGGER.info("\u6253\u5f00\u62a5\u9500\u5355\u8be6\u60c5{}:{}", (Object)entityid, (Object)reimbursingid);
                this.showDetail(reimbursingid, entityid);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u9500\u5355\u8be6\u60c5", (String)"AbnormalSignInListPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            String expenseid = (String)returnData.get("reimbursingId");
            String entityid = (String)returnData.get("entityid");
            this.showDetail(expenseid, entityid);
        }
    }

    private void showDetail(String expenseid, String entityid) {
        Long pkId = BigDecimalUtil.transDecimal((Object)expenseid).longValue();
        if (pkId < 1L || StringUtils.isEmpty((CharSequence)entityid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u9500\u5355\u8be6\u60c5", (String)"AbnormalSignInListPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityid, (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"id:%1$s\u5355\u636e\u4e0d\u5b58\u5728", (String)"AbnormalSignInListPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseid), Integer.valueOf(2000));
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("entityid", entityid);
        customParams.put("pkId", pkId);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("rim_expense_detail");
        if (mainEntityType.getDisplayName() != null) {
            showParameter.setCaption(mainEntityType.getDisplayName().getLocaleValue());
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "view_expense");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void viewInvoice(DynamicObject dynamicObject) {
        String serialNos = dynamicObject.getString("serial_no");
        String[] serialNoStr = StringUtils.split((String)serialNos, (String)",");
        if (serialNoStr == null || serialNoStr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u9500\u5355\u8be6\u60c5", (String)"AbnormalSignInListPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        this.openInvoceList(dynamicObject, Arrays.asList(serialNoStr));
    }

    public void viewSignInInvoice(DynamicObject dynamicObject) {
        String signInSerialNo = dynamicObject.getString("sign_in_serial_no");
        String[] signInSerialNos = StringUtils.split((String)signInSerialNo, (String)",");
        if (signInSerialNos == null || signInSerialNos.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5df2\u7b7e\u6536\u7684\u53d1\u7968", (String)"AbnormalSignInListPlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        this.openInvoceList(dynamicObject, Arrays.asList(signInSerialNos));
    }

    private void openInvoceList(DynamicObject dynamicObject, List<String> taxNoList) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("billType", dynamicObject.getString("expense_type"));
        customParams.put("expenseId", dynamicObject.getString("expense_id"));
        customParams.put("resource", ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624b4", (String)"AbnormalSignInListPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        customParams.put("serialList", taxNoList);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId("rim_view_invoice");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_view_invoice");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }
}

