/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateFactory;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class DeductOperateService
extends InvoiceOperateService {
    private static Log logger = LogFactory.getLog(DeductOperateService.class);
    public static final String OPERATE_TYPE = "operatetype";
    public static final String INVOICES = "invoices";

    public DeductOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
        this.currentOrgId = currentOrgId;
    }

    @Override
    public void operate() {
        Map loadFromCache;
        String deductionPurpose;
        boolean checkUndeduction;
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        this.plugin.getPageCache().remove("selectResult");
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DeductOperateService_58", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Map parentCustomParams = listPlugin.getView().getFormShowParameter().getCustomParams();
        Object queryType = parentCustomParams.get("querytype");
        QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level", (QFilter[])new QFilter[]{filte});
        int count = invoiceCollection.size();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        StringBuilder message = new StringBuilder();
        JSONArray invoices = new JSONArray();
        for (DynamicObject object : invoiceCollection) {
            String msg;
            String msg2;
            String authenticateFlag = object.getString("authenticate_flag");
            String isVoucher = object.getString("isvoucher");
            String invoiceCode = object.getString("invoice_code");
            String invoiceNo = object.getString("invoice_no");
            String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
            if ("deduction_select".equals(this.type) && !StringUtils.isEmpty((CharSequence)authenticateFlag) && !"0".equals(authenticateFlag) && !"4".equals(authenticateFlag)) {
                msg2 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u52fe\u9009\u4e2d\u3001\u5df2\u52fe\u9009\u6216\u8005\u5df2\u8ba4\u8bc1\uff0c\u8bf7\u9009\u62e9\u201c\u672a\u52fe\u9009\u201d\u6216\u201c\u9884\u52fe\u9009\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"DeductOperateService_52", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                message.append(msg2);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            if ("deduction_unselect".equals(this.type)) {
                if (!"1".equals(authenticateFlag)) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u672a\u52fe\u9009\u3001\u9884\u52fe\u9009\u3001\u52fe\u9009\u4e2d\u6216\u8005\u5df2\u8ba4\u8bc1\uff0c\u8bf7\u9009\u62e9\u201c\u5df2\u52fe\u9009\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"DeductOperateService_53", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("1".equals(isVoucher)) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5df2\u751f\u6210\u51ed\u8bc1,\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"DeductOperateService_68", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
            }
            if ("drawback".equals(queryType)) {
                String remark;
                String outputType = object.getString("output_type");
                if (StringUtils.isNotEmpty((CharSequence)outputType)) {
                    String msg3 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5df2\u8fdb\u9879\u8fdb\u9879\u8f6c\u51fa\uff0c\u8bf7\u9009\u62e9\u672a\u8f6c\u51fa\u7684\u53d1\u7968\u3002", (String)"DeductOperateService_55", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg3);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if (StringUtils.isNotEmpty((CharSequence)(remark = object.getString("remark"))) && remark.contains("\u4ee3\u529e\u9000\u7a0e")) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u4ee3\u529e\u9000\u7a0e\u7684\u53d1\u7968\u4e0d\u80fd\u9000\u7a0e\u52fe\u9009\u3002", (String)"DeductOperateService_56", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
            }
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("invoice_type"));
            String invoiceStatus = object.getString("invoice_status");
            if (!(!"deduction_select".equals(this.type) || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) || "0".equals(invoiceStatus) || "7".equals(invoiceStatus))) {
                msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5df2\u7ea2\u51b2\u6216\u8005\u4f5c\u5e9f\uff0c\u8bf7\u9009\u62e9\u201c\u6b63\u5e38\u201d\u6216\u201c\u90e8\u5206\u7ea2\u51b2\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"DeductOperateService_57", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                message.append(msg);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType) && object.getDate("invoice_date") == null) {
                msg = String.format(ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\uff1a%1$s\u586b\u5f00\u65e5\u671f\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u52fe\u9009\u3002", (String)"DeductOperateService_69", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                message.append(msg);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            totalAmount = totalAmount.add(BigDecimalUtil.transDecimal((Object)object.get("total_amount")));
            totalTaxAmount = totalTaxAmount.add(BigDecimalUtil.transDecimal((Object)object.get("total_tax_amount")));
            Map invoiceMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)object);
            invoices.add((Object)invoiceMap);
        }
        String totalInfo = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u91cf\uff1a%1$s\u4efd\uff0c\u603b\u4ef7\u7a0e\u5408\u8ba1\uff1a%2$s\uff0c\u603b\u53ef\u62b5\u6263\u7a0e\u989d\uff1a%3$s", (String)"DeductOperateService_59", (String)"imc-rim-formplugin", (Object[])new Object[0]), count, BigDecimalUtil.decimalFormat((BigDecimal)totalAmount), BigDecimalUtil.decimalFormat((BigDecimal)totalTaxAmount));
        String deductName = ResManager.loadKDString((String)"\u62b5\u6263\u52fe\u9009", (String)"DeductOperateService_65", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        boolean bl = checkUndeduction = "undeduction".equals(queryType) || "readyselect_undeduction".equals(queryType);
        if (checkUndeduction) {
            deductName = ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u52fe\u9009", (String)"DeductOperateService_66", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if ("2".equals(deductionPurpose = DeductionConstant.getDeductionPurposeByQueryType((String)queryType.toString()))) {
            deductName = ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u52fe\u9009", (String)"DeductOperateService_66", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        } else if ("3".equals(deductionPurpose)) {
            deductName = ResManager.loadKDString((String)"\u9000\u7a0e\u52fe\u9009", (String)"DeductOperateService_67", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        String str = message.toString();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)deductName, (String)message.toString(), (int)0, (int)count);
            return;
        }
        ArrayList orgList = Lists.newArrayListWithExpectedSize((int)invoices.size());
        for (int i = 0; i < invoices.size(); ++i) {
            String taxNo;
            JSONObject invoice = invoices.getJSONObject(i);
            Long orgId = invoice.getLong("org");
            String buyerTaxNo = invoice.getString("buyer_tax_no");
            Long invoiceType = invoice.getLong("invoice_type");
            if (InputInvoiceTypeEnum.HGJKS.getCode().compareTo(invoiceType) != 0 || !StringUtils.isEmpty((CharSequence)buyerTaxNo) || orgId == null || orgId == 0L || !StringUtils.isEmpty((CharSequence)(taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId)))) continue;
            orgList.add(orgId);
        }
        if (orgList != null && !orgList.isEmpty() && (loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])orgList.toArray(), (String)"bos_org")) != null) {
            String fomat = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5173\u8054\u7684\u6838\u7b97\u7ec4\u7ec7\uff1a%s\u672a\u7ef4\u62a4\u7a0e\u53f7\uff0c\u52fe\u9009\u5931\u8d25", (String)"DeductOperateService_60", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            String orgInfo = loadFromCache.values().stream().map(v -> v.getLocaleString("name").getLocaleValue()).collect(Collectors.joining("\u3001"));
            this.plugin.getView().showTipNotification(String.format(fomat, orgInfo));
            return;
        }
        if ("deduction_select".equals(this.type)) {
            FormShowParameter showParameter = new FormShowParameter();
            parentCustomParams.put("deductionPurpose", deductionPurpose);
            parentCustomParams.put("deductName", deductName);
            parentCustomParams.put(INVOICES, invoices);
            parentCustomParams.put(OPERATE_TYPE, this.type);
            showParameter.setCustomParams(parentCustomParams);
            showParameter.setFormId("rim_deduct_edit");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u7f16\u8f91", (String)"DeductOperateService_61", (String)"imc-rim-formplugin", (Object[])new Object[0]), deductName));
            this.plugin.getView().showForm(showParameter);
            this.plugin.getPageCache().put("deduct_title", ResManager.loadKDString((String)"\u53d1\u7968\u52fe\u9009", (String)"DeductOperateService_62", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.plugin.getPageCache().put("deduct_title", ResManager.loadKDString((String)"\u64a4\u9500\u52fe\u9009", (String)"DeductOperateService_63", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.plugin.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u64a4\u9500%s\u5417\uff1f", (String)"DeductOperateService_64", (String)"imc-rim-formplugin", (Object[])new Object[0]), deductName), totalInfo, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(this.type), null);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject returnData;
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)this.type, (CharSequence)actionId) && (returnData = (JSONObject)closedCallBackEvent.getReturnData()) != null) {
            this.selectInvoice(returnData, Boolean.TRUE, null);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("deduction_unselect".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level", (QFilter[])new QFilter[]{filte});
            Map parentCustomParams = this.plugin.getView().getFormShowParameter().getCustomParams();
            Object queryType = parentCustomParams.get("querytype");
            Object invoicetype = parentCustomParams.get("invoicetype");
            Long invoiceType = Long.valueOf(String.valueOf(invoicetype));
            JSONObject param = DeductionConstant.getSelectParamJson(queryType, (Object)this.type, (Long)invoiceType);
            JSONArray invoices = new JSONArray();
            String deductionPurpose = DeductionConstant.getDeductionPurposeByQueryType((String)queryType.toString());
            param.put("cancelSelectType", (Object)"1");
            for (DynamicObject object : invoiceCollection) {
                invoices.add((Object)DeductionConstant.createSelectJson((DynamicObject)object, (String)deductionPurpose));
            }
            param.put(INVOICES, (Object)invoices);
            this.selectInvoice(param, Boolean.TRUE, null);
        }
    }

    public void selectInvoice(JSONObject param, Boolean showTip, Consumer<String> consumer) {
        JSONArray invoices = param.getJSONArray(INVOICES);
        param.remove((Object)INVOICES);
        List list = JSONArray.parseArray((String)invoices.toJSONString(), JSONObject.class);
        Map<String, List<JSONObject>> invoiceGroupMap = list.stream().map(t -> {
            if (null == t.get((Object)"buyerTaxNo")) {
                t.put("buyerTaxNo", (Object)"");
            }
            return t;
        }).collect(Collectors.groupingBy(s -> s.getString("buyerTaxNo")));
        if (MapUtils.isEmpty(invoiceGroupMap)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u7684\u7a0e\u53f7\u4fe1\u606f\u4e3a\u7a7a", (String)"DeductOperateService_70", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        Set<Map.Entry<String, List<JSONObject>>> entrySet = invoiceGroupMap.entrySet();
        String taskNo = UUID.randomUUID();
        JSONObject cacheJson = new JSONObject();
        String openSelectSyn = RimConfigUtils.getConfig((String)"open_select_syn");
        String rpaSelectSyn = RimConfigUtils.getConfig((String)"rpa_select_syn");
        int successNum = 0;
        int failNum = 0;
        StringBuilder message = new StringBuilder();
        JSONObject selectRtn = null;
        for (Map.Entry<String, List<JSONObject>> entry : entrySet) {
            JSONObject paramJson = new JSONObject();
            paramJson.putAll((Map)param);
            Long orgId = null;
            String taxNo = entry.getKey();
            paramJson.put("taxNo", (Object)taxNo);
            paramJson.put("taskNo", (Object)taskNo);
            List<JSONObject> invoiceList = entry.getValue();
            for (JSONObject invoice : invoiceList) {
                invoice.remove((Object)"buyerTaxNo");
                if (ObjectUtils.isEmpty(orgId)) {
                    orgId = invoice.getLong("orgId");
                }
                invoice.remove((Object)"orgId");
            }
            paramJson.put("orgId", orgId);
            paramJson.put(INVOICES, invoiceList);
            cacheJson.put(taxNo, (Object)paramJson);
            if ("1".equals(openSelectSyn)) continue;
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                failNum += invoiceList.size();
                message.append(this.getFailMsg(invoiceList, ErrorType.TAXNO_NULL.getName()));
                continue;
            }
            String dkType = DeductionConstant.getDkType((String)taxNo);
            logger.info("{}\u6536\u7968\u901a\u9053:{}", (Object)taxNo, (Object)dkType);
            if (StringUtils.isBlank((CharSequence)dkType)) {
                failNum += invoiceList.size();
                message.append(this.getFailMsg(invoiceList, ErrorType.DKTYPE_NULL.getName()));
                continue;
            }
            if ("1".equals(rpaSelectSyn)) {
                paramJson.put("rpa_select_syn", (Object)rpaSelectSyn);
            }
            DeductSelectService deductSelectService = DeductServiceFactory.newInstanceForDeductSelect((String)dkType);
            String queryType = paramJson.getString("queryType");
            JSONArray isselect = invoiceList.stream().filter(f -> "1".equals(f.getString("isselect"))).collect(Collectors.toCollection(JSONArray::new));
            JSONArray noselect = invoiceList.stream().filter(f -> "0".equals(f.getString("isselect"))).collect(Collectors.toCollection(JSONArray::new));
            if (isselect.size() == 0 && noselect.size() == 0 && (selectRtn = deductSelectService.batchSelectInvoices(paramJson)) != null) {
                successNum += selectRtn.getInteger("successNum").intValue();
                failNum += selectRtn.getInteger("failNum").intValue();
                message.append(selectRtn.get((Object)"message"));
                continue;
            }
            if (isselect.size() > 0) {
                if ("undeduction".equals(queryType)) {
                    paramJson.put("deductibleMode", (Object)"4");
                } else if ("deduction".equals(queryType)) {
                    paramJson.put("deductibleMode", (Object)"1");
                }
                paramJson.put(INVOICES, (Object)isselect);
                selectRtn = deductSelectService.batchSelectInvoices(paramJson);
                if (selectRtn != null) {
                    successNum += selectRtn.getInteger("successNum").intValue();
                    failNum += selectRtn.getInteger("failNum").intValue();
                    message.append(selectRtn.get((Object)"message"));
                    continue;
                }
            }
            if (noselect.size() <= 0) continue;
            paramJson.put("cancelSelectType", (Object)"1");
            for (int i = 0; i < noselect.size(); ++i) {
                if ("undeduction".equals(queryType)) {
                    paramJson.put("deductibleMode", (Object)"-4");
                    continue;
                }
                if (!"deduction".equals(queryType)) continue;
                paramJson.put("deductibleMode", (Object)"-1");
            }
            paramJson.put(INVOICES, (Object)noselect);
            selectRtn = deductSelectService.batchSelectInvoices(paramJson);
            if (selectRtn == null) continue;
            successNum += selectRtn.getInteger("successNum").intValue();
            failNum += selectRtn.getInteger("failNum").intValue();
            message.append(selectRtn.get((Object)"message"));
        }
        if ("1".equals(openSelectSyn)) {
            this.plugin.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
            InvoiceOperateService service = showTip != false ? InvoiceOperateFactory.newInstance("deduct_login_select", this.currentOrgId, this.plugin) : InvoiceOperateFactory.newInstance("deduct_login_select", this.currentOrgId, this.plugin, consumer);
            service.operate();
        } else if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String title = ResManager.loadKDString((String)"\u63d0\u4ea4\u52fe\u9009\u5931\u8d25", (String)"DeductOperateService_74", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            if (successNum > 0) {
                title = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u52fe\u9009%1$s\u6761\uff0c\u63d0\u4ea4\u52fe\u9009\u6210\u529f%2$s\u6761\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u201d\u67e5\u770b\u72b6\u6001\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u8be5\u9875\u9762\u67e5\u770b\u7ed3\u679c\uff1b\u63d0\u4ea4\u52fe\u9009\u5931\u8d25%3$s\u6761", (String)"DeductOperateService_73", (String)"imc-rim-formplugin", (Object[])new Object[0]), successNum + failNum, successNum, failNum);
            }
            this.plugin.getView().showMessage(title, message.toString(), MessageTypes.Default);
            if (successNum > 0) {
                this.refresh();
            }
        } else {
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u201d\u5217\u8868 \u67e5\u770b\u5904\u7406\u65e5\u5fd7\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u5f53\u524d\u9875\u9762\u67e5\u770b\u7ed3\u679c", (String)"DeductOperateService_72", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
    }

    private void refresh() {
        BillList billlist = (BillList)this.plugin.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }

    private String getFailMsg(List<JSONObject> invoiceList, String failMsg) {
        StringBuilder message = new StringBuilder();
        for (JSONObject invoice : invoiceList) {
            message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s %2$s\u3002", (String)"DeductOperateService_71", (String)"imc-rim-formplugin", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup((String)invoice.getString("invoiceCode"), (String)invoice.getString("invoiceNo")), failMsg)).append(ViewUtil.LINE_SEPARATOR);
        }
        return message.toString();
    }

    private void showTips(String s) {
    }
}

