/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;

public class DeductTaxOperateService
extends InvoiceOperateService {
    public DeductTaxOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DeductTaxOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,authenticate_flag,transport_deduction,invoice_code,invoice_no,deduction_flag", (QFilter[])new QFilter[]{filte});
        StringBuilder serialNos = new StringBuilder();
        HashMap<String, String> invoiceMap = new HashMap<String, String>(invoiceCollection.size());
        StringBuilder message = new StringBuilder();
        for (DynamicObject object : invoiceCollection) {
            String serial_no;
            String msg;
            String transport_deduction = object.getString("transport_deduction");
            String deductionFlag = object.getString("deduction_flag");
            String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"));
            if (!"1".equals(deductionFlag)) {
                msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s \u4e0d\u53ef\u62b5\u6263\uff0c\u8bf7\u9009\u62e9\u201c\u53ef\u62b5\u6263\u201d\u7684\u53d1\u7968\u3002", (String)"DeductTaxOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                message.append(msg);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            if ("deduction_tax".equals(this.type) && "1".equals(transport_deduction)) {
                msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5df2\u62b5\u6263\uff0c\u8bf7\u9009\u62e9\u201c\u672a\u62b5\u6263\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"DeductTaxOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                message.append(msg);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            if ("undeduction_tax".equals(this.type) && "0".equals(transport_deduction)) {
                msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u672a\u62b5\u6263\uff0c\u8bf7\u9009\u62e9\u201c\u5df2\u62b5\u6263\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"DeductTaxOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                message.append(msg);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            if (invoiceMap.containsKey(serial_no = object.getString("serial_no"))) continue;
            serialNos.append(serial_no).append(',');
            invoiceMap.put(serial_no, serial_no);
        }
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)message.toString());
            return;
        }
        this.plugin.getPageCache().put("select_taxperiod_serials", serialNos.toString());
        if ("deduction_tax".equals(this.type)) {
            FormShowParameter showParameter = new FormShowParameter();
            HashMap customParams = new HashMap(8);
            showParameter.setCustomParams(customParams);
            showParameter.setFormId("rim_select_tax_period");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
            showParameter.setCloseCallBack(closeCallBack);
            this.plugin.getView().showForm(showParameter);
        } else {
            this.plugin.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u64a4\u9500\u62b5\u6263\u5417?", (String)"DeductTaxOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(this.type), null);
        }
    }

    private String getFormat(DynamicObject object, String s, String deductTaxOperateService_1) {
        String format = ResManager.loadKDString((String)s, (String)deductTaxOperateService_1, (String)"imc-rim-formplugin", (Object[])new Object[0]);
        return String.format(format, CommonUtils.getInvoiceCodeNoGroup((String)object.getString("DeductTaxOperateService_5"), (String)object.getString("imc-rim-formplugin")));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Date taxPeriod;
        if ("deduction_tax".equals(closedCallBackEvent.getActionId()) && (taxPeriod = (Date)closedCallBackEvent.getReturnData()) != null) {
            this.deductInvoice("1", taxPeriod);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("undeduction_tax".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.deductInvoice("0", new Date());
        }
    }

    private void deductInvoice(String transportDeduction, Date taxPeriod) {
        String serials = this.plugin.getPageCache().get("select_taxperiod_serials");
        String[] serialnos = serials.substring(0, serials.length() - 1).split(",");
        List<String> serialNoList = Arrays.asList(serialnos);
        if (CollectionUtils.isNotEmpty(serialNoList)) {
            DeductInvoiceOperateService service = new DeductInvoiceOperateService();
            String deductibleMode = "-6";
            if ("1".equals(transportDeduction)) {
                deductibleMode = "6";
            }
            service.transportDeductBySerialNo(serialNoList, transportDeduction, taxPeriod, deductibleMode, "1");
            BillList billlist = (BillList)this.plugin.getControl("billlistap");
            billlist.clearSelection();
            billlist.refresh();
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DeductTaxOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }
}

