/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;

public class DeductionLoginOperateService
extends InvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(DeductionLoginOperateService.class);
    private static String[] INOUTS = new String[]{"1", "2", "4", "5"};

    public DeductionLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
        this.currentOrgId = currentOrgId;
        this.showResult = this::showResult;
    }

    public DeductionLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin, Consumer<String> consumer) {
        this.plugin = plugin;
        this.type = type;
        this.currentOrgId = currentOrgId;
        this.showResult = consumer;
    }

    @Override
    public void operate() {
        String cache = this.plugin.getPageCache().get("deduct_tax_no");
        String title = this.plugin.getPageCache().get("deduct_title");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject cacheJson = JSONObject.parseObject((String)cache);
        if (ObjectUtils.isEmpty((Object)cacheJson)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> list = new ArrayList<String>(cacheJson.size());
        LOGGER.info("\u767b\u5f55\u68c0\u6d4b\u7a0e\u53f7:{}", (Object)cacheJson.keySet());
        for (Map.Entry entry : cacheJson.entrySet()) {
            String taxNo = (String)entry.getKey();
            JSONObject configObj = cacheJson.getJSONObject(taxNo);
            String dkType = this.getNewDkType(taxNo, configObj);
            LOGGER.info("{}\u6536\u7968\u901a\u9053:{}", (Object)taxNo, (Object)dkType);
            if (Boolean.TRUE.equals(configObj.getBoolean("noLogin"))) {
                this.afterLoginDoOperation(dkType, taxNo, configObj, null);
                list.add(taxNo);
                continue;
            }
            if ("4".equals(dkType)) {
                boolean isBreak = this.loginEleClient(cacheJson, list, taxNo, configObj, dkType);
                if (!isBreak) continue;
                return;
            }
            this.afterLoginDoOperation(dkType, taxNo, configObj, null);
            list.add(taxNo);
        }
        for (String tt : list) {
            cacheJson.remove((Object)tt);
        }
        if (cacheJson.isEmpty()) {
            this.showResult.accept(title);
        }
    }

    private String getNewDkType(String taxNo, JSONObject configObj) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        if (!"deduct_login_down_invoice".equals(this.type)) {
            return dkType;
        }
        if (ObjectUtils.isEmpty((Object)taxNo) || ObjectUtils.isEmpty((Object)dkType) || ObjectUtils.isEmpty((Object)configObj)) {
            return dkType;
        }
        if ("5".equals(dkType)) {
            return dkType;
        }
        JSONArray batchNoList = configObj.getJSONArray("data");
        boolean isCheckDkType = true;
        if (!CollectionUtils.isEmpty((Collection)batchNoList)) {
            for (int i = 0; i < batchNoList.size(); ++i) {
                JSONObject logConfig = batchNoList.getJSONObject(i);
                if (Arrays.asList(INOUTS).contains(logConfig.getString("inout"))) continue;
                isCheckDkType = false;
                break;
            }
        }
        return isCheckDkType ? InvoiceDownloadConstant.convertLqCollect((String)taxNo, (String)dkType) : dkType;
    }

    private boolean loginEleClient(JSONObject cacheJson, List<String> list, String taxNo, JSONObject configObj, String dkType) {
        NewEtaxDeductService service = new NewEtaxDeductService(Long.valueOf(0L));
        JSONObject loginResult = service.login(taxNo);
        JSONObject data = loginResult.getJSONObject("data");
        if (ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
            if (service.needOpenLoginPage(data)) {
                data.put("taxNo", (Object)taxNo);
                service.showLoginPage(data, this.plugin, this.type);
                this.plugin.getPageCache().put("loginTaxNo", taxNo);
                for (String tt : list) {
                    cacheJson.remove((Object)tt);
                }
                this.plugin.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
                return true;
            }
            this.afterLoginDoOperation(dkType, taxNo, configObj, null);
            list.add(taxNo);
        } else {
            this.afterLoginDoOperation(dkType, taxNo, configObj, loginResult.getString("description"));
            list.add(taxNo);
        }
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String taxNo = this.plugin.getPageCache().get("loginTaxNo");
        String cache = this.plugin.getPageCache().get("deduct_tax_no");
        String title = this.plugin.getPageCache().get("deduct_title");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject json = JSONObject.parseObject((String)cache);
        if (ObjectUtils.isEmpty((Object)json)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String dkType = "4";
        JSONObject configObj = json.getJSONObject(taxNo);
        if (StringUtils.isNotBlank((Object)closedCallBackEvent.getReturnData())) {
            this.afterLoginDoOperation(dkType, taxNo, configObj, null);
        } else {
            this.afterLoginDoOperation(dkType, taxNo, configObj, ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"DeductionLoginOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        json.remove((Object)taxNo);
        if (json.isEmpty()) {
            this.showResult.accept(title);
        } else {
            this.plugin.getPageCache().put("deduct_tax_no", json.toJSONString());
            this.operate();
        }
    }

    protected void setOperationResult2Cache(JSONObject operationRtn) {
        String resultCache = this.plugin.getPageCache().get("operation_result");
        JSONObject resultInfo = null;
        int successNum = 0;
        int failNum = 0;
        StringBuilder message = new StringBuilder();
        if (resultCache != null) {
            resultInfo = JSONObject.parseObject((String)resultCache);
            successNum += resultInfo.getIntValue("successNum");
            failNum += resultInfo.getIntValue("failNum");
            String msg = resultInfo.getString("message");
            if (msg != null) {
                message.append(msg);
            }
        } else {
            resultInfo = ResultContant.createSuccessJSONObject();
        }
        if (!ResultContant.isSuccess((JSONObject)operationRtn).booleanValue()) {
            resultInfo.put("errcode", operationRtn.get((Object)"errcode"));
        }
        message.append(operationRtn.get((Object)"message"));
        resultInfo.put("successNum", (Object)(successNum += operationRtn.getInteger("successNum").intValue()));
        resultInfo.put("failNum", (Object)(failNum += operationRtn.getInteger("failNum").intValue()));
        resultInfo.put("message", (Object)message.toString());
        this.plugin.getPageCache().put("operation_result", resultInfo.toJSONString());
    }

    private void showResult(String title) {
        DeductionUtils.showResult((AbstractFormPlugin)this.plugin);
    }
}

