/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseOperateService
extends InvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(ExpenseOperateService.class);

    public ExpenseOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"ExpenseOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            LOGGER.info("\u7ef4\u62a4\u62a5\u9500\u4fe1\u606f\uff0cpkValue\uff1a{}\uff0c", selectCollection.getPrimaryKeyValues());
            QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,expense_status,total_amount", (QFilter[])new QFilter[]{filte});
            StringBuilder serialNos = new StringBuilder();
            HashMap<String, String> invoiceMap = new HashMap<String, String>(invoiceCollection.size());
            for (DynamicObject object : invoiceCollection) {
                String expense_status = object.getString("expense_status");
                if (!StringUtils.isEmpty((CharSequence)expense_status) && !"1".equals(expense_status)) {
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u53d1\u7968\u5728\u7528\u6216\u8005\u5df2\u7528\uff0c\u8bf7\u9009\u62e9\u201c\u672a\u7528\u201d\u72b6\u6001\u7684\u53d1\u7968\u8fdb\u884c\u3002", (String)"ExpenseOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                String serial_no = object.getString("serial_no");
                if (invoiceMap.containsKey(serial_no)) continue;
                serialNos.append(serial_no).append(',');
                invoiceMap.put(serial_no, serial_no);
            }
            this.plugin.getPageCache().put("add_expense_serials", serialNos.toString());
            FormShowParameter showParameter = new FormShowParameter();
            HashMap<String, String> customParams = new HashMap<String, String>(8);
            customParams.put("serials", serialNos.toString());
            showParameter.setCustomParams(customParams);
            LOGGER.info("\u7ef4\u62a4\u62a5\u9500\u4fe1\u606f\uff0ccustomParam\uff1a{}\uff0c", customParams);
            showParameter.setFormId("rim_add_expense");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
            showParameter.setCloseCallBack(closeCallBack);
            this.plugin.getView().showForm(showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data = (Map)closedCallBackEvent.getReturnData();
        if (data != null) {
            if ("1".equals(data.get("updateBillList"))) {
                BillList billlist = (BillList)this.plugin.getControl("billlistap");
                billlist.clearSelection();
                billlist.refresh();
                return;
            }
            String serials = this.plugin.getPageCache().get("add_expense_serials");
            try {
                ExpenseRelationService expenseRelationService = new ExpenseRelationService();
                expenseRelationService.saveExpenseInfo(data, serials);
            }
            catch (MsgException e) {
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%1$s", (String)"ExpenseOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            BillList billlist = (BillList)this.plugin.getControl("billlistap");
            billlist.clearSelection();
            billlist.refresh();
        }
    }
}

