/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.formplugin.downloadcenter.InvoiceExportService;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;

public class ExportOperateService
extends InvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(ExportOperateService.class);
    private static final int BATCH = 5000;

    public ExportOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("bdm_download_center");
            showParameter.setFormId("bos_list");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.plugin.getView().showForm((FormShowParameter)showParameter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void operate() {
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        String invoiceType = String.valueOf(customParams.get("invoicetype"));
        String queryType = String.valueOf(customParams.get("querytype"));
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        int size = selectCollection.size();
        if (size > 50000) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u53d1\u7968\u6700\u591a\u9009\u53d650000\u6761\u6570\u636e", (String)"ExportOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Object[] pkList = null;
        List<QFilter> qfilters = this.getQFilter(customParams);
        pkList = size == 0 ? this.getInvoiceId(qfilters) : selectCollection.getPrimaryKeyValues();
        if (pkList == null || pkList.length < 1) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"ExportOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        size = pkList.length;
        if (size <= 5000) {
            String userId = RequestContext.get().getUserId();
            InvoiceExportService service = new InvoiceExportService();
            byte[] bytes = service.buildXSSFWorkbook(queryType, invoiceType, this.type, pkList, qfilters, Long.valueOf(userId));
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                String urls = "";
                if (this.plugin == null) return;
                String fileName = this.plugin.getView().getFormShowParameter().getCaption() + "_" + DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                String permItem = "4730fc9f000004ae";
                if ("export_head".equals(this.type)) {
                    fileName = fileName + '_' + "\u4e0d\u542b\u660e\u7ec6";
                    permItem = this.getExportPermItem();
                }
                urls = FileUploadUtils.getTempFileUrl((String)(fileName + ".xlsx"), (InputStream)in, (int)5000, (String)"rim_invoice", (String)permItem);
                this.plugin.getView().openUrl(urls);
                return;
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("0030", ResManager.loadKDString((String)"\u751f\u6210excel\u5931\u8d25", (String)"ExportOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0])), new Object[0]);
            }
        } else {
            this.dispatch(pkList, qfilters);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ExportOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u523b\u524d\u5f80", (String)"ExportOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.plugin.getView().showConfirm(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u5bfc\u51fa\u5904\u7406\u4e2d\uff0c\u7531\u4e8e\u6570\u636e\u91cf\u8f83\u5927\uff0c\u60a8\u53ef\u4ee5\u524d\u5f80\u4e0b\u8f7d\u4e2d\u5fc3\u67e5\u770b\u8fdb\u5ea6", (String)"ExportOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(this.type), btnNameMaps);
        }
    }

    private String getExportPermItem() {
        String[] permItems;
        RequestContext request = RequestContext.get();
        for (String permItem : permItems = new String[]{"4730fc9f000004ae", "29ROM/MNM/2K"}) {
            int checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(request.getUserId()), (Long)request.getOrgId(), (String)"rim", (String)"rim_invoice", (String)permItem);
            if (checkPerm <= 0) continue;
            return permItem;
        }
        return "4730fc9f000004ae";
    }

    private void dispatch(Object[] pkids, List<QFilter> qfilters) {
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        Object invoiceType = customParams.get("invoicetype");
        Object queryType = customParams.get("querytype");
        String name = InputInvoiceTypeEnum.getInvoiceType((Long)Long.parseLong(String.valueOf(invoiceType))).getName();
        Date currentDate = new Date();
        DynamicObject centerData = BusinessDataServiceHelper.newDynamicObject((String)"bdm_download_center");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        centerData.set("applytime", (Object)currentDate);
        centerData.set("appid", (Object)"rim");
        centerData.set("source", (Object)ResManager.loadKDString((String)"\u8fdb\u9879\u53d1\u7968\u5bfc\u51fa", (String)"ExportOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        String billno = name + "_" + format.format(currentDate);
        if ("export_head".equals(this.type)) {
            billno = name + '_' + "\u4e0d\u542b\u660e\u7ec6" + '_' + format.format(currentDate);
        }
        centerData.set("filename", (Object)(billno + ".zip"));
        centerData.set("handlestate", (Object)"1");
        centerData.set("applicant", (Object)RequestContext.get().getUserId());
        centerData.set("exp_param", (Object)(queryType + "|" + invoiceType + "|" + this.type));
        centerData.set("delstate", (Object)"1");
        centerData.set("file_type", (Object)"1");
        try {
            if (qfilters != null) {
                JSONArray array = new JSONArray();
                for (QFilter filter : qfilters) {
                    array.add((Object)filter.toSerializedString());
                }
                centerData.set("qfilter_tag", (Object)array.toJSONString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{centerData});
        ThreadPools.executeOnce((String)"ExportOperate_dispatch", () -> {
            DynamicObjectCollection detailCollection = centerData.getDynamicObjectCollection("invoice_detail");
            for (Object pk : pkids) {
                DynamicObject detail = detailCollection.addNew();
                detail.set("serial_no", (Object)String.valueOf(pk));
                detail.set("deal_result", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{centerData});
            InvoiceExportService service = new InvoiceExportService();
            service.dealSync();
        });
    }

    private List<QFilter> getQFilter(Map<String, Object> customParams) {
        Long userId;
        QFilter filter;
        List<Object> qfilters = new ArrayList<QFilter>(8);
        IPageCache pageCache = this.plugin.getPageCache();
        String qfilterCache = pageCache.get("filters");
        LOGGER.info("getInvoiceId-fiters:{}", (Object)qfilterCache);
        if (StringUtils.isNotEmpty((CharSequence)qfilterCache)) {
            List qfilterCacheStrList = SerializationUtils.fromJsonStringToList((String)qfilterCache, String.class);
            for (String filterStr : qfilterCacheStrList) {
                QFilter qFilter = QFilter.fromSerializedString((String)filterStr);
                qfilters.add(qFilter);
            }
            JSONObject filters = (JSONObject)customParams.get("filters");
            if (!ObjectUtils.isEmpty((Object)filters)) {
                qfilters = qfilters.stream().filter(f -> !"tax_period".equals(f.getProperty())).collect(Collectors.toList());
                QFilter taxPeriodFilter = new QFilter("tax_period", "=", (Object)filters.getDate("tax_period"));
                qfilters.add(taxPeriodFilter);
            }
        }
        String orgCache = pageCache.get("current_org_id");
        LOGGER.info("getInvoiceId-current_org_id:{}", (Object)orgCache);
        if (StringUtils.isNotEmpty((CharSequence)orgCache)) {
            JSONArray array = JSONArray.parseArray((String)orgCache);
            ArrayList<Long> list = new ArrayList<Long>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                list.add(array.getLong(i));
            }
            QFilter orgQFilter = new QFilter("org.id", "in", list);
            qfilters.add(orgQFilter);
        }
        if ((filter = PermissionServiceHelper.getDataPermission((long)(userId = Long.valueOf(RequestContext.get().getUserId())), (String)"rim", (String)"rim_invoice")) != null) {
            qfilters.add(filter);
        }
        return qfilters;
    }

    private Object[] getInvoiceId(List<QFilter> qfilters) {
        if (!qfilters.isEmpty()) {
            List pks = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])qfilters.toArray(new QFilter[0]), null, (int)100000);
            return pks.toArray(new Object[0]);
        }
        return null;
    }
}

