/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.helper.ExcelHelper;
import kd.imc.rim.common.helper.ExcelInvoiceUploadHelper;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.lang3.StringUtils;

public class ImportOperateService
extends InvoiceOperateService {
    private static Log logger = LogFactory.getLog(ImportOperateService.class);
    private static final String TEMPLATE_DIR = "templates";
    private static final String TEMPLATE_NAME = "\u5168\u7968\u6c60\u5f15\u5165\u6a21\u677f.xlsx";

    public ImportOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        super.operate();
        if (this.checkPermission()) {
            if ("download_template".equals(this.type)) {
                ExcelHelper.downloadTemplate((AbstractFormPlugin)this.plugin, (String)TEMPLATE_DIR, (String)TEMPLATE_NAME);
            } else if (!"import_invoice".equals(this.type) && "import_result".equals(this.type)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setShowTitle(true);
                showParameter.setFormId("rim_collect_import_result");
                showParameter.setCustomParam("entityId", (Object)"rim_invoice");
                showParameter.setCustomParam("permItem", (Object)"251PPI92VIL5");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, "importResultCallback");
                showParameter.setCloseCallBack(closeCallBack);
                this.plugin.getView().showForm(showParameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        Object[] urls = evt.getUrls();
        if (urls.length >= 2) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u540c\u65f6\u4e0a\u4f20\u4e00\u4e2aexcel\u6587\u4ef6", (String)"ImportOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (urls.length <= 0) return;
        String excelUrl = urls[0].toString();
        if (StringUtils.isEmpty((CharSequence)excelUrl)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6587\u4ef6\u8def\u5f84", (String)"ImportOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        int lastSeparator = excelUrl.lastIndexOf(47);
        String fileName = excelUrl.substring(lastSeparator + 1);
        if (!FileUtils.isExcel((String)fileName)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165excel\u6587\u4ef6", (String)"ImportOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = urls[0].toString();
        if (StringUtils.isEmpty((CharSequence)url)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6587\u4ef6\u8def\u5f84", (String)"ImportOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        InputStream fileInputStream = null;
        FileService service = FileServiceFactory.getAttachmentFileService();
        fileInputStream = service.getInputStream(url);
        fileInputStream = UrlServiceUtils.getAttachmentDecodedStream((InputStream)fileInputStream);
        Boolean isAdmin = InvoiceOperateService.checkPermission("download_template");
        JSONObject paramResult = new JSONObject();
        JSONObject fileParam = new JSONObject();
        fileParam.put("fileName", (Object)fileName);
        fileParam.put("fileUrl", (Object)url);
        fileParam.put("isAdmin", (Object)isAdmin);
        paramResult.put("source", (Object)"full_pool");
        ExcelInvoiceUploadHelper.getResolveResult((InputStream)fileInputStream, (JSONObject)fileParam, null, (JSONObject)paramResult);
        this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6b63\u5728\u5f15\u5165\u4e2d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5019\u3002\u60a8\u53ef\u5728\u3010\u5f15\u5165\u53d1\u7968\u3011\u7684\u4e0b\u62c9\u5217\u8868\u4e2d\u67e5\u770b\u8fdb\u5ea6\u5e76\u4e0b\u8f7d\u7ed3\u679c", (String)"ImportOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5173\u95edexcel\u6d41\u6587\u4ef6\u4e8b\u53d8%1$s", (String)"ImportOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return;
        catch (Exception e) {
            try {
                logger.error((Throwable)e);
                this.plugin.getView().showErrorNotification(e.getMessage());
                if (fileInputStream == null) return;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.error((Throwable)e2);
                    this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5173\u95edexcel\u6d41\u6587\u4ef6\u4e8b\u53d8%1$s", (String)"ImportOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), e2.getMessage()));
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (IOException e3) {
                logger.error((Throwable)e3);
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5173\u95edexcel\u6d41\u6587\u4ef6\u4e8b\u53d8%1$s", (String)"ImportOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), e3.getMessage()));
            }
            return;
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }
}

