/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;

public class InvoiceDetailOperateService
extends InvoiceOperateService {
    public InvoiceDetailOperateService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        super.operate();
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        String invoiceDetailFormId = "rim_invoice_query_detail";
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(invoiceDetailFormId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.plugin.getView().showForm(formShowParameter);
            return;
        }
        Object[] pkValues = selectCollection.getPrimaryKeyValues();
        HashMap<Long, ArrayList<String>> typeSerialNoMap = new HashMap<Long, ArrayList<String>>(InputInvoiceTypeEnum.getDetialType().length);
        if (pkValues != null && pkValues.length > 0) {
            QFilter mainIdFilter = new QFilter("id", "in", (Object)pkValues);
            DynamicObjectCollection mainInvoice = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no, invoice_type", (QFilter[])mainIdFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)mainInvoice)) {
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230id\u4e3a%1$s\u7684\u53d1\u7968\u4fe1\u606f", (String)"InvoiceDetailOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Arrays.toString(pkValues)));
                return;
            }
            for (DynamicObject mainObj : mainInvoice) {
                if (ObjectUtils.isEmpty((Object)mainObj)) continue;
                Long invoiceTypeCode = mainObj.getLong("invoice_type");
                InputInvoiceTypeEnum invoiceTypeEnum = InputInvoiceTypeEnum.getInvoiceType((Long)invoiceTypeCode);
                Long invoiceType = invoiceTypeEnum.getCode();
                if (!Arrays.asList(InputInvoiceTypeEnum.getDetialType()).contains(invoiceTypeEnum)) continue;
                String serialNo = mainObj.getString("serial_no");
                ArrayList<String> serialNos = (ArrayList<String>)typeSerialNoMap.get(invoiceType);
                if (CollectionUtils.isEmpty((Collection)serialNos)) {
                    serialNos = new ArrayList<String>(8);
                }
                serialNos.add(serialNo);
                typeSerialNoMap.put(invoiceType, serialNos);
            }
            if (CollectionUtils.isEmpty(typeSerialNoMap)) {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u7c7b\u578b\u65e0\u660e\u7ec6\u6570\u636e\u5c55\u793a", (String)"InvoiceDetailOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String serialNoMapStr = SerializationUtils.toJsonString(typeSerialNoMap);
        formShowParameter.setCustomParam("serialNoMapStr", (Object)serialNoMapStr);
        this.plugin.getView().showForm(formShowParameter);
    }
}

