/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class RelayInvoiceService
extends InvoiceOperateService {
    public RelayInvoiceService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        if ("relay_invoice".equals(this.type)) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"RelayInvoiceService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
            lsp.setCloseCallBack(closeCallBack);
            this.plugin.getView().showForm((FormShowParameter)lsp);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectCollection = ((IListView)this.plugin.getView()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"RelayInvoiceService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        ListSelectedRowCollection userList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (userList == null) {
            return;
        }
        Object[] primaryKeyValues = userList.getPrimaryKeyValues();
        ArrayList successList = Lists.newArrayList();
        ArrayList failList = Lists.newArrayList();
        if (primaryKeyValues != null) {
            DynamicObject[] invoices;
            Long userId = (Long)primaryKeyValues[0];
            Object[] invoiceIds = selectCollection.getPrimaryKeyValues();
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((Object[])invoiceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"))) {
                String expenseStatus = invoice.getString("expense_status");
                if ("1".equals(expenseStatus) || StringUtils.isEmpty((CharSequence)expenseStatus)) {
                    DynamicObjectCollection users = invoice.getDynamicObjectCollection("collect_user_entry");
                    if (CollectionUtils.isEmpty((Collection)users)) {
                        DynamicObject object = users.addNew();
                        object.set("collect_user", (Object)userId);
                        object.set("rim_user", (Object)userId);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
                        successList.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)invoice));
                        continue;
                    }
                    for (DynamicObject user : users) {
                        if (!RequestContext.get().getUserId().equals(user.getDynamicObject("collect_user").getPkValue() + "")) continue;
                        user.set("collect_user", (Object)userId);
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{user});
                        successList.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)invoice));
                    }
                    continue;
                }
                failList.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)invoice));
            }
        }
        StringBuilder message = new StringBuilder();
        if (failList.size() > 0) {
            for (Map map : failList) {
                Object invoice_type = map.get("invoice_type");
                String msg = "";
                if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice_type)) {
                    Object total_amount = map.get("total_amount");
                    msg = String.format(ResManager.loadKDString((String)"\u975e\u672a\u7528\u53d1\u7968\u4e0d\u80fd\u6307\u6d3e\uff1a\u91d1\u989d%1$s", (String)"RelayInvoiceService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), BigDecimalUtil.transDecimal(total_amount).intValue());
                } else {
                    msg = String.format(ResManager.loadKDString((String)"\u975e\u672a\u7528\u53d1\u7968\u4e0d\u80fd\u6307\u6d3e\uff1a\u53d1\u7968%1$s", (String)"RelayInvoiceService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), InvoiceConvertUtils.getInvoiceCodeAndNo((String)((String)map.get("invoice_code")), (String)((String)map.get("invoice_no")), (String)"-"));
                }
                message.append(msg).append(ViewUtil.LINE_SEPARATOR);
            }
        }
        if (failList.size() == 0) {
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6307\u6d3e\u6210\u529f", (String)"RelayInvoiceService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)ResManager.loadKDString((String)"\u53d1\u7968\u6307\u6d3e\u8be6\u60c5", (String)"RelayInvoiceService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)message.toString(), (int)successList.size(), (int)failList.size());
        }
        BillList billlist = (BillList)this.plugin.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }
}

