/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.helper.ExcelHelper;
import kd.imc.rim.common.helper.ExcelInvoiceUploadHelper;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.query.operate.DeductOperateService;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class SelectInvoiceExcelService
extends InvoiceOperateService {
    private static final String TEMPLATE_DIR = "templates";
    private static final String TEMPLATE_NAME_VAT = "\u53d1\u7968\u52fe\u9009\u5f15\u5165\u6a21\u677f-\u589e\u503c\u7a0e.xlsx";
    private static final String TEMPLATE_NAME_CUSTOM = "\u53d1\u7968\u52fe\u9009\u5f15\u5165\u6a21\u677f-\u6d77\u5173\u7f34\u6b3e\u4e66.xlsx";
    private static final String VAT_DEDUCT = "vat_deduct_";
    private static final String VAT_UNDEDUCT = "vat_undeduct_";
    private static final String CUSTOM_DEDUCT = "custom_deduct_";
    private static final String CUSTOM_UNDEDUCT = "custom_undeduct_";

    private static String SUCCESS() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"SelectInvoiceExcelService_51", (String)"imc-rim-formplugin", (Object[])new Object[0]);
    }

    private static final String FAIL() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"SelectInvoiceExcelService_52", (String)"imc-rim-formplugin", (Object[])new Object[0]);
    }

    public SelectInvoiceExcelService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        boolean permission = InvoiceOperateService.checkPermission("excel_select");
        if (!permission) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f15\u5165\u6e05\u5355\u52fe\u9009\u64cd\u4f5c\u6743\u9650", (String)"SelectInvoiceExcelService_53", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        Object invoiceType = customParams.get("invoicetype");
        String queryType = (String)customParams.get("querytype");
        if ("excel_select_upload".equals(this.type)) {
            if ("0".equals(invoiceType.toString()) && ("deduction".equals(queryType) || "undeduction".equals(queryType))) {
                ExcelHelper.downloadTemplate((AbstractFormPlugin)this.plugin, (String)TEMPLATE_DIR, (String)TEMPLATE_NAME_VAT);
            } else {
                ExcelHelper.downloadTemplate((AbstractFormPlugin)this.plugin, (String)TEMPLATE_DIR, (String)TEMPLATE_NAME_CUSTOM);
            }
        } else if ("excel_select_result".equals(this.type)) {
            String cacheKey = this.getCacheKey(invoiceType, queryType);
            String resultListCache = CacheHelper.get((String)(cacheKey + "resultListCache"));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setShowTitle(true);
            showParameter.setCustomParam("result", (Object)resultListCache);
            showParameter.setFormId("rim_select_excel_result");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.plugin.getView().showForm(showParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterUpload(UploadEvent evt) {
        JSONArray result;
        boolean permission = InvoiceOperateService.checkPermission("excel_select");
        if (!permission) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f15\u5165\u6e05\u5355\u52fe\u9009\u64cd\u4f5c\u6743\u9650", (String)"SelectInvoiceExcelService_53", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        super.afterUpload(evt);
        Object[] urls = evt.getUrls();
        if (urls.length >= 2) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u540c\u65f6\u4e0a\u4f20\u4e00\u4e2aexcel\u6587\u4ef6", (String)"SelectInvoiceExcelService_54", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (urls.length <= 0) return;
        String excelUrl = urls[0].toString();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)excelUrl)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6587\u4ef6\u8def\u5f84", (String)"SelectInvoiceExcelService_55", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        int lastSeparator = excelUrl.lastIndexOf(47);
        String fileName = excelUrl.substring(lastSeparator + 1);
        if (!FileUtils.isExcel((String)fileName)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165excel\u6587\u4ef6", (String)"SelectInvoiceExcelService_56", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = urls[0].toString();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)url)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6587\u4ef6\u8def\u5f84", (String)"SelectInvoiceExcelService_55", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream fileInputStream = service.getInputStream(url);
        fileInputStream = UrlServiceUtils.getAttachmentDecodedStream((InputStream)fileInputStream);
        JSONObject fileParam = new JSONObject();
        fileParam.put("fileName", (Object)fileName);
        fileParam.put("fileUrl", (Object)url);
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        Object invoiceType = customParams.get("invoicetype");
        String queryType = (String)customParams.get("querytype");
        fileParam.put("queryType", (Object)queryType);
        if ("0".equals(invoiceType.toString()) && ("deduction".equals(queryType) || "undeduction".equals(queryType))) {
            fileParam.put("selectType", (Object)"0");
        } else {
            fileParam.put("selectType", (Object)"1");
        }
        String cacheKey = this.getCacheKey(invoiceType, queryType);
        JSONObject resultUrl = this.selectByExcel(fileInputStream, fileParam);
        String resultListCache = CacheHelper.get((String)(cacheKey + "resultListCache"));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resultListCache)) {
            result = new JSONArray();
        } else {
            result = JSONArray.parseArray((String)resultListCache);
            JSONArray array = new JSONArray();
            for (int i = 0; i < result.size(); ++i) {
                JSONObject obj = result.getJSONObject(i);
                Date uploadTime = obj.getDate("uploadTime");
                long daysBetween = DateUtils.daysBetween((Date)new Date(), (Date)uploadTime);
                if (daysBetween > 30L) continue;
                array.add((Object)obj);
            }
            result = array;
        }
        JSONObject obj = new JSONObject();
        obj.put("fileName", (Object)fileName);
        obj.put("uploadTime", (Object)new Date());
        obj.put("status", (Object)resultUrl.getString("status"));
        obj.put("user", (Object)RequestContext.get().getUserName());
        obj.put("path", resultUrl.get((Object)"resultUrl"));
        result.add((Object)obj);
        CacheHelper.put((String)(cacheKey + "resultListCache"), (String)result.toJSONString(), (int)CommonUtils.getTempFileMaxTimeout());
        String status = resultUrl.getString("status");
        if ("1".equals(status)) {
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f\uff0c\u60a8\u53ef\u5728\u3010\u5f15\u5165\u6e05\u5355\u52fe\u9009\u3011\u7684\u4e0b\u62c9\u5217\u8868\u4e2d\u67e5\u770b\u8fdb\u5ea6\u5e76\u4e0b\u8f7d\u7ed3\u679c", (String)"SelectInvoiceExcelService_57", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u60a8\u53ef\u5728\u3010\u5f15\u5165\u6e05\u5355\u52fe\u9009\u3011\u7684\u4e0b\u62c9\u5217\u8868\u4e2d\u67e5\u770b\u8fdb\u5ea6\u5e76\u4e0b\u8f7d\u7ed3\u679c", (String)"SelectInvoiceExcelService_58", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException e) {
            this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5173\u95edexcel\u6d41\u6587\u4ef6\u4e8b\u53d8%1$s", (String)"SelectInvoiceExcelService_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return;
        catch (Exception e) {
            try {
                this.plugin.getView().showErrorNotification(e.getMessage());
                if (fileInputStream == null) return;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5173\u95edexcel\u6d41\u6587\u4ef6\u4e8b\u53d8%1$s", (String)"SelectInvoiceExcelService_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), e2.getMessage()));
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (IOException e3) {
                this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5173\u95edexcel\u6d41\u6587\u4ef6\u4e8b\u53d8%1$s", (String)"SelectInvoiceExcelService_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), e3.getMessage()));
            }
            return;
        }
    }

    private String getCacheKey(Object invoiceType, String queryType) {
        if ("0".equals(invoiceType.toString()) && "deduction".equals(queryType)) {
            return VAT_DEDUCT;
        }
        if ("0".equals(invoiceType.toString()) && "undeduction".equals(queryType)) {
            return VAT_UNDEDUCT;
        }
        if ("1".equals(invoiceType.toString()) && "deduction".equals(queryType)) {
            return CUSTOM_DEDUCT;
        }
        if ("1".equals(invoiceType.toString()) && "undeduction".equals(queryType)) {
            return CUSTOM_UNDEDUCT;
        }
        return "";
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject returnData;
        String actionId = closedCallBackEvent.getActionId();
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        String queryType = (String)customParams.get("querytype");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.type, (CharSequence)actionId) && (returnData = (JSONObject)closedCallBackEvent.getReturnData()) != null) {
            returnData.put("selectOperationType", (Object)"4");
            DeductOperateService deductOperateService = new DeductOperateService(this.type, null, this.plugin);
            JSONArray invoices = returnData.getJSONArray("invoices");
            returnData.put("invoices", (Object)invoices);
            returnData.put("queryType", (Object)queryType);
            deductOperateService.selectInvoice(returnData, Boolean.FALSE, this::showResult);
        }
    }

    private void showResult(String title) {
        this.plugin.getPageCache().put("deduct_title", ResManager.loadKDString((String)"EXCEL\u5f15\u5165\u52fe\u9009", (String)"SelectInvoiceExcelService_59", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        DeductionUtils.showResult((AbstractFormPlugin)this.plugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject selectByExcel(InputStream fileInputStream, JSONObject fileParam) {
        String isSuccess = "0";
        String selectType = fileParam.getString("selectType");
        String queryType = fileParam.getString("queryType");
        JSONArray invoices = new JSONArray();
        try {
            Throwable closeCallBack;
            boolean checkUndeduction;
            Workbook workbook = WorkbookFactory.create((InputStream)fileInputStream);
            if (workbook == null) return new JSONObject();
            Sheet sheet = workbook.getSheetAt(0);
            int fieldRowNo = 0;
            int valueRowNo = 1;
            if ("0".equals(selectType)) {
                fieldRowNo = 1;
                valueRowNo = 2;
            }
            Row row = sheet.getRow(fieldRowNo);
            int rowNum = sheet.getPhysicalNumberOfRows();
            int cellNum = row.getPhysicalNumberOfCells();
            if ("0".equals(selectType)) {
                if (cellNum != 4) throw new MsgException("0001", ResManager.loadKDString((String)"\u6a21\u677f\u6709\u8bef", (String)"SelectInvoiceExcelService_60", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            if ("1".equals(selectType) && cellNum != 3) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u6a21\u677f\u6709\u8bef", (String)"SelectInvoiceExcelService_60", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            SelectInvoiceExcelService.setCellValue(sheet.getRow(fieldRowNo), cellNum, ResManager.loadKDString((String)"\u5f15\u5165\u7ed3\u679c", (String)"SelectInvoiceExcelService_61", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            SelectInvoiceExcelService.setCellValue(sheet.getRow(fieldRowNo), cellNum + 1, ResManager.loadKDString((String)"\u539f\u56e0", (String)"SelectInvoiceExcelService_62", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            for (int i = valueRowNo; i < rowNum; ++i) {
                DynamicObject invoiceObject;
                String operateType = "deduction_select";
                String undeductReason = "";
                String isSelect = ExcelInvoiceUploadHelper.getStringValueFromCell((Cell)sheet.getRow(i).getCell(0));
                String invoiceCode = ExcelInvoiceUploadHelper.getStringValueFromCell((Cell)sheet.getRow(i).getCell(1));
                QFilter delete = new QFilter("delete", "=", (Object)"1");
                if ("0".equals(selectType)) {
                    boolean flag;
                    String invoiceNo = ExcelInvoiceUploadHelper.getStringValueFromCell((Cell)sheet.getRow(i).getCell(2));
                    undeductReason = ExcelInvoiceUploadHelper.getStringValueFromCell((Cell)sheet.getRow(i).getCell(3));
                    boolean bl = flag = "undeduction".equals(queryType) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)undeductReason);
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isSelect) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)invoiceNo)) {
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u672a\u586b\u5199\u5fc5\u586b\u5b57\u6bb5", (String)"SelectInvoiceExcelService_63", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (flag) {
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u52fe\u9009\u987b\u586b\u5199\u4e0d\u62b5\u6263\u539f\u56e0", (String)"SelectInvoiceExcelService_64", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if ("\u5426".equals(isSelect)) {
                        operateType = "deduction_unselect";
                    }
                    String queryFields = MetadataUtil.getFields((String)"rim_invoice");
                    QFilter code = new QFilter("invoice_code", "=", (Object)invoiceCode);
                    QFilter no = new QFilter("invoice_no", "=", (Object)invoiceNo);
                    invoiceObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)queryFields, (QFilter[])new QFilter[]{code, no, delete});
                } else {
                    boolean flag;
                    undeductReason = ExcelInvoiceUploadHelper.getStringValueFromCell((Cell)sheet.getRow(i).getCell(2));
                    boolean bl = flag = "undeduction".equals(queryType) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)undeductReason);
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isSelect) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)invoiceCode)) {
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u672a\u586b\u5199\u5fc5\u586b\u5b57\u6bb5", (String)"SelectInvoiceExcelService_63", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (flag) {
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                        SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u52fe\u9009\u987b\u586b\u5199\u4e0d\u62b5\u6263\u539f\u56e0", (String)"SelectInvoiceExcelService_64", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (ResManager.loadKDString((String)"\u5426", (String)"SelectInvoiceExcelService_65", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(isSelect)) {
                        operateType = "deduction_unselect";
                    }
                    String queryFields = MetadataUtil.getFields((String)"rim_invoice");
                    QFilter no = new QFilter("invoice_no", "=", (Object)invoiceCode);
                    invoiceObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)queryFields, (QFilter[])new QFilter[]{no, delete});
                }
                if (invoiceObject == null) {
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6216\u91c7\u96c6\u81f3\u5168\u7968\u6c60", (String)"SelectInvoiceExcelService_66", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    continue;
                }
                Long invoiceType = invoiceObject.getLong("invoice_type");
                List<Long> deductionTypes = Arrays.asList(InputInvoiceTypeEnum.getDeductionTypes());
                if ("0".equals(selectType) && (!deductionTypes.contains(invoiceType) || InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) || "1".equals(selectType) && !InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u52fe\u9009\u7684\u53d1\u7968\u7c7b\u578b", (String)"SelectInvoiceExcelService_67", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    continue;
                }
                boolean orgFlag = this.getOrgFlag(invoiceObject.getLong("org_id"));
                if (!orgFlag) {
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u65e0\u8be5\u53d1\u7968\u6240\u5c5e\u6838\u7b97\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u65e0\u6cd5\u52fe\u9009", (String)"SelectInvoiceExcelService_68", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    continue;
                }
                String deductionFlag = invoiceObject.getString("deduction_flag");
                if ("0".equals(deductionFlag)) {
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.FAIL());
                    SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum + 1, ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u4e0d\u53ef\u62b5\u6263", (String)"SelectInvoiceExcelService_69", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    continue;
                }
                Map invoiceMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)invoiceObject);
                invoiceMap.put("operateType", operateType);
                invoiceMap.put("undeductReason", this.getUndeductReasonCode(undeductReason));
                invoices.add((Object)invoiceMap);
                isSuccess = "1";
                SelectInvoiceExcelService.setCellValue(sheet.getRow(i), cellNum, SelectInvoiceExcelService.SUCCESS());
            }
            String deductionPurpose = DeductionConstant.getDeductionPurposeByQueryType((String)queryType);
            String deductName = ResManager.loadKDString((String)"\u62b5\u6263\u52fe\u9009", (String)"SelectInvoiceExcelService_70", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            boolean bl = checkUndeduction = "undeduction".equals(queryType) || "readyselect_undeduction".equals(queryType);
            if (checkUndeduction) {
                deductName = ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u52fe\u9009", (String)"SelectInvoiceExcelService_71", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if ("2".equals(deductionPurpose)) {
                deductName = ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u52fe\u9009", (String)"SelectInvoiceExcelService_71", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            } else if ("3".equals(deductionPurpose)) {
                deductName = ResManager.loadKDString((String)"\u9000\u7a0e\u52fe\u9009", (String)"SelectInvoiceExcelService_72", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (invoices.size() > 0) {
                JSONObject param = new JSONObject();
                FormShowParameter showParameter = new FormShowParameter();
                param.put("deductionPurpose", (Object)deductionPurpose);
                param.put("deductName", (Object)deductName);
                param.put("invoices", (Object)invoices);
                param.put("operatetype", (Object)this.type);
                param.put("querytype", (Object)queryType);
                if ("0".equals(selectType)) {
                    param.put("invoicetype", (Object)0);
                } else {
                    param.put("invoicetype", (Object)InputInvoiceTypeEnum.HGJKS.getCode());
                }
                showParameter.setCustomParams((Map)param);
                showParameter.setFormId("rim_deduct_edit");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
                showParameter.setCloseCallBack((CloseCallBack)closeCallBack);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u7f16\u8f91", (String)"SelectInvoiceExcelService_73", (String)"imc-rim-formplugin", (Object[])new Object[0]), deductName));
                this.plugin.getView().showForm(showParameter);
            }
            byte[] bytes = null;
            try {
                closeCallBack = null;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    workbook.write((OutputStream)os);
                    bytes = os.toByteArray();
                }
                catch (Throwable throwable) {
                    closeCallBack = throwable;
                    throw throwable;
                }
            }
            catch (IOException os) {
                // empty catch block
            }
            if (bytes == null) return new JSONObject();
            String exportFileName = UUID.getBatchNo() + ".xlsx";
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                JSONObject result = new JSONObject();
                result.put("resultUrl", (Object)CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(exportFileName, (InputStream)in, CommonUtils.getTempFileMaxTimeout()));
                result.put("status", (Object)isSuccess);
                JSONObject jSONObject = result;
                return jSONObject;
            }
        }
        catch (Exception e) {
            throw new MsgException("0001", ResManager.loadKDString((String)"\u6a21\u677f\u65e0\u6548\uff0c\u9700\u8981\u4f7f\u7528\u7cfb\u7edf\u4e0b\u8f7d\u7684\u6a21\u677f", (String)"SelectInvoiceExcelService_74", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean getOrgFlag(Long org) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.plugin.getView(), (String)"rim_invoice", (String)"47150e89000000ac");
        boolean isAdmin = hasPermOrgResult.hasAllOrgPerm();
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        return isAdmin || hasPermOrgs.contains(org);
    }

    private String getUndeductReasonCode(String undeductReason) {
        switch (undeductReason) {
            case "\u7528\u4e8e\u975e\u5e94\u7a0e\u9879\u76ee": {
                return "1";
            }
            case "\u7528\u4e8e\u514d\u7a0e\u9879\u76ee": {
                return "2";
            }
            case "\u7528\u4e8e\u96c6\u4f53\u798f\u5229\u6216\u8005\u4e2a\u4eba\u6d88\u8d39": {
                return "3";
            }
            case "\u906d\u53d7\u975e\u6b63\u5e38\u635f\u5931": {
                return "4";
            }
            case "\u5176\u4ed6": {
                return "5";
            }
        }
        return "";
    }

    private static void setCellValue(Row row, int cellIndex, String val) {
        if (row == null || StringUtils.isEmpty((CharSequence)val)) {
            return;
        }
        row.createCell(cellIndex).setCellValue(val);
    }
}

