/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.formplugin.query.operate.DeductionLoginOperateService;

public class DeductSelectLoginOperateService
extends DeductionLoginOperateService {
    public DeductSelectLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        super(type, currentOrgId, plugin);
    }

    public DeductSelectLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin, Consumer<String> consumer) {
        super(type, currentOrgId, plugin, consumer);
    }

    @Override
    public void afterLoginDoOperation(String dkType, String taxNo, JSONObject configObj, String failMsg) {
        if (StringUtils.isNotEmpty((CharSequence)failMsg)) {
            configObj.put("errcode", (Object)ErrorType.ALl_E_LOGIN_FAIL.getCode());
            configObj.put("description", (Object)failMsg);
        }
        DeductSelectService service = DeductServiceFactory.newInstanceForDeductSelect((String)dkType);
        JSONArray invoices = configObj.getJSONArray("invoices");
        String queryType = configObj.getString("queryType");
        JSONArray isselect = invoices.stream().filter(f -> "1".equals(((JSONObject)f).getString("isselect"))).collect(Collectors.toCollection(JSONArray::new));
        JSONArray noselect = invoices.stream().filter(f -> "0".equals(((JSONObject)f).getString("isselect"))).collect(Collectors.toCollection(JSONArray::new));
        if (isselect.size() == 0 && noselect.size() == 0) {
            JSONObject selectRtn = service.batchSelectInvoices(configObj);
            this.setOperationResult2Cache(selectRtn);
            return;
        }
        if (isselect.size() > 0) {
            if ("undeduction".equals(queryType)) {
                configObj.put("deductibleMode", (Object)"4");
            } else if ("deduction".equals(queryType)) {
                configObj.put("deductibleMode", (Object)"1");
            }
            configObj.put("invoices", (Object)isselect);
            JSONObject selectRtn = service.batchSelectInvoices(configObj);
            this.setOperationResult2Cache(selectRtn);
        }
        if (noselect.size() > 0) {
            configObj.put("cancelSelectType", (Object)"1");
            for (int i = 0; i < noselect.size(); ++i) {
                if ("undeduction".equals(queryType)) {
                    configObj.put("deductibleMode", (Object)"-4");
                    continue;
                }
                if (!"deduction".equals(queryType)) continue;
                configObj.put("deductibleMode", (Object)"-1");
            }
            configObj.put("invoices", (Object)noselect);
            JSONObject selectRtn = service.batchSelectInvoices(configObj);
            this.setOperationResult2Cache(selectRtn);
        }
    }
}

