/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.recorded;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class TaxRecordedCommitPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxRecordedCommitPlugin.class);
    private static final String ENTRY_GRID = "entryentity";
    public static final String INVOICES = "invoices";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel", "batchupdate"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray invoiceList = JSONObject.parseArray((String)SerializationUtils.toJsonString(customParams.get(INVOICES)));
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_GRID);
        HashMap<Long, Map<String, Object>> updateDataMap = new HashMap<Long, Map<String, Object>>(0);
        List fieldEdits = entryGrid.getFieldEdits();
        Date now = new Date();
        for (int i = 0; i < invoiceList.size(); ++i) {
            JSONObject object = invoiceList.getJSONObject(i);
            int row = this.getModel().createNewEntryRow(ENTRY_GRID);
            this.getModel().setValue("id", (Object)object.getString("id"), row);
            this.getModel().setValue("invoice_code", (Object)object.getString("invoice_code"), row);
            this.getModel().setValue("invoice_no", (Object)object.getString("invoice_no"), row);
            this.getModel().setValue("electronic_no", (Object)object.getString("electronic_no"), row);
            this.getModel().setValue("serial_no", (Object)object.getString("serial_no"), row);
            Long itemInvoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"invoice_type"));
            this.getModel().setValue("invoice_type", (Object)itemInvoiceType, row);
            this.getModel().setValue("invoice_date", (Object)object.getString("invoice_date"), row);
            this.getModel().setValue("saler_name", (Object)object.getString("saler_name"), row);
            this.getModel().setValue("saler_tax_no", (Object)object.getString("saler_tax_no"), row);
            this.getModel().setValue("invoice_amount", (Object)object.getString("invoice_amount"), row);
            this.getModel().setValue("total_tax_amount", (Object)object.getString("total_tax_amount"), row);
            this.getModel().setValue("buyer_tax_no", (Object)object.getString("buyer_tax_no"), row);
            this.getModel().setValue("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"org")), row);
            this.getModel().setValue("invoice_risk_level", (Object)object.getString("invoice_risk_level"), row);
            this.getModel().setValue("invoice_status", (Object)object.getString("invoice_status"), row);
            this.getModel().setValue("tax_recorded_status", (Object)object.getString("tax_recorded_status"), row);
            String taxRecordedPurpose = object.getString("tax_recorded_purpose");
            if (StringUtils.isBlank((CharSequence)taxRecordedPurpose)) {
                Map<String, String> dataMap;
                taxRecordedPurpose = "02";
                if (!updateDataMap.containsKey(object.getLong("id"))) {
                    dataMap = new HashMap(1);
                    updateDataMap.put(object.getLong("id"), dataMap);
                    dataMap.put("tax_recorded_purpose", taxRecordedPurpose);
                } else {
                    dataMap = (Map)updateDataMap.get(object.getLong("id"));
                    dataMap.put("tax_recorded_purpose", taxRecordedPurpose);
                }
            }
            this.getModel().setValue("tax_recorded_purpose", (Object)taxRecordedPurpose, row);
            Date taxRecordedTime = object.getDate("tax_recorded_time");
            if (taxRecordedTime == null) {
                Map<String, Date> dataMap;
                Date accountTime = object.getDate("account_time");
                if (accountTime != null) {
                    taxRecordedTime = accountTime;
                    if (null != object.get((Object)"invoice_date") && DateUtils.compare((Date)accountTime, (Date)object.getDate("invoice_date")) < 0) {
                        taxRecordedTime = DateUtils.trunc((Date)now);
                    }
                } else {
                    taxRecordedTime = DateUtils.trunc((Date)now);
                }
                if (!updateDataMap.containsKey(object.getLong("id"))) {
                    dataMap = new HashMap(1);
                    updateDataMap.put(object.getLong("id"), dataMap);
                    dataMap.put("tax_recorded_time", taxRecordedTime);
                } else {
                    dataMap = (Map)updateDataMap.get(object.getLong("id"));
                    dataMap.put("tax_recorded_time", taxRecordedTime);
                }
            }
            this.getModel().setValue("tax_recorded_time", (Object)taxRecordedTime, row);
        }
        if (MapUtils.isNotEmpty(updateDataMap)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"taxRecordedUpdate", () -> this.updateMainRecordedInfo(updateDataMap));
        }
    }

    private void updateMainRecordedInfo(Map<Long, Map<String, Object>> updateDataMap) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        Set<Long> ids = updateDataMap.keySet();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
        if (null != dynamicObjects && dynamicObjects.length > 0) {
            HashMap invoiceDynamicObjectMap = new HashMap(8);
            for (DynamicObject dynamicObject : dynamicObjects) {
                ArrayList<DynamicObject> dynamicObjects1;
                QFilter serialNOFilter;
                Map<String, Object> dataMap = updateDataMap.get(dynamicObject.getLong("id"));
                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("invoice_type"));
                String serialNo = dynamicObject.getString("serial_no");
                if (invoiceType == null || invoiceType <= 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedEditPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                if (StringUtils.isBlank((CharSequence)serialNo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedEditPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                String entityId = InputInvoiceTypeEnum.getEntity((Long)invoiceType);
                DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{serialNOFilter = new QFilter("serial_no", "=", (Object)serialNo)});
                if (idObject == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b50\u8868\u4e0d\u5b58\u5728\u6570\u636e", (String)"TaxRecordedEditPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), dynamicObject.getString("invoice_no")), Integer.valueOf(2000));
                    return;
                }
                DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    if ("tax_recorded_purpose".equals(entry.getKey())) {
                        dynamicObject.set("tax_recorded_purpose", entry.getValue());
                        invoiceDynamicObject.set("tax_recorded_purpose", entry.getValue());
                    }
                    if (!"tax_recorded_time".equals(entry.getKey())) continue;
                    dynamicObject.set("tax_recorded_time", entry.getValue());
                    invoiceDynamicObject.set("tax_recorded_time", entry.getValue());
                }
                if (invoiceDynamicObjectMap.containsKey(invoiceType)) {
                    dynamicObjects1 = (ArrayList<DynamicObject>)invoiceDynamicObjectMap.get(invoiceType);
                    dynamicObjects1.add(invoiceDynamicObject);
                    continue;
                }
                dynamicObjects1 = new ArrayList<DynamicObject>(1);
                dynamicObjects1.add(invoiceDynamicObject);
                invoiceDynamicObjectMap.put(invoiceType, dynamicObjects1);
            }
            for (List dynamicObjectList : invoiceDynamicObjectMap.values()) {
                SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_GRID);
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u4ea4\u5165\u8d26\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u52fe\u9009\u6570\u636e");
                control.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u63d0\u4ea4\u5165\u8d26\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u52fe\u9009\u6570\u636e", (String)"TaxRecordedCommitPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Date now = DateUtils.trunc((Date)new Date());
            ArrayList<Long> ids = new ArrayList<Long>(1);
            for (DynamicObject dynamicObject : entryEntity) {
                String invoiceCode = dynamicObject.getString("invoice_code");
                String invoiceNo = dynamicObject.getString("invoice_no");
                String taxRecordedPurpose = dynamicObject.getString("tax_recorded_purpose");
                String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                if (null == taxRecordedPurpose) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedCommitPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                    return;
                }
                if (null != dynamicObject.getDate("tax_recorded_time")) {
                    Date taxRecordedTime = DateUtils.trunc((Date)dynamicObject.getDate("tax_recorded_time"));
                    if (taxRecordedTime.compareTo(now) > 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"TaxRecordedCommitPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                        return;
                    }
                    if (null != dynamicObject.get("invoice_date") && DateUtils.compare((Date)taxRecordedTime, (Date)DateUtils.trunc((Date)dynamicObject.getDate("invoice_date"))) < 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5c0f\u4e8e\u53d1\u7968\u7684\u5f00\u7968\u65f6\u95f4", (String)"TaxRecordedCommitPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                        return;
                    }
                } else {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedCommitPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                    return;
                }
                if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("tax_recorded_status"))) continue;
                ids.add(dynamicObject.getLong("id"));
            }
            RecordedConstant.batchUpateInvoiceMain(ids, null, null, (String)"01");
            Map param = RecordedConstant.createRecordedParam((DynamicObjectCollection)entryEntity, null);
            this.getView().returnDataToParent((Object)param);
            this.getView().close();
        }
        if ("btncancel".equals(control.getKey())) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (("tax_recorded_purpose".equals(name) || "tax_recorded_time".equals(name)) && (changeSet = e.getChangeSet()).length > 0) {
            QFilter serialNOFilter;
            ChangeData changeData = changeSet[0];
            DynamicObject dataEntity = changeData.getDataEntity();
            Object id = dataEntity.get("id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_invoice");
            if (null == dynamicObject) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u53d1\u7968\u6570\u636e", (String)"TaxRecordedCommitPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if ("tax_recorded_time".equals(name)) {
                Date date = new Date();
                Date newValue = (Date)changeData.getNewValue();
                if (newValue != null) {
                    if (DateUtils.trunc((Date)newValue).compareTo(DateUtils.trunc((Date)date)) > 0) {
                        this.getModel().setValue("tax_recorded_time", changeData.getOldValue(), changeData.getRowIndex());
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"TaxRecordedEditPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        return;
                    }
                    if (null != dynamicObject.get("invoice_date") && DateUtils.compare((Date)newValue, (Date)dynamicObject.getDate("invoice_date")) < 0) {
                        this.getModel().setValue("tax_recorded_time", changeData.getOldValue(), changeData.getRowIndex());
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5c0f\u4e8e\u53d1\u7968\u7684\u5f00\u7968\u65f6\u95f4", (String)"TaxRecordedCommitPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        return;
                    }
                }
            }
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("invoice_type"));
            String serialNo = dynamicObject.getString("serial_no");
            if (invoiceType == null || invoiceType <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedEditPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (StringUtils.isBlank((CharSequence)serialNo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedEditPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            String entityId = InputInvoiceTypeEnum.getEntity((Long)invoiceType);
            DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{serialNOFilter = new QFilter("serial_no", "=", (Object)serialNo)});
            if (idObject == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\uff0c\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b50\u8868\u4e0d\u5b58\u5728\u6570\u636e", (String)"TaxRecordedEditPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), dynamicObject.getString("invoice_no")), Integer.valueOf(2000));
                return;
            }
            DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
            invoiceDynamicObject.set(name, changeData.getNewValue());
            dynamicObject.set(name, changeData.getNewValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceDynamicObject});
        }
    }
}

