/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.recorded;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ViewUtil;

public class TaxRecordedEditPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(TaxRecordedEditPlugin.class);
    public static final String INVOICES = "invoices";
    private static final String ENTRY_GRID = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        String taxRecordedPurposeDefault;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object updateType = customParams.get("update_type");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isBlank(updateType)) {
            jsonObject.put("code", (Object)"0001");
            jsonObject.put("message", (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a", (String)"TaxRecordedEditPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)jsonObject);
            this.getView().close();
            return;
        }
        Object data = customParams.get(INVOICES);
        if (data == null) {
            jsonObject.put("code", (Object)"0002");
            jsonObject.put("message", (Object)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"TaxRecordedEditPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)jsonObject);
            this.getView().close();
            return;
        }
        JSONArray invoices = (JSONArray)data;
        JSONObject jsonObjectPram = (JSONObject)invoices.get(0);
        Object account_time = jsonObjectPram.get((Object)"account_time");
        Object taxRecordedTime = jsonObjectPram.get((Object)"tax_recorded_time");
        Date taxRecordedTimeDefault = new Date();
        if (null != taxRecordedTime) {
            taxRecordedTimeDefault = jsonObjectPram.getDate("tax_recorded_time");
        } else if (null != account_time) {
            taxRecordedTimeDefault = jsonObjectPram.getDate("account_time");
        }
        Object taxRecordedPurpose = jsonObjectPram.get((Object)"tax_recorded_purpose");
        String string = taxRecordedPurposeDefault = StringUtils.isNotBlank((Object)taxRecordedPurpose) ? taxRecordedPurpose.toString() : "02";
        if ("update_time".equals(updateType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tax_recorded_purpose"});
            this.getModel().setValue("tax_recorded_time", (Object)taxRecordedTimeDefault);
        } else if ("update_purpose".equals(updateType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tax_recorded_time"});
            this.getModel().setValue("tax_recorded_purpose", (Object)taxRecordedPurposeDefault);
        } else if ("update_time_purpose".equals(updateType)) {
            LOGGER.info("\u4fee\u6539\u5165\u8d26\u65f6\u95f4\u548c\u5165\u8d26\u7528\u9014");
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object updateType = customParams.get("update_type");
        JSONObject jsonObject = new JSONObject();
        if ("btnok".equals(control.getKey())) {
            Object value;
            String taxRecordedPurpose = null;
            Date taxRecordedTime = null;
            if ("update_time".equals(updateType)) {
                value = this.getModel().getValue("tax_recorded_time");
                if (value == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedEditPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                taxRecordedTime = (Date)value;
                Date date = new Date();
                if (DateUtils.trunc((Date)taxRecordedTime).compareTo(DateUtils.trunc((Date)date)) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"TaxRecordedEditPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if ("update_purpose".equals(updateType)) {
                value = this.getModel().getValue("tax_recorded_purpose");
                if (value == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u5165\u8d26\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRecordedEditPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                taxRecordedPurpose = (String)value;
            }
            JSONArray invoiceList = JSONObject.parseArray((String)SerializationUtils.toJsonString(customParams.get(INVOICES)));
            if (taxRecordedTime != null) {
                Date taxRecordedTimeTemp = DateUtils.trunc((Date)taxRecordedTime);
                StringBuilder message = new StringBuilder();
                for (Object o : invoiceList) {
                    JSONObject object = (JSONObject)o;
                    if (null == object.get((Object)"invoice_date") || DateUtils.compare((Date)taxRecordedTimeTemp, (Date)object.getDate("invoice_date")) >= 0) continue;
                    String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"));
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5c0f\u4e8e\u53d1\u7968\uff1a%1$s\u7684\u5f00\u7968\u65f6\u95f4", (String)"TaxRecordedEditPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                String str = message.toString();
                if (StringUtils.isNotBlank((CharSequence)str)) {
                    String recordedName = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4", (String)"RecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    ViewUtil.showMessage((AbstractFormPlugin)this, (String)recordedName, (String)message.toString(), (int)0, (int)invoiceList.size());
                    return;
                }
            }
            RecordedConstant.batchUpateInvoiceMain(invoiceList.stream().map(t -> (JSONObject)t).map(t -> t.get((Object)"id")).collect(Collectors.toList()), (String)taxRecordedPurpose, (Date)taxRecordedTime, null);
            jsonObject.put("code", (Object)"0000");
            jsonObject.put("message", (Object)ResManager.loadKDString((String)"\u5bf9\u5e94\u53d1\u7968\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u6216\u7a0e\u5c40\u5165\u8d26\u7528\u9014\u5df2\u66f4\u65b0\u6210\u529f", (String)"TaxRecordedEditPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)jsonObject);
            this.getView().close();
        }
        if ("btncancel".equals(control.getKey())) {
            this.getView().close();
        }
    }
}

