/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.recorded;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.invoice.model.SelectLog;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;

public class TaxRecordedOperateService
extends InvoiceOperateService {
    private static Log logger = LogFactory.getLog(TaxRecordedOperateService.class);
    public static final String OPERATE_TYPE = "operatetype";
    public static final String INVOICES = "invoices";
    private static final int DEFAULT_SIZE = 500;

    public TaxRecordedOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            FormShowParameter showParameter;
            String str;
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"RecordedOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            Map parentCustomParams = listPlugin.getView().getFormShowParameter().getCustomParams();
            Object queryType = parentCustomParams.get("querytype");
            QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time", (QFilter[])new QFilter[]{filte}, (String)"id desc");
            int count = invoiceCollection.size();
            StringBuilder message = new StringBuilder();
            JSONArray invoices = new JSONArray();
            for (DynamicObject object : invoiceCollection) {
                String msg;
                String serialNo;
                String recordedStatus = object.getString("tax_recorded_status");
                String recordedPurpose = object.getString("tax_recorded_purpose");
                Date recordedTime = object.getDate("tax_recorded_time");
                String invoiceCode = object.getString("invoice_code");
                String invoiceNo = object.getString("invoice_no");
                String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("invoice_type"));
                if (invoiceType == null || invoiceType <= 0L) {
                    String msg2 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)(serialNo = object.getString("serial_no")))) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedOperateService_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("recorded_commit".equals(this.type) && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)recordedStatus) && !"01".equals(recordedStatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u5165\u8d26\u72b6\u6001\u4e0d\u7b49\u4e8e\u672a\u5165\u8d26\uff0c\u8bf7\u9009\u62e9\u672a\u5165\u8d26\u6570\u636e", (String)"RecordedOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("recorded_revoke".equals(this.type) && !"02".equals(recordedStatus) && !"03".equals(recordedStatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u5165\u8d26\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5165\u8d26(\u4f01\u4e1a\u6240\u5f97\u7a0e\u7a0e\u524d\u6263\u9664) \u6216 \u5df2\u5165\u8d26(\u4f01\u4e1a\u6240\u5f97\u7a0e\u4e0d\u6263\u9664)", (String)"RecordedOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if (("maintain_recorded_time".equals(this.type) || "maintain_recorded_purpose".equals(this.type)) && ("02".equals(recordedStatus) || "03".equals(recordedStatus) || "06".equals(recordedStatus))) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5df2\u5165\u8d26\u6216\u5df2\u64a4\u9500\u5165\u8d26\uff0c\u4e0d\u80fd\u4fee\u6539\u7a0e\u5c40\u5165\u8d26\u7528\u9014\u6216\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4", (String)"RecordedOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if (!kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)message.toString())) continue;
                invoices.add((Object)object);
            }
            String recordedName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5165\u8d26", (String)"RecordedOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            if ("recorded_revoke".equals(this.type)) {
                recordedName = ResManager.loadKDString((String)"\u64a4\u9500\u5165\u8d26", (String)"RecordedOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if ("maintain_recorded_purpose".equals(this.type)) {
                recordedName = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u7528\u9014", (String)"RecordedOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if ("maintain_recorded_time".equals(this.type)) {
                recordedName = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4", (String)"RecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)(str = message.toString()))) {
                ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)recordedName, (String)message.toString(), (int)0, (int)count);
                return;
            }
            this.plugin.getPageCache().put("deduct_title", recordedName);
            if ("recorded_commit".equals(this.type)) {
                showParameter = new FormShowParameter();
                parentCustomParams.put(INVOICES, invoices);
                showParameter.setCustomParams(parentCustomParams);
                showParameter.setFormId("rim_tax_recorded_commit");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
                showParameter.setCloseCallBack(closeCallBack);
                this.plugin.getView().showForm(showParameter);
            }
            if ("recorded_revoke".equals(this.type)) {
                this.plugin.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u64a4\u9500\u5165\u8d26\uff1f", (String)"RecordedOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(this.type), null);
            }
            if ("maintain_recorded_time".equals(this.type) || "maintain_recorded_purpose".equals(this.type)) {
                showParameter = new FormShowParameter();
                parentCustomParams.put(INVOICES, invoices);
                String updateType = "update_time";
                String title = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4", (String)"RecordedOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                if ("maintain_recorded_purpose".equals(this.type)) {
                    updateType = "update_purpose";
                    title = ResManager.loadKDString((String)"\u7ef4\u62a4\u7a0e\u5c40\u5165\u8d26\u7528\u9014", (String)"RecordedOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                parentCustomParams.put("update_type", updateType);
                showParameter.setCustomParams(parentCustomParams);
                showParameter.setFormId("rim_recorded_update");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setCaption(title);
                this.plugin.getView().showForm(showParameter);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (kd.imc.rim.common.utils.StringUtils.equals((CharSequence)this.type, (CharSequence)actionId)) {
            JSONObject returnData;
            Object data;
            if ("recorded_commit".equals(this.type)) {
                Object recordedParam = closedCallBackEvent.getReturnData();
                if (recordedParam != null && this.invokeRecorded((Map)recordedParam) > 0) {
                    this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u524d\u5f80 \u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u5217\u8868 \u67e5\u770b\u5904\u7406\u65e5\u5fd7\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u5f53\u524d\u9875\u9762\u67e5\u770b\u7ed3\u679c", (String)"RecordedOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                this.plugin.getView().invokeOperation("refresh");
            }
            if (("maintain_recorded_time".equals(this.type) || "maintain_recorded_purpose".equals(this.type)) && (data = closedCallBackEvent.getReturnData()) != null && kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)(returnData = (JSONObject)data).get((Object)"message").toString())) {
                if ("0000".equals(returnData.get((Object)"code"))) {
                    this.plugin.getView().showSuccessNotification(returnData.get((Object)"message").toString(), Integer.valueOf(2000));
                    this.plugin.getView().invokeOperation("refresh");
                } else {
                    this.plugin.getView().showTipNotification(returnData.get((Object)"message").toString(), Integer.valueOf(2000));
                }
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("recorded_revoke".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time", (QFilter[])new QFilter[]{filte}, (String)"id desc");
            if (CollectionUtils.isEmpty((Collection)invoiceCollection)) {
                logger.info("\u64a4\u9500\u52fe\u9009\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u4e0d\u505a\u53d8\u52a8");
                return;
            }
            Map recordedParam = RecordedConstant.createRecordedParam((DynamicObjectCollection)invoiceCollection, (String)"06");
            if (this.invokeRecorded(recordedParam) > 0) {
                this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u524d\u5f80 \u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u5217\u8868 \u67e5\u770b\u5904\u7406\u65e5\u5fd7\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u5f53\u524d\u9875\u9762\u67e5\u770b\u7ed3\u679c", (String)"RecordedOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public int invokeRecorded(Map<String, Map<String, List<JSONObject>>> returnData) {
        String str;
        int maxSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)500, (String)"recorded_size_4");
        if (maxSize <= 0) {
            maxSize = 500;
        }
        StringBuilder message = new StringBuilder();
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>(1);
        int success = 0;
        int fail = 0;
        for (Map.Entry<String, Map<String, List<JSONObject>>> entry : returnData.entrySet()) {
            String buyTaxNo = entry.getKey();
            Map<String, List<JSONObject>> recordedData = entry.getValue();
            if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)buyTaxNo)) {
                for (List<JSONObject> value : recordedData.values()) {
                    fail += value.size();
                    for (JSONObject jSONObject : value) {
                        String invoiceCode = jSONObject.getString("invoiceCode");
                        String invoiceNo = jSONObject.getString("invoiceNo");
                        String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                        String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s \u8d2d\u65b9\u7a0e\u53f7\u4e3a\u7a7a", (String)"TaxRecordedOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                        message.append(msg);
                        message.append(ViewUtil.LINE_SEPARATOR);
                    }
                }
                continue;
            }
            String dktype = DeductionConstant.getDkType((String)buyTaxNo);
            DeductService deductService = DeductServiceFactory.newInstanceForRecordedHandle((String)dktype);
            if (deductService == null) {
                for (List list : recordedData.values()) {
                    fail += list.size();
                    for (JSONObject jsonObject2 : list) {
                        String invoiceCode = jsonObject2.getString("invoiceCode");
                        String invoiceNo = jsonObject2.getString("invoiceNo");
                        String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                        String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s \u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c", (String)"TaxRecordedOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                        message.append(msg);
                        message.append(ViewUtil.LINE_SEPARATOR);
                    }
                }
                continue;
            }
            for (Map.Entry entry2 : recordedData.entrySet()) {
                String string = (String)entry2.getKey();
                List invoices = (List)entry2.getValue();
                JSONObject param = new JSONObject();
                param.put("taxNo", (Object)buyTaxNo);
                param.put("nextEntryMarkStatus", (Object)string);
                if (CollectionUtils.isNotEmpty((Collection)invoices)) {
                    if (invoices.size() > maxSize) {
                        List lists = ListUtils.splitList((List)invoices, (int)maxSize);
                        for (List list : lists) {
                            param.put(INVOICES, (Object)list);
                            JSONObject result = deductService.recordedCommit(param);
                            if (result == null) continue;
                            if (ErrorType.NEED_LOGIN.getCode().equals(result.getString("errcode"))) {
                                fail += list.size();
                                String description = result.getString("description");
                                for (JSONObject jsonObject : list) {
                                    String invoiceCode = jsonObject.getString("invoiceCode");
                                    String invoiceNo = jsonObject.getString("invoiceNo");
                                    String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                                    String msg = codeGroup + "==" + description;
                                    message.append(msg);
                                    message.append(ViewUtil.LINE_SEPARATOR);
                                }
                                continue;
                            }
                            success += invoices.size();
                            param.put("result", (Object)result);
                            resultList.add(param);
                        }
                        continue;
                    }
                    param.put(INVOICES, (Object)invoices);
                    JSONObject result = deductService.recordedCommit(param);
                    if (result == null) continue;
                    if (ErrorType.NEED_LOGIN.getCode().equals(result.getString("errcode"))) {
                        fail += invoices.size();
                        String description = result.getString("description");
                        for (JSONObject jsonObject : invoices) {
                            String invoiceCode = jsonObject.getString("invoiceCode");
                            String invoiceNo = jsonObject.getString("invoiceNo");
                            String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                            String msg = codeGroup + "==" + description;
                            message.append(msg);
                            message.append(ViewUtil.LINE_SEPARATOR);
                        }
                        continue;
                    }
                    success += invoices.size();
                    param.put("result", (Object)result);
                    resultList.add(param);
                    continue;
                }
                logger.info("\u4e0d\u5b58\u5728\u53d1\u7968\u4fe1\u606f\uff0c\u8d2d\u65b9\u6d41\u6c34\u53f7\uff0c{}\uff0c \u7a0e\u5c40\u5165\u8d26\u7528\u9014\uff0c {}", (Object)buyTaxNo, (Object)string);
            }
        }
        if (resultList != null && resultList.size() > 0) {
            this.saveRecordedLog(resultList);
        }
        String recordedName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5165\u8d26", (String)"RecordedOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        if ("recorded_revoke".equals(this.type)) {
            recordedName = ResManager.loadKDString((String)"\u64a4\u9500\u5165\u8d26", (String)"RecordedOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (kd.imc.rim.common.utils.StringUtils.isNotBlank((CharSequence)(str = message.toString()))) {
            ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)recordedName, (String)message.toString(), (int)success, (int)fail);
        }
        return success;
    }

    private void saveRecordedLog(List<JSONObject> resultList) {
        String userId = RequestContext.get().getUserId();
        long orgId = RequestContext.get().getOrgId();
        String tenantNo = TenantUtils.getTenantNo();
        for (JSONObject jsonObject : resultList) {
            String taxNo = jsonObject.getString("taxNo");
            String nextEntryMarkStatus = jsonObject.getString("nextEntryMarkStatus");
            JSONObject result = jsonObject.getJSONObject("result");
            String errcode = result.getString("errcode");
            String description = result.getString("description");
            JSONObject data = result.getJSONObject("data");
            String batchNo = "";
            if (data != null && data.containsKey((Object)"batchNo")) {
                Object batchNoObj = data.get((Object)"batchNo");
                if (!ObjectUtils.isEmpty((Object)batchNoObj)) {
                    batchNo = batchNoObj.toString();
                }
            } else {
                batchNo = UUID.getBatchNo();
            }
            List invoices = (List)jsonObject.get((Object)INVOICES);
            if (CollectionUtils.isEmpty((Collection)invoices)) continue;
            ArrayList<DynamicObject> selectAccountList = new ArrayList<DynamicObject>(invoices.size());
            boolean fail = !"0000".equals(errcode);
            for (JSONObject invoice : invoices) {
                DynamicObject accountObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_select_account");
                accountObject.set("serial_no", (Object)invoice.getString("serial_no"));
                accountObject.set("batch_no", (Object)batchNo);
                accountObject.set("invoice_type", (Object)invoice.getLongValue("invoice_type"));
                accountObject.set("org", (Object)(invoice.getLongValue("org") != 0L ? invoice.getLongValue("org") : orgId));
                accountObject.set("deduction_purpose", (Object)nextEntryMarkStatus);
                accountObject.set("handle_status", (Object)(fail ? "2" : "3"));
                accountObject.set("invoice_code", invoice.get((Object)"invoiceCode"));
                accountObject.set("invoice_no", invoice.get((Object)"invoiceNo"));
                accountObject.set("electronic_no", (Object)invoice.getString("etaxInvoiceNo"));
                accountObject.set("invoice_amount", (Object)invoice.getBigDecimal("invoiceAmount"));
                accountObject.set("total_tax_amount", (Object)invoice.getBigDecimal("totalTaxAmount"));
                accountObject.set("invoice_date", (Object)invoice.getDate("invoice_date"));
                accountObject.set("saler_tax_no", (Object)invoice.getString("salerTaxNo"));
                accountObject.set("saler_name", (Object)invoice.getString("salerName"));
                accountObject.set("manage_status", (Object)"0");
                accountObject.set("select_time", (Object)invoice.getDate("tax_recorded_time"));
                accountObject.set("creater", (Object)userId);
                accountObject.set("select_opera_type", (Object)"1");
                if (fail) {
                    if (StringUtils.isNotEmpty((CharSequence)description) && description.length() > 100) {
                        description = description.substring(0, 100);
                    }
                    accountObject.set("description", (Object)description);
                }
                accountObject.set("create_time", (Object)new Date());
                accountObject.set("update_time", (Object)new Date());
                accountObject.set("tenant_no", (Object)tenantNo);
                selectAccountList.add(accountObject);
            }
            SelectLog selectLog = new SelectLog();
            selectLog.setBatchNo(batchNo);
            selectLog.setTaskNo(UUID.randomUUID());
            selectLog.setFailNum(Integer.valueOf(0));
            selectLog.setSuccessNum(Integer.valueOf(0));
            if (fail) {
                selectLog.setDescription(description);
                selectLog.setFailNum(Integer.valueOf(invoices.size()));
            }
            selectLog.setTotalNum(Integer.valueOf(invoices.size()));
            selectLog.setSelectType("7");
            selectLog.setOperateType(nextEntryMarkStatus);
            selectLog.setSelectOperaType("1");
            selectLog.setOrgId(Long.valueOf(orgId));
            selectLog.setUserId(userId);
            selectLog.setTaxNo(taxNo);
            selectLog.setAsyncFlag("1");
            selectLog.setHandleStatus(fail ? "2" : "3");
            selectLog.setBillType("0");
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                try {
                    SelectAccountService.insertSelectLog((SelectLog)selectLog);
                    SaveServiceHelper.save((DynamicObject[])selectAccountList.toArray(new DynamicObject[selectAccountList.size()]));
                }
                catch (Throwable e) {
                    logger.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }
}

