/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.report.rptinput;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;

public class RptDetailMainPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TYPE_TREE = "typetree";
    private static final String KEY_DATA_FLEX = "data_flex";

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        InputInvoiceTypeEnum[] invoiceTypes = new InputInvoiceTypeEnum[]{InputInvoiceTypeEnum.GENERAL_PAPER, InputInvoiceTypeEnum.USEDCAR_INVOICE, InputInvoiceTypeEnum.TRAIN_INVOICE, InputInvoiceTypeEnum.AIR_INVOICE, InputInvoiceTypeEnum.TRANSPORT_INVOICE, InputInvoiceTypeEnum.BOAT_INVOICE, InputInvoiceTypeEnum.TAXI_INVOICE, InputInvoiceTypeEnum.QUOTA_INVOICE, InputInvoiceTypeEnum.ROAD_BRIDGE, InputInvoiceTypeEnum.HGJKS, InputInvoiceTypeEnum.TAX_PROOF, InputInvoiceTypeEnum.OTHER_INVOICE, InputInvoiceTypeEnum.TRAIN_REFUND, InputInvoiceTypeEnum.FINANCIAL_INVOICE};
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(8);
        for (InputInvoiceTypeEnum type : invoiceTypes) {
            TreeNode node = new TreeNode();
            node.setId(type.getCode() + "");
            if (InputInvoiceTypeEnum.GENERAL_PAPER == type) {
                node.setText(ResManager.loadKDString((String)"\u901a\u7528\u673a\u6253\u53d1\u7968", (String)"RptDetailMainPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                node.setText(type.getName());
            }
            list.add(node);
        }
        TreeNode firstNode = new TreeNode();
        firstNode.setId(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode() + "");
        firstNode.setText(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u53d1\u7968", (String)"RptDetailMainPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(0, firstNode);
        List<TreeNode> valuableList = this.getValuableNode(list);
        if (CollectionUtils.isEmpty(valuableList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u7968\u7684\u8be6\u60c5", (String)"RptDetailMainPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        tree.addNodes(valuableList);
        if (valuableList != null && valuableList.size() > 0) {
            tree.focusNode(valuableList.get(0));
            tree.treeNodeClick(null, valuableList.get(0).getId());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Long nodeId = Long.parseLong((String)evt.getNodeId());
        if (ObjectUtils.isEmpty((Object)nodeId)) {
            nodeId = InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode();
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId("rim_rpt_detail");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_rpt_detail");
        reportShowParameter.setCloseCallBack(closeCallBack);
        Map customerParams = this.getView().getFormShowParameter().getCustomParams();
        customerParams.put("nodeId", nodeId);
        reportShowParameter.setCustomParams(customerParams);
        reportShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        reportShowParameter.getOpenStyle().setTargetKey(KEY_DATA_FLEX);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private List<TreeNode> getValuableNode(List<TreeNode> allNodes) {
        if (CollectionUtils.isEmpty(allNodes)) {
            return null;
        }
        List<Long> valuableInvoiceTypes = this.getValuableInvoiceType();
        if (CollectionUtils.isEmpty(valuableInvoiceTypes)) {
            return null;
        }
        if ((valuableInvoiceTypes.contains(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.ORDINARY_PAPER.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.SPECIAL_PAPER.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.ORDINARY_ROLL.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.MOTOR_INVOICE.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.TOLL_ELECTRON.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode())) && !valuableInvoiceTypes.contains(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode())) {
            valuableInvoiceTypes.add(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
        }
        if ((valuableInvoiceTypes.contains(InputInvoiceTypeEnum.GENERAL_PAPER.getCode()) || valuableInvoiceTypes.contains(InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode())) && !valuableInvoiceTypes.contains(InputInvoiceTypeEnum.GENERAL_PAPER.getCode())) {
            valuableInvoiceTypes.add(InputInvoiceTypeEnum.GENERAL_PAPER.getCode());
        }
        ArrayList<TreeNode> needRemoveNodes = new ArrayList<TreeNode>(16);
        for (TreeNode treeNode : allNodes) {
            if (ObjectUtils.isEmpty((Object)treeNode) || valuableInvoiceTypes.contains(Long.parseLong(treeNode.getId()))) continue;
            needRemoveNodes.add(treeNode);
        }
        if (!CollectionUtils.isEmpty(needRemoveNodes)) {
            allNodes.removeAll(needRemoveNodes);
        }
        return allNodes;
    }

    private List<Long> getValuableInvoiceType() {
        DataSet hgjksDataSet;
        DataSet tollDataSet;
        DataSet specialDataSet;
        DataSet ordinaryDataSet;
        QFilter expenseTypeFilter;
        DynamicObject expenseTypeObj;
        JSONArray authListArray;
        Object taxRateObj;
        Map customerParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customerParams)) {
            return null;
        }
        List checkList = null;
        if (ObjectUtils.isEmpty(customerParams.get("checkSeqList"))) {
            return null;
        }
        checkList = (List)customerParams.get("checkSeqList");
        String goodsName = null;
        String goodsNameQuery = null;
        BigDecimal unitPrice = null;
        BigDecimal taxRate = null;
        String unit = null;
        String spec = null;
        String sellerName = null;
        String sellerNameQuery = null;
        String buyerName = null;
        String buyerNameQuery = null;
        Date invoiceDateStart = null;
        Date invoiceDateEnd = null;
        Long invoiceType = null;
        String expenseType = null;
        String expenseStatus = null;
        String originalState = null;
        String authenticateFlag = null;
        String remark = null;
        String remarkQuery = null;
        Long org = null;
        Long taxOrg = null;
        Date createDateStart = null;
        Date createDateEnd = null;
        Date accountDateStart = null;
        Date accountDateEnd = null;
        Date authDateStart = null;
        Date authDateEnd = null;
        Boolean isAdmin = null;
        ArrayList<Long> authList = null;
        goodsName = (String)customerParams.get("items.goods_name");
        spec = (String)customerParams.get("items.spec_model");
        Object unitPriceParam = customerParams.get("items.unit_price");
        if (unitPriceParam != null) {
            unitPrice = BigDecimalUtil.transDecimal(unitPriceParam);
        }
        unit = (String)customerParams.get("items.unit");
        Object itemTaxRateObj = customerParams.get("items.tax_rate");
        if (itemTaxRateObj != null) {
            taxRate = BigDecimalUtil.transDecimal(itemTaxRateObj);
        }
        if (!CollectionUtils.isEmpty((Collection)checkList) && checkList.contains("tax_check") && (taxRateObj = customerParams.get("tax_rate")) != null) {
            taxRate = BigDecimalUtil.transDecimal(taxRateObj);
        }
        if (!CollectionUtils.isEmpty((Collection)checkList) && checkList.contains("remark_check")) {
            remark = (String)customerParams.get("remark");
        }
        if (!CollectionUtils.isEmpty((Collection)checkList) && checkList.contains("saler_check")) {
            sellerName = (String)customerParams.get("saler_name");
        }
        if (!CollectionUtils.isEmpty((Collection)checkList) && checkList.contains("buyer_check")) {
            buyerName = (String)customerParams.get("buyer_name");
        }
        expenseType = (String)customerParams.get("expense_type");
        expenseStatus = (String)customerParams.get("expense_status");
        originalState = (String)customerParams.get("original_state");
        authenticateFlag = (String)customerParams.get("authenticate_flag");
        invoiceType = Long.parseLong(customerParams.get("invoice_type_id").toString());
        if (!ObjectUtils.isEmpty(customerParams.get("invoice_date"))) {
            Date invoiceDate = DateUtils.stringToDate((String)((String)customerParams.get("invoice_date")), (String)"yyyy-MM");
            invoiceDateStart = DateUtils.getFirstDateOfMonth((Date)invoiceDate);
            invoiceDateEnd = DateUtils.getLastDateOfMonth((Date)invoiceDate);
        }
        if (ObjectUtils.isEmpty((Object)goodsName) && !ObjectUtils.isEmpty(customerParams.get("goods_name_query"))) {
            goodsNameQuery = (String)customerParams.get("goods_name_query");
        }
        if ((ObjectUtils.isEmpty((Object)invoiceType) || invoiceType == 0L) && !ObjectUtils.isEmpty(customerParams.get("invoice_type_query"))) {
            JSONObject invoiceTypeInfo = (JSONObject)customerParams.get("invoice_type_query");
            invoiceType = invoiceTypeInfo.getLong("id");
        }
        if (!ObjectUtils.isEmpty(customerParams.get("isAdmin"))) {
            isAdmin = (Boolean)customerParams.get("isAdmin");
        }
        if (!ObjectUtils.isEmpty(customerParams.get("authList")) && !CollectionUtils.isEmpty((Collection)(authListArray = (JSONArray)customerParams.get("authList")))) {
            for (int i = 0; i < authListArray.size(); ++i) {
                JSONArray detailAuthList = ((JSONObject)authListArray.get(i)).getJSONArray("value");
                if (CollectionUtils.isEmpty((Collection)detailAuthList)) continue;
                for (int j = 0; j < detailAuthList.size(); ++j) {
                    if (authList == null) {
                        authList = new ArrayList<Long>(16);
                    }
                    authList.add(Long.parseLong(detailAuthList.get(j).toString()));
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object)invoiceType) && invoiceType != 0L) {
            ArrayList<Long> showTypes = new ArrayList<Long>(1);
            showTypes.add(invoiceType);
            return showTypes;
        }
        if (!ObjectUtils.isEmpty(customerParams.get("org_query"))) {
            org = ((JSONObject)customerParams.get("org_query")).getLong("id");
        }
        if (!ObjectUtils.isEmpty(customerParams.get("tax_org_query"))) {
            taxOrg = ((JSONObject)customerParams.get("tax_org_query")).getLong("id");
        }
        if (!ObjectUtils.isEmpty(customerParams.get("create_time_startdate_query"))) {
            createDateStart = DateUtils.stringToDate((String)((String)customerParams.get("create_time_startdate_query")));
        }
        if (!ObjectUtils.isEmpty(customerParams.get("create_time_enddate_query"))) {
            createDateEnd = DateUtils.stringToDate((String)((String)customerParams.get("create_time_enddate_query")));
        }
        if (ObjectUtils.isEmpty((Object)sellerName) && !ObjectUtils.isEmpty(customerParams.get("saler_name_query"))) {
            sellerNameQuery = (String)customerParams.get("saler_name_query");
        }
        if (ObjectUtils.isEmpty((Object)buyerName) && !ObjectUtils.isEmpty(customerParams.get("buyer_name_query"))) {
            buyerNameQuery = (String)customerParams.get("buyer_name_query");
        }
        if (ObjectUtils.isEmpty((Object)remark) && !ObjectUtils.isEmpty(customerParams.get("remark_query"))) {
            remarkQuery = (String)customerParams.get("remark_query");
        }
        if (ObjectUtils.isEmpty((Object)invoiceDateStart) && !ObjectUtils.isEmpty(customerParams.get("invoice_date_startdate_query"))) {
            invoiceDateStart = DateUtils.stringToDate((String)((String)customerParams.get("invoice_date_startdate_query")));
        }
        if (ObjectUtils.isEmpty((Object)invoiceDateEnd) && !ObjectUtils.isEmpty(customerParams.get("invoice_date_enddate_query"))) {
            invoiceDateEnd = DateUtils.stringToDate((String)((String)customerParams.get("invoice_date_enddate_query")));
        }
        if (!ObjectUtils.isEmpty(customerParams.get("daterangefield_startdate_query"))) {
            accountDateStart = DateUtils.stringToDate((String)((String)customerParams.get("daterangefield_startdate_query")));
        }
        if (!ObjectUtils.isEmpty(customerParams.get("daterangefield_startdate_query"))) {
            accountDateEnd = DateUtils.stringToDate((String)((String)customerParams.get("daterangefield_enddate_query")));
        }
        if (!ObjectUtils.isEmpty(customerParams.get("daterangefield1_startdate_query"))) {
            authDateStart = DateUtils.stringToDate((String)((String)customerParams.get("daterangefield1_startdate_query")));
        }
        if (!ObjectUtils.isEmpty(customerParams.get("daterangefield1_enddate_query"))) {
            authDateEnd = DateUtils.stringToDate((String)((String)customerParams.get("daterangefield1_enddate_query")));
        }
        QFilter mainFilter = new QFilter("delete", "!=", (Object)"0");
        String isShowUncheck = RimConfigUtils.getConfig((String)"rim_config", (String)"show_uncheck");
        String isShowDelete = RimConfigUtils.getConfig((String)"rim_config", (String)"delete_unused");
        if (StringUtils.isEmpty((CharSequence)isShowDelete) || "0".equals(isShowUncheck)) {
            mainFilter.and("check_status", "=", (Object)"1");
        }
        if ("1".equals(isShowDelete)) {
            mainFilter.and("delete", "=", (Object)"1");
        }
        if (invoiceDateStart != null) {
            mainFilter.and("invoice_date", ">=", (Object)invoiceDateStart);
        }
        if (invoiceDateEnd != null) {
            mainFilter.and("invoice_date", "<=", (Object)invoiceDateEnd);
        }
        if (isAdmin != null && !isAdmin.booleanValue()) {
            mainFilter.and("org", "in", authList);
        }
        if (org != null) {
            mainFilter.and("org", "=", (Object)org);
        }
        if (taxOrg != null) {
            mainFilter.and("tax_org", "=", (Object)taxOrg);
        }
        if (createDateStart != null) {
            mainFilter.and("createtime", ">=", (Object)createDateStart);
        }
        if (createDateEnd != null) {
            mainFilter.and("createtime", "<=", (Object)createDateEnd);
        }
        if (sellerName != null) {
            mainFilter.and("saler_name", "=", (Object)sellerName);
        } else if (!ObjectUtils.isEmpty((Object)sellerNameQuery)) {
            mainFilter.and("saler_name", "like", (Object)("%" + sellerNameQuery + "%"));
        }
        if (buyerName != null) {
            mainFilter.and("buyer_name", "=", (Object)buyerName);
        } else if (!ObjectUtils.isEmpty((Object)buyerNameQuery)) {
            mainFilter.and("buyer_name", "like", (Object)("%" + buyerNameQuery + "%"));
        }
        if (remark != null) {
            mainFilter.and("remark", "=", (Object)remark);
        } else if (!StringUtils.isEmpty((CharSequence)remarkQuery)) {
            mainFilter.and("remark", "like", (Object)("%" + remarkQuery + "%"));
        }
        if (accountDateStart != null) {
            mainFilter.and("account_time", ">=", (Object)accountDateStart);
        }
        if (accountDateEnd != null) {
            mainFilter.and("account_time", "<=", (Object)accountDateEnd);
        }
        if (authDateStart != null) {
            mainFilter.and("authenticate_time", ">=", (Object)authDateStart);
        }
        if (accountDateEnd != null) {
            mainFilter.and("authenticate_time", "<=", (Object)authDateEnd);
        }
        if (expenseStatus != null) {
            mainFilter.and("expense_status", "=", (Object)expenseStatus);
        }
        if (originalState != null) {
            mainFilter.and("original_state", "=", (Object)originalState);
        }
        if (authenticateFlag != null) {
            mainFilter.and("authenticate_flag", "=", (Object)authenticateFlag);
        }
        ArrayList<String> serialNos = new ArrayList<String>(16);
        if (expenseType != null && !ObjectUtils.isEmpty((Object)(expenseTypeObj = QueryServiceHelper.queryOne((String)"rim_expense_type", (String)"number", (QFilter[])(expenseTypeFilter = new QFilter("name", "=", (Object)expenseType)).toArray())))) {
            String expenseTypeNumber = expenseTypeObj.getString("number");
            QFilter expenseSerialNosFilter = new QFilter("expense_type", "=", (Object)expenseTypeNumber);
            DynamicObjectCollection serialNosCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])expenseSerialNosFilter.toArray());
            if (!serialNosCollection.isEmpty()) {
                for (DynamicObject serialNoObj : serialNosCollection) {
                    if (ObjectUtils.isEmpty((Object)serialNoObj)) continue;
                    serialNos.add(serialNoObj.getString("serial_no"));
                }
            }
            if (!CollectionUtils.isEmpty(serialNos)) {
                mainFilter.and("serial_no", "in", serialNos);
            }
        }
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_invoice", (String)"serial_no, invoice_type", (QFilter[])mainFilter.toArray(), null);
        QFilter taxRateFilter = null;
        QFilter goodsNameFilter = null;
        QFilter unitPriceFilter = null;
        QFilter unitFilter = null;
        QFilter specFilter = null;
        if (taxRate != null) {
            taxRateFilter = new QFilter("items.tax_rate", ">=", (Object)taxRate.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5))).and("items.tax_rate", "<=", (Object)taxRate.divide(BigDecimal.valueOf(100L), 4, 2).add(BigDecimal.valueOf(5.0E-5)));
        }
        if (goodsName != null) {
            goodsNameFilter = new QFilter("items.goods_name", "=", (Object)goodsName);
        } else if (!StringUtils.isEmpty((CharSequence)goodsNameQuery)) {
            goodsNameFilter = new QFilter("items.goods_name", "like", (Object)("%" + goodsNameQuery + "%"));
        }
        if (unitPrice != null) {
            unitPriceFilter = new QFilter("items.unit_price", ">=", (Object)unitPrice.subtract(BigDecimal.valueOf(0.005))).and("items.unit_price", "<", (Object)unitPrice.add(BigDecimal.valueOf(0.005)));
        }
        if (unit != null) {
            unitFilter = new QFilter("items.unit", "=", (Object)unit);
        }
        if (spec != null) {
            specFilter = new QFilter("items.spec_model", "=", (Object)spec);
        }
        ArrayList<Long> showTypes = new ArrayList<Long>(16);
        if (specFilter != null) {
            showTypes.add(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
            return showTypes;
        }
        ArrayList<QFilter> detailFilters = new ArrayList<QFilter>(6);
        if (goodsNameFilter != null) {
            detailFilters.add(goodsNameFilter);
        }
        if (unitFilter != null) {
            detailFilters.add(unitFilter);
        }
        if (unitPriceFilter != null) {
            detailFilters.add(unitPriceFilter);
        }
        DataSet unionDataSet = null;
        if (!CollectionUtils.isEmpty(detailFilters)) {
            if (taxRateFilter != null) {
                detailFilters.add(taxRateFilter);
            }
            ordinaryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_ordinary", (String)"serial_no", (QFilter[])detailFilters.toArray(new QFilter[0]), null);
            specialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_special", (String)"serial_no", (QFilter[])detailFilters.toArray(new QFilter[0]), null);
            tollDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_toll", (String)"serial_no", (QFilter[])detailFilters.toArray(new QFilter[0]), null);
            hgjksDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_custom", (String)"serial_no", (QFilter[])detailFilters.toArray(new QFilter[0]), null);
            DataSet electricDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_electric", (String)"serial_no", (QFilter[])detailFilters.toArray(new QFilter[0]), null);
            unionDataSet = ordinaryDataSet.union(specialDataSet).union(tollDataSet).union(hgjksDataSet).union(electricDataSet);
        } else if (taxRateFilter != null) {
            ordinaryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_ordinary", (String)"serial_no", (QFilter[])taxRateFilter.toArray(), null);
            specialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_special", (String)"serial_no", (QFilter[])taxRateFilter.toArray(), null);
            tollDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_toll", (String)"serial_no", (QFilter[])taxRateFilter.toArray(), null);
            hgjksDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_custom", (String)"serial_no", (QFilter[])taxRateFilter.toArray(), null);
            QFilter newTaxFilter = new QFilter("tax_rate", ">=", (Object)taxRate.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5))).and("tax_rate", "<=", (Object)taxRate.divide(BigDecimal.valueOf(100L), 4, 2).add(BigDecimal.valueOf(5.0E-5)));
            DataSet motorDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_motor", (String)"serial_no", (QFilter[])newTaxFilter.toArray(), null);
            DataSet airDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_air", (String)"serial_no", (QFilter[])newTaxFilter.toArray(), null);
            DataSet trainDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_train", (String)"serial_no", (QFilter[])newTaxFilter.toArray(), null);
            DataSet transportDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_transport", (String)"serial_no", (QFilter[])newTaxFilter.toArray(), null);
            DataSet electricDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_electric", (String)"serial_no", (QFilter[])taxRateFilter.toArray(), null);
            if (ordinaryDataSet != null) {
                unionDataSet = ordinaryDataSet.union(new DataSet[]{specialDataSet, tollDataSet, hgjksDataSet, motorDataSet, airDataSet, trainDataSet, transportDataSet, electricDataSet});
            }
        }
        DataSet result = null;
        result = unionDataSet != null ? mainDataSet.join(unionDataSet, JoinType.INNER).on("serial_no", "serial_no").select(new String[]{"invoice_type"}).finish().groupBy(new String[]{"invoice_type"}).finish() : mainDataSet.groupBy(new String[]{"invoice_type"}).finish();
        while (result.hasNext()) {
            Row row = result.next();
            showTypes.add(row.getLong("invoice_type"));
        }
        return showTypes;
    }
}

