/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.verify;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class FileTypeVerifyPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"save"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject entryInfo = (JSONObject)customParams.get("currentEntryInfo");
        if (entryInfo != null) {
            this.getModel().setValue("file_custom_name", (Object)entryInfo.getString("file_custom_name"));
            this.getModel().setValue("file_custom_level", (Object)entryInfo.getString("file_custom_level"));
            this.getModel().setValue("file_invoice_type", (Object)entryInfo.getString("file_invoice_type"));
            this.getModel().setValue("file_type", (Object)entryInfo.getString("file_type"));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("save".equals(control.getKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONArray entryInfo = (JSONArray)customParams.get("entryInfo");
            String file_custom_name = (String)this.getModel().getValue("file_custom_name");
            String file_custom_level = (String)this.getModel().getValue("file_custom_level");
            String file_invoice_type = (String)this.getModel().getValue("file_invoice_type");
            String file_type = (String)this.getModel().getValue("file_type");
            HashMap<String, String> result = new HashMap<String, String>(4);
            result.put("file_custom_name", file_custom_name);
            result.put("file_custom_level", file_custom_level);
            result.put("file_invoice_type", file_invoice_type);
            result.put("file_type", file_type);
            boolean hasSameElement = false;
            if (entryInfo != null && !entryInfo.isEmpty()) {
                for (int i = 0; i < entryInfo.size(); ++i) {
                    JSONObject info = entryInfo.getJSONObject(i);
                    String entryInvoiceType = info.getString("file_invoice_type");
                    String entryFileType = info.getString("file_type");
                    String[] invoiceTypes = entryInvoiceType.split(",");
                    String[] fileTypes = entryFileType.split(",");
                    boolean invoiceTypeExist = Arrays.stream(invoiceTypes).filter(t -> !"".equals(t)).anyMatch(element -> Arrays.asList(file_invoice_type.split(",")).contains(element));
                    boolean fileTypeExist = Arrays.stream(fileTypes).filter(t -> !"".equals(t)).anyMatch(element -> Arrays.asList(file_type.split(",")).contains(element));
                    if (!invoiceTypeExist || !fileTypeExist) continue;
                    hasSameElement = true;
                    break;
                }
            }
            if (hasSameElement) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6dfb\u52a0\u91cd\u590d\u7684\u53d1\u7968\u7c7b\u578b\u548c\u6587\u4ef6\u7c7b\u578b", (String)"VerifyPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                JSONObject currentEntryInfo = (JSONObject)customParams.get("currentEntryInfo");
                if (currentEntryInfo != null) {
                    result.put("index", currentEntryInfo.getString("index"));
                }
                this.getView().returnDataToParent(result);
                this.getView().close();
            }
        }
    }
}

