/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.deduction;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductServiceTask;
import kd.imc.rim.common.utils.AllEleAuthUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.LockUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.schedule.invoicedownload.service.InvoiceDownTaskHelper;

public class AsyncDeductSelectTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AsyncDeductSelectTask.class);
    private static final int THREADPOOL_SIZE = 10;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"AsyncDeductSelectTask", (int)10);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        block18: {
            LOGGER.info("\u5f02\u6b65\u52fe\u9009\u7ed3\u679c\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
            try (DLock lock = DLock.create((String)"AsyncDeductSelectTask", (String)"AsyncDeductSelectTask");){
                if (lock.tryLock()) {
                    if (!this.putIdToCache()) {
                        return;
                    }
                    int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)800, (String)"async_deduct_size");
                    int countPages = InvoiceDownloadConstant.getPageSizeFromConfig((int)100, (String)"async_deduct_count_page");
                    for (int pageNo = 1; pageNo <= countPages; ++pageNo) {
                        int result = this.queryLogByQueue(pageSize, requestContext);
                        if (result >= 1) continue;
                        break block18;
                    }
                    break block18;
                }
                LOGGER.info("AsyncDeductSelectTask-Lock");
            }
        }
        LOGGER.info("\u5f02\u6b65\u52fe\u9009\u7ed3\u679c\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f... ");
    }

    private boolean putIdToCache() {
        String cache = CacheHelper.get((String)"async_deduct_cache");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            QFilter handleStatusFilter = new QFilter("handle_status", "=", (Object)"3");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_select_log", (String)"id", (QFilter[])handleStatusFilter.toArray(), (String)"create_time");
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return false;
            }
            List ids = collection.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
            int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)24, (String)"async_deduct_cache_hours");
            CacheHelper.put((String)"async_deduct_cache", (String)SerializationUtils.toJsonString(ids), (int)(maxHours * 60 * 60));
        }
        return true;
    }

    private int queryLogByQueue(int pageSize, RequestContext rc) {
        int result = 0;
        List<Long> selectLogIds = InvoiceDownTaskHelper.getDownIds("async_deduct_cache");
        if (CollectionUtils.isEmpty(selectLogIds)) {
            return result;
        }
        DynamicObject[] selectLogs = InvoiceDownTaskHelper.getDownDynamicObject("rim_select_log", selectLogIds, pageSize, "async_deduct_cache");
        this.handle(selectLogs, rc);
        if (selectLogIds.size() >= pageSize) {
            result = 1;
        }
        return result;
    }

    private void handle(DynamicObject[] selectLogs, RequestContext rc) {
        String isSinglethread = RimConfigUtils.getConfig((String)"rim_deduction", (String)"sync_deduct_thread");
        if (ObjectUtils.isEmpty((Object[])selectLogs)) {
            return;
        }
        ArrayList<DynamicObject> collection = new ArrayList<DynamicObject>(Arrays.asList(selectLogs));
        Map<String, List<DynamicObject>> logGroupMap = collection.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
        ArrayList<String> taxNos = new ArrayList<String>(logGroupMap.keySet());
        ArrayList<String> rpaTaxNos = new ArrayList<String>(8);
        for (String taxNo : taxNos) {
            String dkType = DeductionConstant.getDkType((String)taxNo);
            if (!"4".equals(dkType)) continue;
            rpaTaxNos.add(taxNo);
        }
        HashMap<String, List<DynamicObject>> rpaLogGroupMap = new HashMap<String, List<DynamicObject>>(8);
        if (!CollectionUtils.isEmpty(rpaTaxNos)) {
            taxNos.removeAll(rpaTaxNos);
            for (String rpaTaxNo : rpaTaxNos) {
                rpaLogGroupMap.put(rpaTaxNo, logGroupMap.remove(rpaTaxNo));
            }
        }
        this.handleCertData(taxNos, logGroupMap, rc, isSinglethread);
        this.handleRpaData(rpaTaxNos, rpaLogGroupMap, rc, isSinglethread);
    }

    private void handleCertData(List<String> taxNos, Map<String, List<DynamicObject>> logGroupMap, RequestContext rc, String isSinglethread) {
        if (CollectionUtils.isEmpty(taxNos) || CollectionUtils.isEmpty(logGroupMap)) {
            return;
        }
        Set<Map.Entry<String, List<DynamicObject>>> entrySet = logGroupMap.entrySet();
        ArrayList<Future> futureList = new ArrayList<Future>(8);
        int index = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : entrySet) {
            List<DynamicObject> logs = entry.getValue();
            if (CollectionUtils.isEmpty(logs)) continue;
            AsyncDeductServiceTask task = new AsyncDeductServiceTask(rc, logs);
            if ("1".equals(isSinglethread)) {
                try {
                    task.call();
                }
                catch (Exception exception) {}
                continue;
            }
            futureList.add(threadPool.submit((Callable)task));
            CommonUtils.futureWait(futureList, (int)10, (int)(++index));
        }
        CommonUtils.futureWait(futureList, (int)10, (int)10);
    }

    private void handleRpaData(List<String> taxNos, Map<String, List<DynamicObject>> logGroupMap, RequestContext rc, String isSinglethread) {
        if (CollectionUtils.isEmpty(taxNos) || CollectionUtils.isEmpty(logGroupMap)) {
            return;
        }
        List inputAccounts = AllEleAuthUtil.getInputAccounts(taxNos);
        Set<String> haveAccountTaxNos = inputAccounts.stream().map(s -> s.getString("taxNo")).collect(Collectors.toSet());
        this.handleNotAccount(haveAccountTaxNos, logGroupMap, rc);
        if (CollectionUtils.isEmpty(logGroupMap)) {
            return;
        }
        Map<String, List<JSONObject>> accountGroupMap = inputAccounts.stream().collect(Collectors.groupingBy(s -> s.getString("account") + s.getString("city")));
        ArrayList<Future> futureList = new ArrayList<Future>(8);
        Set<Map.Entry<String, List<JSONObject>>> entries = accountGroupMap.entrySet();
        int index = 0;
        for (Map.Entry<String, List<JSONObject>> entry : entries) {
            String entryKey = entry.getKey();
            DLock dLock = LockUtils.createDLockByMd5((String)("rim.account-" + entryKey), (String)"rpa_account_lock");
            Throwable throwable = null;
            try {
                if (dLock.tryLock(2000L)) {
                    List<JSONObject> accounts = entry.getValue();
                    ArrayList<DynamicObject> selectLogs = new ArrayList<DynamicObject>(8);
                    for (JSONObject account : accounts) {
                        List<DynamicObject> dynamicObjectList = logGroupMap.get(account.getString("taxNo"));
                        if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
                        selectLogs.addAll(dynamicObjectList);
                    }
                    AsyncDeductServiceTask task = new AsyncDeductServiceTask(rc, selectLogs);
                    if ("1".equals(isSinglethread)) {
                        try {
                            task.call();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                    futureList.add(threadPool.submit((Callable)task));
                    CommonUtils.futureWait(futureList, (int)10, (int)(++index));
                    continue;
                }
                LOGGER.info("locked:" + entryKey);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dLock == null) continue;
                if (throwable != null) {
                    try {
                        dLock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dLock.close();
            }
        }
        CommonUtils.futureWait(futureList, (int)10, (int)10);
    }

    private void handleNotAccount(Set<String> haveAccountTaxNos, Map<String, List<DynamicObject>> logGroupMap, RequestContext rc) {
        if (haveAccountTaxNos == null || CollectionUtils.isEmpty(logGroupMap)) {
            return;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : logGroupMap.entrySet()) {
            String taxNo = entry.getKey();
            if (haveAccountTaxNos.contains(taxNo)) continue;
            AsyncDeductServiceTask task = new AsyncDeductServiceTask(rc, entry.getValue());
            try {
                task.call();
            }
            catch (Exception exception) {}
        }
        Iterator<String> iterator = logGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            String taxNo = iterator.next();
            if (haveAccountTaxNos.contains(taxNo)) continue;
            iterator.remove();
        }
    }
}

