/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.deduction;

import java.util.Collection;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.deduction.AutoDeductSelectService;
import kd.imc.rim.common.utils.DynamicObjectUtil;

public class AutoDeductSelectTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AutoDeductSelectTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u81ea\u52a8\u52fe\u9009\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        try (DLock lock = DLock.create((String)"AutoDeductSelectTask", (String)"AutoDeductSelectTask");){
            if (lock.tryLock()) {
                QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_auto_deduction_task", (String)"id", (QFilter[])qFilter.toArray());
                Object[] ids = collection.stream().map(s -> s.get("id")).toArray();
                Object[] configs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_auto_deduction_task"));
                if (!ObjectUtils.isEmpty((Object[])configs)) {
                    for (Object config : configs) {
                        this.doTask((DynamicObject)config);
                    }
                }
            } else {
                LOGGER.info("AutoDeductSelectTask-Lock");
            }
        }
    }

    public void doTask(DynamicObject config) {
        AutoDeductSelectService selectService = new AutoDeductSelectService();
        DynamicObjectCollection userorg = config.getDynamicObjectCollection("userorg");
        if (CollectionUtils.isEmpty((Collection)userorg)) {
            DynamicObject item = userorg.addNew();
            item.set("seq", (Object)1);
            item.set("taxpayer_org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)config.get("accountingorg")));
            item.set("taxpayer_tax_no", (Object)config.getString("taxno"));
            item.set("taxpayer_name", (Object)config.getString("taxname"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
        }
        for (DynamicObject orgObj : userorg) {
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)orgObj.get("taxpayer_org"));
            selectService.autoDeductSelect(config, orgId, orgObj.getString("taxpayer_tax_no"));
        }
    }
}

