/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.service;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.schedule.invoicedownload.task.TableHeadApplyTask;

public class InvoiceDownTaskHelper {
    private static final Log LOGGER = LogFactory.getLog(TableHeadApplyTask.class);

    public static DynamicObject[] getDownDynamicObject(String entity, List<Long> idList, int pageSize, String cacheKey) {
        DynamicObject[] downInitDynamicObjects = new DynamicObject[]{};
        if (!CollectionUtils.isEmpty(idList)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (idList.size() <= pageSize) {
                downInitDynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)mainEntityType);
                CacheHelper.remove((String)cacheKey);
            } else {
                List<Long> downIdList = idList.subList(0, pageSize);
                downInitDynamicObjects = BusinessDataServiceHelper.load((Object[])downIdList.toArray(), (DynamicObjectType)mainEntityType);
                idList.removeAll(downIdList);
                int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)24, (String)(cacheKey + "_hours"));
                CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString(idList), (int)(3600 * maxHours));
            }
        }
        return downInitDynamicObjects;
    }

    public static List<Long> getDownIds(String cacheKey) {
        String cache = CacheHelper.get((String)cacheKey);
        List idList = Collections.emptyList();
        if (!StringUtils.isEmpty((CharSequence)cache)) {
            idList = SerializationUtils.fromJsonStringToList((String)cache, Long.class);
        }
        LOGGER.info("{}\u5269\u4f59\u4e0b\u8f7d\u6570\u91cf:{}", (Object)cacheKey, (Object)idList.size());
        return idList;
    }
}

