/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class InputDownCacheBatchNoTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InputDownCacheBatchNoTask.class);
    private static final Integer MAX_INPUT_DOWN_DEAL_DATE = 60;
    private static final String CONFIG_INPUT_DOWN_KEY = "inoutput_down_dates";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u83b7\u53d6\u4e0b\u8f7d\u6279\u6b21\u53f7\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"InputDownCacheBatchNoTask", (String)"InputDownCacheBatchNoTask.lock");){
            if (lock.tryLock()) {
                this.putCacheHeadDownload();
            } else {
                LOGGER.info("InputDownCacheBatchNoTask-Lock");
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("\u83b7\u53d6\u4e0b\u8f7d\u6279\u6b21\u53f7\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
    }

    private void putCacheHeadDownload() {
        int maxDownDates;
        Date maxDate;
        QFilter dateFilter;
        QFilter govStatusFilter;
        DynamicObjectCollection collection;
        String cacheCert = CacheHelper.get((String)"invoice_full_down_cache");
        String cacheRpa = CacheHelper.get((String)"invoice_full_down_rpa_cache");
        if ((StringUtils.isEmpty((CharSequence)cacheCert) || StringUtils.isEmpty((CharSequence)cacheRpa)) && !CollectionUtils.isEmpty((Collection)(collection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,tax_no,inout", (QFilter[])new QFilter[]{govStatusFilter = new QFilter("gov_status", "in", (Object)InvoiceDownloadConstant.ALLOW_DOWN_STATUS), dateFilter = new QFilter("createtime", ">=", (Object)(maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - (maxDownDates = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_INPUT_DOWN_DEAL_DATE, (String)CONFIG_INPUT_DOWN_KEY)))))))})))) {
            HashSet certIdList = Sets.newHashSet();
            HashSet rpaIdList = Sets.newHashSet();
            for (DynamicObject dynamicObject : collection) {
                String taxNo = dynamicObject.getString("tax_no");
                String inout = dynamicObject.getString("inout");
                String dkType = DeductionConstant.getDkType((String)taxNo);
                if (!"4".equals(dkType = InvoiceDownloadConstant.convertLqCollect((String)taxNo, (String)dkType))) {
                    certIdList.add(dynamicObject.getLong("id"));
                    continue;
                }
                if ("3".equals(inout)) {
                    rpaIdList.add(dynamicObject.getLong("id"));
                    continue;
                }
                if ("1".equals(inout) || "2".equals(inout)) {
                    if (InvoiceDownloadConstant.isAsyncDown((String)taxNo)) {
                        certIdList.add(dynamicObject.getLong("id"));
                        continue;
                    }
                    rpaIdList.add(dynamicObject.getLong("id"));
                    continue;
                }
                certIdList.add(dynamicObject.getLong("id"));
            }
            if (StringUtils.isEmpty((CharSequence)cacheCert) && CollectionUtils.isNotEmpty((Collection)certIdList)) {
                int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)36, (String)"invoice_full_down_cache_hours");
                CacheHelper.put((String)"invoice_full_down_cache", (String)SerializationUtils.toJsonString((Object)certIdList), (int)(maxHours * 60 * 60));
            }
            if (StringUtils.isEmpty((CharSequence)cacheRpa) && CollectionUtils.isNotEmpty((Collection)rpaIdList)) {
                int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)36, (String)"invoice_full_down_rpa_cache_hours");
                CacheHelper.put((String)"invoice_full_down_rpa_cache", (String)SerializationUtils.toJsonString((Object)rpaIdList), (int)(maxHours * 60 * 60));
            }
        }
    }
}

