/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InvoiceDownService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.schedule.invoicedownload.service.InvoiceDownTaskHelper;

public class TableHeadDownloadTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(TableHeadDownloadTask.class);
    private static final String CONFIG_KEY = "head_down_size";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u5934\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)200, (String)CONFIG_KEY);
        try (DLock lock = DLock.create((String)"TableHeadDownloadLockTask", (String)"TableHeadDownloadLockTask.lock");){
            if (lock.tryLock()) {
                List<Long> idList = InvoiceDownTaskHelper.getDownIds("invoice_head_down_cache");
                Object[] dynamicObjects = InvoiceDownTaskHelper.getDownDynamicObject("rim_down_init", idList, pageSize, "invoice_head_down_cache");
                if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
                    return;
                }
                this.downInvoice((DynamicObject[])dynamicObjects, "head", requestContext);
                this.downInvoice((DynamicObject[])dynamicObjects, "taxperiod", requestContext);
            } else {
                LOGGER.info("TableHeadDownloadLockTask-Lock");
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u5934\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
    }

    private void downInvoice(DynamicObject[] dynamicObjects, String downType, RequestContext requestContext) {
        InvoiceDownService downService = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection orgList = dynamicObject.getDynamicObjectCollection("userorg");
            if (CollectionUtils.isEmpty((Collection)orgList)) continue;
            for (DynamicObject orgObj : orgList) {
                long start = System.currentTimeMillis();
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)orgObj.get("taxpayer_org"));
                String taxNo = orgObj.getString("taxpayer_tax_no");
                downService = InvoiceDownServiceFactory.newInstanceForDown((String)downType, (String)taxNo);
                if (downService == null) continue;
                downService.invoiceDown(dynamicObject, requestContext, orgId, taxNo);
                LOGGER.info("{}-\u4e0b\u8f7d\u8868\u5934\u8017\u65f6:{}", (Object)taxNo, (Object)(System.currentTimeMillis() - start));
            }
        }
    }
}

