/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.servicehelper.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.FormFileEntity;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.ItextPdfUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;
import kd.imc.rim.file.utils.ofd.OfdConvertUtil;
import org.apache.pdfbox.pdmodel.PDDocument;

public class RecognitionService {
    private RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();

    public Map<String, Object> recognitionCheck(Map<String, Object> param) {
        JSONObject result = ResultContant.createSuccessJSONObject();
        String json = SerializationUtils.toJsonString(param);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        JSONObject businessParam = new JSONObject();
        businessParam.put("orgId", (Object)RequestContext.get().getOrgId());
        String notCheck = jsonObj.getString("notCheck");
        String fileHash = jsonObj.getString("fileHash");
        String pageNo = jsonObj.getString("pageNo");
        try {
            FormFileEntity fileEntity = this.recognitionCheckHelper.getFormFileEntity(jsonObj.getString("fileUrl"), jsonObj.getString("fileName"));
            if (!StringUtils.isEmpty((CharSequence)fileHash)) {
                fileEntity.setFileHash(fileHash + pageNo);
            }
            List recognitionResultList = this.recognitionCheckHelper.recognitionInvoiceFile(fileEntity, (Map)businessParam);
            if (!"1".equals(notCheck)) {
                List checkResultList = this.recognitionCheckHelper.checkInvoiceByRecognitionInfo(recognitionResultList, (Map)businessParam);
                result.put("data", checkResultList);
            } else {
                result.put("data", recognitionResultList);
            }
        }
        catch (MsgException e) {
            result.put("errcode", e.getErrorCode());
            result.put("description", e.getErrorMsg());
        }
        catch (Exception e) {
            result.put("errcode", "9999");
            result.put("description", ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25", (String)"RecognitionService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    public Map<String, Object> check(Map<String, Object> param) {
        JSONObject result = ResultContant.createSuccessJSONObject();
        String json = SerializationUtils.toJsonString(param);
        CheckParam checkParam = ConvertFieldUtil.getInvoiceCheckPart((JSONObject)JSONObject.parseObject((String)json));
        if (checkParam != null) {
            try {
                CheckResult checkResult = SimplyCheckService.checkInvoice((CheckParam)checkParam, (Long)0L, (String)"");
                if ("0000".equals(checkResult.getErrcode()) && checkResult.getData() != null) {
                    Object invoiceEntity = checkResult.getData();
                    String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                    JSONObject invoiceCheckInfo = JSON.parseObject((String)invoiceCheckStr);
                    result.put("checkStatus", "1");
                    result.put("data", invoiceCheckInfo);
                } else {
                    result.put("checkStatus", "2");
                    result.put("errcode", checkResult.getErrcode());
                    result.put("description", checkResult.getDescription());
                }
            }
            catch (Exception e) {
                result.put("errcode", "9998");
                result.put("description", ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25", (String)"RecognitionService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }

    public Map<String, Object> ofdConvert(Map<String, Object> param) {
        int indx;
        JSONObject result = ResultContant.createSuccessJSONObject();
        String json = SerializationUtils.toJsonString(param);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        String ofdUrl = jsonObj.getString("ofdUrl");
        String fileName = jsonObj.getString("fileName");
        if (fileName == null) {
            fileName = UUID.randomUUIDZero();
        } else if (fileName.lastIndexOf(46) > 0 && (indx = fileName.lastIndexOf(46)) > 0) {
            fileName = fileName.substring(0, indx);
        }
        String savePath = jsonObj.getString("savePath");
        HashMap<String, String> map = new HashMap<String, String>(2);
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream((InputStream)FileServiceFactory.getAttachmentFileService().getInputStream(ofdUrl));){
            byte[] streamByte = FileUtils.getByte((InputStream)fileInputStream);
            byte[] imageByte = OfdConvertUtil.convertToImage((byte[])streamByte, (float)1.0f, (int)2, (int)0);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(imageByte);){
                String path = FileUploadUtils.upload((String)(savePath + "/" + fileName + ".jpg"), (String)(fileName + ".jpg"), (InputStream)stream);
                if (StringUtils.isEmpty((CharSequence)path)) {
                    result.put("errcode", "9996");
                    result.put("description", ResManager.loadKDString((String)"ofd\u751f\u6210\u5feb\u7167\u5931\u8d25", (String)"RecognitionService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                } else {
                    map.put("image", path);
                }
            }
            String pdf = FileConvertUtils.ofd2pdf((byte[])streamByte, (String)(fileName + ".pdf"), (String)(savePath + "/" + fileName + ".pdf"));
            map.put("pdf", pdf);
            result.put("data", map);
        }
        catch (Exception e) {
            result.put("errcode", "9997");
            result.put("description", ResManager.loadKDString((String)"ofd\u751f\u6210\u5feb\u7167\u5931\u8d25", (String)"RecognitionService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    public Map<String, Object> analysis(Map<String, Object> param) {
        String fileUrl = (String)param.get("fileUrl");
        JSONObject result = ResultContant.createSuccessJSONObject();
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream((InputStream)FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl));
             PDDocument document = PDDocument.load((InputStream)fileInputStream);){
            byte[] streamByte;
            JSONObject pdfInvoice;
            int numberOfPages = document.getNumberOfPages();
            boolean isMore = false;
            if (numberOfPages > 1) {
                isMore = true;
            }
            if ((pdfInvoice = ItextPdfUtils.analysis((byte[])(streamByte = FileUtils.getByte((InputStream)fileInputStream)), (boolean)isMore)) != null) {
                result.put("data", pdfInvoice);
            }
        }
        catch (IOException e) {
            result.put("errcode", "9995");
            result.put("description", ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25", (String)"RecognitionService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        return result;
    }
}

