/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.id.ID;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.imc.rim.common.utils.DateUtils;

public class DownConfigUpgradeService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("upgrade DownConfig to items");
        long startTime = System.currentTimeMillis();
        final HashSet taxNos = new HashSet(16);
        String repeatSql = "select a.fid,a.ftax_no ,a.ftax_name,a.forg from t_rim_down_init a left join t_rim_down_init_userorg b on a.fid =b.fid where b.fid is null";
        DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)repeatSql, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet result) throws Exception {
                while (result.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(4);
                    map.put("id", result.getLong(1));
                    map.put("taxNo", result.getString(2));
                    map.put("name", result.getString(3));
                    map.put("orgId", result.getLong(4));
                    taxNos.add(map);
                }
                return null;
            }
        });
        if (CollectionUtils.isEmpty(taxNos)) {
            return result;
        }
        ArrayList<Object[]> initParams = new ArrayList<Object[]>(taxNos.size());
        ArrayList<Object[]> itemsParams = new ArrayList<Object[]>(taxNos.size());
        String itemsSql = "INSERT INTO t_rim_down_init_userorg (fid, fentryid, fseq, ftaxpayer_org, ftaxpayer_tax_no, ftaxpayer_name) VALUES(?, ?, ?, ?, ?, ?)";
        String initSql = "update t_rim_down_init set fnumber =?,fname =? where fid =?";
        String numberPre = "FPYDW" + DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
        int seq = 1001;
        for (Map map : taxNos) {
            Long fid = (Long)map.get("id");
            Long orgId = (Long)map.get("orgId");
            String taxNo = (String)map.get("taxNo");
            String name = (String)map.get("name");
            Long fentryid = ID.genLongId();
            Object[] array = new Object[]{fid, fentryid, 1, orgId, taxNo, name};
            itemsParams.add(array);
            String number = numberPre + seq;
            Object[] initParam = new Object[]{number, number, fid};
            initParams.add(initParam);
            ++seq;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)initSql, initParams);
        DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)itemsSql, itemsParams);
        long endQIdTime = System.currentTimeMillis();
        result.setLog("end upgrade DownConfig to items" + (endQIdTime - startTime));
        return result;
    }
}

