/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CtrlstrategyEnum;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.collector.AisinoBlackListSyn;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.ScriptUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DeductionConstant {
    private static Log logger = LogFactory.getLog(DeductionConstant.class);
    private static ThreadPool blacklistThreadPool = ThreadPools.newFixedThreadPool((String)"rim_blacklistThread", (int)1);
    public static final String DEDUCTION_CONFIG = "rim_deduction";
    public static final String DEDUCTION_CONFIG_GD_TAXNO = "rim_gd_taxno";
    public static final String DK_TYPE_SHUIPAN = "1";
    public static final String DK_TYPE_CERT = "2";
    public static final String TAX_SUPPLIER_SHUIPAN = "1";
    public static final String TAX_SUPPLIER_HOLYTAX = "2";
    public static final String TAX_SUPPLIER_AISINO = "3";
    public static final String TAX_SUPPLIER_NEW = "4";
    public static final String TAX_SUPPLIER_LQ = "5";
    public static final String TAX_SUPPLIER_BW = "6";
    public static final String LOGIN_AFTER_KEY = "loginAfter";
    public static final String LOGIN_INVALID = "91300";
    public static final Date AGRIC_START_DATE = DateUtils.stringToDate("2023-04-01", "yyyy-MM-dd");
    public static final String[] DEFAULT_COLLECT_ERRCODE = new String[]{"1132", "1022", "1021", "0301"};
    public static final String[] E_TAX_COLLECT_ERRCODE = new String[]{"91300", ErrorType.NEED_LOGIN.getCode(), ErrorType.ALL_E_CLIENT_SHUTDOWN.getCode(), ErrorType.ALL_E_TOKEN_FAIL.getCode()};
    public static final String DEDUCTION_FLAG_YES = "1";
    public static final String DEDUCTION_FLAG_NO = "0";
    public static final String DEDUCTION_PURPOSE_1 = "1";
    public static final String DEDUCTION_PURPOSE_2 = "2";
    public static final String DEDUCTION_PURPOSE_4 = "4";
    public static final String DEDUCTION_PURPOSE_3 = "3";
    public static final String AUTHENTICATE_FLAG_UNSELECT = "0";
    public static final String AUTHENTICATE_FLAG_SELECTED = "1";
    public static final String AUTHENTICATE_FLAG_SELECT_AUTH = "2";
    public static final String DEDUCTION_FLAG_SCAN_AUTH = "3";
    public static final String DEDUCTION_FLAG_READY_SELECT = "4";
    public static final String AUTHENTICATE_FLAG_SELECTING = "5";
    public static final String UNDEDUCTION_FLAG_TAX = "0";
    public static final String DEDUCTION_FLAG_TAX = "1";
    public static final String READY_DEDUCTION_FLAG_TAX = "2";
    public static final String DEDUCTIBLE_MODE_SELECT = "1";
    public static final String DEDUCTIBLE_MODE_CANCEL_SELECT = "-1";
    public static final String DEDUCTIBLE_MODE_UNSELECT = "4";
    public static final String DEDUCTIBLE_MODE_CANCEL_UNSELECT = "-4";
    public static final String DEDUCTIBLE_MODE_REFUND_TAX = "2";
    public static final String DEDUCTIBLE_MODE_CANCEL_REFUND_TAX = "-2";
    public static final String CACHE_SHUIPAN_LOGIN = "rim_shuipan_login_success";
    public static final String CACHE_SKSSQ = "rim_skssq";
    public static final String CACHE_DK_TYPE = "rim_dk_type_";
    public static final String CACHE_CURRENT_AMOUNT = "rim_current_amount";
    public static final String CACHE_CURRENT_SALE_TAX = "sale_tax_amount";
    public static final String CACHE_LEFT_TAX = "surplus_tax_amount";
    public static final String CACHE_SALE_AMOUNT = "sale_amount";
    public static final String SELECT_STATUS_UNFINISHED = "0";
    public static final String SELECT_STATUS_SUCCESS = "1";
    public static final String SELECT_STATUS_FAIL = "2";
    public static final String SELECT_STATUS_HANDLING = "3";
    public static final String SELECT_TYPE_1 = "1";
    public static final String SELECT_TYPE_2 = "2";
    public static final String SELECT_TYPE_3 = "3";
    public static final String SELECT_TYPE_4 = "4";
    public static final String SELECT_TYPE_5 = "5";
    public static final String SELECT_TYPE_6 = "6";
    public static final String SELECT_TYPE_7 = "7";
    public static final String SELECT_TYPE_8 = "8";
    public static final String OPERATE_READY_SELECT = "5";
    public static final String OPERATE_CANCEL_READY_SELECT = "-5";
    public static final String OPERATE_DEDUCT = "6";
    public static final String OPERATE_CANCEL_DEDUCT = "-6";
    public static final String OPERATE_CREATE_STATISTICS = "7";
    public static final String OPERATE_CANCEL_STATISTICS = "-7";
    public static final String OPERATE_CONFIRM_STATISTICS = "8";
    public static final String OPERATE_BATCH_AUTHENTICATE = "9";
    public static final String OPERATE_CONFIRM_DRAWBACK_STATISTICS = "10";
    public static final String OPERATE_AGRIC_SELF_PRODUCED = "13";
    public static final String OPERATE_AGRIC_NOT_SELF_PRODUCED = "14";
    public static final String OPERATE_AGRIC_PARTIAL_SELF_PRODUCED = "15";
    public static final String OPERATE_AGRIC_PARTIAL_INVOICEAMOUNT = "16";
    public static final String OPERATE_AGRIC_INVOICEAMOUNT = "17";
    public static final String TAX_RECORDED_DEDUCT = "02";
    public static final String TAX_RECORDED_NOT_DEDUCT = "03";
    public static final String TAX_RECORDED_REVOKE = "06";
    public static final String ALL_E_INVOICE_LOGIN = "bdm_tax_login";
    public static final String CACHE_KEY_TAX_NO = "deduct_tax_no";
    public static final String CACHE_KEY_TITLE = "deduct_title";
    public static final String CACHE_LOGIN_TAX_NO = "loginTaxNo";
    public static final String LOGIN_ACTION_ID = "loop_deduct_login";
    public static final String CACHE_OPERATION_RESULT = "operation_result";
    public static final String LEQI_API_TYPE = "api_type";
    public static final String APPLY = "1";
    public static final String CANCEL = "2";
    public static final String IS_VOUCHER = "1";
    public static final String IS_NOT_VOUCHER = "0";
    public static final String SELECT_QUERY_FEILDS = "id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level";
    private static final String PASS_DEDUCT_CONFIG_FIELDS = "id,number,name, custom_config_tag, air_begin_date, air_person_identity, train_begin_date, train_person_identity, bus_begin_date, bus_person_identity, boat_begin_date, boat_person_identity, ctrlstrategy";
    private static Map<Long, String> DATE_MAP = new HashMap<Long, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(InputInvoiceTypeEnum.TRAIN_INVOICE.getCode(), "train_begin_date");
            this.put(InputInvoiceTypeEnum.AIR_INVOICE.getCode(), "air_begin_date");
            this.put(InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode(), "bus_begin_date");
            this.put(InputInvoiceTypeEnum.BOAT_INVOICE.getCode(), "boat_begin_date");
            this.put(9L, "train_begin_date");
            this.put(10L, "air_begin_date");
            this.put(16L, "bus_begin_date");
            this.put(20L, "boat_begin_date");
        }
    };
    private static Map<Long, String> IDENTITY_MAP = new HashMap<Long, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(InputInvoiceTypeEnum.TRAIN_INVOICE.getCode(), "train_person_identity");
            this.put(InputInvoiceTypeEnum.AIR_INVOICE.getCode(), "air_person_identity");
            this.put(InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode(), "bus_person_identity");
            this.put(InputInvoiceTypeEnum.BOAT_INVOICE.getCode(), "boat_person_identity");
            this.put(9L, "train_person_identity");
            this.put(10L, "air_person_identity");
            this.put(16L, "bus_person_identity");
            this.put(20L, "boat_person_identity");
        }
    };
    private static Map<String, String> FILTER_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("goods_name", "goodsName");
            this.put("invoice_date", "invoiceDate");
            this.put("saler_name", "salerName");
        }
    };
    public static final String FIRST_TAX_PERIOD = "2019-03-31 23:59:59";

    public static boolean isAsyncRequest(String dkType) {
        return "3".equals(dkType) || "5".equals(dkType);
    }

    public static boolean isAsyncGxRequest(String dkType) {
        return DeductionConstant.isAsyncRequest(dkType) || "6".equals(dkType);
    }

    public static Boolean isShuipanLogin(Long orgId) {
        return "1".equals(CacheHelper.get(CACHE_SHUIPAN_LOGIN + orgId));
    }

    public static void shuipanLoginSuccess(Long orgId) {
        CacheHelper.put(CACHE_SHUIPAN_LOGIN + orgId, "1", 1800);
    }

    public static void cacheSkssq(String taxNo, String ssq) {
        int days = InvoiceDownloadConstant.getPageSizeFromConfig(15, "tax_period_cache_days");
        CacheHelper.put(CACHE_SKSSQ + taxNo, ssq, 86400 * days);
    }

    public static Map<String, BigDecimal> getCurrentTaxAmount(Long orgId, Date taxPeriod) {
        QFilter dateFilter = new QFilter("tax_period", "=", (Object)taxPeriod).and("org", "=", (Object)orgId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"rim_current_tax_info", (String)"sale_amount,sale_tax_amount,surplus_tax_amount", (QFilter[])dateFilter.toArray());
        HashMap<String, BigDecimal> taxInfoMap = new HashMap<String, BigDecimal>(3);
        if (!ObjectUtils.isEmpty((Object)obj)) {
            taxInfoMap.put(CACHE_CURRENT_SALE_TAX, obj.getBigDecimal(CACHE_CURRENT_SALE_TAX));
            taxInfoMap.put(CACHE_LEFT_TAX, obj.getBigDecimal(CACHE_LEFT_TAX));
            taxInfoMap.put(CACHE_SALE_AMOUNT, obj.getBigDecimal(CACHE_SALE_AMOUNT));
        }
        return taxInfoMap;
    }

    public static String getSkssq(Long orgId) {
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
            return DeductionConstant.getSkssq(taxNo, 0);
        }
        return "";
    }

    public static String getSkssq(String taxNo) {
        return DeductionConstant.getSkssq(taxNo, 0);
    }

    public static String getLastTaxPeriodDate(Long orgId) {
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
            return DeductionConstant.getSkssq(taxNo, 1);
        }
        return "";
    }

    public static String getLastTaxPeriodDate(String taxNo) {
        return DeductionConstant.getSkssq(taxNo, 1);
    }

    private static String getSkssq(String taxNo, int index) {
        String ssq = CacheHelper.get(CACHE_SKSSQ + taxNo);
        if (ssq != null) {
            String[] ssqs = ssq.split(";");
            return ssqs[index];
        }
        return "";
    }

    public static Boolean updateSkssq(String taxNo) {
        String skssq = CacheHelper.get(CACHE_SKSSQ + taxNo);
        Boolean updateFlag = Boolean.FALSE;
        if (StringUtils.isEmpty((CharSequence)skssq)) {
            updateFlag = Boolean.TRUE;
        } else {
            String[] ssqs = skssq.split(";");
            Date endDate = DateUtils.stringToDate(ssqs[0], "yyyyMM");
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date firstDate = calendar.getTime();
            if (endDate.compareTo(firstDate) < 0) {
                updateFlag = Boolean.TRUE;
            }
        }
        return updateFlag;
    }

    public static String canBeDeductionForTaxInvoice(JSONObject invoice) {
        if ("0".equals(DeductionConstant.canBeDeduction(invoice))) {
            return "0";
        }
        return DeductionConstant.canBeDeductionForTaxInvoiceByInv(invoice);
    }

    public static String canBeDeductionForTaxInvoiceByInv(JSONObject invoice) {
        String invoiceStatus = invoice.getString("invoiceStatus");
        Date invoiceDate = CommonUtils.getJsonValue((Map<String, Object>)invoice, Date.class, "invoiceDate", "issueDate");
        Date startDate = DateUtils.stringToDate("2017-01-01", "yyyy-MM-dd");
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
        Boolean isHgjks = InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType);
        if (!(isHgjks.booleanValue() || "0".equals(invoiceStatus) || "7".equals(invoiceStatus))) {
            return "0";
        }
        BigDecimal totalTaxAmount = null;
        totalTaxAmount = StringUtils.isNotEmpty((CharSequence)invoice.getString("totalTaxAmount")) ? invoice.getBigDecimal("totalTaxAmount") : BigDecimalUtil.transDecimal(invoice.get((Object)"taxAmount"));
        String downResource = invoice.getString("downResource");
        if (!("inputInit".equals(downResource) || totalTaxAmount != null && totalTaxAmount.compareTo(BigDecimal.ZERO) >= 0)) {
            return "0";
        }
        BigDecimal invoiceAmount = null;
        invoiceAmount = StringUtils.isNotEmpty((CharSequence)invoice.getString("invoiceAmount")) ? invoice.getBigDecimal("invoiceAmount") : BigDecimalUtil.transDecimal(invoice.get((Object)"totalAmount"));
        if (!("inputInit".equals(downResource) || isHgjks.booleanValue() || invoiceAmount != null && invoiceAmount.compareTo(BigDecimal.ZERO) >= 0)) {
            return "0";
        }
        if (invoiceDate == null) {
            return "0";
        }
        if (invoiceDate.compareTo(startDate) < 0) {
            return "0";
        }
        return "1";
    }

    private static boolean validate(JSONObject invoice) {
        BigDecimal totalTaxAmount;
        if (!"1".equals(invoice.getString("expenseStatus")) || "1".equals(invoice.getString("transportDeduction"))) {
            return true;
        }
        String taxAmount = invoice.getString("totalTaxAmount");
        if (StringUtils.isEmpty((CharSequence)taxAmount)) {
            taxAmount = invoice.getString("taxAmount");
        }
        return (totalTaxAmount = BigDecimalUtil.transDecimal(taxAmount)) == null || totalTaxAmount.compareTo(BigDecimal.ZERO) <= 0;
    }

    private static DynamicObject getDeductConfig(Long orgId) {
        QFilter qFilter;
        DynamicObject dynamicObject = null;
        String cacheKey = "rim_deduct_config" + orgId;
        String cacheId = CacheHelper.get(cacheKey);
        if (!StringUtils.isEmpty((CharSequence)cacheId)) {
            qFilter = new QFilter("id", "=", (Object)Long.parseLong(cacheId));
            qFilter.and("enable", "=", (Object)"1");
            DynamicObject collection = QueryServiceHelper.queryOne((String)"rim_deduct_config", (String)PASS_DEDUCT_CONFIG_FIELDS, (QFilter[])new QFilter[]{qFilter});
            if (collection != null) {
                return collection;
            }
            CacheHelper.remove(cacheKey);
        }
        qFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"rim_deduct_config", (Long)orgId, (String)"id");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_deduct_config", (String)PASS_DEDUCT_CONFIG_FIELDS, (QFilter[])new QFilter[]{qFilter, enableFilter}, (String)"modifytime desc");
        for (CtrlstrategyEnum ctrlstrategyEnum : CtrlstrategyEnum.values()) {
            String code = ctrlstrategyEnum.getCode();
            for (DynamicObject config : collection) {
                if (!code.equals(config.get("ctrlstrategy"))) continue;
                dynamicObject = config;
                CacheHelper.put(cacheKey, String.valueOf(dynamicObject.getLong("id")), 600);
                break;
            }
            if (!ObjectUtils.isEmpty(dynamicObject)) break;
        }
        return dynamicObject;
    }

    public static String canBeAgricInvoice(String invoiceStatus, BigDecimal totalAmount) {
        boolean isBlue;
        boolean invoiceStatusFlag = "0".equals(invoiceStatus) || "7".equals(invoiceStatus);
        boolean bl = isBlue = BigDecimalUtil.transDecimal(totalAmount).compareTo(BigDecimal.ZERO) >= 0;
        if (!invoiceStatusFlag || !isBlue) {
            return "0";
        }
        return "1";
    }

    public static String canBeDeductionForOrdinary(JSONObject invoice, Long orgId) {
        String invoiceNo;
        if ("0".equals(DeductionConstant.canBeDeduction(invoice))) {
            return "0";
        }
        String invoiceCode = invoice.getString("invoiceCode");
        if (InvoiceConvertUtils.isBlockChainType(invoiceCode, invoiceNo = invoice.getString("invoiceNo")) || InvoiceConvertUtils.isYunNanBlockchain(invoiceCode, invoiceNo)) {
            return "0";
        }
        BigDecimal invoiceAmount = null;
        invoiceAmount = StringUtils.isNotEmpty((CharSequence)invoice.getString("invoiceAmount")) ? invoice.getBigDecimal("invoiceAmount") : invoice.getBigDecimal("totalAmount");
        if (invoiceAmount == null || invoiceAmount.compareTo(BigDecimal.ZERO) < 0) {
            return "0";
        }
        if (!"0".equals(invoice.getString("invoiceStatus")) && !"7".equals(invoice.getString("invoiceStatus"))) {
            return "0";
        }
        if ("7".equals(invoice.getString("invoiceStatus")) && invoiceAmount.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        DynamicObject dynamicObject = DeductionConstant.getDeductConfig(orgId);
        logger.info("\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u914d\u7f6e\u662f\uff1a{}-{},[{}]", new Object[]{invoiceCode, invoiceNo, ObjectUtils.isEmpty((Object)dynamicObject) ? null : dynamicObject.getString("number")});
        String filterStr = ObjectUtils.isEmpty((Object)dynamicObject) ? null : dynamicObject.getString("custom_config_tag");
        logger.info("\u662f\u5426\u5b58\u5728\u81ea\u5b9a\u4e49\u65c5\u5ba2\u8fd0\u8f93\u914d\u7f6e\uff1a{}", (Object)StringUtils.isNotEmpty((CharSequence)filterStr));
        if (StringUtils.isEmpty((CharSequence)filterStr)) {
            JSONArray items = invoice.getJSONArray("items");
            if (CollectionUtils.isEmpty((Collection)items)) {
                return "0";
            }
            boolean filterGoodName = false;
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                String goodsName = Optional.ofNullable(item.getString("goodsName")).orElseGet(String::new);
                boolean bl = filterGoodName = goodsName.contains("*\u8fd0\u8f93\u670d\u52a1*") && !goodsName.contains("\u6e2f\u6fb3\u53f0") && !goodsName.contains("\u56fd\u9645") && !goodsName.contains("\u8d27\u7269");
                if (filterGoodName) break;
            }
            if (!filterGoodName) {
                return "0";
            }
            if (!"0".equals(invoice.getString("invoiceStatus"))) {
                return "0";
            }
            BigDecimal totalTaxAmount = null;
            totalTaxAmount = StringUtils.isNotEmpty((CharSequence)invoice.getString("totalTaxAmount")) ? invoice.getBigDecimal("totalTaxAmount") : invoice.getBigDecimal("taxAmount");
            if (totalTaxAmount == null || totalTaxAmount.compareTo(BigDecimal.ZERO) <= 0) {
                return "0";
            }
            Date startDate = DateUtils.stringToDate(FIRST_TAX_PERIOD, "yyyy-MM-dd HH:mm:ss");
            Object date = invoice.get((Object)"invoiceDate");
            Date invoiceDate = date instanceof Long ? new Date((Long)date) : DateUtils.stringToDate(date.toString(), "yyyy-MM-dd");
            if (invoiceDate.before(startDate)) {
                return "0";
            }
        } else {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            if (filterCondition != null) {
                List filterRow = filterCondition.getFilterRow();
                int index = 0;
                StringBuilder sb = new StringBuilder();
                try {
                    for (SimpleFilterRow row : filterRow) {
                        ++index;
                        if (StringUtils.isNotEmpty((CharSequence)row.getLeftBracket())) {
                            sb.append(row.getLeftBracket());
                        }
                        ArrayList<Object> invoiceValue = null;
                        if (row.getFieldName().startsWith("items.")) {
                            String field = row.getFieldName().replace("items.", "");
                            JSONArray collect = invoice.getJSONArray("items");
                            ArrayList<Object> list = new ArrayList<Object>();
                            String fileKey = FILTER_MAP.get(field);
                            if (collect != null && collect.size() > 0) {
                                for (int i = 0; i < collect.size(); ++i) {
                                    JSONObject jons = collect.getJSONObject(i);
                                    list.add(jons.getObject(fileKey, Object.class));
                                }
                            }
                            invoiceValue = list;
                        } else {
                            invoiceValue = invoice.get((Object)FILTER_MAP.get(row.getFieldName()));
                        }
                        List filterValueList = row.getValue();
                        ArrayList<Object> filterValues = null;
                        if (filterValueList != null) {
                            filterValues = new ArrayList<Object>(filterValueList.size());
                            for (FilterValue value : filterValueList) {
                                filterValues.add(value.getValue());
                            }
                        }
                        sb.append(VerifyService.compare(invoiceValue, row.getCompareType(), filterValues, null));
                        if (StringUtils.isNotEmpty((CharSequence)row.getRightBracket())) {
                            sb.append(row.getRightBracket());
                        }
                        if (index >= filterRow.size()) continue;
                        if ("0".equals(row.getLogic())) {
                            sb.append("&&");
                            continue;
                        }
                        sb.append("||");
                    }
                    logger.info("\u5b50\u8868\u67e5\u8be2\u6761\u4ef6\uff1a[{}]", (Object)sb.toString());
                    Object reslut = ScriptUtils.eval(sb.toString());
                    if ("true".equals(reslut.toString())) {
                        return "1";
                    }
                }
                catch (Exception e) {
                    logger.info("\u62fc\u63a5\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u914d\u7f6e\u53c2\u6570\u51fa\u9519\uff1a{}", (Object)e);
                }
                return "0";
            }
        }
        return "1";
    }

    public static String canBeDeductionForTransport(JSONObject invoice, Long orgId) {
        if ("0".equals(DeductionConstant.canBeDeduction(invoice))) {
            return "0";
        }
        String invoiceTypeStr = invoice.getString("invoiceType");
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceTypeStr);
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) && ("2".equals(invoice.getString("businessType")) || "4".equals(invoice.getString("businessType")) || "3".equals(invoice.getString("businessType")))) {
            return "0";
        }
        DynamicObject dynamicObject = DeductionConstant.getDeductConfig(orgId);
        if (dynamicObject == null) {
            return DeductionConstant.canBeDeductionForTransportDefault(invoice);
        }
        logger.info("\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u914d\u7f6e\u662f\uff1a{}-{},[{}]", new Object[]{invoice.getString("invoiceCode"), invoice.getString("invoiceNo"), ObjectUtils.isEmpty((Object)dynamicObject) ? null : dynamicObject.getString("number")});
        String dateKey = DATE_MAP.get(invoiceType);
        String idKey = IDENTITY_MAP.get(invoiceType);
        boolean walk = InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType);
        Date invoiceDate = null;
        if (!walk && !StringUtils.isEmpty((CharSequence)dateKey)) {
            invoiceDate = dynamicObject.getDate(dateKey);
        }
        String filter = null;
        if (!walk && !StringUtils.isEmpty((CharSequence)idKey)) {
            filter = dynamicObject.getString(idKey);
        }
        if (invoiceDate == null || StringUtils.isEmpty(filter) || DeductionConstant.validate(invoice)) {
            if ("0".equals(DeductionConstant.canBeDeduction(invoice))) {
                return "0";
            }
            BigDecimal totalTaxAmount = null;
            totalTaxAmount = StringUtils.isNotEmpty((CharSequence)invoice.getString("totalTaxAmount")) ? invoice.getBigDecimal("totalTaxAmount") : invoice.getBigDecimal("taxAmount");
            if (totalTaxAmount == null || totalTaxAmount.compareTo(BigDecimal.ZERO) <= 0) {
                return "0";
            }
        } else {
            if (walk) {
                filter = "1";
                invoiceDate = DateUtils.stringToDate(FIRST_TAX_PERIOD, "yyyy-MM-dd HH:mm:ss");
            }
            boolean largeEquals = invoice.getDate("invoiceDate").after(invoiceDate);
            String passengerName = InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) ? invoice.getString("customerName") : invoice.getString("passengerName");
            String customerIdNo = invoice.getString("customerIdNo");
            boolean deductionFlag = true;
            if ("1".equals(filter)) {
                deductionFlag = largeEquals && (StringUtils.isNotEmpty((CharSequence)passengerName) || StringUtils.isNotEmpty((CharSequence)customerIdNo));
            } else if ("2".equals(filter)) {
                boolean bl = deductionFlag = largeEquals && StringUtils.isNotEmpty((CharSequence)passengerName) && StringUtils.isNotEmpty((CharSequence)customerIdNo);
            }
            if (!deductionFlag) {
                return "0";
            }
        }
        return "1";
    }

    private static String canBeDeductionForTransportDefault(JSONObject invoice) {
        if ("0".equals(DeductionConstant.canBeDeduction(invoice))) {
            return "0";
        }
        BigDecimal totalTaxAmount = null;
        totalTaxAmount = StringUtils.isNotEmpty((CharSequence)invoice.getString("totalTaxAmount")) ? invoice.getBigDecimal("totalTaxAmount") : invoice.getBigDecimal("taxAmount");
        if (totalTaxAmount == null || totalTaxAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return "0";
        }
        return "1";
    }

    public static String canBeDeduction(JSONObject invoice) {
        String allowDeduction = invoice.getString("allowDeduction");
        String deductionFlag = invoice.getString("deductionFlag");
        if ("1".equals(allowDeduction) && StringUtils.isNotEmpty((CharSequence)deductionFlag)) {
            return deductionFlag;
        }
        return "1";
    }

    public static String getDeductionFlag(JSONObject invoiceJson, Long orgId) {
        String awsInvoiceType = invoiceJson.getString("invoiceType");
        Long longInvoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType);
        String deduction_flag = "";
        if (longInvoiceType == null || longInvoiceType == 0L) {
            return deduction_flag;
        }
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(longInvoiceType)) {
            deduction_flag = DeductionConstant.canBeDeductionForOrdinary(invoiceJson, orgId);
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(longInvoiceType)) {
            deduction_flag = DeductionConstant.canBeDeductionForTransport(invoiceJson, orgId);
        }
        if (InputInvoiceTypeEnum.canDeduction(longInvoiceType).booleanValue()) {
            deduction_flag = DeductionConstant.canBeDeductionForTaxInvoice(invoiceJson);
        }
        return deduction_flag;
    }

    public static String getDeductionFlag(DynamicObject mainObject, DynamicObject bodyObject) {
        Long longInvoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("invoice_type"));
        String deduction_flag = "";
        if (longInvoiceType == null || longInvoiceType == 0L) {
            return deduction_flag;
        }
        if (InputInvoiceTypeEnum.canDeduction(longInvoiceType).booleanValue() || InputInvoiceTypeEnum.canTransportDeduction(longInvoiceType).booleanValue()) {
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("org"));
            Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObject);
            String extInfo = mainObject.getString("ext_info");
            try {
                JSONObject extObject = JSONObject.parseObject((String)extInfo);
                deduction_flag = extObject.getString(InvoiceSaveConstant.EXT_DEDUCTION_FLAG);
                if (!StringUtils.isEmpty((CharSequence)deduction_flag)) {
                    return deduction_flag;
                }
            }
            catch (Exception extObject) {
                // empty catch block
            }
            Map<String, Object> fileMap = DynamicObjectUtil.dynamicObjectToMap(bodyObject);
            InvoiceConvertService.putAll(mainMap, fileMap);
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(longInvoiceType, null);
            JSONObject result = convertService.convert(mainMap);
            if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(longInvoiceType)) {
                deduction_flag = DeductionConstant.canBeDeductionForOrdinary(result, orgId);
            } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(longInvoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(longInvoiceType)) {
                deduction_flag = DeductionConstant.canBeDeductionForTransport(result, orgId);
            }
            if (InputInvoiceTypeEnum.canDeduction(longInvoiceType).booleanValue()) {
                deduction_flag = DeductionConstant.canBeDeductionForTaxInvoice(result);
            }
            if (StringUtils.isNotEmpty((CharSequence)deduction_flag)) {
                InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, deduction_flag);
            }
        }
        return deduction_flag;
    }

    @Deprecated
    public static String getDeductionFlag(DynamicObject mainObject) {
        return DeductionConstant.getDeductionFlag(mainObject, null);
    }

    private static JSONObject getInvoiceConvertResult(DynamicObject mainObject) {
        Long longInvoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("invoice_type"));
        Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObject);
        DynamicObject[] detail = InvoiceQueryService.loadBySerialNo(InputInvoiceTypeEnum.getEntity(longInvoiceType), TenantUtils.getTenantNo(), new String[]{mainObject.getString("serial_no")});
        if (detail != null && detail.length > 0) {
            Map<String, Object> bodyMap = DynamicObjectUtil.dynamicObjectToMap(detail[0]);
            InvoiceConvertService.putAll(mainMap, bodyMap);
        }
        InvoiceConvertService convertService = InvoiceConvertService.newInstance(longInvoiceType, null);
        JSONObject result = convertService.convert(mainMap);
        return result;
    }

    public static void setUnittestFlag(Map<String, Object> param) {
        param.put("userId", RequestContext.get().getUserId());
        param.put("isUpdateStatus", "1");
        String unittestFlag = RimConfigUtils.getConfig("unit_test_flag");
        String invoiceAllSuccess = RimConfigUtils.getConfig("test_invoice_all_success");
        if (StringUtils.isNotEmpty((CharSequence)unittestFlag)) {
            param.put("unittestFlag", unittestFlag);
            param.put("invoiceAllSuccess", Optional.ofNullable(invoiceAllSuccess).orElse("0"));
        }
    }

    public static Pair<String, String> getDeductionPurpose(String deductibleMode) {
        String deductionPurpose = "1";
        String authenticateFlag = "1";
        if ("1".equals(deductibleMode)) {
            deductionPurpose = "1";
        } else if (DEDUCTIBLE_MODE_CANCEL_SELECT.equals(deductibleMode)) {
            authenticateFlag = "0";
            deductionPurpose = "1";
        } else if ("4".equals(deductibleMode)) {
            deductionPurpose = "2";
        } else if (DEDUCTIBLE_MODE_CANCEL_UNSELECT.equals(deductibleMode)) {
            authenticateFlag = "0";
            deductionPurpose = "2";
        } else if ("2".equals(deductibleMode)) {
            deductionPurpose = "3";
        } else if (DEDUCTIBLE_MODE_CANCEL_REFUND_TAX.equals(deductibleMode)) {
            authenticateFlag = "0";
            deductionPurpose = "3";
        }
        return Pair.of((Object)authenticateFlag, (Object)deductionPurpose);
    }

    public static String getDeductibleMode(String deductionPurpose, String authenticateFlag) {
        if ("1".equals(authenticateFlag) && "1".equals(deductionPurpose)) {
            return "1";
        }
        if ("0".equals(authenticateFlag) && "1".equals(deductionPurpose)) {
            return DEDUCTIBLE_MODE_CANCEL_SELECT;
        }
        if ("1".equals(authenticateFlag) && "2".equals(deductionPurpose)) {
            return "4";
        }
        if ("0".equals(authenticateFlag) && "2".equals(deductionPurpose)) {
            return DEDUCTIBLE_MODE_CANCEL_UNSELECT;
        }
        if ("1".equals(authenticateFlag) && "3".equals(deductionPurpose)) {
            return "2";
        }
        return "1";
    }

    public static String getDkType(String taxNo) {
        String dkType = CacheHelper.get(CACHE_DK_TYPE + taxNo);
        return Optional.ofNullable(dkType).filter(StringUtils::isNotEmpty).orElseGet(() -> DeductionConstant.getDkTypeByTaxNo(taxNo));
    }

    public static String getDkTypeByTaxNo(String taxNo) {
        Map<String, String> map = TenantUtils.getTaxInfo(taxNo);
        String dkType = Optional.ofNullable(map).map(s -> (String)s.get("dkType")).filter(StringUtils::isNotEmpty).orElseGet(() -> DeductionConstant.getDkType());
        return dkType;
    }

    public static String getDkType() {
        String dkType = RimConfigUtils.getConfig(DEDUCTION_CONFIG, "tax_supplier");
        return Optional.ofNullable(dkType).filter(StringUtils::isNotEmpty).orElse("2");
    }

    public static void searchBlacklist(String sellerTaxNo) {
        String dkType = DeductionConstant.getDkType();
        if (StringUtils.isEmpty((CharSequence)sellerTaxNo)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)dkType) && "3".equals(dkType)) {
            ArrayList<String> salerTaxList = new ArrayList<String>(1);
            salerTaxList.add(sellerTaxNo);
            AisinoBlackListSyn aisinoBlackListSyn = new AisinoBlackListSyn(RequestContext.get(), salerTaxList);
            blacklistThreadPool.execute((Runnable)aisinoBlackListSyn);
        }
    }

    public static JSONObject createSelectJson(DynamicObject object) {
        return DeductionConstant.createSelectJson(object, null);
    }

    public static JSONObject createSelectJson(DynamicObject object, String deductionPurpose) {
        return DeductionConstant.createSelectJson(object, deductionPurpose, "");
    }

    public static JSONObject createSelectJson(DynamicObject object, String deductionPurpose, String undeductReason) {
        JSONObject invoice = new JSONObject();
        invoice.put("id", (Object)object.getString("id"));
        try {
            String isselect = object.getString("isselect");
            invoice.put("isselect", (Object)isselect);
        }
        catch (Exception isselect) {
            // empty catch block
        }
        DataEntityPropertyCollection properties = object.getDataEntityType().getProperties();
        Set fileds = properties.stream().map(s -> s.getName()).collect(Collectors.toSet());
        invoice.put("invoiceCode", (Object)object.getString("invoice_code"));
        if (fileds.contains("buyer_tax_no")) {
            invoice.put("buyerTaxNo", (Object)object.getString("buyer_tax_no"));
        }
        invoice.put("orgId", (Object)DynamicObjectUtil.getDynamicObjectLongValue(object.get("org")));
        invoice.put("invoiceNo", (Object)object.getString("invoice_no"));
        invoice.put("serialNo", (Object)object.getString("serial_no"));
        Long invoiceTypeLong = DynamicObjectUtil.getDynamicObjectLongValue(object.get("invoice_type"));
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceTypeLong)) {
            invoice.put("customDeclarationNo", (Object)object.getString("invoice_no"));
            Long orgId = invoice.getLong("orgId");
            String buyerTaxNo = invoice.getString("buyerTaxNo");
            if (StringUtils.isEmpty((CharSequence)buyerTaxNo) && orgId != null && orgId != 0L) {
                String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
                invoice.put("buyerTaxNo", (Object)taxNo);
            }
        }
        invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType(invoiceTypeLong));
        invoice.put("invoiceTypeLong", (Object)invoiceTypeLong);
        String electronicNo = object.getString("electronic_no");
        if (StringUtils.isNotEmpty((CharSequence)electronicNo)) {
            invoice.put("etaxInvoiceNo", (Object)electronicNo);
        }
        BigDecimal effectiveTaxAmount = object.getBigDecimal("effective_tax_amount");
        BigDecimal totalTaxAmount = object.getBigDecimal("total_tax_amount");
        if (BigDecimal.ZERO.compareTo(BigDecimalUtil.transDecimal(effectiveTaxAmount)) == 0) {
            effectiveTaxAmount = totalTaxAmount;
        }
        invoice.put("effectiveTaxAmount", (Object)BigDecimalUtil.format(effectiveTaxAmount));
        invoice.put("invoiceDate", (Object)DateUtils.format(object.getDate("invoice_date")));
        invoice.put("totalTaxAmount", (Object)BigDecimalUtil.format(totalTaxAmount));
        invoice.put("invoiceAmount", (Object)BigDecimalUtil.format(object.getBigDecimal("invoice_amount")));
        if (fileds.contains("authenticate_flag")) {
            invoice.put("preAuthenticateFlag", (Object)object.getString("authenticate_flag"));
        }
        if (("2".equals(deductionPurpose) || "2".equals(object.getString("deduction_purpose"))) && fileds.contains("not_deductible_type")) {
            invoice.put("notDeductibleType", (Object)object.getString("not_deductible_type"));
            if (StringUtils.isNotEmpty((CharSequence)undeductReason)) {
                invoice.put("notDeductibleType", (Object)undeductReason);
            }
        }
        if (fileds.contains("saler_name")) {
            invoice.put("salerName", (Object)object.getString("saler_name"));
        }
        if (fileds.contains("saler_tax_no")) {
            invoice.put("salerTaxNo", (Object)object.getString("saler_tax_no"));
        }
        return invoice;
    }

    public static String getDeductionPurposeByQueryType(String queryType) {
        boolean checkUndeduction;
        boolean bl = checkUndeduction = "undeduction".equals(queryType) || "readyselect_undeduction".equals(queryType);
        if (checkUndeduction) {
            return "2";
        }
        if ("drawback".equals(queryType)) {
            return "3";
        }
        return "1";
    }

    public static JSONObject getSelectParamJson(Object queryType, Object operatetype, Long invoiceType) {
        boolean checkUndeduction;
        boolean checkDeduction;
        JSONObject param = new JSONObject();
        String billType = "0";
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
            billType = "1";
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            billType = "2";
        }
        param.put("billType", (Object)billType);
        param.put("deductibleMode", (Object)"1");
        boolean bl = checkDeduction = "deduction".equals(queryType) || "readyselect_deduction".equals(queryType);
        if (checkDeduction && "deduction_select".equals(operatetype)) {
            param.put("deductibleMode", (Object)"1");
        }
        if (checkDeduction && "deduction_unselect".equals(operatetype)) {
            param.put("deductibleMode", (Object)DEDUCTIBLE_MODE_CANCEL_SELECT);
        }
        boolean bl2 = checkUndeduction = "undeduction".equals(queryType) || "readyselect_undeduction".equals(queryType);
        if (checkUndeduction && "deduction_select".equals(operatetype)) {
            param.put("deductibleMode", (Object)"4");
        }
        if (checkUndeduction && "deduction_unselect".equals(operatetype)) {
            param.put("deductibleMode", (Object)DEDUCTIBLE_MODE_CANCEL_UNSELECT);
        }
        if ("drawback".equals(queryType)) {
            param.put("deductibleMode", (Object)"2");
            if ("deduction_unselect".equals(operatetype)) {
                param.put("deductibleMode", (Object)DEDUCTIBLE_MODE_CANCEL_REFUND_TAX);
            }
        }
        return param;
    }

    public static String getRequestId(JSONObject paramJson) {
        String requestId = CommonUtils.getJsonValue((Map<String, Object>)paramJson, String.class, "requestId", "messageId");
        if (StringUtils.isEmpty((CharSequence)requestId)) {
            requestId = UUID.randomUUID();
        }
        return requestId;
    }

    public static String changeAuthenticateFlag(String deductibleMode) {
        if (StringUtils.isNotEmpty((CharSequence)deductibleMode)) {
            if (DEDUCTIBLE_MODE_CANCEL_SELECT.equals(deductibleMode)) {
                return "0";
            }
            return deductibleMode;
        }
        return "";
    }

    public static void removeLoopLoginCache(IPageCache pageCache) {
        pageCache.remove(CACHE_KEY_TAX_NO);
        pageCache.remove(CACHE_OPERATION_RESULT);
        pageCache.remove(CACHE_LOGIN_TAX_NO);
    }
}

