/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;

public enum HolytaxInvoiceTypeEnum {
    ORDINARY_ELECTRON("10", InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode()),
    ELECTRIC_ORDINARY("10xdp", InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode()),
    SPECIAL_ELECTRON("08", InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode()),
    ELECTRIC_SPECIAL("08xdp", InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()),
    ORDINARY_PAPER("04", InputInvoiceTypeEnum.ORDINARY_PAPER.getCode()),
    SPECIAL_PAPER("01", InputInvoiceTypeEnum.SPECIAL_PAPER.getCode()),
    ORDINARY_ROLL("11", InputInvoiceTypeEnum.ORDINARY_ROLL.getCode()),
    MOTOR_INVOICE("03", InputInvoiceTypeEnum.MOTOR_INVOICE.getCode()),
    USEDCAR_INVOICE("15", InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode()),
    HGJKS("17", InputInvoiceTypeEnum.HGJKS.getCode()),
    TOLL_ELECTRON("14", InputInvoiceTypeEnum.TOLL_ELECTRON.getCode());

    private String code;
    private Long invoicType;

    public static Set<String> getAllHolytaxTypes() {
        return Arrays.stream(HolytaxInvoiceTypeEnum.values()).map(HolytaxInvoiceTypeEnum::getCode).collect(Collectors.toSet());
    }

    public static Long getInvoiceTypeByHolytaxType(String holytaxType) {
        if (StringUtils.isEmpty((String)holytaxType)) {
            return 0L;
        }
        if ("08xdpzz".equals(holytaxType)) {
            return InputInvoiceTypeEnum.SPECIAL_PAPER.getCode();
        }
        for (HolytaxInvoiceTypeEnum invoiceType : HolytaxInvoiceTypeEnum.values()) {
            if (!invoiceType.getCode().equals(holytaxType)) continue;
            return invoiceType.getInvoicType();
        }
        return 0L;
    }

    public static String getAwsTypeByHolytaxType(String holytaxType) {
        return InputInvoiceTypeEnum.getAwsType(HolytaxInvoiceTypeEnum.getInvoiceTypeByHolytaxType(holytaxType));
    }

    public static String getHolytaxTypeByAwsType(String awsType) {
        return HolytaxInvoiceTypeEnum.getHolytaxType(InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsType));
    }

    public static String getHolytaxType(Long invoiceType) {
        if (null == invoiceType) {
            return null;
        }
        for (HolytaxInvoiceTypeEnum holytaxType : HolytaxInvoiceTypeEnum.values()) {
            if (!holytaxType.getInvoicType().equals(invoiceType)) continue;
            return holytaxType.getCode();
        }
        return null;
    }

    private HolytaxInvoiceTypeEnum(String code, Long invoicType) {
        this.code = code;
        this.invoicType = invoicType;
    }

    public String getCode() {
        return this.code;
    }

    public Long getInvoicType() {
        return this.invoicType;
    }
}

