/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.invoice.model.type.AirEleInvoice;
import kd.imc.rim.common.invoice.model.type.AirInvoice;
import kd.imc.rim.common.invoice.model.type.CustomInvoice;
import kd.imc.rim.common.invoice.model.type.ElectricInvoice;
import kd.imc.rim.common.invoice.model.type.FinancialInvoice;
import kd.imc.rim.common.invoice.model.type.GeneralInvoice;
import kd.imc.rim.common.invoice.model.type.MotorInvoice;
import kd.imc.rim.common.invoice.model.type.OrdinaryInvoice;
import kd.imc.rim.common.invoice.model.type.OtherInvoice;
import kd.imc.rim.common.invoice.model.type.OverSeaInvoice;
import kd.imc.rim.common.invoice.model.type.QuotaInvoice;
import kd.imc.rim.common.invoice.model.type.SpecialInvoice;
import kd.imc.rim.common.invoice.model.type.TaxProofInvoice;
import kd.imc.rim.common.invoice.model.type.TaxiInvoice;
import kd.imc.rim.common.invoice.model.type.TollInvoice;
import kd.imc.rim.common.invoice.model.type.TrainEleInvoice;
import kd.imc.rim.common.invoice.model.type.TrainInvoice;
import kd.imc.rim.common.invoice.model.type.TrainRefundInvoice;
import kd.imc.rim.common.invoice.model.type.TransportInvoice;
import kd.imc.rim.common.invoice.model.type.UsedCarInvoice;
import kd.imc.rim.common.invoice.model.type.WithholdInvoice;
import kd.imc.rim.common.invoice.model.type.items.AirEleItems;
import kd.imc.rim.common.invoice.model.type.items.AirItems;
import kd.imc.rim.common.invoice.model.type.items.CustomItems;
import kd.imc.rim.common.invoice.model.type.items.ElectricItems;
import kd.imc.rim.common.invoice.model.type.items.FinancialItems;
import kd.imc.rim.common.invoice.model.type.items.OrdinaryItems;
import kd.imc.rim.common.invoice.model.type.items.OverSeaItems;
import kd.imc.rim.common.invoice.model.type.items.SpecialItems;
import kd.imc.rim.common.invoice.model.type.items.TollItems;
import kd.imc.rim.common.model.MultiLangEnumBridge;

public enum InputInvoiceTypeEnum {
    ALL_INVOICE(0L, new MultiLangEnumBridge("\u5168\u90e8", "InputInvoiceTypeEnum_0", "imc-rim-common"), null, ""),
    ORDINARY_ELECTRON(961634333825754112L, new MultiLangEnumBridge("\u7535\u5b50\u666e\u901a\u53d1\u7968", "InputInvoiceTypeEnum_1", "imc-rim-common"), OrdinaryInvoice.class, "1"),
    SPECIAL_ELECTRON(961639304377984000L, new MultiLangEnumBridge("\u7535\u5b50\u4e13\u7528\u53d1\u7968", "InputInvoiceTypeEnum_2", "imc-rim-common"), SpecialInvoice.class, "2"),
    ELECTRIC_ORDINARY(1376129501813207040L, new MultiLangEnumBridge("\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", "InputInvoiceTypeEnum_3", "imc-rim-common"), ElectricInvoice.class, "26"),
    ELECTRIC_SPECIAL(1376129725579325440L, new MultiLangEnumBridge("\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", "InputInvoiceTypeEnum_4", "imc-rim-common"), ElectricInvoice.class, "27"),
    AIR_ELE_INVOICE(1715266493832248320L, new MultiLangEnumBridge("\u6570\u7535\u7968\uff08\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968)", "InputInvoiceTypeEnum_5", "imc-rim-common"), AirEleInvoice.class, "28"),
    TRAIN_ELE_INVOICE(1715267177252499456L, new MultiLangEnumBridge("\u6570\u7535\u7968\uff08\u94c1\u8def\u7535\u5b50\u5ba2\u7968)", "InputInvoiceTypeEnum_6", "imc-rim-common"), TrainEleInvoice.class, "29"),
    ORDINARY_PAPER(961639799666521088L, new MultiLangEnumBridge("\u7eb8\u8d28\u666e\u901a\u53d1\u7968", "InputInvoiceTypeEnum_7", "imc-rim-common"), OrdinaryInvoice.class, "3"),
    SPECIAL_PAPER(961640097369875456L, new MultiLangEnumBridge("\u7eb8\u8d28\u4e13\u7528\u53d1\u7968", "InputInvoiceTypeEnum_8", "imc-rim-common"), SpecialInvoice.class, "4"),
    ORDINARY_ROLL(961640365939504128L, new MultiLangEnumBridge("\u666e\u901a\u7eb8\u8d28\u5377\u7968", "InputInvoiceTypeEnum_9", "imc-rim-common"), OrdinaryInvoice.class, "5"),
    TOLL_ELECTRON(961642468384760832L, new MultiLangEnumBridge("\u901a\u884c\u8d39\u7535\u5b50\u53d1\u7968", "InputInvoiceTypeEnum_10", "imc-rim-common"), TollInvoice.class, "15"),
    GENERAL_PAPER(961640584051745792L, new MultiLangEnumBridge("\u901a\u7528\u673a\u6253\u7eb8\u8d28\u53d1\u7968", "InputInvoiceTypeEnum_11", "imc-rim-common"), GeneralInvoice.class, "7"),
    GENERAL_ELECTRON(1064297140039193600L, new MultiLangEnumBridge("\u901a\u7528\u673a\u6253\u7535\u5b50\u53d1\u7968", "InputInvoiceTypeEnum_12", "imc-rim-common"), GeneralInvoice.class, "23"),
    MOTOR_INVOICE(961641829533496320L, new MultiLangEnumBridge("\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968", "InputInvoiceTypeEnum_13", "imc-rim-common"), MotorInvoice.class, "12"),
    USEDCAR_INVOICE(961641980209718272L, new MultiLangEnumBridge("\u4e8c\u624b\u8f66\u9500\u552e\u53d1\u7968", "InputInvoiceTypeEnum_14", "imc-rim-common"), UsedCarInvoice.class, "13"),
    TRAIN_INVOICE(961640926684439552L, new MultiLangEnumBridge("\u706b\u8f66/\u9ad8\u94c1\u7968", "InputInvoiceTypeEnum_15", "imc-rim-common"), TrainInvoice.class, "9"),
    AIR_INVOICE(961641064953820160L, new MultiLangEnumBridge("\u98de\u673a\u884c\u7a0b\u5355", "InputInvoiceTypeEnum_16", "imc-rim-common"), AirInvoice.class, "10"),
    TRANSPORT_INVOICE(961642651029877760L, new MultiLangEnumBridge("\u516c\u8def\u6c7d\u8f66\u7968", "InputInvoiceTypeEnum_17", "imc-rim-common"), TransportInvoice.class, "16"),
    BOAT_INVOICE(961642939052733440L, new MultiLangEnumBridge("\u8f6e\u8239\u7968", "InputInvoiceTypeEnum_18", "imc-rim-common"), TransportInvoice.class, "20"),
    TAXI_INVOICE(961640786812744704L, new MultiLangEnumBridge("\u51fa\u79df\u8f66\u7968", "InputInvoiceTypeEnum_19", "imc-rim-common"), TaxiInvoice.class, "8"),
    QUOTA_INVOICE(961642274356212736L, new MultiLangEnumBridge("\u5b9a\u989d\u53d1\u7968", "InputInvoiceTypeEnum_20", "imc-rim-common"), QuotaInvoice.class, "14"),
    ROAD_BRIDGE(961642798694589440L, new MultiLangEnumBridge("\u8fc7\u8def\u6865\u8d39\u53d1\u7968", "InputInvoiceTypeEnum_21", "imc-rim-common"), GeneralInvoice.class, "17"),
    TAX_PROOF(1153677132925255680L, new MultiLangEnumBridge("\u5b8c\u7a0e\u8bc1\u660e", "InputInvoiceTypeEnum_22", "imc-rim-common"), TaxProofInvoice.class, "19"),
    HGJKS(961643098478273536L, new MultiLangEnumBridge("\u6d77\u5173\u7f34\u6b3e\u4e66", "InputInvoiceTypeEnum_23", "imc-rim-common"), CustomInvoice.class, "21"),
    TRAIN_REFUND(1289853151331127296L, new MultiLangEnumBridge("\u706b\u8f66\u7968\u9000\u7968\u51ed\u8bc1", "InputInvoiceTypeEnum_24", "imc-rim-common"), TrainRefundInvoice.class, "24"),
    FINANCIAL_INVOICE(1289853364628262912L, new MultiLangEnumBridge("\u8d22\u653f\u7535\u5b50\u7968\u636e", "InputInvoiceTypeEnum_25", "imc-rim-common"), FinancialInvoice.class, "25"),
    OVERSEA_INVOICE(1508663424216008704L, new MultiLangEnumBridge("\u6d77\u5916\u53d1\u7968", "InputInvoiceTypeEnum_26", "imc-rim-common"), OverSeaInvoice.class, "30"),
    WITHHOLDING(1976201167029761024L, new MultiLangEnumBridge("\u589e\u503c\u7a0e\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1", "InputInvoiceTypeEnum_28", "imc-rim-common"), WithholdInvoice.class, "47"),
    OTHER_INVOICE(961641254855173120L, new MultiLangEnumBridge("\u5176\u4ed6\u7968", "InputInvoiceTypeEnum_27", "imc-rim-common"), OtherInvoice.class, "11");

    private MultiLangEnumBridge bridge = null;
    private Long code;
    private String name;
    private Class entityClazz;
    private String awsType;

    private InputInvoiceTypeEnum(Long code, MultiLangEnumBridge bridge, Class entityClazz, String awsType) {
        this.code = code;
        this.bridge = bridge;
        this.entityClazz = entityClazz;
        this.awsType = awsType;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static InputInvoiceTypeEnum getInvoiceType(String awsType) {
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsType);
        return InputInvoiceTypeEnum.getInvoiceType(invoiceType);
    }

    public static InputInvoiceTypeEnum getInvoiceType(Long code) {
        for (InputInvoiceTypeEnum invoiceType : InputInvoiceTypeEnum.values()) {
            if (!invoiceType.getCode().equals(code)) continue;
            return invoiceType;
        }
        return null;
    }

    public static Long[] getRedInvoiceType() {
        return new Long[]{InputInvoiceTypeEnum.ORDINARY_ELECTRON.code, InputInvoiceTypeEnum.SPECIAL_ELECTRON.code, InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code, InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code, InputInvoiceTypeEnum.ORDINARY_PAPER.code, InputInvoiceTypeEnum.SPECIAL_PAPER.code, InputInvoiceTypeEnum.TOLL_ELECTRON.code, InputInvoiceTypeEnum.MOTOR_INVOICE.code, InputInvoiceTypeEnum.USEDCAR_INVOICE.code};
    }

    public static InputInvoiceTypeEnum[] getDetialType() {
        return new InputInvoiceTypeEnum[]{ORDINARY_ELECTRON, SPECIAL_ELECTRON, ELECTRIC_ORDINARY, ELECTRIC_SPECIAL, ORDINARY_PAPER, SPECIAL_PAPER, ORDINARY_ROLL, TOLL_ELECTRON, MOTOR_INVOICE, USEDCAR_INVOICE, HGJKS};
    }

    public static Boolean canDeduction(Long code) {
        return InputInvoiceTypeEnum.SPECIAL_PAPER.code.equals(code) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.MOTOR_INVOICE.code.equals(code) || InputInvoiceTypeEnum.TOLL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.HGJKS.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(code) || WITHHOLDING.getCode().equals(code) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.code.equals(code);
    }

    public static Long[] getDeductionTypes() {
        return new Long[]{SPECIAL_ELECTRON.getCode(), SPECIAL_PAPER.getCode(), MOTOR_INVOICE.getCode(), TOLL_ELECTRON.getCode(), HGJKS.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code, WITHHOLDING.getCode(), InputInvoiceTypeEnum.AIR_ELE_INVOICE.code};
    }

    public static Long[] getDeductionAllTypes() {
        return new Long[]{SPECIAL_ELECTRON.getCode(), SPECIAL_PAPER.getCode(), MOTOR_INVOICE.getCode(), TOLL_ELECTRON.getCode(), HGJKS.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code, WITHHOLDING.getCode(), ORDINARY_PAPER.getCode(), ORDINARY_ELECTRON.getCode(), ELECTRIC_ORDINARY.getCode(), AIR_ELE_INVOICE.getCode()};
    }

    public static InputInvoiceTypeEnum[] getDeductionTypeEnums() {
        return new InputInvoiceTypeEnum[]{SPECIAL_ELECTRON, SPECIAL_PAPER, MOTOR_INVOICE, TOLL_ELECTRON, HGJKS, ELECTRIC_SPECIAL, WITHHOLDING, AIR_ELE_INVOICE};
    }

    public static Long[] getVatDeductionTypes() {
        return new Long[]{SPECIAL_ELECTRON.getCode(), SPECIAL_PAPER.getCode(), MOTOR_INVOICE.getCode(), TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code, InputInvoiceTypeEnum.AIR_ELE_INVOICE.code};
    }

    public static Boolean canVatDrawbackDeduction(Long code) {
        return InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.SPECIAL_PAPER.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(code);
    }

    public static Long[] getVatDrawbackTypes() {
        return new Long[]{InputInvoiceTypeEnum.SPECIAL_ELECTRON.code, InputInvoiceTypeEnum.SPECIAL_PAPER.code, InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code};
    }

    public static Boolean canTransportDeduction(Long code) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code.equals(code) || InputInvoiceTypeEnum.TRAIN_INVOICE.code.equals(code) || InputInvoiceTypeEnum.AIR_INVOICE.code.equals(code) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.code.equals(code) || InputInvoiceTypeEnum.BOAT_INVOICE.code.equals(code);
    }

    public static Long[] getTransportTypes() {
        return new Long[]{ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code, TRAIN_INVOICE.getCode(), AIR_INVOICE.getCode(), TRANSPORT_INVOICE.getCode(), BOAT_INVOICE.getCode()};
    }

    public static Long[] getVatTypes() {
        return new Long[]{SPECIAL_ELECTRON.getCode(), SPECIAL_PAPER.getCode(), ORDINARY_ELECTRON.getCode(), ORDINARY_PAPER.getCode(), ORDINARY_ROLL.getCode(), MOTOR_INVOICE.getCode(), TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code, InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code, AIR_ELE_INVOICE.getCode()};
    }

    public static boolean isElectricInvoice(Long code) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.TOLL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.GENERAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.FINANCIAL_INVOICE.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(code);
    }

    public static boolean isCheckOriginalFile(Long code) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.TOLL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.code.equals(code) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.code.equals(code);
    }

    public static boolean isAirEleTrainEleType(Long code) {
        return InputInvoiceTypeEnum.AIR_ELE_INVOICE.code.equals(code) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.code.equals(code);
    }

    public static Long[] getPaperTypes() {
        return new Long[]{InputInvoiceTypeEnum.ORDINARY_PAPER.code, InputInvoiceTypeEnum.SPECIAL_PAPER.code, InputInvoiceTypeEnum.ORDINARY_ROLL.code, InputInvoiceTypeEnum.GENERAL_PAPER.code, InputInvoiceTypeEnum.MOTOR_INVOICE.code, InputInvoiceTypeEnum.TRAIN_INVOICE.code, InputInvoiceTypeEnum.AIR_INVOICE.code, InputInvoiceTypeEnum.TRANSPORT_INVOICE.code, InputInvoiceTypeEnum.TAXI_INVOICE.code, InputInvoiceTypeEnum.QUOTA_INVOICE.code, InputInvoiceTypeEnum.ROAD_BRIDGE.code, InputInvoiceTypeEnum.OTHER_INVOICE.code, InputInvoiceTypeEnum.TAX_PROOF.code, InputInvoiceTypeEnum.HGJKS.code, InputInvoiceTypeEnum.BOAT_INVOICE.code, InputInvoiceTypeEnum.TRAIN_REFUND.code, InputInvoiceTypeEnum.USEDCAR_INVOICE.code};
    }

    public static Boolean needCheck(Long code) {
        return InputInvoiceTypeEnum.SPECIAL_PAPER.code.equals(code) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.MOTOR_INVOICE.code.equals(code) || InputInvoiceTypeEnum.TOLL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.USEDCAR_INVOICE.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_PAPER.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_ROLL.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code.equals(code) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.code.equals(code) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.code.equals(code);
    }

    public static Boolean needCheckAws(String code) {
        return SPECIAL_PAPER.getAwsType().equals(code) || SPECIAL_ELECTRON.getAwsType().equals(code) || MOTOR_INVOICE.getAwsType().equals(code) || TOLL_ELECTRON.getAwsType().equals(code) || USEDCAR_INVOICE.getAwsType().equals(code) || ORDINARY_ELECTRON.getAwsType().equals(code) || ORDINARY_PAPER.getAwsType().equals(code) || ORDINARY_ROLL.getAwsType().equals(code) || ELECTRIC_SPECIAL.getAwsType().equals(code) || ELECTRIC_ORDINARY.getAwsType().equals(code) || AIR_ELE_INVOICE.getAwsType().equals(code) || TRAIN_ELE_INVOICE.getAwsType().equals(code);
    }

    public static Boolean isEleInvoice(Long code) {
        return InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(code) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code.equals(code) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.code.equals(code);
    }

    public static Boolean needItems(Long code) {
        return InputInvoiceTypeEnum.SPECIAL_PAPER.code.equals(code) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.TOLL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.HGJKS.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_PAPER.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_ROLL.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code.equals(code);
    }

    public static Boolean canGeneratePdf(Long code) {
        return ORDINARY_PAPER.getCode().equals(code) || ORDINARY_ELECTRON.getCode().equals(code) || TOLL_ELECTRON.getCode().equals(code) || SPECIAL_PAPER.getCode().equals(code) || SPECIAL_ELECTRON.getCode().equals(code) || ELECTRIC_ORDINARY.getCode().equals(code) || ELECTRIC_SPECIAL.getCode().equals(code);
    }

    public static String getEntity(Long code) {
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_PAPER.code.equals(code) || InputInvoiceTypeEnum.ORDINARY_ROLL.code.equals(code)) {
            return "rim_inv_ordinary";
        }
        if (InputInvoiceTypeEnum.SPECIAL_PAPER.code.equals(code) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(code)) {
            return "rim_inv_special";
        }
        if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code.equals(code) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(code)) {
            return "rim_inv_electric";
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.code.equals(code)) {
            return "rim_inv_air";
        }
        if (InputInvoiceTypeEnum.TOLL_ELECTRON.code.equals(code)) {
            return "rim_inv_toll";
        }
        if (InputInvoiceTypeEnum.MOTOR_INVOICE.code.equals(code)) {
            return "rim_inv_motor";
        }
        if (InputInvoiceTypeEnum.USEDCAR_INVOICE.code.equals(code)) {
            return "rim_inv_usedcar";
        }
        if (InputInvoiceTypeEnum.GENERAL_PAPER.code.equals(code) || InputInvoiceTypeEnum.GENERAL_ELECTRON.code.equals(code) || InputInvoiceTypeEnum.ROAD_BRIDGE.code.equals(code)) {
            return "rim_inv_general";
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.code.equals(code)) {
            return "rim_inv_train";
        }
        if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.code.equals(code) || InputInvoiceTypeEnum.BOAT_INVOICE.code.equals(code)) {
            return "rim_inv_transport";
        }
        if (InputInvoiceTypeEnum.TAXI_INVOICE.code.equals(code)) {
            return "rim_inv_taxi";
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.code.equals(code)) {
            return "rim_inv_quota";
        }
        if (InputInvoiceTypeEnum.OTHER_INVOICE.code.equals(code)) {
            return "rim_inv_other";
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.code.equals(code)) {
            return "rim_inv_tax_proof";
        }
        if (InputInvoiceTypeEnum.ALL_INVOICE.code.equals(code)) {
            return "rim_invoice";
        }
        if (InputInvoiceTypeEnum.HGJKS.code.equals(code)) {
            return "rim_inv_custom";
        }
        if (InputInvoiceTypeEnum.TRAIN_REFUND.code.equals(code)) {
            return "rim_inv_train_refund";
        }
        if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.code.equals(code)) {
            return "rim_inv_financial";
        }
        if (InputInvoiceTypeEnum.OVERSEA_INVOICE.code.equals(code)) {
            return "rim_inv_oversea";
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.code.equals(code)) {
            return "rim_inv_air_ele";
        }
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.code.equals(code)) {
            return "rim_inv_train_ele";
        }
        if (InputInvoiceTypeEnum.WITHHOLDING.code.equals(code)) {
            return "rim_inv_withholding";
        }
        return "";
    }

    public static String getAwsType(Object invoiceType) {
        if (invoiceType == null) {
            return "";
        }
        Long type = Long.parseLong(invoiceType.toString());
        if (InputInvoiceTypeEnum.OTHER_INVOICE.code.equals(type)) {
            return "11";
        }
        if (InputInvoiceTypeEnum.MOTOR_INVOICE.code.equals(type)) {
            return "12";
        }
        if (InputInvoiceTypeEnum.GENERAL_ELECTRON.code.equals(type)) {
            return "23";
        }
        if (InputInvoiceTypeEnum.USEDCAR_INVOICE.code.equals(type)) {
            return "13";
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.code.equals(type)) {
            return "14";
        }
        if (InputInvoiceTypeEnum.TOLL_ELECTRON.code.equals(type)) {
            return "15";
        }
        if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.code.equals(type)) {
            return "16";
        }
        if (InputInvoiceTypeEnum.ROAD_BRIDGE.code.equals(type)) {
            return "17";
        }
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.code.equals(type)) {
            return "1";
        }
        if (InputInvoiceTypeEnum.SPECIAL_ELECTRON.code.equals(type)) {
            return "2";
        }
        if (InputInvoiceTypeEnum.ORDINARY_PAPER.code.equals(type)) {
            return "3";
        }
        if (InputInvoiceTypeEnum.SPECIAL_PAPER.code.equals(type)) {
            return "4";
        }
        if (InputInvoiceTypeEnum.ORDINARY_ROLL.code.equals(type)) {
            return "5";
        }
        if (InputInvoiceTypeEnum.GENERAL_PAPER.code.equals(type)) {
            return "7";
        }
        if (InputInvoiceTypeEnum.TAXI_INVOICE.code.equals(type)) {
            return "8";
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.code.equals(type)) {
            return "9";
        }
        if (InputInvoiceTypeEnum.BOAT_INVOICE.code.equals(type)) {
            return "20";
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.code.equals(type)) {
            return "10";
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.code.equals(type)) {
            return "19";
        }
        if (InputInvoiceTypeEnum.HGJKS.code.equals(type)) {
            return "21";
        }
        if (InputInvoiceTypeEnum.TRAIN_REFUND.code.equals(type)) {
            return "24";
        }
        if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.code.equals(type)) {
            return "25";
        }
        if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code.equals(type)) {
            return "26";
        }
        if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code.equals(type)) {
            return "27";
        }
        if (InputInvoiceTypeEnum.OVERSEA_INVOICE.code.equals(type)) {
            return "30";
        }
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.code.equals(type)) {
            return "28";
        }
        if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.code.equals(type)) {
            return "29";
        }
        if (InputInvoiceTypeEnum.WITHHOLDING.code.equals(type)) {
            return "47";
        }
        return "";
    }

    public static Long getInvoiceTypeByAwsType(String awsType) {
        if (StringUtils.isEmpty((String)awsType)) {
            return 0L;
        }
        switch (awsType) {
            case "11": {
                return InputInvoiceTypeEnum.OTHER_INVOICE.code;
            }
            case "12": {
                return InputInvoiceTypeEnum.MOTOR_INVOICE.code;
            }
            case "23": {
                return InputInvoiceTypeEnum.GENERAL_ELECTRON.code;
            }
            case "13": {
                return InputInvoiceTypeEnum.USEDCAR_INVOICE.code;
            }
            case "14": {
                return InputInvoiceTypeEnum.QUOTA_INVOICE.code;
            }
            case "15": {
                return InputInvoiceTypeEnum.TOLL_ELECTRON.code;
            }
            case "16": {
                return InputInvoiceTypeEnum.TRANSPORT_INVOICE.code;
            }
            case "17": {
                return InputInvoiceTypeEnum.ROAD_BRIDGE.code;
            }
            case "1": {
                return InputInvoiceTypeEnum.ORDINARY_ELECTRON.code;
            }
            case "2": {
                return InputInvoiceTypeEnum.SPECIAL_ELECTRON.code;
            }
            case "3": {
                return InputInvoiceTypeEnum.ORDINARY_PAPER.code;
            }
            case "4": {
                return InputInvoiceTypeEnum.SPECIAL_PAPER.code;
            }
            case "5": {
                return InputInvoiceTypeEnum.ORDINARY_ROLL.code;
            }
            case "7": {
                return InputInvoiceTypeEnum.GENERAL_PAPER.code;
            }
            case "8": {
                return InputInvoiceTypeEnum.TAXI_INVOICE.code;
            }
            case "9": {
                return InputInvoiceTypeEnum.TRAIN_INVOICE.code;
            }
            case "20": {
                return InputInvoiceTypeEnum.BOAT_INVOICE.code;
            }
            case "10": {
                return InputInvoiceTypeEnum.AIR_INVOICE.code;
            }
            case "19": {
                return InputInvoiceTypeEnum.TAX_PROOF.code;
            }
            case "21": {
                return InputInvoiceTypeEnum.HGJKS.code;
            }
            case "24": {
                return InputInvoiceTypeEnum.TRAIN_REFUND.code;
            }
            case "25": {
                return InputInvoiceTypeEnum.FINANCIAL_INVOICE.code;
            }
            case "26": {
                return InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code;
            }
            case "27": {
                return InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code;
            }
            case "30": {
                return InputInvoiceTypeEnum.OVERSEA_INVOICE.code;
            }
            case "28": {
                return InputInvoiceTypeEnum.AIR_ELE_INVOICE.code;
            }
            case "29": {
                return InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.code;
            }
            case "47": {
                return InputInvoiceTypeEnum.WITHHOLDING.code;
            }
        }
        if (StringUtils.isNumeric((String)awsType)) {
            try {
                InputInvoiceTypeEnum enu = InputInvoiceTypeEnum.getInvoiceType(Long.parseLong(awsType));
                if (enu != null) {
                    return enu.getCode();
                }
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static Long getInvoiceTypeByRuiqiType(String ruiqiType, String electronicMark, String transitMark) {
        if (StringUtils.isEmpty((String)ruiqiType)) {
            return 0L;
        }
        switch (ruiqiType) {
            case "10100": {
                if ("1".equals(electronicMark)) {
                    return InputInvoiceTypeEnum.SPECIAL_ELECTRON.code;
                }
                return InputInvoiceTypeEnum.SPECIAL_PAPER.code;
            }
            case "10101": {
                return InputInvoiceTypeEnum.ORDINARY_PAPER.code;
            }
            case "10102": {
                if ("1".equals(transitMark)) {
                    return InputInvoiceTypeEnum.TOLL_ELECTRON.code;
                }
                return InputInvoiceTypeEnum.ORDINARY_ELECTRON.code;
            }
            case "10103": {
                return InputInvoiceTypeEnum.ORDINARY_ROLL.code;
            }
            case "10203": {
                return InputInvoiceTypeEnum.TRAIN_REFUND.code;
            }
            case "10104": {
                return InputInvoiceTypeEnum.MOTOR_INVOICE.code;
            }
            case "10105": {
                return InputInvoiceTypeEnum.USEDCAR_INVOICE.code;
            }
            case "10505a": {
                return InputInvoiceTypeEnum.BOAT_INVOICE.code;
            }
            case "10200": {
                return InputInvoiceTypeEnum.QUOTA_INVOICE.code;
            }
            case "10400": {
                if ("1".equals(electronicMark)) {
                    return InputInvoiceTypeEnum.GENERAL_ELECTRON.code;
                }
                return InputInvoiceTypeEnum.GENERAL_PAPER.code;
            }
            case "10500": {
                return InputInvoiceTypeEnum.TAXI_INVOICE.code;
            }
            case "10503": {
                return InputInvoiceTypeEnum.TRAIN_INVOICE.code;
            }
            case "10505": {
                return InputInvoiceTypeEnum.TRANSPORT_INVOICE.code;
            }
            case "10506": {
                return InputInvoiceTypeEnum.AIR_INVOICE.code;
            }
            case "10507": {
                return InputInvoiceTypeEnum.ROAD_BRIDGE.code;
            }
            case "10900": {
                return InputInvoiceTypeEnum.OTHER_INVOICE.code;
            }
            case "10902": {
                return InputInvoiceTypeEnum.TAX_PROOF.code;
            }
            case "10108": {
                return InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code;
            }
            case "10107": {
                return InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code;
            }
            case "260000": {
                return InputInvoiceTypeEnum.ELECTRIC_ORDINARY.code;
            }
            case "270000": {
                return InputInvoiceTypeEnum.ELECTRIC_SPECIAL.code;
            }
        }
        return InputInvoiceTypeEnum.OTHER_INVOICE.code;
    }

    public Long getCode() {
        return this.code;
    }

    public Class getClazz() {
        return this.entityClazz;
    }

    public String getAwsType() {
        return this.awsType;
    }

    public static Class getClazzByCode(Long code) {
        Class name = null;
        for (InputInvoiceTypeEnum entity : InputInvoiceTypeEnum.values()) {
            if (!entity.getCode().equals(code)) continue;
            name = entity.getClazz();
            break;
        }
        return name;
    }

    public static Class getItemClazzByCode(Long code) {
        Class itemClazz = null;
        if (ORDINARY_ELECTRON.getCode().equals(code) || ORDINARY_PAPER.getCode().equals(code) || ORDINARY_ROLL.getCode().equals(code)) {
            itemClazz = OrdinaryItems.class;
        } else if (SPECIAL_ELECTRON.getCode().equals(code) || SPECIAL_PAPER.getCode().equals(code)) {
            itemClazz = SpecialItems.class;
        } else if (ELECTRIC_ORDINARY.getCode().equals(code) || ELECTRIC_SPECIAL.getCode().equals(code)) {
            itemClazz = ElectricItems.class;
        } else if (TOLL_ELECTRON.getCode().equals(code)) {
            itemClazz = TollItems.class;
        } else if (AIR_INVOICE.getCode().equals(code)) {
            itemClazz = AirItems.class;
        } else if (HGJKS.getCode().equals(code)) {
            itemClazz = CustomItems.class;
        } else if (FINANCIAL_INVOICE.getCode().equals(code)) {
            itemClazz = FinancialItems.class;
        } else if (AIR_ELE_INVOICE.getCode().equals(code)) {
            itemClazz = AirEleItems.class;
        } else if (OVERSEA_INVOICE.getCode().equals(code)) {
            itemClazz = OverSeaItems.class;
        }
        return itemClazz;
    }

    public static String getLqInvoiceType(String awsType) {
        return InputInvoiceTypeEnum.getLqInvoiceType(null, awsType);
    }

    public static String getLqInvoiceType(Long invoiceType) {
        return InputInvoiceTypeEnum.getLqInvoiceType(invoiceType, "");
    }

    public static String getLqInvoiceType(Long invoiceType, String awsType) {
        String type = "";
        if (SPECIAL_PAPER.getCode().equals(invoiceType) || SPECIAL_PAPER.getAwsType().equals(awsType)) {
            type = "01";
        } else if (MOTOR_INVOICE.getCode().equals(invoiceType) || MOTOR_INVOICE.getAwsType().equals(awsType)) {
            type = "03";
        } else if (SPECIAL_ELECTRON.getCode().equals(invoiceType) || SPECIAL_ELECTRON.getAwsType().equals(awsType)) {
            type = "08";
        } else if (TOLL_ELECTRON.getCode().equals(invoiceType) || TOLL_ELECTRON.getAwsType().equals(awsType)) {
            type = "14";
        } else if (TRAIN_ELE_INVOICE.getCode().equals(invoiceType) || TRAIN_ELE_INVOICE.getAwsType().equals(awsType)) {
            type = "51";
        } else if (AIR_ELE_INVOICE.getCode().equals(invoiceType) || AIR_ELE_INVOICE.getAwsType().equals(awsType)) {
            type = "61";
        } else if (ELECTRIC_SPECIAL.getCode().equals(invoiceType) || ELECTRIC_SPECIAL.getAwsType().equals(awsType)) {
            type = "81";
        } else if (ELECTRIC_ORDINARY.getCode().equals(invoiceType) || ELECTRIC_ORDINARY.getAwsType().equals(awsType)) {
            type = "82";
        } else if (ORDINARY_PAPER.getCode().equals(invoiceType) || ORDINARY_PAPER.getAwsType().equals(awsType)) {
            type = "04";
        } else if (ORDINARY_ELECTRON.getCode().equals(invoiceType) || ORDINARY_ELECTRON.getAwsType().equals(awsType)) {
            type = "10";
        } else if (USEDCAR_INVOICE.getCode().equals(invoiceType) || USEDCAR_INVOICE.getAwsType().equals(awsType)) {
            type = "15";
        } else if (ORDINARY_ROLL.getCode().equals(invoiceType) || ORDINARY_ROLL.getAwsType().equals(awsType)) {
            type = "11";
        }
        return type;
    }

    public static Long getInvoiceTypeByLqType(String lqType) {
        InputInvoiceTypeEnum type = InputInvoiceTypeEnum.getInvoiceTypeEnumByLqType(lqType);
        return type != null ? type.getCode() : 0L;
    }

    public static String getAwsTypeByLqType(String lqType) {
        InputInvoiceTypeEnum type = InputInvoiceTypeEnum.getInvoiceTypeEnumByLqType(lqType);
        return type != null ? type.getAwsType() : "";
    }

    public static InputInvoiceTypeEnum getInvoiceTypeEnumByLqType(String lqType) {
        if ("01".equals(lqType)) {
            return SPECIAL_PAPER;
        }
        if ("03".equals(lqType)) {
            return MOTOR_INVOICE;
        }
        if ("08".equals(lqType)) {
            return SPECIAL_ELECTRON;
        }
        if ("14".equals(lqType)) {
            return TOLL_ELECTRON;
        }
        if ("51".equals(lqType)) {
            return TRAIN_ELE_INVOICE;
        }
        if ("61".equals(lqType)) {
            return AIR_ELE_INVOICE;
        }
        if ("81".equals(lqType)) {
            return ELECTRIC_SPECIAL;
        }
        if ("82".equals(lqType)) {
            return ELECTRIC_ORDINARY;
        }
        if ("04".equals(lqType)) {
            return ORDINARY_PAPER;
        }
        if ("10".equals(lqType)) {
            return ORDINARY_ELECTRON;
        }
        if ("15".equals(lqType)) {
            return USEDCAR_INVOICE;
        }
        if ("11".equals(lqType)) {
            return ORDINARY_ROLL;
        }
        return null;
    }

    public static Map<Long, String> getInvoiceTypeFormBaseData() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicetype", (String)"id,name", (QFilter[])new QFilter[]{filter});
        LinkedHashMap<Long, String> retrunMap = new LinkedHashMap<Long, String>(32);
        for (InputInvoiceTypeEnum entity : InputInvoiceTypeEnum.values()) {
            retrunMap.put(entity.getCode(), entity.getName());
            DynamicObject obj = (DynamicObject)map.get(entity.getCode());
            if (obj == null || StringUtils.isEmpty((String)obj.getString("name"))) continue;
            retrunMap.put(entity.getCode(), obj.getString("name"));
        }
        return retrunMap;
    }

    public static boolean allowDrawbackType(String awsType) {
        return SPECIAL_ELECTRON.getAwsType().equals(awsType) || SPECIAL_PAPER.getAwsType().equals(awsType) || HGJKS.getAwsType().equals(awsType) || ELECTRIC_SPECIAL.getAwsType().equals(awsType);
    }

    public static boolean allowDrawbackType(Long invoiceType) {
        return SPECIAL_ELECTRON.getCode().equals(invoiceType) || SPECIAL_PAPER.getCode().equals(invoiceType) || HGJKS.getCode().equals(invoiceType) || ELECTRIC_SPECIAL.getCode().equals(invoiceType);
    }

    public static boolean needClassOfInvoice(Long invoiceType) {
        return ORDINARY_ELECTRON.getCode().equals(invoiceType) || SPECIAL_ELECTRON.getCode().equals(invoiceType) || ELECTRIC_ORDINARY.getCode().equals(invoiceType) || ELECTRIC_SPECIAL.getCode().equals(invoiceType) || ORDINARY_PAPER.getCode().equals(invoiceType) || SPECIAL_PAPER.getCode().equals(invoiceType) || TOLL_ELECTRON.getCode().equals(invoiceType) || GENERAL_ELECTRON.getCode().equals(invoiceType) || FINANCIAL_INVOICE.getCode().equals(invoiceType);
    }

    public static boolean isExistEtaxInvoiceNo(Long invoiceType) {
        return ORDINARY_PAPER.getCode().equals(invoiceType) || SPECIAL_PAPER.getCode().equals(invoiceType) || MOTOR_INVOICE.getCode().equals(invoiceType);
    }

    public static boolean canSelfproducedAgric(Long invoiceType) {
        return Arrays.asList(InputInvoiceTypeEnum.getSelfproducedAgricType()).contains(invoiceType);
    }

    public static Long[] getSelfproducedAgricType() {
        return new Long[]{ORDINARY_PAPER.getCode(), ORDINARY_ELECTRON.getCode()};
    }

    public static boolean canSmallScaleSpecialType(Long invoiceType) {
        return Arrays.asList(InputInvoiceTypeEnum.getSmallScaleSpecialType()).contains(invoiceType);
    }

    public static Long[] getSmallScaleSpecialType() {
        return new Long[]{SPECIAL_ELECTRON.getCode(), SPECIAL_PAPER.getCode(), ELECTRIC_SPECIAL.getCode()};
    }

    public static boolean isVatType(Long invoiceType) {
        return ORDINARY_ELECTRON.getCode().equals(invoiceType) || SPECIAL_ELECTRON.getCode().equals(invoiceType) || ELECTRIC_ORDINARY.getCode().equals(invoiceType) || ELECTRIC_SPECIAL.getCode().equals(invoiceType) || AIR_ELE_INVOICE.getCode().equals(invoiceType) || TRAIN_ELE_INVOICE.getCode().equals(invoiceType) || ORDINARY_PAPER.getCode().equals(invoiceType) || SPECIAL_PAPER.getCode().equals(invoiceType) || ORDINARY_ROLL.getCode().equals(invoiceType) || TOLL_ELECTRON.getCode().equals(invoiceType) || MOTOR_INVOICE.getCode().equals(invoiceType) || USEDCAR_INVOICE.getCode().equals(invoiceType);
    }

    public static Long[] getTaxRecordedTypes() {
        return new Long[]{ORDINARY_ELECTRON.getCode(), SPECIAL_ELECTRON.getCode(), ELECTRIC_ORDINARY.getCode(), ELECTRIC_SPECIAL.getCode(), AIR_ELE_INVOICE.getCode(), TRAIN_ELE_INVOICE.getCode(), ORDINARY_PAPER.getCode(), SPECIAL_PAPER.getCode(), ORDINARY_ROLL.getCode(), TOLL_ELECTRON.getCode(), MOTOR_INVOICE.getCode(), USEDCAR_INVOICE.getCode()};
    }

    public static boolean needReplaceAmountType(Long invoiceType) {
        return ELECTRIC_ORDINARY.getCode().equals(invoiceType) || ELECTRIC_SPECIAL.getCode().equals(invoiceType) || AIR_ELE_INVOICE.getCode().equals(invoiceType) || TRAIN_ELE_INVOICE.getCode().equals(invoiceType);
    }
}

