/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections.CollectionUtils;

public class RecordedConstant {
    private static Log logger = LogFactory.getLog(RecordedConstant.class);
    public static final String NEXT_ENTRY_MARK_STATUS = "nextEntryMarkStatus";
    public static final String TAX_RECORDED_STATUS = "tax_recorded_status";
    public static final String TAX_RECORDED_STATUS_01 = "01";
    public static final String TAX_RECORDED_STATUS_02 = "02";
    public static final String TAX_RECORDED_STATUS_03 = "03";
    public static final String TAX_RECORDED_STATUS_06 = "06";
    public static final String TAX_RECORDED_PURPOSE = "tax_recorded_purpose";
    public static final String TAX_RECORDED_PURPOSE_02 = "02";
    public static final String TAX_RECORDED_PURPOSE_03 = "03";
    public static final String TAX_RECORDED_TIME = "tax_recorded_time";
    public static final String TAX_OPERATE_UPDATE_TYPE = "update_type";
    public static final String UPDATE_TYPE_TIME = "update_time";
    public static final String UPDATE_TYPE_PURPOSE = "update_purpose";
    public static final String UPDATE_TYPE_TIME_PURPOSE = "update_time_purpose";
    public static final String RECORDED_QUERY_FEILDS = "id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,effective_tax_amount,buyer_tax_no,org,invoice_status,saler_name,saler_tax_no,invoice_risk_level,electronic_no,createtime,account_time,tax_recorded_status,tax_recorded_purpose,tax_recorded_time";

    public static Map<String, Map<String, List<JSONObject>>> createRecordedParam(DynamicObjectCollection invoiceCollection, String revokeSatus) {
        if (null != invoiceCollection && invoiceCollection.size() > 0) {
            JSONArray invoice = new JSONArray();
            for (DynamicObject dynamicObject : invoiceCollection) {
                JSONObject recordedParam = RecordedConstant.createRecordedSingle(dynamicObject, revokeSatus);
                if (recordedParam == null) continue;
                invoice.add((Object)recordedParam);
            }
            if (invoice.size() > 0) {
                Map<String, Map<String, List<JSONObject>>> param = invoice.stream().map(t -> (JSONObject)t).filter(t -> t.getString("buyerTaxNo") != null && t.getString("taxRecordedPurpose") != null).collect(Collectors.groupingBy(t -> t.getString("buyerTaxNo"), Collectors.groupingBy(t -> t.getString("taxRecordedPurpose"))));
                return param;
            }
            return null;
        }
        return null;
    }

    public static JSONObject createRecordedSingle(DynamicObject invoice, String revokeSatus) {
        JSONObject param = new JSONObject();
        try {
            param.put("id", invoice.get("id"));
            param.put("serial_no", (Object)invoice.getString("serial_no"));
            param.put("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("org")));
            if (StringUtils.isBlank((CharSequence)invoice.getString("buyer_tax_no"))) {
                logger.info("\u53d1\u7968\u6d41\u6c34\u53f7\uff1a{}, \u8d2d\u65b9\u7a0e\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u6ee1\u8db3\u8c03\u7528rpa\u5165\u8d26\u63d0\u4ea4\u63a5\u53e3", (Object)invoice.getString("serial_no"));
                param.put("buyerTaxNo", (Object)"");
            } else {
                param.put("buyerTaxNo", (Object)invoice.getString("buyer_tax_no"));
            }
            param.put("salerName", (Object)invoice.getString("saler_name"));
            param.put("salerTaxNo", (Object)invoice.getString("saler_tax_no"));
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(invoice.get("invoice_type"));
            param.put("invoice_type", (Object)invoiceType);
            param.put("invoiceType", (Object)Integer.valueOf(InputInvoiceTypeEnum.getAwsType(invoiceType)));
            param.put("invoiceCode", (Object)invoice.getString("invoice_code"));
            param.put("etaxInvoiceNo", (Object)invoice.getString("electronic_no"));
            param.put("invoiceNo", (Object)invoice.getString("invoice_no"));
            param.put("invoice_date", (Object)invoice.getDate("invoice_date"));
            param.put("invoiceDate", (Object)DateUtils.format(invoice.getDate("invoice_date"), "yyyy-MM-dd HH:mm:ss"));
            String invoiceAmount = "0.00";
            String totalTaxAmount = "0.00";
            if (null != invoice.get("invoice_amount") && BigDecimalUtil.ZERO.compareTo(BigDecimalUtil.transDecimal(invoice.get("invoice_amount"))) != 0) {
                invoiceAmount = String.valueOf(BigDecimalUtil.transDecimal(invoice.get("invoice_amount")).setScale(2, RoundingMode.HALF_UP));
            }
            if (null != invoice.get("total_tax_amount") && BigDecimalUtil.ZERO.compareTo(BigDecimalUtil.transDecimal(invoice.get("total_tax_amount"))) != 0) {
                totalTaxAmount = String.valueOf(BigDecimalUtil.transDecimal(invoice.get("total_tax_amount")).setScale(2, RoundingMode.HALF_UP));
            }
            param.put("invoiceAmount", (Object)invoiceAmount);
            param.put("totalTaxAmount", (Object)totalTaxAmount);
            param.put("invoiceStatus", (Object)Integer.valueOf(invoice.getString("invoice_status")));
            param.put("invoiceRiskLevel", (Object)RecordedConstant.convertInvoiceRiskLevel(invoice.getString("invoice_risk_level")));
            param.put(TAX_RECORDED_TIME, (Object)invoice.getDate(TAX_RECORDED_TIME));
            param.put("entryMarkDate", (Object)DateUtils.format(invoice.getDate(TAX_RECORDED_TIME), "yyyy-MM-dd"));
            if (StringUtils.isNotBlank((CharSequence)revokeSatus)) {
                DynamicObject invoiceDynamicObject;
                param.put("entryMarkStatus", (Object)invoice.getString(TAX_RECORDED_STATUS));
                String serialNo = invoice.getString("serial_no");
                String entityId = InputInvoiceTypeEnum.getEntity(invoiceType);
                QFilter serialNOFilter = new QFilter("serial_no", "=", (Object)serialNo);
                DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{serialNOFilter});
                if (idObject != null && (invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId)) != null) {
                    param.put("mxuuid", (Object)invoiceDynamicObject.getString("recorded_mxuuid"));
                    param.put("rzuuid", (Object)invoiceDynamicObject.getString("recorded_rzuuid"));
                }
            }
            String taxRecordedPurpose = invoice.getString(TAX_RECORDED_PURPOSE);
            if (StringUtils.isBlank((CharSequence)invoice.getString(TAX_RECORDED_PURPOSE))) {
                logger.info("\u53d1\u7968\u6d41\u6c34\u53f7\uff1a{},\u5165\u8d26\u7528\u9014\u4e3a\u7a7a\uff0c\u4e0d\u6ee1\u8db3\u8c03\u7528rpa\u5165\u8d26\u63d0\u4ea4\u63a5\u53e3", (Object)invoice.getString("serial_no"));
                taxRecordedPurpose = "";
            }
            param.put("taxRecordedPurpose", (Object)(StringUtils.isNotBlank((CharSequence)revokeSatus) ? revokeSatus : taxRecordedPurpose));
        }
        catch (NumberFormatException e) {
            logger.error("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return param;
    }

    public static String convertInvoiceRiskLevel(String invoiceRiskLevel) {
        if (StringUtils.isBlank((CharSequence)invoiceRiskLevel)) {
            return "\u6b63\u5e38";
        }
        switch (invoiceRiskLevel) {
            case "1": {
                return "\u6b63\u5e38";
            }
            case "2": {
                return "\u7591\u70b9\u53d1\u7968";
            }
            case "3": {
                return "\u5f02\u5e38\u51ed\u8bc1";
            }
        }
        return "\u6b63\u5e38";
    }

    public static String checkDataBeforeInvoke(DynamicObjectCollection entryEntity) {
        StringBuilder message = new StringBuilder();
        AwsFpyService service = AwsFpyService.newInstance();
        for (DynamicObject dynamicObject : entryEntity) {
            if (!StringUtils.isBlank((CharSequence)dynamicObject.getString("buyer_tax_no"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecordedConstant_0", (String)"imc-rim-common", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup(dynamicObject.getString("invoice_code"), dynamicObject.getString("invoice_no")));
            message.append(msg);
            message.append(ViewUtil.LINE_SEPARATOR);
        }
        return message.toString();
    }

    public static void batchUpateInvoiceMain(List<Object> ids, String taxRecordedPurpose, Date taxRecordedTime, String taxRecordedStatus) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            return;
        }
        HashMap invoiceDynamicObjectMap = new HashMap(8);
        for (DynamicObject dynamicObject : dynamicObjects) {
            ArrayList<DynamicObject> dynamicObjects1;
            QFilter serialNOFilter;
            String serialNo;
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type"));
            if (invoiceType == null || invoiceType <= 0L || StringUtils.isBlank((CharSequence)(serialNo = dynamicObject.getString("serial_no")))) continue;
            String entityId = InputInvoiceTypeEnum.getEntity(invoiceType);
            DynamicObject idObject = QueryServiceHelper.queryOne((String)entityId, (String)"id", (QFilter[])new QFilter[]{serialNOFilter = new QFilter("serial_no", "=", (Object)serialNo)});
            if (idObject == null) continue;
            DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)entityId);
            if (StringUtils.isNotBlank((CharSequence)taxRecordedPurpose)) {
                dynamicObject.set(TAX_RECORDED_PURPOSE, (Object)taxRecordedPurpose);
                invoiceDynamicObject.set(TAX_RECORDED_PURPOSE, (Object)taxRecordedPurpose);
            }
            if (null != taxRecordedTime) {
                dynamicObject.set(TAX_RECORDED_TIME, (Object)taxRecordedTime);
                invoiceDynamicObject.set(TAX_RECORDED_TIME, (Object)taxRecordedTime);
            }
            if (StringUtils.isNotBlank((CharSequence)taxRecordedStatus)) {
                dynamicObject.set(TAX_RECORDED_STATUS, (Object)taxRecordedStatus);
                invoiceDynamicObject.set(TAX_RECORDED_STATUS, (Object)taxRecordedStatus);
            }
            if (invoiceDynamicObjectMap.containsKey(invoiceType)) {
                dynamicObjects1 = (ArrayList<DynamicObject>)invoiceDynamicObjectMap.get(invoiceType);
                dynamicObjects1.add(invoiceDynamicObject);
                continue;
            }
            dynamicObjects1 = new ArrayList<DynamicObject>(1);
            dynamicObjects1.add(invoiceDynamicObject);
            invoiceDynamicObjectMap.put(invoiceType, dynamicObjects1);
        }
        for (List dynamicObjectList : invoiceDynamicObjectMap.values()) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }
}

