/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.expense.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.service.InvoiceSaveEkService;
import kd.imc.rim.common.expense.domain.ExpenseAttachDTO;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.InvoiceImageNotifyService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.file.utils.FileConvertUtils;

public class ExpenseService {
    private static Log LOGGER = LogFactory.getLog(ExpenseService.class);
    private static final String CACHE_INVOICE_ATTACH = "CACHE_INVOICE_ATTACH";

    public void save(ExpenseDTO param) {
        JSONObject verifyConfig;
        List<ExpenseInvoiceDTO> invoiceList;
        if (param.getResource() == null) {
            param.setResource(" ");
        }
        if (CollectionUtils.isEmpty(invoiceList = param.getInvoiceList())) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.saveAttachmentRelation(param);
                    this.saveCoverRelation(param);
                    this.newExpense(param, null);
                    List<String> delteSerialList = this.deleteExpense(param, false);
                    List<String> origSerialList = this.updateInvoiceByOriginalId(param, null);
                    if (delteSerialList != null && !delteSerialList.isEmpty()) {
                        origSerialList.addAll(delteSerialList);
                    }
                    if (!CollectionUtils.isEmpty(origSerialList)) {
                        this.updateInvoiceMain(origSerialList, null);
                    }
                    this.saveCallBack("save", param, null, delteSerialList);
                    InvoiceImageNotifyService.imageNotify(param);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            return;
        }
        ArrayList<String> serialList = new ArrayList<String>(invoiceList.size());
        HashMap<String, ExpenseInvoiceDTO> invoiceDtoMap = new HashMap<String, ExpenseInvoiceDTO>(invoiceList.size());
        HashMap<String, Boolean> serialRepeatMap = new HashMap<String, Boolean>(invoiceList.size());
        for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
            serialList.add(invoiceDto.getSerialNo());
            invoiceDtoMap.put(invoiceDto.getSerialNo(), invoiceDto);
            serialRepeatMap.put(invoiceDto.getSerialNo(), invoiceDto.isAllowRepeat());
        }
        HashMap<String, Object> verifyParam = new HashMap<String, Object>(4);
        verifyParam.put("orgId", param.getOrgId());
        verifyParam.put("billType", param.getExpenseType());
        Boolean allowRepeat = Boolean.FALSE;
        allowRepeat = param.isAllowRepeat() ? Boolean.TRUE : Boolean.valueOf(!"0".equals((verifyConfig = VerifyService.getVerfifyConfig(verifyParam)).getString("repeat_expense")));
        List<String> deleteSerialList = null;
        List<String> origSerialList = null;
        ArrayList<String> deleteExpenseId = new ArrayList<String>(8);
        try (TXHandle h = TX.requiresNew();){
            try {
                origSerialList = this.updateInvoiceByOriginalId(param, serialList);
                QFilter filter = new QFilter("serial_no", "in", serialList);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,entityid,serial_no", (QFilter[])new QFilter[]{filter});
                if (CollectionUtils.isEmpty((Collection)collection)) {
                    deleteSerialList = this.deleteExpense(param, false);
                    this.newExpense(param, serialList);
                } else if ("1".equals(param.getStatus())) {
                    deleteSerialList = this.deleteExpense(param, false);
                    this.newExpense(param, serialList);
                } else {
                    HashSet<String> doubleSet = new HashSet<String>();
                    this.loadBillLinkDownNodes(param);
                    HashSet<String> idEqualSerialSet = new HashSet<String>(8);
                    for (DynamicObject obj : collection) {
                        Boolean isAllowRepeat;
                        String status = obj.getString("status");
                        String serialNo = obj.getString("serial_no");
                        boolean idEqual = this.isEqual(param.getEntityId(), param.getExpenseId(), param.getResource(), obj.getString("entityid"), obj.getString("expense_id"), obj.getString("resource"));
                        if (idEqual) {
                            idEqualSerialSet.add(serialNo);
                        }
                        if (idEqual && "aws".equals(obj.getString("resource"))) {
                            deleteExpenseId.add(obj.getString("expense_id"));
                        }
                        if (idEqual || !StringUtils.isNotEmpty((CharSequence)status) || "1".equals(obj.getString("status")) || (isAllowRepeat = (Boolean)serialRepeatMap.get(serialNo)) != null && isAllowRepeat.booleanValue()) continue;
                        doubleSet.add(serialNo);
                    }
                    if (!idEqualSerialSet.isEmpty()) {
                        doubleSet.removeAll(idEqualSerialSet);
                    }
                    if (!allowRepeat.booleanValue()) {
                        if (invoiceList.size() == doubleSet.size()) {
                            throw new MsgException(ErrorType.ALL_REPEAT.getCode(), ErrorType.ALL_REPEAT.getName());
                        }
                        if (doubleSet.size() > 0) {
                            QFilter doubleFilter = new QFilter("serial_no", "in", doubleSet);
                            DynamicObjectCollection doubleCollect = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_type, invoice_code, invoice_no", (QFilter[])new QFilter[]{doubleFilter});
                            String partRepeatStr = String.format(ResManager.loadKDString((String)"\u53d1\u7968[%s]\u91cd\u590d\u62a5\u9500", (String)"ExpenseService_2", (String)"imc-rim-common", (Object[])new Object[0]), this.getDoubleInvoiceStr(doubleCollect));
                            throw new MsgException(ErrorType.PART_REPEAT.getCode(), partRepeatStr);
                        }
                    }
                    deleteSerialList = this.deleteExpense(param, false);
                    this.newExpense(param, serialList);
                }
                if (!deleteExpenseId.isEmpty()) {
                    QFilter expenseIdfilter = new QFilter("expense_id", "in", deleteExpenseId);
                    QFilter resourcefilter = new QFilter("resource", "=", (Object)"aws");
                    DeleteServiceHelper.delete((String)"rim_expense_relation", (QFilter[])new QFilter[]{expenseIdfilter, resourcefilter});
                }
                this.saveCoverRelation(param);
                this.saveAttachmentRelation(param);
                ArrayList<String> addSerialList = new ArrayList<String>(serialList);
                ArrayList<String> delSerialList = null;
                if (!CollectionUtils.isEmpty(deleteSerialList)) {
                    delSerialList = new ArrayList<String>(deleteSerialList);
                    delSerialList.removeAll(serialList);
                    serialList.addAll(deleteSerialList);
                }
                if (!origSerialList.isEmpty()) {
                    serialList.addAll(origSerialList);
                }
                this.updateInvoiceMain(serialList, invoiceDtoMap);
                if (deleteSerialList != null) {
                    deleteSerialList.removeAll(serialList);
                    this.deleteInvoiceAttach(deleteSerialList, param.getExpenseId());
                }
                this.saveCallBack("save", param, addSerialList, delSerialList);
                this.updateInvoiceOrg(param);
                InvoiceImageNotifyService.imageNotify(param);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private String getDoubleInvoiceStr(DynamicObjectCollection doubleCollect) {
        if (doubleCollect.size() > 0) {
            StringBuilder doubleInvoiceStr = new StringBuilder();
            for (DynamicObject obj : doubleCollect) {
                if (InputInvoiceTypeEnum.isEleInvoice(DynamicObjectUtil.getDynamicObjectLongValue(obj.get("invoice_type"))).booleanValue()) {
                    doubleInvoiceStr.append(obj.getString("invoice_no")).append(",");
                    continue;
                }
                doubleInvoiceStr.append(obj.getString("invoice_code")).append("-").append(obj.getString("invoice_no")).append(",");
            }
            return doubleInvoiceStr.substring(0, doubleInvoiceStr.length() - 1);
        }
        return "";
    }

    private boolean isEqual(String entityId1, String expenseId1, String resource1, String entityId2, String expenseId2, String resource2) {
        entityId1 = StringUtils.trimToEmpty((String)entityId1);
        expenseId1 = StringUtils.trimToEmpty((String)expenseId1);
        resource1 = StringUtils.trimToEmpty((String)resource1);
        entityId2 = StringUtils.trimToEmpty((String)entityId2);
        expenseId2 = StringUtils.trimToEmpty((String)expenseId2);
        if ("aws".equals(resource2 = StringUtils.trimToEmpty((String)resource2)) && !StringUtils.isEmpty((CharSequence)entityId2)) {
            resource2 = "4";
        }
        if (expenseId1.equals(expenseId2)) {
            if (resource1.equals(resource2)) {
                return true;
            }
            if (!StringUtils.isEmpty((CharSequence)entityId1) && !StringUtils.isEmpty((CharSequence)entityId2)) {
                return entityId1.equals(entityId2);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)entityId1) && !expenseId1.startsWith(entityId1)) {
            expenseId1 = entityId1 + '_' + expenseId1;
        }
        if (!StringUtils.isEmpty((CharSequence)entityId2) && !expenseId1.startsWith(entityId2)) {
            expenseId2 = entityId2 + '_' + expenseId2;
        }
        return expenseId1.equals(expenseId2);
    }

    private List<String> updateInvoiceByOriginalId(ExpenseDTO param, List<String> serialList) {
        ArrayList<String> updateSerialList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)param.getOriginalId())) {
            MainEntityType mainEntityType;
            QFilter expenseIdfilter = new QFilter("expense_id", "=", (Object)param.getOriginalId());
            QFilter entityfilter = null;
            if (StringUtils.isNotEmpty((CharSequence)param.getOriginalType())) {
                entityfilter = new QFilter("entityid", "=", (Object)param.getOriginalType());
            }
            if (entityfilter == null && StringUtils.isNotEmpty((CharSequence)param.getEntityId())) {
                entityfilter = new QFilter("entityid", "=", (Object)param.getEntityId());
            }
            QFilter resourcefilter = null;
            if (entityfilter == null && StringUtils.isNotEmpty((CharSequence)param.getResource())) {
                resourcefilter = new QFilter("resource", "=", (Object)param.getResource());
            }
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,serial_no", (QFilter[])new QFilter[]{expenseIdfilter, entityfilter, resourcefilter});
            ArrayList<Long> updateList = new ArrayList<Long>(16);
            ArrayList<Long> deleteList = new ArrayList<Long>(16);
            for (DynamicObject object : collect) {
                if (serialList == null || serialList.isEmpty()) {
                    updateList.add(object.getLong("id"));
                } else {
                    deleteList.add(object.getLong("id"));
                }
                updateSerialList.add(object.getString("serial_no"));
            }
            if (!deleteList.isEmpty()) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_expense_relation");
                DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])deleteList.toArray());
            }
            if (!updateList.isEmpty()) {
                DynamicObject[] objects;
                mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_expense_relation");
                for (DynamicObject obj : objects = BusinessDataServiceHelper.load((Object[])updateList.toArray(), (DynamicObjectType)mainEntityType)) {
                    obj.set("expense_num", (Object)param.getExpenseNum());
                    obj.set("expense_id", (Object)param.getExpenseId());
                    obj.set("entityid", (Object)param.getEntityId());
                    obj.set("view_page", (Object)param.getViewPage());
                    obj.set("expense_type", (Object)param.getExpenseType());
                    obj.set("status", (Object)param.getStatus());
                    obj.set("resource", (Object)param.getResource());
                }
                SaveServiceHelper.save((DynamicObject[])objects);
            }
        }
        return updateSerialList;
    }

    public void saveCoverAndAttachmentRelation(ExpenseDTO param) {
        if (param.getResource() == null) {
            param.setResource(" ");
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                this.saveAttachmentRelation(param);
                this.saveCoverRelation(param);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void saveCallBack(String operate, ExpenseDTO param, List<String> addSerialList, List<String> delSerialList) {
        InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
        HashMap<String, Object> expenseInfo = new HashMap<String, Object>(8);
        expenseInfo.put("billId", param.getExpenseId());
        expenseInfo.put("billNo", param.getExpenseNum());
        expenseInfo.put("entityId", param.getEntityId());
        expenseInfo.put("resource", param.getResource());
        expenseInfo.put("status", param.getStatus());
        if ("delete".equals(operate)) {
            ekService.afterDelExpense(expenseInfo, delSerialList);
        } else {
            ekService.afterSaveExpense(expenseInfo, addSerialList, delSerialList);
        }
    }

    public void saveInvoiceAndExpenseOfAPI(List<ExpenseDTO> expenseList, String invoiceSerialNo) {
        ArrayList serialList = Lists.newArrayList((Object[])new String[]{invoiceSerialNo});
        QFilter filter = new QFilter("serial_no", "in", (Object)serialList);
        filter.and(new QFilter("resource", "in", (Object)"api"));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,serial_no", (QFilter[])new QFilter[]{filter});
        try (TXHandle h = TX.requiresNew();){
            try {
                if (collection != null && !collection.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"), (Object[])collection.stream().map(v -> v.get("id")).toArray());
                }
                for (ExpenseDTO param : expenseList) {
                    this.deleteInvoiceReimEntry(serialList, param);
                    this.newExpense(param, serialList);
                }
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                invoiceDto.setSerialNo(invoiceSerialNo);
                HashMap invoiceDtoMap = Maps.newHashMapWithExpectedSize((int)1);
                invoiceDtoMap.put(invoiceSerialNo, invoiceDto);
                this.updateInvoiceMain(serialList, invoiceDtoMap);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void deleteInvoiceAttach(List<String> deletedSerials, String expenseId) {
        if (CollectionUtils.isEmpty(deletedSerials) || StringUtils.isEmpty((CharSequence)expenseId)) {
            return;
        }
        ArrayList<String> notNullList = new ArrayList<String>(deletedSerials.size());
        for (String serialNo : deletedSerials) {
            if (StringUtils.isEmpty((CharSequence)serialNo)) continue;
            notNullList.add(serialNo);
        }
        QFilter filter = new QFilter("relation_id", "in", notNullList).and("expense_id", "=", (Object)expenseId);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])filter.toArray());
    }

    public void updateInvoiceOrg(ExpenseDTO param) {
        DynamicObject[] mainInvoiceArr;
        String saveUpdateOrg = ImcConfigUtil.getValue("rim_config", "save_update_org");
        if (!param.isUpdateInvoiceOrg() && !"1".equals(saveUpdateOrg)) {
            return;
        }
        List<ExpenseInvoiceDTO> invoiceList = param.getInvoiceList();
        if (invoiceList.isEmpty()) {
            return;
        }
        Long orgId = param.getOrgId();
        if (orgId == null || orgId <= 0L) {
            return;
        }
        List<String> serialList = invoiceList.stream().map(ExpenseInvoiceDTO::getSerialNo).collect(Collectors.toList());
        for (DynamicObject mainInvoice : mainInvoiceArr = InvoiceQueryService.queryInvoiceHead("rim_invoice", TenantUtils.getTenantNo(), serialList)) {
            mainInvoice.set("org_id", (Object)orgId);
        }
        SaveServiceHelper.save((DynamicObject[])mainInvoiceArr);
    }

    public void updateInvoiceMain(List<String> serialList, Map<String, ExpenseInvoiceDTO> invoiceDtoMap) {
        this.updateInvoiceMain(serialList, invoiceDtoMap, "");
    }

    public void updateInvoiceMain(List<String> serialList, Map<String, ExpenseInvoiceDTO> invoiceDtoMap, String from) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter serialFilter = new QFilter("serial_no", "in", serialList);
        DynamicObjectCollection relationList = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,serial_no,status,expense_num,preset_deduction_purpose,create_time,deduction_flag,deduction_amount,output_reason,output_amount,effective_tax_amount, not_deductible_type", (QFilter[])new QFilter[]{serialFilter}, (String)"status desc,create_time");
        HashMap<String, Map<String, Object>> statusMap = new HashMap<String, Map<String, Object>>(serialList.size());
        VoucherService voucherService = new VoucherService();
        DynamicObjectCollection vouchCollection = voucherService.queryVouchRelationBySerialNos(serialList);
        if (!CollectionUtils.isEmpty((Collection)vouchCollection)) {
            for (Iterator obj : vouchCollection) {
                String billid = obj.getString("billid");
                HashMap<String, Object> statusValueMap = (HashMap<String, Object>)statusMap.get(billid);
                if (statusValueMap == null) {
                    statusValueMap = new HashMap<String, Object>(8);
                    statusValueMap.put("deduction_amount", BigDecimal.ZERO);
                    statusValueMap.put("output_amount", BigDecimal.ZERO);
                    statusValueMap.put("output_reason", "");
                }
                String vouch_no = obj.getString("vouch_no");
                HashSet<String> set = (HashSet<String>)statusValueMap.get("vouchNo");
                if (set == null) {
                    set = new HashSet<String>(4);
                }
                set.add(vouch_no);
                statusValueMap.put("vouchNo", set);
                Date accountDate1 = (Date)statusValueMap.get("accountDate");
                Date accountDate2 = obj.getDate("account_date");
                if (accountDate1 == null || accountDate2 != null && accountDate2.compareTo(accountDate1) > 0) {
                    statusValueMap.put("accountDate", accountDate2);
                    statusValueMap.put("accountTime", obj.getDate("account_time"));
                }
                statusValueMap.put("status", 65);
                statusMap.put(billid, statusValueMap);
            }
        }
        HashMap<String, Set<String>> expenNoMap = new HashMap<String, Set<String>>(serialList.size());
        for (DynamicObject obj : relationList) {
            Date time;
            Date createDate;
            String notDeductibleType;
            String preset_deduction_purpose;
            String expense_num;
            HashSet<String> set;
            Integer status2;
            Integer status = this.getStausInteger(obj.getString("status"));
            String serailNo = obj.getString("serial_no");
            HashMap<String, Object> statusValueMap = (HashMap<String, Object>)statusMap.get(serailNo);
            if (statusValueMap == null) {
                statusValueMap = new HashMap<String, Object>(8);
                statusValueMap.put("deduction_amount", BigDecimal.ZERO);
                statusValueMap.put("output_amount", BigDecimal.ZERO);
                statusValueMap.put("output_reason", "");
            }
            if ((status2 = (Integer)statusValueMap.get("status")) == null || status > status2) {
                statusValueMap.put("status", status);
            }
            if ((set = (HashSet<String>)expenNoMap.get(serailNo)) == null) {
                set = new HashSet<String>();
            }
            if (StringUtils.isNotEmpty((CharSequence)(expense_num = obj.getString("expense_num")))) {
                set.add(obj.getString("expense_num"));
            }
            expenNoMap.put(serailNo, set);
            String deductionFlag = obj.getString("deduction_flag");
            BigDecimal deductionAmount = obj.getBigDecimal("deduction_amount");
            BigDecimal effectiveTaxAmount = obj.getBigDecimal("effective_tax_amount");
            String outputReason = obj.getString("output_reason");
            BigDecimal outputAmount = obj.getBigDecimal("output_amount");
            if (StringUtils.isNotEmpty((CharSequence)deductionFlag)) {
                String flag = (String)statusValueMap.get("deduction_flag");
                if (StringUtils.isEmpty((CharSequence)flag)) {
                    statusValueMap.put("deduction_flag", deductionFlag);
                } else if (!"0".equals(flag)) {
                    statusValueMap.put("deduction_flag", deductionFlag);
                }
            }
            if (deductionAmount != null && deductionAmount.compareTo(BigDecimal.ZERO) > 0) {
                statusValueMap.put("deduction_amount", deductionAmount);
            }
            if (effectiveTaxAmount != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                statusValueMap.put("effective_tax_amount", effectiveTaxAmount);
            }
            if (!StringUtils.isEmpty((CharSequence)(preset_deduction_purpose = obj.getString("preset_deduction_purpose")))) {
                statusValueMap.put("preset_deduction_purpose", preset_deduction_purpose);
            }
            if (StringUtils.isNotBlank((CharSequence)(notDeductibleType = obj.getString("not_deductible_type")))) {
                statusValueMap.put("not_deductible_type", notDeductibleType);
            }
            if (outputAmount != null && outputAmount.compareTo(BigDecimal.ZERO) > 0) {
                statusValueMap.put("output_amount", outputAmount);
                statusValueMap.put("output_reason", outputReason);
            }
            if (null != (createDate = obj.getDate("create_time")) && ((time = (Date)statusValueMap.get("create_time")) == null || createDate.compareTo(time) > 0)) {
                statusValueMap.put("create_time", createDate);
            }
            statusMap.put(serailNo, statusValueMap);
        }
        if (!CollectionUtils.isEmpty(serialList)) {
            long start = System.currentTimeMillis();
            this.updateMainExpense(invoiceDtoMap, statusMap, expenNoMap, serialList, from);
            LOGGER.info("\u66f4\u65b0\u62a5\u9500\u72b6\u6001\u8017\u65f6:{},{}", (Object)(System.currentTimeMillis() - start), (Object)serialList.size());
        }
        DynamicObjectCollection uncheckList = QueryServiceHelper.query((String)"rim_invoice_uncheck", (String)"id,serial_no,expense_status,expense_num", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        ArrayList<Object> uncheckPkList = new ArrayList<Object>(uncheckList.size());
        for (DynamicObject obj : uncheckList) {
            uncheckPkList.add(obj.get("id"));
        }
        if (!CollectionUtils.isEmpty(uncheckPkList)) {
            this.updateUncheckExpense(invoiceDtoMap, statusMap, expenNoMap, uncheckPkList);
        }
    }

    private void updateUncheckExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Map<String, Object>> statusMap, Map<String, Set<String>> expenNoMap, List<Object> pkList) {
        DynamicObject[] mainDynamicObjectsTemp;
        for (DynamicObject obj : mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"))) {
            ExpenseInvoiceDTO dto;
            Set<String> set;
            String serailNo = obj.getString("serial_no");
            String expense_status = obj.getString("expense_status");
            if (!"65".equals(expense_status)) {
                Integer status2 = (Integer)((Map)statusMap.getOrDefault(serailNo, new HashMap(1))).get("status");
                if (status2 != null) {
                    obj.set("expense_status", (Object)status2.toString());
                } else {
                    obj.set("expense_status", (Object)"1");
                }
            }
            if ((set = expenNoMap.get(serailNo)) == null || set.isEmpty()) {
                obj.set("expense_num", (Object)"");
            } else {
                String num = String.join((CharSequence)",", set);
                if (num.length() > 450) {
                    obj.set("expense_num", (Object)num.substring(0, 450));
                } else {
                    obj.set("expense_num", (Object)String.join((CharSequence)",", set));
                }
            }
            if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null && dto.getOrgId() != null && dto.getOrgId() > 0L) {
                obj.set("org", (Object)dto.getOrgId());
            }
            obj.set("expense_time", (Object)new Date());
            obj.set("update_time", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])mainDynamicObjectsTemp);
    }

    private void updateMainExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Map<String, Object>> statusMap, Map<String, Set<String>> expenNoMap, List<String> serialList) {
        this.updateMainExpense(invoiceDtoMap, statusMap, expenNoMap, serialList, "");
    }

    /*
     * WARNING - void declaration
     */
    private void updateMainExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Map<String, Object>> statusMap, Map<String, Set<String>> expenNoMap, List<String> serialList, String from) {
        void var15_17;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        Map fields = mainEntityType.getFields();
        DynamicObject[] mainDynamicObjectsTemp = InvoiceQueryService.queryInvoiceHead("rim_invoice", TenantUtils.getTenantNo(), serialList);
        Boolean deleteUnused = "1".equals(RimConfigUtils.getConfig("delete_unused"));
        InvoiceSaveService service = new InvoiceSaveService();
        HashMap<String, ArrayList<Object>> typeMap = new HashMap<String, ArrayList<Object>>(8);
        HashSet<String> loadDetailSet = new HashSet<String>(4);
        DynamicObject[] dynamicObjectArray = mainDynamicObjectsTemp;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var15_17 < n) {
            ArrayList<DynamicObject[]> invoiceList;
            String extInfo;
            DynamicObject obj = dynamicObjectArray[var15_17];
            DynamicObject[] serailNo = obj.getString("serial_no");
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("invoice_type"));
            String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
            if (InputInvoiceTypeEnum.canTransportDeduction(invoiceType).booleanValue() && ((extInfo = obj.getString("ext_info")) == null || extInfo.indexOf(InvoiceSaveConstant.EXT_DEDUCTION_FLAG) < 0)) {
                loadDetailSet.add(entity);
            }
            if ((invoiceList = (ArrayList<DynamicObject[]>)typeMap.get(entity)) == null) {
                invoiceList = new ArrayList<DynamicObject[]>(4);
            }
            invoiceList.add(serailNo);
            typeMap.put(entity, invoiceList);
            ++var15_17;
        }
        HashMap<String, DynamicObject> detailMap = new HashMap<String, DynamicObject>(serialList.size());
        for (Map.Entry entry : typeMap.entrySet()) {
            DynamicObject[] invoiceBodys = null;
            invoiceBodys = loadDetailSet.contains(entry.getKey()) ? InvoiceQueryService.loadBySerialNo((String)entry.getKey(), " ", (List)entry.getValue()) : InvoiceQueryService.queryInvoiceHead((String)entry.getKey(), " ", (List)entry.getValue());
            for (DynamicObject obj : invoiceBodys) {
                detailMap.put(obj.getString("serial_no"), obj);
            }
        }
        for (DynamicObject obj : mainDynamicObjectsTemp) {
            String entity;
            ArrayList<String> invoiceList;
            ExpenseInvoiceDTO dto;
            String delete;
            Integer expenseStatus;
            String serailNo = obj.getString("serial_no");
            String original_state = obj.getString("original_state");
            Map<String, Object> statusValueMap = statusMap.get(serailNo);
            if (statusValueMap == null) {
                statusValueMap = new HashMap<String, Object>(4);
            }
            if ((expenseStatus = (Integer)statusValueMap.get("status")) == null) {
                expenseStatus = 1;
                statusValueMap.put("status", expenseStatus);
            }
            obj.set("expense_status", (Object)expenseStatus.toString());
            if (expenseStatus < 65) {
                obj.set("vouch_no", (Object)"");
                obj.set("account_time", null);
                obj.set("account_date", null);
            } else {
                Set vouchNoSet = (Set)statusValueMap.get("vouchNo");
                obj.set("vouch_no", (Object)this.getString(vouchNoSet));
                obj.set("account_time", statusValueMap.get("accountTime"));
                obj.set("account_date", statusValueMap.get("accountDate"));
            }
            String deductionFlag = (String)statusValueMap.get("deduction_flag");
            String fpyDeductionFlag = DeductionConstant.getDeductionFlag(obj, (DynamicObject)detailMap.get(serailNo));
            BigDecimal deductionAmount = (BigDecimal)statusValueMap.get("deduction_amount");
            BigDecimal outputAmount = (BigDecimal)statusValueMap.get("output_amount");
            BigDecimal effectiveTaxAmount = (BigDecimal)statusValueMap.get("effective_tax_amount");
            LOGGER.info("\u4fee\u6539\u53d1\u7968\u4e3b\u8868\uff0c\u53d1\u7968\u6d41\u6c34\u53f7: {}, \u5355\u636e\u4f20\u8fc7\u6765\u7684\u62b5\u6263\u6807\u8bc6deductionFlag\uff1a{}, fpy\u8ba1\u7b97\u7684\u62b5\u6263\u6807\u8bc6\uff1a{}", new Object[]{serailNo, deductionFlag, fpyDeductionFlag});
            if ("1".equals(fpyDeductionFlag) && StringUtils.isNotEmpty((CharSequence)deductionFlag)) {
                obj.set("deduction_flag", (Object)deductionFlag);
                InvoiceSaveService.setExtInfo(obj, InvoiceSaveConstant.EXT_BILL_DEDUCTION_FLAG, deductionFlag);
            } else {
                obj.set("deduction_flag", (Object)fpyDeductionFlag);
            }
            if (deductionAmount != null) {
                obj.set("entry_amount", (Object)deductionAmount);
            }
            if (outputAmount != null && "1".equals(fpyDeductionFlag) && outputAmount.compareTo(BigDecimal.ZERO) > 0) {
                obj.set("output_amount", (Object)outputAmount);
                obj.set("output_reason", statusValueMap.get("output_reason"));
            } else {
                obj.set("output_amount", (Object)BigDecimal.ZERO);
                obj.set("output_reason", (Object)"");
            }
            Date create_time = (Date)statusValueMap.get("create_time");
            obj.set("expense_time", (Object)create_time);
            Set<String> set = expenNoMap.get(serailNo);
            String string = delete = InvoiceSaveConstant.INVOICE_SAVE_FROM_VALUE.equals(from) ? obj.getString("delete") : "1";
            if (set == null || set.isEmpty()) {
                obj.set("expense_num", (Object)"");
                if (deleteUnused.booleanValue() && expenseStatus <= 1 && StringUtils.isEmpty((CharSequence)obj.getString("resource"))) {
                    delete = "3";
                }
            } else {
                obj.set("expense_num", (Object)this.getString(set));
            }
            obj.set("delete", (Object)delete);
            statusValueMap.put("delete", delete);
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("invoice_type"));
            if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null) {
                if (!"1".equals(original_state) && "1".equals(dto.getOriginalState())) {
                    obj.set("original_state", (Object)"1");
                    obj.set("original_time", (Object)new Date());
                }
                if (StringUtils.isNotEmpty((CharSequence)dto.getInvoiceResource())) {
                    InvoiceSaveService.setExtInfo(obj, InvoiceSaveConstant.EXT_INVOICE_RESOURCE, dto.getInvoiceResource());
                }
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("org"));
                if (dto.getOrgId() != null && dto.getOrgId() > 0L && !dto.getOrgId().equals(orgId)) {
                    obj.set("org", (Object)dto.getOrgId());
                    statusValueMap.put("org", dto.getOrgId());
                    if (!InputInvoiceTypeEnum.needCheck(invoiceType).booleanValue()) {
                        Long taxOrg = TenantUtils.getTaxOrgId(dto.getOrgId());
                        statusValueMap.put("tax_org", taxOrg);
                        obj.set("tax_org", (Object)taxOrg);
                    }
                }
                JSONObject extInfo = dto.getExtInfo();
                this.setExtInfo(fields, obj, extInfo);
            }
            if ((invoiceList = (ArrayList<String>)typeMap.get(entity = InputInvoiceTypeEnum.getEntity(invoiceType))) == null) {
                invoiceList = new ArrayList<String>(4);
            }
            invoiceList.add(serailNo);
            typeMap.put(entity, invoiceList);
            if ("1".equals(fpyDeductionFlag)) {
                String authenticate_flag = obj.getString("authenticate_flag");
                String preset_deduction_purpose = (String)statusValueMap.get("preset_deduction_purpose");
                if (preset_deduction_purpose == null) {
                    preset_deduction_purpose = "";
                }
                boolean isTransportTypes = Arrays.asList(InputInvoiceTypeEnum.getTransportTypes()).contains(invoiceType);
                String transportDeduction = obj.getString("transport_deduction");
                if (isTransportTypes && "0".equals(transportDeduction)) {
                    if (effectiveTaxAmount != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0 && isTransportTypes) {
                        obj.set("effective_tax_amount", (Object)effectiveTaxAmount);
                    }
                } else if ("0".equals(authenticate_flag)) {
                    obj.set("deduction_purpose", (Object)preset_deduction_purpose);
                    if (effectiveTaxAmount != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0 && isTransportTypes) {
                        obj.set("effective_tax_amount", (Object)effectiveTaxAmount);
                    }
                    if ("2".equals(preset_deduction_purpose) && statusValueMap.containsKey("not_deductible_type")) {
                        obj.set("not_deductible_type", (Object)((String)statusValueMap.get("not_deductible_type")));
                    }
                }
                obj.set("preset_deduction_purpose", (Object)preset_deduction_purpose);
            }
            statusMap.put(serailNo, statusValueMap);
            obj.set("modifytime", (Object)new Date());
            service.setMainInvoiceInfo(obj);
        }
        for (Map.Entry entry : typeMap.entrySet()) {
            List bodySerials = (List)entry.getValue();
            ArrayList<DynamicObject> invoiceBodys = new ArrayList<DynamicObject>(bodySerials.size());
            boolean i = false;
            HashMap<String, IDataEntityProperty> bodyFields = null;
            for (String serailNo : bodySerials) {
                ExpenseInvoiceDTO dto;
                Object taxOrg;
                Map<String, Object> statusValueMap;
                Object org;
                DynamicObject body = (DynamicObject)detailMap.get(serailNo);
                if (body == null) continue;
                if (bodyFields == null) {
                    bodyFields = new HashMap<String, IDataEntityProperty>(16);
                    DataEntityPropertyCollection mainPros = body.getDataEntityType().getProperties();
                    for (IDataEntityProperty property : mainPros) {
                        bodyFields.put(property.getName(), property);
                    }
                }
                if ((org = (statusValueMap = statusMap.get(serailNo)).get("org")) != null) {
                    body.set("org", statusValueMap.get("org"));
                }
                if ((taxOrg = statusValueMap.get("tax_org")) != null) {
                    body.set("tax_org", taxOrg);
                }
                body.set("delete", statusValueMap.get("delete"));
                if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null) {
                    this.setExtInfo(bodyFields, body, dto.getExtInfo());
                }
                body.set("modifytime", (Object)new Date());
                Object status = statusValueMap.get("status");
                if (status != null) {
                    body.set("expense_status", status);
                }
                invoiceBodys.add(body);
            }
            if (invoiceBodys.size() <= 0) continue;
            if (loadDetailSet.contains(entry.getKey())) {
                SaveServiceHelper.save((DynamicObject[])invoiceBodys.toArray(new DynamicObject[0]));
                continue;
            }
            SaveServiceHelper.update((DynamicObject[])invoiceBodys.toArray(new DynamicObject[0]));
        }
        SaveServiceHelper.update((DynamicObject[])mainDynamicObjectsTemp);
    }

    private void setExtInfo(Map<String, IDataEntityProperty> fields, DynamicObject obj, JSONObject extInfo) {
        if (extInfo != null) {
            Set keySet = extInfo.keySet();
            for (String key : keySet) {
                IDataEntityProperty property = fields.get(key);
                if (property == null) continue;
                if (property instanceof BasedataProp) {
                    obj.set(key, (Object)extInfo.getLong(key));
                    continue;
                }
                if (property instanceof DecimalProp) {
                    obj.set(key, (Object)extInfo.getBigDecimal(key));
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    obj.set(key, (Object)extInfo.getDate(key));
                    continue;
                }
                obj.set(key, (Object)extInfo.getString(key));
            }
        }
    }

    private String getString(Set<String> set) {
        if (set == null) {
            return "";
        }
        String num = String.join((CharSequence)",", set);
        if (num.length() > 450) {
            return num.substring(0, 450);
        }
        return num;
    }

    public void delete(ExpenseDTO param) {
        List<String> delteSerialList = this.deleteExpense(param, true);
        if (!CollectionUtils.isEmpty(delteSerialList)) {
            this.updateInvoiceMain(delteSerialList, null);
        }
        this.saveCallBack("delete", param, null, delteSerialList);
    }

    private Integer getStausInteger(String status) {
        if (status == null || "".equals(status.trim())) {
            return Integer.parseInt("1");
        }
        return Integer.parseInt(status.trim());
    }

    private void newExpense(ExpenseDTO param, List<String> serialList) {
        QFilter idfilter = new QFilter("expense_id", "=", (Object)param.getExpenseId());
        if (!StringUtils.isEmpty((CharSequence)param.getEntityId())) {
            idfilter = idfilter.and(new QFilter("entityid", "=", (Object)param.getEntityId()));
        } else if (!StringUtils.isEmpty((CharSequence)param.getResource())) {
            idfilter = idfilter.and(new QFilter("resource", "=", (Object)param.getResource()));
        }
        List list = QueryServiceHelper.queryPrimaryKeys((String)"rim_expense", (QFilter[])new QFilter[]{idfilter}, (String)"id", (int)5);
        DynamicObject expenseObject = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Object pk = list.get(0);
            if (list.size() > 1) {
                QFilter pkfilter = new QFilter("id", "!=", pk);
                DeleteServiceHelper.delete((String)"rim_expense", (QFilter[])new QFilter[]{idfilter, pkfilter});
            }
            expenseObject = BusinessDataServiceHelper.loadSingle(pk, (String)"rim_expense");
            expenseObject.set("update_time", (Object)new Date());
        } else {
            expenseObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense");
            expenseObject.set("create_time", (Object)new Date());
            expenseObject.set("update_time", (Object)new Date());
        }
        expenseObject.set("expense_num", (Object)param.getExpenseNum());
        expenseObject.set("expense_id", (Object)param.getExpenseId());
        expenseObject.set("expense_type", (Object)param.getExpenseType());
        expenseObject.set("status", (Object)param.getStatus());
        expenseObject.set("resource", (Object)param.getResource());
        expenseObject.set("entityid", (Object)param.getEntityId());
        expenseObject.set("view_page", (Object)param.getViewPage());
        expenseObject.set("creator_id", (Object)param.getBillUser());
        expenseObject.set("creator_name", (Object)param.getCreatorName());
        expenseObject.set("remark", (Object)param.getRemark());
        expenseObject.set("expense_time", (Object)param.getExpenseTime());
        expenseObject.set("orgid", (Object)param.getOrgId());
        expenseObject.set("batch", (Object)param.getBatch());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
        if (serialList != null && serialList.size() > 0) {
            this.newExpenseRelation(param, serialList);
        }
    }

    private void newExpenseRelation(ExpenseDTO param, List<String> serialList) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter serialFilter = new QFilter("serial_no", "in", serialList);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,check_status,total_amount,total_tax_amount,serial_no", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        HashMap<String, DynamicObject> serialMap = new HashMap<String, DynamicObject>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            serialMap.put(dynamicObject.getString("serial_no"), dynamicObject);
        }
        List<ExpenseInvoiceDTO> invoiceList = param.getInvoiceList();
        ArrayList<DynamicObject> relaitonList = new ArrayList<DynamicObject>(invoiceList.size());
        HashSet<String> savedSerialNo = new HashSet<String>(invoiceList.size());
        for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
            DynamicObject dynamicObject;
            if (!CollectionUtils.isEmpty(savedSerialNo) && savedSerialNo.contains(invoiceDto.getSerialNo()) || (dynamicObject = (DynamicObject)serialMap.get(invoiceDto.getSerialNo())) == null) continue;
            DynamicObject relationObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense_relation");
            relationObject.set("serial_no", (Object)invoiceDto.getSerialNo());
            relationObject.set("expense_num", (Object)param.getExpenseNum());
            relationObject.set("expense_id", (Object)param.getExpenseId());
            relationObject.set("entityid", (Object)param.getEntityId());
            relationObject.set("view_page", (Object)param.getViewPage());
            relationObject.set("expense_type", (Object)param.getExpenseType());
            relationObject.set("status", (Object)param.getStatus());
            relationObject.set("resource", (Object)param.getResource());
            relationObject.set("create_time", (Object)new Date());
            relationObject.set("output_amount", (Object)invoiceDto.getOutputAmount());
            relationObject.set("output_reason", (Object)invoiceDto.getRemark());
            relationObject.set("deduction_flag", (Object)invoiceDto.getDeductionFlag());
            relationObject.set("deduction_amount", (Object)BigDecimal.ZERO);
            relationObject.set("effective_tax_amount", (Object)BigDecimal.ZERO);
            relationObject.set("reimbursingid", (Object)param.getReimbursingId());
            relationObject.set("preset_deduction_purpose", (Object)invoiceDto.getDeductionPurpose());
            relationObject.set("not_deductible_type", (Object)invoiceDto.getNotDeductibleType());
            if (invoiceDto.getDeductionAmount() != null) {
                relationObject.set("deduction_amount", (Object)invoiceDto.getDeductionAmount());
            } else {
                relationObject.set("deduction_amount", dynamicObject.get("total_tax_amount"));
            }
            if (invoiceDto.getEffectiveTaxAmount() != null) {
                relationObject.set("effective_tax_amount", (Object)invoiceDto.getEffectiveTaxAmount());
            }
            if (invoiceDto.getExpenseAmount() != null) {
                relationObject.set("expense_amount", (Object)invoiceDto.getExpenseAmount());
            } else {
                relationObject.set("expense_amount", dynamicObject.get("total_amount"));
            }
            relationObject.set("check_status", dynamicObject.get("check_status"));
            relaitonList.add(relationObject);
            savedSerialNo.add(invoiceDto.getSerialNo());
        }
        this.saveInvoiceReimEntry(savedSerialNo, param);
        SaveServiceHelper.save((DynamicObject[])relaitonList.toArray(new DynamicObject[relaitonList.size()]));
    }

    public List<String> deleteExpense(ExpenseDTO param, boolean deleteAll) {
        QFilter idfilter = this.getExpenseRelationQFilter(param, "expense_id", "entityid", "resource");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,serial_no", (QFilter[])new QFilter[]{idfilter});
        ArrayList<String> delteSerialList = new ArrayList<String>(collection.size());
        ArrayList<Object> pkList = new ArrayList<Object>(collection.size());
        for (DynamicObject obj : collection) {
            String serialNo = obj.getString("serial_no");
            pkList.add(obj.get("id"));
            delteSerialList.add(serialNo);
        }
        if (pkList != null && !pkList.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"), (Object[])pkList.toArray());
            this.deleteInvoiceReimEntry(delteSerialList, param);
            if (deleteAll) {
                DeleteServiceHelper.delete((String)"rim_expense", (QFilter[])idfilter.toArray());
                this.deleteInvoiceAttach(delteSerialList, param.getExpenseId());
                AttachQueryService attachQueryService = new AttachQueryService();
                attachQueryService.cacheFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
            }
            return delteSerialList;
        }
        return null;
    }

    private void saveAttachmentRelation(ExpenseDTO param) {
        AttachQueryService attachQueryService = new AttachQueryService();
        if (param == null) {
            LOGGER.info("\u8bf7\u6c42\u53c2\u6570param\u4e3a\u7a7a");
            return;
        }
        if (param.isUpdateAttachRelation()) {
            this.updateAttachmentRelation(param);
            return;
        }
        String expenseId = param.getExpenseId();
        JSONArray invoiceAttachObj = attachQueryService.queryFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), false);
        boolean useOriginal = false;
        if (StringUtils.isNotEmpty((CharSequence)param.getOriginalId()) && (invoiceAttachObj == null || invoiceAttachObj.isEmpty())) {
            invoiceAttachObj = attachQueryService.queryFpzsAttach(param.getOriginalId(), param.getOriginalType(), param.getResource(), false);
            useOriginal = true;
        }
        if (invoiceAttachObj != null) {
            InvoiceLog.insertExpenseLog(ResManager.loadKDString((String)"\u9644\u4ef6\u7f13\u5b58", (String)"ExpenseService_3", (String)"imc-rim-common", (Object[])new Object[0]), param.getExpenseId(), param.getExpenseNum(), invoiceAttachObj.toJSONString());
        }
        if (param.isDeleteAttachRelation()) {
            LOGGER.info("\u5f00\u59cb\u5220\u9664\u539f\u6709\u5355\u636e\u6240\u6709\u9644\u4ef6\u5173\u7cfb\u3002[{}]", (Object)expenseId);
            QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
            DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])billFilter.toArray());
        }
        if (invoiceAttachObj == null || invoiceAttachObj.isEmpty()) {
            List<ExpenseAttachDTO> attachDTOList = param.getAttachDTOList();
            if (!CollectionUtils.isEmpty(attachDTOList)) {
                HashSet<String> attachNoList = new HashSet<String>(8);
                HashSet<Long> attachIdList = new HashSet<Long>(8);
                for (ExpenseAttachDTO attDto : param.getAttachDTOList()) {
                    attachNoList.add(attDto.getAttachNo());
                    Long attachId = BigDecimalUtil.transDecimal(attDto.getAttachId()).longValue();
                    if (attachId <= 0L) continue;
                    attachIdList.add(attachId);
                }
                if (!attachIdList.isEmpty()) {
                    DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_attach", (String)"id", (QFilter[])new QFilter("id", "in", attachIdList).toArray());
                    HashSet<Long> existsAttachIds = new HashSet<Long>(collect.size());
                    for (Object obj : collect) {
                        existsAttachIds.add(obj.getLong("id"));
                    }
                    ArrayList<DynamicObject> newAttachList = new ArrayList<DynamicObject>(attachIdList.size());
                    for (ExpenseAttachDTO attachDTO : param.getAttachDTOList()) {
                        Long attachId = BigDecimalUtil.transDecimal(attachDTO.getAttachId()).longValue();
                        if (attachId <= 0L || !existsAttachIds.add(attachId)) continue;
                        DynamicObject needSaveAttach = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
                        String attachNo = UUID.randomUUID();
                        needSaveAttach.set("id", (Object)attachId);
                        needSaveAttach.set("attach_no", (Object)attachNo);
                        needSaveAttach.set("attach_url", (Object)attachDTO.getAttachUrl());
                        needSaveAttach.set("attach_name", (Object)attachDTO.getAttachName());
                        needSaveAttach.set("attach_type", (Object)attachDTO.getAttachType());
                        needSaveAttach.set("remark", (Object)attachDTO.getAttachRemark());
                        needSaveAttach.set("snapshot_url", (Object)attachDTO.getSnapshotUrl());
                        needSaveAttach.set("original_name", (Object)attachDTO.getOriginalFileName());
                        needSaveAttach.set("file_extension", (Object)attachDTO.getFileExtension());
                        needSaveAttach.set("attach_category", (Object)BigDecimalUtil.transDecimal(attachDTO.getAttachCategory()));
                        needSaveAttach.set("create_time", (Object)new Date());
                        needSaveAttach.set("update_time", (Object)new Date());
                        newAttachList.add(needSaveAttach);
                    }
                    if (!newAttachList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])newAttachList.toArray(new DynamicObject[0]));
                    }
                }
                invoiceAttachObj = new JSONArray();
                for (ExpenseAttachDTO dto : attachDTOList) {
                    if (StringUtils.isEmpty((CharSequence)dto.getAttachId()) && StringUtils.isEmpty((CharSequence)dto.getAttachNo())) continue;
                    if (StringUtils.isEmpty((CharSequence)dto.getAttachId())) {
                        QFilter filter = new QFilter("attach_no", "=", (Object)dto.getAttachNo());
                        DynamicObject dy = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id", (QFilter[])new QFilter[]{filter});
                        if (dy == null) continue;
                        dto.setAttachId(String.valueOf(dy.get("id")));
                    }
                    JSONObject dataJson = new JSONObject();
                    dataJson.put("attachId", (Object)dto.getAttachId());
                    dataJson.put("attachUrl", (Object)dto.getAttachUrl());
                    dataJson.put("attachType", (Object)dto.getAttachType());
                    dataJson.put("attachNo", (Object)dto.getAttachNo());
                    dataJson.put("attachName", (Object)dto.getAttachName());
                    dataJson.put("remark", (Object)dto.getAttachRemark());
                    dataJson.put("serialNo", (Object)dto.getSerialNo());
                    invoiceAttachObj.add((Object)dataJson);
                }
            }
            if (invoiceAttachObj == null || invoiceAttachObj.isEmpty()) {
                return;
            }
        }
        LOGGER.info("\u5f00\u59cb\u5220\u9664\u62a5\u9500\u5355\u548c\u9644\u4ef6\u7684\u5173\u8054\u5173\u7cfb...,\u62a5\u9500\u5355id" + expenseId);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(8);
        ArrayList<String> attachIdList = new ArrayList<String>(8);
        for (int i = 0; i < invoiceAttachObj.size(); ++i) {
            JSONObject attach = invoiceAttachObj.getJSONObject(i);
            DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
            String serialNo = attach.getString("serialNo");
            String attachId = attach.getString("attachId");
            attachIdList.add(attachId);
            item.set("relation_type", (Object)1);
            if (!StringUtils.isEmpty((CharSequence)serialNo)) {
                item.set("relation_type", (Object)2);
            }
            item.set("attach_id", (Object)attachId);
            item.set("expense_id", (Object)expenseId);
            item.set("relation_id", (Object)serialNo);
            dynamicObjects.add(item);
        }
        QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
        QFilter idFilter = new QFilter("attach_id", "in", attachIdList);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])new QFilter[]{billFilter, idFilter});
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
        LOGGER.info("\u4fdd\u5b58\u6210\u529f\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u6570\u636e\u7f13\u5b58\uff1aCACHE_INVOICE_ATTACH" + expenseId);
        attachQueryService.cacheFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
        if (useOriginal) {
            attachQueryService.cacheFpzsAttach(param.getOriginalId(), param.getOriginalType(), param.getResource(), null);
        }
    }

    private void updateAttachmentRelation(ExpenseDTO param) {
        if (param.getAttachDTOList() == null) {
            LOGGER.info("\u9644\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        String expenseId = param.getExpenseId();
        AttachQueryService attachQueryService = new AttachQueryService();
        JSONArray attachRelationArray = attachQueryService.queryFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), true);
        if (attachRelationArray != null) {
            InvoiceLog.insertExpenseLog(ResManager.loadKDString((String)"\u9644\u4ef6\u7f13\u5b58", (String)"ExpenseService_3", (String)"imc-rim-common", (Object[])new Object[0]), param.getExpenseId(), param.getExpenseNum(), attachRelationArray.toJSONString());
        }
        LOGGER.info("\u5f00\u59cb\u5220\u9664\u539f\u6709\u5355\u636e\u6240\u6709\u9644\u4ef6\u5173\u7cfb\u3002[{}]", (Object)expenseId);
        QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])billFilter.toArray());
        Set attachNoList = param.getAttachDTOList().stream().map(ExpenseAttachDTO::getAttachNo).collect(Collectors.toSet());
        ArrayList<DynamicObject> attachRelationList = new ArrayList<DynamicObject>(8);
        if (attachRelationArray == null) {
            attachRelationArray = new JSONArray();
        }
        for (int i = 0; i < attachRelationArray.size(); ++i) {
            JSONObject attach = attachRelationArray.getJSONObject(i);
            String attachNo = attach.getString("attachNo_1");
            if (StringUtils.isBlank((CharSequence)attachNo)) {
                attachNo = attach.getString("attachNo");
            }
            String attachId = attach.getString("attachId");
            if (!attachNoList.contains(attachNo)) continue;
            DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
            String serialNo = attach.getString("serialNo");
            item.set("relation_type", (Object)1);
            if (!StringUtils.isEmpty((CharSequence)serialNo)) {
                item.set("relation_type", (Object)2);
            }
            item.set("attach_id", (Object)attachId);
            item.set("expense_id", (Object)expenseId);
            item.set("relation_id", (Object)serialNo);
            attachRelationList.add(item);
        }
        if (!CollectionUtils.isEmpty(attachRelationList)) {
            SaveServiceHelper.save((DynamicObject[])attachRelationList.toArray(new DynamicObject[attachRelationList.size()]));
        }
        LOGGER.info("\u4fdd\u5b58\u6210\u529f\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u6570\u636e\u7f13\u5b58\uff1aCACHE_INVOICE_ATTACH" + expenseId);
        attachQueryService.cacheFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
    }

    private JSONObject saveCoverRelation(ExpenseDTO billExpense) {
        String expenseId = billExpense.getExpenseId();
        if (StringUtils.isBlank((CharSequence)expenseId)) {
            throw new MsgException(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        List<ExpenseCoverDTO> coverDTOList = billExpense.getCoverDTOList();
        if (!CollectionUtils.isEmpty(coverDTOList)) {
            QFilter coverFilter = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObjectCollection coverRelationObjs = QueryServiceHelper.query((String)"rim_cover_relation", (String)"cover_id", (QFilter[])coverFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)coverRelationObjs)) {
                this.newCoverAndRelation(billExpense);
            } else {
                ArrayList<Long> coverIds = new ArrayList<Long>();
                for (DynamicObject dynamicObject : coverRelationObjs) {
                    if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                    coverIds.add(dynamicObject.getLong("cover_id"));
                }
                if (!CollectionUtils.isEmpty(coverIds)) {
                    this.deleteCover(coverIds);
                }
                this.deleteCoverRelation(billExpense.getExpenseId());
                this.newCoverAndRelation(billExpense);
            }
        }
        return ResultContant.createSuccessJSONObject();
    }

    private JSONArray newAttach(ExpenseDTO billExpense) {
        DynamicObject[] attachSaveResult;
        JSONArray attachCacheArray = new JSONArray();
        List<ExpenseAttachDTO> attachDTOList = billExpense.getAttachDTOList();
        if (CollectionUtils.isEmpty(attachDTOList)) {
            LOGGER.info("\u5c01\u9762\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58");
            return attachCacheArray;
        }
        Object[] needSaveAttachs = new DynamicObject[attachDTOList.size()];
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        int i = 0;
        for (ExpenseAttachDTO attachDTO : attachDTOList) {
            if (!StringUtils.isEmpty((CharSequence)attachDTO.getAttachNo())) continue;
            DynamicObject needSaveAttach = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
            String attachNo = UUID.randomUUID();
            needSaveAttach.set("attach_no", (Object)attachNo);
            needSaveAttach.set("attach_url", (Object)attachDTO.getAttachUrl());
            needSaveAttach.set("attach_name", (Object)attachDTO.getAttachName());
            needSaveAttach.set("attach_type", (Object)attachDTO.getAttachType());
            needSaveAttach.set("remark", (Object)attachDTO.getAttachRemark());
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream fileInputStream = service.getInputStream(attachDTO.getAttachUrl());
            String attachHash = FileUtils.getSHA256(fileInputStream);
            needSaveAttach.set("attach_hash_value", (Object)attachHash);
            needSaveAttach.set("user", (Object)userId);
            needSaveAttach.set("create_time", (Object)new Date());
            needSaveAttach.set("update_time", (Object)new Date());
            needSaveAttachs[i++] = needSaveAttach;
        }
        if (ArrayUtils.isEmpty((Object[])needSaveAttachs)) {
            LOGGER.info("\u9644\u4ef6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
            return attachCacheArray;
        }
        for (DynamicObject att : attachSaveResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])needSaveAttachs)) {
            JSONObject dataJson = new JSONObject();
            dataJson.put("attachId", att.get("id"));
            dataJson.put("attachUrl", att.get("attach_url"));
            dataJson.put("attachType", att.get("attach_type"));
            dataJson.put("attachNo", att.get("attach_no"));
            dataJson.put("attachName", att.get("attach_name"));
            dataJson.put("remark", att.get("remark"));
            dataJson.put("attachSize", att.get("size"));
            dataJson.put("createTime", (Object)DateUtils.format(att.getDate("create_time"), "yyyy-MM-dd HH:mm:ss"));
            attachCacheArray.add((Object)dataJson);
        }
        return attachCacheArray;
    }

    private void newCoverAndRelation(ExpenseDTO billExpense) {
        List<ExpenseCoverDTO> coverDTOList = billExpense.getCoverDTOList();
        if (CollectionUtils.isEmpty(coverDTOList)) {
            LOGGER.info("\u5c01\u9762\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58");
            return;
        }
        String expenseId = billExpense.getExpenseId();
        int i = 0;
        Object[] needSaveCovers = new DynamicObject[coverDTOList.size()];
        DynamicObject[] needSaveCoverRelations = new DynamicObject[coverDTOList.size()];
        for (ExpenseCoverDTO coverDTO : coverDTOList) {
            String localUrl = coverDTO.getLocalUrl();
            String savePath = null;
            String snapshotUrl = null;
            if (StringUtils.isEmpty((CharSequence)localUrl)) {
                if (StringUtils.isEmpty((CharSequence)coverDTO.getBase64())) {
                    LOGGER.info("\u5c01\u9762\u6587\u4ef6\u4e3a\u7a7a:" + coverDTO.getCoverNo());
                } else if (1 == coverDTO.getFileType()) {
                    savePath = FileUploadUtils.uploadBase64(FileUploadUtils.getInvoiceDir("cover") + billExpense.getResource() + "/" + billExpense.getEntityId() + "_" + expenseId + "/" + coverDTO.getCoverNo() + ".pdf", coverDTO.getCoverNo() + ".pdf", coverDTO.getBase64());
                    snapshotUrl = this.getCoverSnapshotUrlByBase64(coverDTO.getBase64());
                } else {
                    snapshotUrl = savePath = FileUploadUtils.uploadBase64(FileUploadUtils.getInvoiceDir("cover") + billExpense.getResource() + "/" + billExpense.getEntityId() + "_" + expenseId + "/" + coverDTO.getCoverNo() + ".jpg", coverDTO.getCoverNo() + ".jpg", coverDTO.getBase64());
                }
            }
            DynamicObject needSaveCover = BusinessDataServiceHelper.newDynamicObject((String)"rim_cover");
            needSaveCover.set("cover_no", (Object)coverDTO.getCoverNo());
            if (!ObjectUtils.isEmpty((Object)coverDTO.getFileType())) {
                needSaveCover.set("cover_type", (Object)coverDTO.getFileType());
            } else {
                needSaveCover.set("cover_type", (Object)"1");
            }
            needSaveCover.set("cover_url", (Object)(StringUtils.isNotEmpty((CharSequence)localUrl) ? localUrl : savePath));
            needSaveCover.set("create_time", (Object)new Date());
            needSaveCover.set("update_time", (Object)new Date());
            needSaveCover.set("snapshot_url", snapshotUrl);
            needSaveCover.set("resource", (Object)billExpense.getResource());
            needSaveCovers[i++] = needSaveCover;
        }
        if (ArrayUtils.isEmpty((Object[])needSaveCovers)) {
            LOGGER.info("\u5c01\u9762\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
            return;
        }
        Object[] coverSaveResult = SaveServiceHelper.save((DynamicObject[])needSaveCovers);
        if (ArrayUtils.isEmpty((Object[])coverSaveResult)) {
            return;
        }
        int j = 0;
        for (Object obj : coverSaveResult) {
            if (ObjectUtils.isEmpty((Object)obj)) continue;
            DynamicObject needSaveCoverRelation = BusinessDataServiceHelper.newDynamicObject((String)"rim_cover_relation");
            needSaveCoverRelation.set("cover_id", ((DynamicObject)obj).getPkValue());
            needSaveCoverRelation.set("expense_id", (Object)expenseId);
            needSaveCoverRelation.set("resource", (Object)billExpense.getResource());
            needSaveCoverRelation.set("create_time", (Object)new Date());
            needSaveCoverRelations[j++] = needSaveCoverRelation;
        }
        SaveServiceHelper.save((DynamicObject[])needSaveCoverRelations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCoverSnapshotUrl(String coverUrl) {
        InputStream fileInputStream = null;
        String snapshotUrl = "";
        try {
            fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(coverUrl);
            byte[] streamByte = FileUtils.getByte(fileInputStream);
            if (streamByte != null) {
                LOGGER.info("byteArray size:{}\uff0c coverUrl\uff1a{}", (Object)streamByte.length, (Object)coverUrl);
            } else {
                LOGGER.info("byteArray is empty\uff0c coverUrl\uff1a{}", (Object)coverUrl);
            }
            snapshotUrl = FileConvertUtils.pdf2image((byte[])streamByte, (String)"jpg", (float)1.5f);
        }
        catch (Exception e) {
            LOGGER.error("pdf\u5c01\u9762\u751f\u6210\u5feb\u7167\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u5173\u95ed\u9644\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return snapshotUrl;
    }

    private String getCoverSnapshotUrlByBase64(String base64) {
        String snapshotUrl = "";
        try {
            snapshotUrl = FileConvertUtils.pdf2image((String)base64, (String)"jpg", (float)1.5f);
        }
        catch (Exception e) {
            LOGGER.error("pdf\u5c01\u9762\u751f\u6210\u5feb\u7167\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return snapshotUrl;
    }

    private JSONObject deleteCover(List<Long> coverIds) {
        QFilter coverFilter = new QFilter("id", "in", coverIds);
        int deleteSize = DeleteServiceHelper.delete((String)"rim_cover", (QFilter[])coverFilter.toArray());
        if (deleteSize <= 0) {
            LOGGER.error("\u5220\u9664\u62a5\u9500\u5355\u548c\u5c01\u9762\u5173\u8054\u5173\u7cfb\u5931\u8d25\uff0cdeleteSize:" + deleteSize);
            return ResultContant.createJSONObject("1300", ResManager.loadKDString((String)"\u5220\u9664\u9644\u4ef6\u5931\u8d25", (String)"ExpenseService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return ResultContant.createSuccessJSONObject();
    }

    private JSONObject deleteCoverRelation(String expenseId) {
        QFilter coverFilter = new QFilter("expense_id", "=", (Object)expenseId);
        int billDeleteSize = DeleteServiceHelper.delete((String)"rim_cover_relation", (QFilter[])coverFilter.toArray());
        if (billDeleteSize <= 0) {
            LOGGER.error("\u5220\u9664\u62a5\u9500\u5355\u548c\u5c01\u9762\u5173\u8054\u5173\u7cfb\u5931\u8d25\uff0cdeleteSize:" + billDeleteSize);
            return ResultContant.createJSONObject("1300", ResManager.loadKDString((String)"\u5220\u9664\u62a5\u9500\u5355\u548c\u5c01\u9762\u5173\u8054\u5173\u7cfb\u5931\u8d25", (String)"ExpenseService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return ResultContant.createSuccessJSONObject();
    }

    public DynamicObjectCollection findByFilter(String mainFields, QFilter qFilter) {
        return QueryServiceHelper.query((String)"rim_expense", (String)mainFields, (QFilter[])new QFilter[]{qFilter});
    }

    public boolean isExitst(QFilter qFilter) {
        return QueryServiceHelper.exists((String)"rim_expense_relation", (QFilter[])new QFilter[]{qFilter});
    }

    private void deleteInvoiceReimEntry(List<String> deletedSerials, ExpenseDTO param) {
        DynamicObject[] invoiceArr;
        if (CollectionUtils.isEmpty(deletedSerials)) {
            return;
        }
        if (!ExpenseService.dealReimEntry()) {
            return;
        }
        String selectClumn = "id,reim_expense_id,vouch_vouchid";
        QFilter invoiceFilter = new QFilter("serial_no", "in", deletedSerials);
        QFilter reimFilter = this.getExpenseRelationQFilter(param, "reimvouchrelation.reim_expense_id", "reimvouchrelation.reim_entityid", "reimvouchrelation.reim_resource");
        for (DynamicObject invoice : invoiceArr = BusinessDataServiceHelper.load((String)"rim_invoice", (String)selectClumn, (QFilter[])new QFilter[]{invoiceFilter, reimFilter})) {
            DynamicObjectCollection relationEntry = invoice.getDynamicObjectCollection("reimvouchrelation");
            relationEntry.removeIf(v -> StringUtils.isBlank((CharSequence)v.getString("vouch_vouchid")) && StringUtils.equals((CharSequence)param.getExpenseId(), (CharSequence)v.getString("reim_expense_id")));
        }
        SaveServiceHelper.save((DynamicObject[])invoiceArr);
    }

    public static boolean dealReimEntry() {
        String config = RimConfigUtils.getConfig("rim_relation", "vouch_reim_invoice");
        return StringUtils.equals((CharSequence)config, (CharSequence)"1");
    }

    private void saveInvoiceReimEntry(Set<String> savedSerialNo, ExpenseDTO param) {
        DynamicObject[] invoiceArr;
        if (CollectionUtils.isEmpty(savedSerialNo)) {
            return;
        }
        if (!ExpenseService.dealReimEntry()) {
            return;
        }
        ArrayList listClumn = Lists.newArrayList((Object[])new String[]{"id", "reimvouchrelation.reim_resource", "reimvouchrelation.reim_entityid", "reimvouchrelation.reim_expense_id", "reimvouchrelation.reim_expense_num", "reimvouchrelation.reim_create_time", "reimvouchrelation.reim_status", "reimvouchrelation.reim_expense_type", "reimvouchrelation.vouch_vouchid", "reimvouchrelation.vouch_vouch_no", "reimvouchrelation.vouch_resource", "reimvouchrelation.vouch_account_date", "reimvouchrelation.vouch_account_time"});
        String selectClumn = listClumn.stream().collect(Collectors.joining(","));
        QFilter invoiceFilter = new QFilter("serial_no", "in", savedSerialNo);
        for (DynamicObject invoice : invoiceArr = BusinessDataServiceHelper.load((String)"rim_invoice", (String)selectClumn, (QFilter[])new QFilter[]{invoiceFilter})) {
            DynamicObjectCollection relationEntry = invoice.getDynamicObjectCollection("reimvouchrelation");
            boolean isCurrentExpenseId = false;
            for (DynamicObject relation : relationEntry) {
                if (!this.isCurrentExpenseId(param, relation)) continue;
                relation.set("reim_status", (Object)param.getStatus());
                isCurrentExpenseId = true;
                break;
            }
            if (isCurrentExpenseId) continue;
            DynamicObject newRelation = this.getRelation(relationEntry, param);
            relationEntry.add((Object)newRelation);
        }
        SaveServiceHelper.save((DynamicObject[])invoiceArr);
    }

    private DynamicObject getRelation(DynamicObjectCollection relation, ExpenseDTO param) {
        DynamicObject newRelation = new DynamicObject(relation.getDynamicObjectType());
        newRelation.set("reim_expense_id", (Object)StringUtils.defaultIfBlank((CharSequence)param.getExpenseId(), (CharSequence)" "));
        newRelation.set("reim_resource", (Object)StringUtils.defaultIfBlank((CharSequence)param.getResource(), (CharSequence)" "));
        newRelation.set("reim_entityid", (Object)StringUtils.defaultIfBlank((CharSequence)param.getEntityId(), (CharSequence)" "));
        newRelation.set("reim_expense_num", (Object)StringUtils.defaultIfBlank((CharSequence)param.getExpenseNum(), (CharSequence)" "));
        newRelation.set("reim_create_time", (Object)new Date());
        newRelation.set("reim_status", (Object)StringUtils.defaultIfBlank((CharSequence)param.getStatus(), (CharSequence)" "));
        newRelation.set("reim_expense_type", (Object)StringUtils.defaultIfBlank((CharSequence)param.getExpenseType(), (CharSequence)" "));
        newRelation.set("vouch_vouchid", (Object)" ");
        newRelation.set("vouch_vouch_no", (Object)" ");
        newRelation.set("vouch_resource", (Object)" ");
        newRelation.set("vouch_account_date", null);
        newRelation.set("vouch_account_time", null);
        return newRelation;
    }

    private QFilter getExpenseRelationQFilter(ExpenseDTO param, String expense_idKey, String entityidKey, String resourceKey) {
        QFilter idfilter = new QFilter(expense_idKey, "=", (Object)param.getExpenseId());
        if (StringUtils.isNotEmpty((CharSequence)param.getEntityId()) && param.getResource() != null) {
            idfilter = idfilter.and(new QFilter(entityidKey, "=", (Object)param.getEntityId()).or(new QFilter(resourceKey, "=", (Object)param.getResource())));
            return idfilter;
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getEntityId())) {
            idfilter = idfilter.and(new QFilter(entityidKey, "=", (Object)param.getEntityId()));
            if (param.getResource() != null) {
                idfilter = idfilter.and(new QFilter(resourceKey, "=", (Object)param.getResource()));
            }
        } else {
            if (param.getResource() == null) {
                param.setResource(" ");
            }
            idfilter = idfilter.and(new QFilter(resourceKey, "=", (Object)param.getResource()));
        }
        return idfilter;
    }

    private boolean isCurrentExpenseId(ExpenseDTO param, DynamicObject relation) {
        String expenseId = relation.getString("reim_expense_id");
        String entityId = relation.getString("reim_entityid");
        String resource = relation.getString("reim_resource");
        if (StringUtils.equals((CharSequence)param.getExpenseId(), (CharSequence)expenseId)) {
            if (StringUtils.isNotEmpty((CharSequence)param.getEntityId())) {
                if (param.getResource() != null) {
                    return StringUtils.equals((CharSequence)param.getEntityId(), (CharSequence)entityId) && (StringUtils.isBlank((CharSequence)param.getResource()) && StringUtils.isBlank((CharSequence)resource) || StringUtils.equals((CharSequence)param.getResource(), (CharSequence)resource));
                }
                return StringUtils.equals((CharSequence)param.getEntityId(), (CharSequence)entityId);
            }
            if (param.getResource() == null) {
                param.setResource(" ");
            }
            return StringUtils.equals((CharSequence)param.getResource(), (CharSequence)resource);
        }
        return false;
    }

    public static List<Object> getBillIds(List<String> serialNos) {
        List<Object> billIds = Lists.newArrayList();
        if (serialNos == null || serialNos.size() == 0) {
            return billIds;
        }
        List nos = serialNos.stream().filter(i -> !i.isEmpty()).collect(Collectors.toList());
        DynamicObjectCollection idCollect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", nos)});
        billIds = idCollect.stream().map(o -> o.get("expense_id")).distinct().collect(Collectors.toList());
        return billIds;
    }

    public void loadBillLinkDownNodes(ExpenseDTO param) {
        if (param.getBotpBillList() != null && param.getBotpBillList().size() > 0) {
            return;
        }
        List<Map<String, String>> botpBillList = this.loadBillLinkDownNodes(param.getEntityId(), param.getExpenseId());
        param.setBotpBillList(botpBillList);
    }

    public List<Map<String, String>> loadBillLinkDownNodes(String entityId, String billId) {
        ArrayList<Map<String, String>> botpBillList = new ArrayList<Map<String, String>>(4);
        long start = System.currentTimeMillis();
        Long id = BigDecimalUtil.transDecimal(billId).longValue();
        if (!StringUtils.isEmpty((CharSequence)entityId) && id > 0L && MetadataUtil.exists(entityId).booleanValue()) {
            try {
                Long[] ids = new Long[]{};
                Class<?> classZzz = Class.forName("kd.bos.service.ctbotp.service.CtBillLkServiceHelper");
                Method method = classZzz.getMethod("loadBillLinkDownNodes", String.class, String.class, String.class, ids.getClass(), Boolean.TYPE);
                RequestContext context = RequestContext.get();
                Object obj = method.invoke(null, context.getTenantId(), context.getAccountId(), entityId, new Long[]{id}, true);
                if (obj != null) {
                    JSONObject tNodes;
                    JSONObject bb;
                    String json = SerializationUtils.toJsonString((Object)obj);
                    JSONObject result = JSONObject.parseObject((String)json);
                    if (!result.isEmpty()) {
                        LOGGER.info("\u4e0b\u67e5\u5173\u8054\u5355\u636e{}", (Object)json);
                    }
                    if ((bb = result.getJSONObject(billId)) != null && (tNodes = bb.getJSONObject("tnodes")) != null) {
                        for (Map.Entry entry : tNodes.entrySet()) {
                            JSONObject rowId;
                            JSONObject rowIdObject = tNodes.getJSONObject((String)entry.getKey());
                            if (rowIdObject == null || rowIdObject.isEmpty() || !entityId.equals((rowId = rowIdObject.getJSONObject("rowId")).getString("mainEntityKey"))) continue;
                            HashMap<String, String> resultMap = new HashMap<String, String>(2);
                            resultMap.put("billId", rowId.getString("billId"));
                            resultMap.put("entityId", rowId.getString("mainEntityKey"));
                            botpBillList.add(resultMap);
                        }
                    }
                }
                LOGGER.info("\u4e0b\u67e5\u5173\u8054\u5355\u636e[{},{}],\u5173\u8054\u5355\u636e:{}\u8017\u65f6{}", new Object[]{entityId, billId, botpBillList, System.currentTimeMillis() - start});
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.info("\u4e0b\u67e5\u5173\u8054\u5355\u636e\u5931\u8d251:" + e);
            }
            catch (Throwable e) {
                LOGGER.info("\u4e0b\u67e5\u5173\u8054\u5355\u636e\u5931\u8d252:" + e);
            }
        }
        return botpBillList;
    }

    public List<Map<String, String>> loadBillLinkUpNodes(String entityId, String billId) {
        long start = System.currentTimeMillis();
        Long id = BigDecimalUtil.transDecimal(billId).longValue();
        ArrayList<Map<String, String>> botpBillList = new ArrayList<Map<String, String>>(4);
        if (!StringUtils.isEmpty((CharSequence)entityId) && id > 0L && MetadataUtil.exists(entityId).booleanValue()) {
            try {
                Long[] ids = new Long[]{};
                Class<?> classZzz = Class.forName("kd.bos.service.ctbotp.service.CtBillLkServiceHelper");
                Method method = classZzz.getMethod("loadBillLinkUpNodes", String.class, String.class, String.class, ids.getClass(), Boolean.TYPE);
                Object obj = method.invoke(null, RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityId, new Long[]{id}, true);
                if (obj != null) {
                    JSONObject tNodes;
                    JSONObject bb;
                    String json = SerializationUtils.toJsonString((Object)obj);
                    JSONObject result = JSONObject.parseObject((String)json);
                    if (!result.isEmpty()) {
                        LOGGER.info("\u4e0a\u67e5\u5173\u8054\u5355\u636e{}", (Object)json);
                    }
                    if ((bb = result.getJSONObject(billId)) != null && (tNodes = bb.getJSONObject("snodes")) != null) {
                        for (Map.Entry entry : tNodes.entrySet()) {
                            JSONObject rowId;
                            JSONObject rowIdObject = tNodes.getJSONObject((String)entry.getKey());
                            if (rowIdObject == null || rowIdObject.isEmpty() || !entityId.equals((rowId = rowIdObject.getJSONObject("rowId")).getString("mainEntityKey"))) continue;
                            HashMap<String, String> resultMap = new HashMap<String, String>(2);
                            resultMap.put("billId", rowId.getString("billId"));
                            resultMap.put("entityId", rowId.getString("mainEntityKey"));
                            botpBillList.add(resultMap);
                        }
                    }
                }
                LOGGER.info("\u4e0a\u67e5\u5173\u8054\u5355\u636e[{},{}],\u5173\u8054\u5355\u636e:{}\u8017\u65f6{}", new Object[]{entityId, billId, botpBillList, System.currentTimeMillis() - start});
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.info("\u4e0a\u67e5\u5173\u8054\u5355\u636e\u5931\u8d251:" + e);
            }
            catch (Throwable e) {
                LOGGER.info("\u4e0a\u67e5\u5173\u8054\u5355\u636e\u5931\u8d252:" + e);
            }
        }
        return botpBillList;
    }

    private Map<String, String> queryCtsyTenant(Long orgId) {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        if (orgId != null && orgId > 0L) {
            try {
                Class<?> classZzz = Class.forName("kd.bos.servicehelper.basedata.CtsyBaseServiceHelper");
                Method method = classZzz.getMethod("getCtsyTenant", Long.class);
                Object obj = method.invoke(null, orgId);
                if (obj != null) {
                    String json = SerializationUtils.toJsonString((Object)obj);
                    JSONObject result = JSONObject.parseObject((String)json);
                    if (!result.isEmpty()) {
                        LOGGER.info("\u4e0a\u6e38\u5173\u8054\u5355\u636e\u79df\u6237\u4fe1\u606f{}-{}", (Object)orgId, (Object)json);
                    }
                    String tenantId = result.getString("tenantId");
                    String accountId = result.getString("accountId");
                    if (StringUtils.isNotEmpty((CharSequence)tenantId) && StringUtils.isNotEmpty((CharSequence)accountId)) {
                        resultMap.put("tenantId", tenantId);
                        resultMap.put("accountId", accountId);
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.info("\u4e0a\u6e38\u5173\u8054\u5355\u636e\u79df\u6237\u4fe1\u606f\u5931\u8d251:" + e);
            }
            catch (Exception e) {
                LOGGER.info("\u4e0a\u6e38\u5173\u8054\u5355\u636e\u79df\u6237\u4fe1\u606f\u5931\u8d252:" + e);
            }
        }
        return resultMap;
    }
}

