/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.expense.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.MD5;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class InvoiceImageNotifyService {
    private static Log LOGGER = LogFactory.getLog(InvoiceImageNotifyService.class);

    public static void imageNotify(ExpenseDTO billExpense) {
        String needNotify = ImcConfigUtil.getValue("rim_config", "need_notify");
        if (!StringUtils.equals((CharSequence)needNotify, (CharSequence)"1")) {
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"InvoiceImageNotifyService", () -> {
            InvoiceImageNotifyService service = new InvoiceImageNotifyService();
            List<JSONObject> params = service.buildParams(billExpense);
            for (JSONObject param : params) {
                service.excute(param);
            }
        });
    }

    public static void imageNotify(List<String> params) {
        InvoiceImageNotifyService service = new InvoiceImageNotifyService();
        for (String param : params) {
            service.excute(JSONObject.parseObject((String)param));
        }
    }

    private void excute(JSONObject param) {
        try {
            if (param != null) {
                this.createInfoLog(param);
                this.notify(param);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u3010\u5f71\u50cf\u901a\u77e5\u3011\u6267\u884c\u901a\u77e5\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)e);
            this.createResultLog("", param, e.getMessage(), true);
        }
    }

    private List<JSONObject> buildParams(ExpenseDTO billExpense) {
        ArrayList params = Lists.newArrayList();
        if (billExpense.getCoverDTOList() == null || billExpense.getCoverDTOList().isEmpty()) {
            params.add(this.buildParam(billExpense, null));
        } else {
            for (int i = 0; i < billExpense.getCoverDTOList().size(); ++i) {
                params.add(this.buildParam(billExpense, billExpense.getCoverDTOList().get(i).getCoverNo()));
            }
        }
        return params;
    }

    private JSONObject buildParam(ExpenseDTO billExpense, String coverNo) {
        JSONObject param = new JSONObject();
        param.put("fexpenseId", (Object)billExpense.getExpenseId());
        param.put("fexpenseNum", (Object)billExpense.getExpenseNum());
        param.put("expense_type", (Object)billExpense.getExpenseType());
        param.put("fscanBillNo", (Object)coverNo);
        param.put("fsource", (Object)"4");
        if (billExpense.getBillUser() == null) {
            billExpense.setBillUser(RequestContext.get().getUserId());
        }
        param.put("fcreatorId", (Object)billExpense.getBillUser());
        Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(billExpense.getBillUser()));
        if (userInfo != null) {
            if (userInfo.get("name") != null) {
                param.put("fcreatorName", userInfo.get("name"));
            }
            if (userInfo.get("phone") != null) {
                param.put("fcreatorPhone", userInfo.get("phone"));
            }
            if (userInfo.get("email") != null) {
                param.put("fcreatorEmail", userInfo.get("email"));
            }
        }
        return param;
    }

    private void notify(JSONObject param) {
        String url = "";
        try {
            DynamicObject notifyUrlInfo = this.getNotifyUrl();
            if (notifyUrlInfo == null) {
                this.createResultLog("", param, ResManager.loadKDString((String)"\u672a\u542f\u7528FPY\u5f71\u50cf\u7cfb\u7edf", (String)"InvoiceImageNotifyService_0", (String)"imc-rim-common", (Object[])new Object[0]), true);
                return;
            }
            String notifyUrl = notifyUrlInfo.getString("imageurl");
            if (StringUtils.isBlank((CharSequence)notifyUrl)) {
                this.createResultLog("", param, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5f71\u50cf\u7cfb\u7edfurl", (String)"InvoiceImageNotifyService_1", (String)"imc-rim-common", (Object[])new Object[0]), true);
                return;
            }
            if (!notifyUrl.endsWith("/")) {
                notifyUrl = notifyUrl + "/";
            }
            url = notifyUrl + "imgsys/outside/match/fpzs/inform";
            String clientId = notifyUrlInfo.getString("clientid");
            String clientSecret = notifyUrlInfo.getString("clientsecret");
            if (StringUtils.isBlank((CharSequence)clientId)) {
                JSONObject globalConfig = AwsFpyService.newInstance().getGlobalConfig();
                clientId = globalConfig.getString("client_id");
                clientSecret = globalConfig.getString("client_secret");
            }
            Long timestamp = new Date().getTime();
            String sign = MD5.md5Hex(clientId + clientSecret + timestamp);
            param.put("fclientId", (Object)clientId);
            param.put("sign", (Object)sign);
            param.put("timestamp", (Object)timestamp);
            LOGGER.info("\u901a\u77e5\u5f71\u50cfurl\uff1a{}\uff0c\u53c2\u6570\uff1a{}", (Object)url, (Object)param.toJSONString());
            String str = HttpUtil.doPostJson(url, null, null, param.toJSONString());
            this.createResultLog(url, param, str, false);
        }
        catch (Exception e) {
            LOGGER.info("\u901a\u77e5\u5f71\u50cf\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u95ee\u9898\uff1a{}", (Object)e);
            this.createResultLog(url, param, e.getMessage(), true);
        }
    }

    private void createInfoLog(JSONObject param) {
        String fexpenseId = param.getString("fexpenseId");
        String expenseType = param.getString("expense_type");
        String fscanBillNo = param.getString("fscanBillNo");
        long fcreatorId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject infoLog = this.query(fexpenseId, expenseType, fscanBillNo);
        if (infoLog == null) {
            infoLog = BusinessDataServiceHelper.newDynamicObject((String)"rim_image_notify_log");
            infoLog.set("expense_type", (Object)expenseType);
            infoLog.set("expense_id", (Object)fexpenseId);
            infoLog.set("scan_bill_no", (Object)fscanBillNo);
            infoLog.set("json", (Object)param.toJSONString());
            infoLog.set("creater_id", (Object)fcreatorId);
            Date date = new Date(System.currentTimeMillis());
            infoLog.set("createdate", (Object)date);
            infoLog.set("modifydate", (Object)date);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{infoLog});
        }
    }

    private DynamicObject query(String fexpenseId, String fexpenseType, String fscanBillNo) {
        QFilter expenseIdQf = new QFilter("expense_id", "=", (Object)fexpenseId);
        if (StringUtils.isNotBlank((CharSequence)fexpenseType)) {
            expenseIdQf.and(new QFilter("expense_type", "=", (Object)fexpenseType));
        } else if (StringUtils.isNotBlank((CharSequence)fscanBillNo)) {
            expenseIdQf.and(new QFilter("scan_bill_no", "=", (Object)fscanBillNo));
        }
        String selectProperties = "id";
        DynamicObject loadSingleFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)"rim_image_notify_log", (String)selectProperties, (QFilter[])new QFilter[]{expenseIdQf});
        if (loadSingleFromCache == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)loadSingleFromCache.get("id"), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"rim_image_notify_log").getDynamicObjectType());
    }

    private void createResultLog(String url, JSONObject param, String result, boolean isError) {
        String fscanBillNo;
        String expenseType;
        String fexpenseId = param.getString("fexpenseId");
        DynamicObject infoLog = this.query(fexpenseId, expenseType = param.getString("expense_type"), fscanBillNo = param.getString("fscanBillNo"));
        if (infoLog == null) {
            LOGGER.info("\u3010\u5f71\u50cf\u901a\u77e5\u3011\u6570\u636e\u9519\u8bef\u3002\u8bf7\u6c42\u540e\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e\u65e5\u5fd7");
            return;
        }
        DynamicObjectCollection detailLogColl = infoLog.getDynamicObjectCollection("rim_notify_log_detail");
        Date updateDate = new Date(System.currentTimeMillis());
        infoLog.set("modifydate", (Object)updateDate);
        DynamicObject newLog = detailLogColl.addNew();
        if (StringUtils.isNotBlank((CharSequence)url) && url.length() > 300) {
            url = url.substring(0, 300);
        }
        newLog.set("url", (Object)url);
        newLog.set("param", (Object)param.toJSONString());
        newLog.set("post_data", (Object)updateDate);
        newLog.set("user_id", (Object)Long.parseLong(RequestContext.get().getUserId()));
        if (StringUtils.isNotBlank((CharSequence)result) && result.length() > 500) {
            result = result.substring(0, 500);
        }
        if (isError) {
            newLog.set("error_info", (Object)result);
        } else {
            newLog.set("result", (Object)result);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{infoLog});
    }

    private DynamicObject getNotifyUrl() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"A");
        enableFilter.and(new QFilter("number", "=", (Object)"FPY"));
        return QueryServiceHelper.queryOne((String)"bas_imageconfig", (String)"imageurl,clientid,clientsecret", (QFilter[])new QFilter[]{enableFilter});
    }

    public static String getImageNumber(String billType, String billId) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billId);
        imageInfo.setBilltype(billType);
        LOGGER.info("getImageNumber param: " + billType + ", " + billId);
        ImageInfo result = ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        if (result == null) {
            LOGGER.info("\u3010\u53d1\u7968\u4e91\u670d\u52a1\u3011\u4fdd\u5b58\u670d\u52a1\uff0c\u5f71\u50cf\u7f16\u7801\u672a\u67e5\u8be2\u5230");
            return "";
        }
        LOGGER.info("\u3010\u53d1\u7968\u4e91\u670d\u52a1\u3011\u4fdd\u5b58\u670d\u52a1\uff0c\u5f71\u50cf\u7f16\u7801: {}", (Object)result.getImageNo());
        return result.getImageNo();
    }

    public static String createImageNumber(String billId, String billNo, String userId, String orgId, String billType) {
        String imageNum = "";
        try {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setBillId(billId);
            imageInfo.setBillNo(billNo);
            imageInfo.setCreator(userId);
            imageInfo.setBilltype(billType);
            imageInfo.setOrgId(orgId);
            imageNum = ImageServiceHelper.createImageInfo((ImageInfo)imageInfo);
            LOGGER.info("\u3010\u53d1\u7968\u4e91\u670d\u52a1\u3011\u4fdd\u5b58\u670d\u52a1\uff0c\u63a8\u9001\u53d1\u7968\u5f71\u50cf\u6570\u636e\u524d\u521b\u5efa\u5f71\u50cf\u7f16\u7801\u6210\u529f\uff1a{}", (Object)imageNum);
        }
        catch (Exception e) {
            LOGGER.info("\u3010\u53d1\u7968\u4e91\u670d\u52a1\u3011\u4fdd\u5b58\u670d\u52a1\uff0c\u63a8\u9001\u53d1\u7968\u5f71\u50cf\u6570\u636e\u524d\u521b\u5efa\u5f71\u50cf\u7f16\u7801\u5931\u8d25,\u5f02\u5e38\u7c7b\u578b\uff1a{}", (Object)e);
        }
        return imageNum;
    }
}

