/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.helper.ExcelInvoiceImportUtil;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.collector.InvoiceExcelImportTask;
import kd.imc.rim.common.invoice.collector.TaxInvoiceExcelImportTask;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.recognition.impl.ExcelResolveTask;
import kd.imc.rim.common.invoice.recognition.listener.IRecognitionListener;
import kd.imc.rim.common.invoice.recognition.listener.RecognitionListenerResult;
import kd.imc.rim.common.invoice.save.ExcelInvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelInvoiceUploadHelper {
    private static Log logger = LogFactory.getLog(ExcelInvoiceUploadHelper.class);
    private static ThreadPool excelThreadPool = ThreadPools.newFixedThreadPool((String)"excelResolveThread", (int)12);
    private static InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public static JSONObject getResolveResult(InputStream fileInputStream, JSONObject fileParam, IRecognitionListener recognitionListener, JSONObject paramResult) {
        if (paramResult == null) {
            paramResult = new JSONObject();
        }
        Boolean isAdmin = fileParam.getBoolean("isAdmin");
        String fileName = fileParam.getString("fileName");
        String fileUrl = fileParam.getString("fileUrl");
        JSONArray checkParamList = new JSONArray();
        Workbook workbook = null;
        Boolean closeFlag = Boolean.FALSE;
        try {
            workbook = WorkbookFactory.create((InputStream)fileInputStream);
            int excelType = 0;
            if (workbook != null) {
                int sheetCounts = workbook.getNumberOfSheets();
                Sheet firstSheet = workbook.getSheetAt(0);
                if (firstSheet == null) {
                    throw new MsgException("0001", ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef(sheet\u4fe1\u606f\u4e3a\u7a7a)\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"ExcelInvoiceUploadHelper_0", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                Row firstRow = firstSheet.getRow(0);
                if (firstRow == null || firstRow.getCell(0) == null) {
                    throw new MsgException("0001", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff08%1$s\u7684\u9996\u884c\u4fe1\u606f\u4e3a\u7a7a\uff09\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"ExcelInvoiceUploadHelper_1", (String)"imc-rim-common", (Object[])new Object[0]), firstSheet));
                }
                String tableParamStr = firstRow.getCell(0).getStringCellValue();
                String[] tableParams = tableParamStr.split("#");
                if (tableParams.length >= 2) {
                    excelType = 2;
                } else if (tableParams.length == 1 && tableParams[0].trim().contains("\u53d1\u7968\u4ee3\u7801")) {
                    excelType = 1;
                } else {
                    throw new MsgException("0001", ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff08\u65e0\u6cd5\u6839\u636e\u9996\u884c\u53c2\u6570\u5185\u5bb9\u89e3\u6790excel\u6587\u4ef6\uff09\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"ExcelInvoiceUploadHelper_2", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                logger.info("excel\u6a21\u677f\u7c7b\u578b:" + excelType);
                String source = paramResult.getString("source");
                if (paramResult != null && excelType != 2 && "full_pool".equals(source)) {
                    throw new MsgException("0001", ResManager.loadKDString((String)"\u5f15\u5165\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u5728\u3010\u5f15\u5165\u53d1\u7968\u3011\u5904\u4e0b\u8f7d\u6b63\u786e\u7684\u6a21\u677f", (String)"ExcelInvoiceUploadHelper_3", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                if (excelType == 1) {
                    JSONObject recognitionResultData = ExcelInvoiceUploadHelper.resolveExcelCheckModel(checkParamList, workbook, fileParam, recognitionListener);
                    logger.info("\u67e5\u9a8c\u6a21\u677f\u67e5\u9a8c\u7ed3\u679c:" + recognitionResultData.getJSONArray("successData"));
                    closeFlag = Boolean.TRUE;
                    JSONObject jSONObject = recognitionResultData;
                    return jSONObject;
                }
                if (excelType == 2 && isAdmin.booleanValue()) {
                    ArrayList<Future<JSONObject>> futureList = new ArrayList<Future<JSONObject>>(sheetCounts - 1);
                    HashMap<String, Integer> sheetIndexMap = new HashMap<String, Integer>(sheetCounts);
                    for (int i = 0; i < sheetCounts; ++i) {
                        Sheet sheet = workbook.getSheetAt(i);
                        Row tableRow = sheet.getRow(0);
                        String entityNameStr = ExcelInvoiceUploadHelper.getStringValueFromCell(tableRow.getCell(0));
                        if (entityNameStr == null || entityNameStr.split("#").length < 3 || "demo".equals(entityNameStr.split("#")[2].trim())) continue;
                        sheetIndexMap.put(entityNameStr.split("#")[2].trim(), i);
                        ExcelResolveTask task = new ExcelResolveTask(sheet);
                        Future future = excelThreadPool.submit((Callable)task);
                        futureList.add(future);
                    }
                    String excelImportStatus = InvoiceExcelImportTask.getExcelImportStatus();
                    if ("1".equals(excelImportStatus)) {
                        throw new MsgException(ResManager.loadKDString((String)"\u5f53\u524d\u8fd8\u6709\u53d1\u7968\u5c1a\u672a\u5f15\u5165\u5b8c\u6210\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5019\uff0c\u6240\u6709\u53d1\u7968\u5f15\u5165\u5b8c\u6210\u540e\u53ef\u518d\u6b21\u5f15\u5165", (String)"ExcelInvoiceUploadHelper_4", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    InvoiceExcelImportTask invoiceExcelImportTask = new InvoiceExcelImportTask(RequestContext.get(), futureList, fileName, fileUrl, workbook, sheetIndexMap);
                    ThreadPools.executeOnce((String)"invoice_excel_import_task", (Runnable)invoiceExcelImportTask);
                    ExcelInvoiceUploadHelper.closeModule(recognitionListener, fileUrl, fileName);
                    closeFlag = Boolean.TRUE;
                }
                if (excelType == 2 && !isAdmin.booleanValue()) {
                    throw new MsgException(ResManager.loadKDString((String)"\u53ea\u6709\u7ba1\u7406\u5458\u624d\u6709\u6743\u9650\u6267\u884c\u5168\u7968\u6c60\u7684\u5f15\u5165\u64cd\u4f5c", (String)"ExcelInvoiceUploadHelper_5", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                paramResult.put("tipDescription", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85\uff01\u60a8\u53ef\u4ee5\u70b9\u51fb\u3010\u67e5\u770b\u53d1\u7968\u5f15\u5165\u7ed3\u679c\u3011\u67e5\u770b\u8fdb\u5ea6\u5e76\u4e0b\u8f7d\u7ed3\u679c", (String)"ExcelInvoiceUploadHelper_6", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            JSONObject resultData = new JSONObject();
            resultData.put("successData", (Object)checkParamList);
            resultData.put("failData", (Object)new JSONArray());
            JSONObject jSONObject = resultData;
            return jSONObject;
        }
        catch (IOException e) {
            logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e);
            throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199\uff1a%1$s", (String)"ExcelInvoiceUploadHelper_7", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (!closeFlag.booleanValue()) {
                ExcelInvoiceUploadHelper.closeModule(recognitionListener, fileUrl, fileName);
            }
            IOUtils.closeQuietly((Closeable)fileInputStream);
        }
    }

    private static void closeModule(IRecognitionListener recognitionListener, String fileUrl, String fileName) {
        if (recognitionListener != null) {
            RecognitionListenerResult recognitionListenerResult = new RecognitionListenerResult();
            recognitionListenerResult.setFileUrl(fileUrl);
            recognitionListenerResult.setFileName(fileName);
            recognitionListenerResult.setRecognitionSize(1);
            recognitionListenerResult.setRecognitionIndex(1);
            recognitionListenerResult.setRecognitionInvoice(new JSONArray());
            recognitionListener.handle(recognitionListenerResult);
        }
    }

    private static JSONObject resolveExcelCheckModel(JSONArray checkParamList, Workbook workbook, JSONObject fileParam, IRecognitionListener recognitionListener) {
        int sheetCounts = workbook.getNumberOfSheets();
        JSONObject recognitionResult = new JSONObject();
        JSONArray failResultData = new JSONArray();
        JSONArray recognitionResultData = new JSONArray();
        String fileName = fileParam.getString("fileName");
        String fileUrl = fileParam.getString("fileUrl");
        String resource = fileParam.getString("resource");
        String inputResource = fileParam.getString("inputResource");
        int allSumSize = 0;
        for (int sheetIndex = 0; sheetIndex < sheetCounts; ++sheetIndex) {
            Cell firstCell;
            String title;
            Row firstRow;
            Sheet sheet = workbook.getSheetAt(sheetIndex);
            int sheetRows = sheet.getPhysicalNumberOfRows();
            if (sheetRows < 2 || (firstRow = sheet.getRow(0)) == null || (allSumSize = StringUtils.isEmpty((CharSequence)(title = ExcelInvoiceUploadHelper.getStringValueFromCell(firstCell = firstRow.getCell(0)))) || ArrayUtils.isEmpty((Object[])title.split("#")) || title.split("#").length < 3 ? allSumSize + sheetRows - 1 : allSumSize + sheetRows - 4) <= 400) continue;
            throw new MsgException("0001", ResManager.loadKDString((String)"excel\u6570\u636e\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7200\u884c", (String)"ExcelInvoiceUploadHelper_8", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        int index = 0;
        for (int sheetIndex = 0; sheetIndex < sheetCounts; ++sheetIndex) {
            JSONObject sheetDataJSON;
            Row firstRow;
            Sheet sheet = workbook.getSheetAt(sheetIndex);
            int sheetRows = sheet.getPhysicalNumberOfRows();
            if (sheetRows < 2 || (firstRow = sheet.getRow(0)) == null) continue;
            Cell firstCell = firstRow.getCell(0);
            String title = ExcelInvoiceUploadHelper.getStringValueFromCell(firstCell);
            if (StringUtils.isEmpty((CharSequence)title) || ArrayUtils.isEmpty((Object[])title.split("#")) || title.split("#").length < 3) {
                String invoiceNo;
                String invoiceCode;
                if (sheetRows > 201) {
                    throw new MsgException("0001", String.format(ResManager.loadKDString((String)"excel\u6570\u636e\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7200\u884c,\u8d85\u884csheet:%1$s", (String)"ExcelInvoiceUploadHelper_9", (String)"imc-rim-common", (Object[])new Object[0]), sheet.getSheetName()));
                }
                for (int rowIndex = 1; rowIndex < sheetRows; ++rowIndex) {
                    Cell cell5;
                    Cell cell4;
                    Cell cell3;
                    Cell cell2;
                    Row row = sheet.getRow(rowIndex);
                    if (row == null) continue;
                    JSONObject checkParam = new JSONObject();
                    checkParam.put("order", (Object)sheetIndex);
                    invoiceCode = "";
                    invoiceNo = "";
                    String invoiceDate = "";
                    String invoiceAmount = "";
                    String checkCode = "";
                    Cell cell1 = row.getCell(0);
                    if (cell1 != null) {
                        invoiceCode = ExcelInvoiceUploadHelper.getStringValueFromCell(cell1);
                    }
                    if ((cell2 = row.getCell(1)) != null) {
                        invoiceNo = ExcelInvoiceUploadHelper.getStringValueFromCell(cell2);
                    }
                    if ((cell3 = row.getCell(2)) != null) {
                        invoiceDate = ExcelInvoiceUploadHelper.getStringValueFromCell(cell3);
                    }
                    if ((cell4 = row.getCell(3)) != null) {
                        checkCode = ExcelInvoiceUploadHelper.getStringValueFromCell(cell4);
                    }
                    if ((cell5 = row.getCell(4)) != null) {
                        invoiceAmount = ExcelInvoiceUploadHelper.getStringValueFromCell(cell5);
                    }
                    checkParam.put("invoiceCode", (Object)invoiceCode);
                    checkParam.put("invoiceNo", (Object)invoiceNo);
                    checkParam.put("invoiceDate", (Object)invoiceDate);
                    checkParam.put("invoiceAmount", (Object)invoiceAmount);
                    checkParam.put("checkCode", (Object)checkCode);
                    checkParamList.add((Object)checkParam);
                }
                logger.info("\u67e5\u9a8cexcel\u6a21\u677f\u89e3\u6790\u7ed3\u679c:" + checkParamList);
                int checkParamSize = checkParamList.size();
                for (int checkParamIndex = 0; checkParamIndex < checkParamSize; ++checkParamIndex) {
                    Long orgId;
                    JSONObject checkParamJson = checkParamList.getJSONObject(checkParamIndex);
                    invoiceCode = checkParamJson.getString("invoiceCode");
                    invoiceNo = checkParamJson.getString("invoiceNo");
                    String invoiceAmount = checkParamJson.getString("invoiceAmount");
                    BigDecimal checkAmount = BigDecimal.ZERO;
                    if (StringUtils.isNotEmpty((CharSequence)invoiceAmount)) {
                        checkAmount = new BigDecimal(invoiceAmount);
                    }
                    String awsInvoiceType = null;
                    Long invoiceType = null;
                    if (invoiceNo.length() != 20) {
                        awsInvoiceType = InvoiceConvertUtils.checkInvoiceType(invoiceCode, invoiceNo);
                        invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType);
                    }
                    if (ObjectUtils.isEmpty((Object)(orgId = fileParam.getLong("orgId")))) {
                        orgId = RequestContext.get().getOrgId();
                    }
                    String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
                    HashMap extMap = Maps.newHashMap();
                    extMap.put("orgId", orgId);
                    extMap.put("taxNo", taxNo);
                    extMap.put("eid", RequestContext.get().getUserId());
                    CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, checkParamJson.getString("invoiceDate"), checkAmount, checkParamJson.getString("checkCode"), (Map<String, Object>)extMap);
                    CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo);
                    JSONObject showInvoice = new JSONObject();
                    JSONArray importFailedResultData = new JSONArray();
                    if (checkResult != null && "0000".equals(checkResult.getErrcode())) {
                        Object invoiceEntity = checkResult.getData();
                        String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                        JSONObject invoice = JSON.parseObject((String)invoiceCheckStr);
                        String checkStatus = invoice.getString("checkStatus");
                        if (StringUtils.isEmpty((CharSequence)checkStatus)) {
                            invoice.put("checkStatus", (Object)"1");
                        }
                        invoice.put("fileName", (Object)fileName);
                        invoice.put("fileIndex", (Object)(checkParamIndex + 1));
                        invoice.put("resource", (Object)resource);
                        invoice.put("collect_type", (Object)CollectTypeEnum.PC_EXCEL.getCode());
                        invoice.put("org_id", (Object)orgId);
                        ConvertFieldUtil.getStandardInvoice(invoice);
                        String verifySaveFlag = RimConfigUtils.getConfig("verify_save");
                        if ("0".equals(verifySaveFlag)) {
                            invoice.put("delete", (Object)"2");
                        }
                        try {
                            invoiceCollectService.saveInvoice(invoice, null, null);
                            String isSaleListInvoice = invoice.getString("isSaleListInvoice");
                            if ("1".equals(isSaleListInvoice)) {
                                RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                                recognitionCheckHelper.dealInvoiceAttachRelation(invoice);
                            }
                            recognitionResultData.add((Object)invoice);
                            showInvoice = invoice;
                        }
                        catch (MsgException e) {
                            checkParamJson.put("reason", (Object)e.getMessage());
                            importFailedResultData.add((Object)checkParamJson);
                            failResultData.add((Object)checkParamJson);
                        }
                    } else if (checkResult == null) {
                        checkParamJson.put("reason", (Object)ResManager.loadKDString((String)"\u67e5\u9a8c\u7ed3\u679c\u8fd4\u56de\u7a7a\u503c", (String)"ExcelInvoiceUploadHelper_10", (String)"imc-rim-common", (Object[])new Object[0]));
                        importFailedResultData.add((Object)checkParamJson);
                        failResultData.add((Object)checkParamJson);
                    } else if (!"0000".equals(checkResult.getErrcode())) {
                        JSONObject invoice = new JSONObject();
                        if (ObjectUtils.isEmpty((Object)invoice)) {
                            invoice = checkParamJson;
                            invoice.put("reason", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25:%1$s,%2$s", (String)"ExcelInvoiceUploadHelper_11", (String)"imc-rim-common", (Object[])new Object[0]), checkResult.getErrcode(), checkResult.getDescription()));
                        }
                        importFailedResultData.add((Object)invoice);
                        failResultData.add((Object)invoice);
                    }
                    if (recognitionListener == null) continue;
                    RecognitionListenerResult recognitionListenerResult = new RecognitionListenerResult();
                    recognitionListenerResult.setFileUrl(fileUrl);
                    recognitionListenerResult.setFileName(fileName);
                    recognitionListenerResult.setRecognitionSize(allSumSize);
                    recognitionListenerResult.setRecognitionIndex(++index);
                    if (checkResult != null && "0000".equals(checkResult.getErrcode())) {
                        JSONArray recognitionInvoiceArray = new JSONArray();
                        recognitionInvoiceArray.add((Object)showInvoice);
                        recognitionListenerResult.setRecognitionInvoice(recognitionInvoiceArray);
                        recognitionListenerResult.setImportFailInvoice(new JSONArray());
                        recognitionListener.handle(recognitionListenerResult);
                        continue;
                    }
                    recognitionListenerResult.setRecognitionInvoice(new JSONArray());
                    recognitionListenerResult.setImportFailInvoice(importFailedResultData);
                    recognitionListener.handle(recognitionListenerResult);
                }
                continue;
            }
            if (ArrayUtils.isEmpty((Object[])title.split(",")) || title.split("#").length < 3) continue;
            ExcelResolveTask task = new ExcelResolveTask(sheet);
            try {
                sheetDataJSON = task.call();
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u975e\u589e\u503c\u7a0e\u53d1\u7968\u5931\u8d25\uff0cexcel\u9996\u884c\u4fe1\u606f:" + title, (Throwable)e);
                continue;
            }
            String sheetId = sheetDataJSON.getString("sheetId");
            JSONArray tableArray = sheetDataJSON.getJSONArray("data");
            if (CollectionUtils.isEmpty((Collection)tableArray)) continue;
            if (tableArray.size() > 200) {
                logger.info("\u5904\u7406\u975e\u589e\u503c\u7a0e\u53d1\u7968(" + sheetId + ")\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7200\u884c" + title);
                throw new MsgException("0001", String.format(ResManager.loadKDString((String)"excel\u6570\u636e\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7200\u884c, \u8d85\u884csheet:%1$s", (String)"ExcelInvoiceUploadHelper_12", (String)"imc-rim-common", (Object[])new Object[0]), sheet.getSheetName()));
            }
            Long invoiceType = null;
            for (int i = 0; i < tableArray.size(); ++i) {
                Object tableObject = tableArray.get(i);
                JSONObject fieldObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)tableObject));
                JSONArray successData = new JSONArray();
                JSONArray failData = new JSONArray();
                if (fieldObject.getBoolean("isResolveError") != null && fieldObject.getBoolean("isResolveError").booleanValue()) {
                    fieldObject.put("reason", (Object)fieldObject.getString("resolveErrorMsg"));
                    failData.add((Object)fieldObject);
                    ExcelInvoiceUploadHelper.sendRecognitionResult(recognitionListener, successData, failData, fileUrl, fileName, ++index, allSumSize);
                    failResultData.add((Object)fieldObject);
                    continue;
                }
                if (!"general".equals(sheetId) && !"special".equals(sheetId)) {
                    invoiceType = Long.parseLong(sheetId);
                }
                JSONObject saveResult = new JSONObject();
                fieldObject.put("invoiceType", (Object)invoiceType);
                Boolean checkFlag = ExcelInvoiceUploadHelper.checkRequiredParam(fieldObject, invoiceType);
                if (checkFlag.booleanValue()) {
                    fieldObject.put("inputResource", (Object)inputResource);
                    String invoiceDateStr = fieldObject.getString("invoice_date");
                    Date invoiceDate = null;
                    ExcelInvoiceSaveService excelInvoiceSaveService = new ExcelInvoiceSaveService(invoiceType);
                    try {
                        String verifySaveFlag;
                        invoiceDate = DateUtils.stringToDate(invoiceDateStr, "yyyyMMdd");
                        DynamicObject savedInvoice = excelInvoiceSaveService.checkInvoiceExist(fieldObject);
                        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
                            invoiceCollectService.setTicketChange(fieldObject);
                            String ticketChanges = fieldObject.getString("ticketChanges");
                            String endorsement = fieldObject.getString("endorsement");
                            boolean isRebook = ("\u6539\u7b7e\u8d39".equals(endorsement) || "\u9000\u7968\u8d39".equals(endorsement) || "\u9000\u7968\u624b\u7eed\u8d39".equals(endorsement)) && "1".equals(ticketChanges);
                            String internationalFlag = CommonUtils.getJsonValue((Map<String, Object>)fieldObject, String.class, "internationalFlag", "international_flag");
                            if ("2".equals(internationalFlag) || isRebook) {
                                fieldObject.put("total_tax_amount", (Object)BigDecimal.ZERO);
                            } else {
                                fieldObject = excelInvoiceSaveService.fillDefaultInvoice(fieldObject);
                            }
                        }
                        fieldObject.put("resource", (Object)resource);
                        Long requestOrg = fileParam.getLong("orgId");
                        if (requestOrg != null) {
                            fieldObject.put("org", (Object)requestOrg);
                        }
                        if ("0".equals(verifySaveFlag = RimConfigUtils.getConfig("verify_save"))) {
                            fieldObject.put("delete", (Object)"2");
                        }
                        saveResult = excelInvoiceSaveService.save(fieldObject);
                        saveResult.put("invoiceType", (Object)invoiceType);
                        successData.add((Object)saveResult);
                    }
                    catch (Exception e) {
                        logger.error("\u4fdd\u5b58\u53d1\u7968\u5931\u8d25", (Throwable)e);
                        fieldObject.put("reason", (Object)e.getMessage());
                        failData.add((Object)fieldObject);
                        failResultData.add((Object)fieldObject);
                        successData.add((Object)fieldObject);
                        fieldObject.put("invoice_date", (Object)invoiceDate);
                        saveResult = InvoiceConvertService.newInstance(invoiceType).convert((Map<String, Object>)fieldObject);
                        saveResult.put("checkFail", (Object)String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u8f6c\u6362\u51fa\u9519:%1$s", (String)"ExcelInvoiceUploadHelper_13", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
                        saveResult.put("invoiceType", (Object)invoiceType);
                    }
                } else {
                    fieldObject.put("reason", (Object)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8c03\u6574\u53c2\u6570", (String)"ExcelInvoiceUploadHelper_14", (String)"imc-rim-common", (Object[])new Object[0]));
                    failData.add((Object)fieldObject);
                    failResultData.add((Object)fieldObject);
                    successData.add((Object)fieldObject);
                    String invoiceDate = fieldObject.getString("invoice_date");
                    if (StringUtils.isNotBlank((CharSequence)invoiceDate)) {
                        try {
                            fieldObject.put("invoice_date", (Object)DateUtils.stringToDate(invoiceDate, "yyyyMMdd"));
                        }
                        catch (Exception e) {
                            saveResult.put("checkFail", (Object)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e14\u5f00\u7968\u65e5\u671f\u683c\u5f0f\u683c\u5f0f\u9519\u8bef\uff0c\u5bfc\u5165\u5931\u8d25", (String)"ExcelInvoiceUploadHelper_15", (String)"imc-rim-common", (Object[])new Object[0]));
                            fieldObject.put("invoice_date", null);
                        }
                        saveResult = InvoiceConvertService.newInstance(invoiceType).convert((Map<String, Object>)fieldObject);
                        saveResult.put("checkFail", (Object)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25", (String)"ExcelInvoiceUploadHelper_16", (String)"imc-rim-common", (Object[])new Object[0]));
                        saveResult.put("invoiceType", (Object)invoiceType);
                    }
                }
                recognitionResultData.add((Object)saveResult);
                ExcelInvoiceUploadHelper.sendRecognitionResult(recognitionListener, successData, failData, fileUrl, fileName, ++index, allSumSize);
            }
        }
        recognitionResult.put("successData", (Object)recognitionResultData);
        recognitionResult.put("failData", (Object)failResultData);
        return recognitionResult;
    }

    private static Boolean checkRequiredParam(JSONObject fieldObject, Long invoiceType) {
        Boolean checkFlag = Boolean.TRUE;
        if ((InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) && (StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_code")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("train_num")) || StringUtils.isBlank((CharSequence)fieldObject.getString("sequence_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")) || StringUtils.isBlank((CharSequence)fieldObject.getString("passenger_name")))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("eticket_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("print_num")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("place_of_departure")) || StringUtils.isBlank((CharSequence)fieldObject.getString("destination"))) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_amount")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")) || StringUtils.isBlank((CharSequence)fieldObject.getString("other_amount"))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_code")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")))) {
            checkFlag = Boolean.FALSE;
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(invoiceType) && (StringUtils.isBlank((CharSequence)fieldObject.getString("tax_paid_proof_no")) || StringUtils.isBlank((CharSequence)fieldObject.getString("invoice_date")) || StringUtils.isBlank((CharSequence)fieldObject.getString("total_amount")) || StringUtils.isBlank((CharSequence)fieldObject.getString("buyer_tax_no")))) {
            checkFlag = Boolean.FALSE;
        }
        return checkFlag;
    }

    public static String getStringValueFromCell(Cell cell) {
        SimpleDateFormat sFormat = new SimpleDateFormat("MM/dd/yyyy");
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        if (cell.getCellType() == CellType.STRING) {
            cellValue = cell.getStringCellValue();
        } else if (cell.getCellType() == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                double d = cell.getNumericCellValue();
                Date date = DateUtil.getJavaDate((double)d);
                cellValue = sFormat.format(date);
            } else {
                cellValue = decimalFormat.format(cell.getNumericCellValue());
            }
        } else if (cell.getCellType() == CellType.BLANK) {
            cellValue = "";
        } else if (cell.getCellType() == CellType.BOOLEAN) {
            cellValue = String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == CellType.ERROR) {
            cellValue = "";
        } else if (cell.getCellType() == CellType.FORMULA) {
            cellValue = cell.getCellFormula();
        }
        return cellValue;
    }

    private static void sendRecognitionResult(IRecognitionListener recognitionListener, JSONArray successData, JSONArray failData, String fileUrl, String fileName, int index, int allSize) {
        if (recognitionListener != null) {
            RecognitionListenerResult recognitionListenerResult = new RecognitionListenerResult();
            recognitionListenerResult.setFileUrl(fileUrl);
            recognitionListenerResult.setFileName(fileName);
            if (!CollectionUtils.isEmpty((Collection)successData)) {
                recognitionListenerResult.setRecognitionSize(allSize);
                recognitionListenerResult.setRecognitionInvoice(successData);
                recognitionListenerResult.setImportFailInvoice(new JSONArray());
            }
            if (!CollectionUtils.isEmpty((Collection)failData)) {
                recognitionListenerResult.setRecognitionInvoice(new JSONArray());
                recognitionListenerResult.setImportFailInvoice(failData);
            }
            logger.info("\u5f53\u524d\u7d22\u5f15\u4f4d\u7f6e" + index + ",\u5f53\u524d\u603b\u6570\uff1a" + allSize);
            recognitionListenerResult.setRecognitionIndex(index);
            recognitionListener.handle(recognitionListenerResult);
        }
    }

    public static JSONObject recognitionFpzsExcel(JSONObject fileParam, IRecognitionListener recognitionListener) throws Exception {
        try (InputStream fileInputStream = null;){
            JSONObject recognitionResult;
            FileService service = FileServiceFactory.getAttachmentFileService();
            String fileUrl = fileParam.getString("fileUrl");
            fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(service.getInputStream(fileUrl));
            fileParam.put("inputResource", (Object)"fpzs");
            JSONObject jSONObject = recognitionResult = ExcelInvoiceUploadHelper.recognitionExcel(fileInputStream, fileParam, recognitionListener);
            return jSONObject;
        }
    }

    private static JSONObject recognitionExcel(InputStream fileInputStream, JSONObject fileParam, IRecognitionListener recognitionListener) throws Exception {
        JSONArray checkParamList = new JSONArray();
        JSONObject recognitionResult = new JSONObject();
        try {
            Workbook workbook = null;
            workbook = WorkbookFactory.create((InputStream)fileInputStream);
            if (workbook != null) {
                recognitionResult = ExcelInvoiceUploadHelper.resolveExcelCheckModel(checkParamList, workbook, fileParam, recognitionListener);
            }
            logger.info("excel\u89e3\u6790\u7ed3\u679c\uff1a" + checkParamList);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e);
            throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff08%1$s\uff09\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"ExcelInvoiceUploadHelper_17", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
        return recognitionResult;
    }

    public static JSONObject getResolveTaxExcelResult(InputStream fileInputStream, JSONObject fileParam, IRecognitionListener recognitionListener, JSONObject paramResult) {
        if (paramResult == null) {
            paramResult = new JSONObject();
        }
        Boolean isAdmin = fileParam.getBoolean("isAdmin");
        String fileName = fileParam.getString("fileName");
        String fileUrl = fileParam.getString("fileUrl");
        JSONArray checkParamList = new JSONArray();
        Workbook workbook = null;
        Boolean isEmptySheet = Boolean.TRUE;
        Closeable os = null;
        Closeable fin = null;
        try {
            workbook = WorkbookFactory.create((InputStream)fileInputStream);
            int numberOfSheet = workbook.getNumberOfSheets();
            Sheet mainSheet = null;
            Sheet itemSheet = null;
            for (int i = 0; i < numberOfSheet; ++i) {
                String sheetName = workbook.getSheetName(i);
                if ("\u53d1\u7968\u57fa\u7840\u4fe1\u606f".equals(sheetName)) {
                    mainSheet = workbook.getSheetAt(i);
                }
                if (!"\u4fe1\u606f\u6c47\u603b\u8868".equals(sheetName)) continue;
                itemSheet = workbook.getSheetAt(i);
            }
            if (mainSheet == null) {
                throw new MsgException("0002", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u540d\u4e3a'\u53d1\u7968\u57fa\u7840\u4fe1\u606f'\u7684sheet,\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u6b63\u786e", (String)"ExcelInvoiceUploadHelper_31", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (workbook != null) {
                Sheet firstSheet = mainSheet;
                Row firstRow = firstSheet.getRow(0);
                if (firstRow == null || firstRow.getCell(0) == null) {
                    throw new MsgException("0001", ResManager.loadKDString((String)"\u8bfb\u53d6\u7b2c\u4e00\u884c\u6570\u636e\u5931\u8d25", (String)"ExcelInvoiceUploadHelper_19", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                Object[] invoiceArray = ExcelInvoiceUploadHelper.analyzeTaxExcel(firstSheet, "invoice");
                if (ObjectUtils.isEmpty((Object[])invoiceArray)) {
                    throw new MsgException("0001", ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u53d1\u7968\u6570\u636e\u4e3a\u7a7a", (String)"ExcelInvoiceUploadHelper_20", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                JSONObject[] itemsArray = null;
                if (itemSheet != null) {
                    itemsArray = ExcelInvoiceUploadHelper.analyzeTaxExcel(itemSheet, "items");
                }
                HashMap<String, JSONArray> itemMap = new HashMap<String, JSONArray>(8);
                if (itemsArray != null && itemsArray.length > 0) {
                    for (JSONObject object : itemsArray) {
                        String uniqueKey = TaxInvoiceExcelImportTask.getUniqueKey(object);
                        JSONArray list = itemMap.getOrDefault(uniqueKey, new JSONArray());
                        list.add((Object)object);
                        itemMap.put(uniqueKey, list);
                    }
                }
                TaxInvoiceExcelImportTask taxInvoiceExcelImportTask = new TaxInvoiceExcelImportTask(RequestContext.get(), (JSONObject[])invoiceArray, fileName, fileUrl, workbook, itemMap);
                ThreadPools.executeOnce((String)"tax_invoice_excel_import_task", (Runnable)taxInvoiceExcelImportTask);
            }
            paramResult.put("tipDescription", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85\uff01\u60a8\u53ef\u4ee5\u70b9\u51fb\u3010\u67e5\u770b\u53d1\u7968\u5f15\u5165\u7ed3\u679c\u3011\u67e5\u770b\u8fdb\u5ea6\u5e76\u4e0b\u8f7d\u7ed3\u679c", (String)"ExcelInvoiceUploadHelper_6", (String)"imc-rim-common", (Object[])new Object[0]));
            JSONObject resultData = new JSONObject();
            resultData.put("successData", (Object)checkParamList);
            resultData.put("failData", (Object)new JSONArray());
            JSONObject jSONObject = resultData;
            return jSONObject;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e);
            throw new MsgException(e, ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u7a0e\u5c40\u6a21\u677f\u53ef\u80fd\u5df2\u7ecf\u53d8\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"ExcelInvoiceUploadHelper_21", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        finally {
            IOUtils.closeQuietly((Closeable)fileInputStream);
            IOUtils.closeQuietly(fin);
            IOUtils.closeQuietly(os);
            ExcelInvoiceUploadHelper.closeModule(recognitionListener, fileUrl, fileName);
        }
    }

    private static JSONObject[] analyzeTaxExcel(Sheet sheet, String type) {
        int invoiceStart = 1;
        Row fieldRow = sheet.getRow(0);
        int invoiceLast = sheet.getLastRowNum();
        JSONObject[] invoiceArray = new JSONObject[invoiceLast - invoiceStart + 1];
        for (int cIndex = fieldRow.getFirstCellNum(); cIndex < fieldRow.getLastCellNum(); ++cIndex) {
            Cell fieldCell = fieldRow.getCell(cIndex);
            if (fieldCell == null || StringUtils.isBlank((CharSequence)fieldCell.getStringCellValue())) {
                logger.info("\u7edf\u8ba1\u786e\u8ba4\u53d1\u7968\u5bfc\u5165\uff0c\u89e3\u6790excel\uff0c\u5b57\u6bb5\u540d\u4e3a\u7a7a\uff0c\u5ffd\u7565");
                continue;
            }
            String fieldName = ExcelInvoiceImportUtil.invoiceCell2Name(fieldCell.getStringCellValue(), type);
            for (int rIndex = invoiceStart; rIndex <= invoiceLast; ++rIndex) {
                int invoiceIndex = rIndex - invoiceStart;
                Cell cell = sheet.getRow(rIndex).getCell(cIndex);
                if (cell == null) continue;
                if (invoiceArray[invoiceIndex] == null) {
                    invoiceArray[invoiceIndex] = new JSONObject();
                }
                CellType cellType = cell.getCellType();
                invoiceArray[invoiceIndex].put("row", (Object)rIndex);
                if (CellType.NUMERIC.equals((Object)cellType)) {
                    BigDecimal val = BigDecimalUtil.transDecimal(cell.getNumericCellValue());
                    String strVal = "invoiceCode".equals(fieldName) || "invoiceNo".equals(fieldName) || "eleInvoiceNo".equals(fieldName) || "goodsCode".equals(fieldName) ? val.stripTrailingZeros().toPlainString() : BigDecimalUtil.format(val);
                    invoiceArray[invoiceIndex].put(fieldName, (Object)strVal);
                    continue;
                }
                invoiceArray[invoiceIndex].put(fieldName, (Object)cell.getStringCellValue());
            }
        }
        return invoiceArray;
    }
}

