/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.helper;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ImcSaveServiceHelper
extends SaveServiceHelper {
    private static final int DEFULT_SIZE = 300000;

    public static Object save(DynamicObject dynamicObject) {
        Object[] objects = ImcSaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return objects[0];
    }

    public static Object[] save(List<DynamicObject> dynamicObjectList) {
        return SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
    }

    public static void update(List<DynamicObject> dynamicObjectList) {
        SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
    }

    public static Object[] saveMassBatchList(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return new Object[0];
        }
        int size = dynamicObjectList.size();
        int max = RimConfigUtils.getPageSizeFromConfig(300000, "one_save_max_size");
        if (max < 1) {
            max = 300000;
        }
        if (size > max) {
            Object[] result = new Object[]{};
            List<List<DynamicObject>> lists = ListUtils.splitList(dynamicObjectList, max);
            for (List<DynamicObject> list : lists) {
                Object[] rtn = ImcSaveServiceHelper.save(list);
                result = ArrayUtils.addAll((Object[])result, (Object[])rtn);
            }
            return result;
        }
        return ImcSaveServiceHelper.save(dynamicObjectList);
    }

    public static void deleteMassBatch(String entityName, QFilter[] qFilters) {
        if (StringUtils.isEmpty((String)entityName) || ObjectUtils.isEmpty((Object[])qFilters)) {
            return;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        List<Object> primaryKeys = collection.stream().map(s -> s.get("id")).collect(Collectors.toList());
        DBUtils.deleteByIds(entityName, primaryKeys);
    }
}

