/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.aws.ofd.util.analysis.OfdReadUtils;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.constant.FpzsConstant;
import kd.imc.rim.common.constant.InputInvoiceConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.model.annotation.OverseaMerge;
import kd.imc.rim.common.invoice.model.type.OtherInvoice;
import kd.imc.rim.common.invoice.model.type.OverSeaInvoice;
import kd.imc.rim.common.invoice.recognitionnew.RecognitionFactory;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionParam;
import kd.imc.rim.common.invoice.recognitionnew.model.RecognitionResult;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.FormFileEntity;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.ItextPdfUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.utils.Lists;

public class RecognitionCheckHelper {
    private static Log logger = LogFactory.getLog(RecognitionCheckHelper.class);
    private static final String awsRecognitionImpl = "kd.imc.rim.common.invoice.recognitionnew.impl.AwsRecognitionService";
    private static final String HANGXINCHECKSERIVCESTR = "kd.imc.rim.common.invoice.checknew.impl.HangxinCheckService";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public List<JSONObject> recognitionInvoiceFile(FormFileEntity fileEntity, Map<String, Object> extMap) throws Exception {
        ArrayList resultList = Lists.newArrayList();
        List<FormFileEntity> fileEntityList = fileEntity.getSubFileList();
        if (fileEntityList == null || fileEntityList.isEmpty()) {
            fileEntityList = new ArrayList<FormFileEntity>(1);
            fileEntityList.add(fileEntity);
        }
        int pageNo = 0;
        Map<String, String> configMap = ImcConfigUtil.getValue("rim_recog_check");
        String recognitionImplStr = configMap.get("rimpl");
        boolean isAwsRecognition = StringUtils.isEmpty((CharSequence)recognitionImplStr) || awsRecognitionImpl.equals(recognitionImplStr);
        String cachhour = configMap.get("cache_hour");
        int cacheHour = 24;
        if (!StringUtils.isEmpty((CharSequence)cachhour) && (cacheHour = BigDecimalUtil.transDecimal(configMap.get("cache_hour")).intValue()) < 0) {
            cacheHour = 0;
        }
        String overseaAppCode = this.getOverseaAppCode(configMap);
        for (FormFileEntity entity : fileEntityList) {
            ++pageNo;
            String fileName = entity.getFileName();
            InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(entity.getFileUrl()));
            Throwable throwable = null;
            try {
                if (fileEntityList.isEmpty()) {
                    fileEntity.setFileSize(fileInputStream.available());
                }
                byte[] streamByte = FileUtils.getByte(fileInputStream);
                String fileHash = FileConvertUtils.getSHA256((byte[])streamByte);
                long threadCount = 0L;
                boolean exceptionDecr = false;
                int countTimeOut = 60;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(streamByte);
                    Throwable throwable2 = null;
                    try {
                        RecognitionParam recognitionParam = new RecognitionParam(byteArrayInputStream, extMap);
                        recognitionParam.setFileName(fileName);
                        recognitionParam.setLocalUrl(fileEntity.getFileUrl());
                        recognitionParam.setLocalHash(fileEntity.getFileHash());
                        recognitionParam.setRecogConfigMap(configMap);
                        if (StringUtils.isEmpty((CharSequence)recognitionParam.getLocalHash())) {
                            recognitionParam.setLocalHash(fileHash);
                        }
                        recognitionParam.setFileUrl(entity.getFileUrl());
                        recognitionParam.setPageNo(pageNo);
                        recognitionParam.setCacheHour(cacheHour);
                        if (extMap.get("recogType") != null) {
                            recognitionParam.setRecogType(extMap.get("recogType").toString());
                            recognitionParam.setAppCode(overseaAppCode);
                        }
                        RecognitionResult recognitionResult = new RecognitionResult();
                        JSONObject analysisInvoiceInfo = entity.getInvoiceInfo();
                        boolean resultFlag = false;
                        boolean isMore = false;
                        if (analysisInvoiceInfo != null) {
                            Object invoice = analysisInvoiceInfo.get((Object)"invoice");
                            if (invoice == null) {
                                invoice = analysisInvoiceInfo;
                            } else {
                                isMore = true;
                            }
                            resultFlag = this.getValidateFlag(invoice);
                        }
                        if (resultFlag) {
                            ArrayList entityList = Lists.newArrayList();
                            JSONArray invoiceArray = new JSONArray();
                            if (isMore) {
                                invoiceArray.addAll((Collection)analysisInvoiceInfo.getJSONArray("invoice"));
                            } else {
                                invoiceArray.add((Object)analysisInvoiceInfo);
                            }
                            String itemsKey = "items";
                            ConvertFieldUtil.convertRecognitionEntity(entityList, invoiceArray, itemsKey, "item");
                            recognitionResult.setErrcode("0000");
                            recognitionResult.setData(entityList);
                            logger.info("\u8bc6\u522b\u7ed3\u679c\u53d6pdf\u89e3\u6790..");
                        } else {
                            exceptionDecr = true;
                            threadCount = CacheHelper.inc("recogThread", countTimeOut);
                            logger.info("\u8bc6\u522b\u7ebf\u7a0b\u6570\u91cf{}", (Object)threadCount);
                            recognitionResult = RecognitionFactory.getRecognitionService(recognitionImplStr).recognitionInvoice(recognitionParam);
                            threadCount = CacheHelper.decr("recogThread", countTimeOut);
                            exceptionDecr = false;
                        }
                        if (recognitionResult == null) continue;
                        if (!"0000".equals(recognitionResult.getErrcode())) {
                            StringBuilder sb = this.getMsgExceptionInfo(recognitionResult);
                            throw new MsgException(sb.toString());
                        }
                        List recognitionDataList = recognitionResult.getData();
                        String salelistposturl = configMap.get("salelistposturl");
                        if (!StringUtils.isEmpty((CharSequence)salelistposturl)) {
                            try (ByteArrayInputStream saleListByteArrayStream = new ByteArrayInputStream(streamByte);){
                                RecognitionParam saleListParam = new RecognitionParam(saleListByteArrayStream, extMap);
                                saleListParam.setFileName(fileName);
                                saleListParam.setRecogConfigMap(configMap);
                                this.saleListRecognition(recognitionDataList, saleListParam);
                            }
                        }
                        this.supRecognitionInfo(recognitionDataList, isAwsRecognition, fileHash, fileName, pageNo, resultList, configMap);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (byteArrayInputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        byteArrayInputStream.close();
                    }
                }
                catch (Throwable t) {
                    if (exceptionDecr && threadCount > 0L) {
                        threadCount = CacheHelper.decr("recogThread", countTimeOut);
                    }
                    logger.error("ByteArrayInputStream error:", t);
                    throw t;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (fileInputStream == null) continue;
                if (throwable != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                fileInputStream.close();
            }
        }
        this.mergeOverseaInvoice(resultList);
        this.mergeCustomInvoice(resultList);
        return resultList;
    }

    private void mergeCustomInvoice(List<JSONObject> resultList) {
        if (resultList.size() > 0) {
            List<JSONObject> result;
            List customList = resultList.stream().filter(f -> InputInvoiceTypeEnum.HGJKS.getCode().equals(f.getLong("invoiceType"))).collect(Collectors.toList());
            if (customList.size() == 0 || customList.size() == 1) {
                return;
            }
            HashMap groupCustom = Maps.newHashMap();
            for (JSONObject customInfo : customList) {
                String customDeclarationNo = customInfo.getString("customDeclarationNo");
                JSONArray array = new JSONArray();
                if (groupCustom.containsKey(customDeclarationNo)) {
                    array = (JSONArray)groupCustom.get(customDeclarationNo);
                }
                array.add((Object)customInfo);
                groupCustom.put(customDeclarationNo, array);
            }
            if (!groupCustom.isEmpty() && (result = this.mergeCustomGroup(groupCustom)).size() > 0) {
                resultList.removeAll(customList);
                resultList.addAll(result);
            }
        }
    }

    private List<JSONObject> mergeCustomGroup(HashMap<String, JSONArray> groupCustom) {
        ArrayList mergeResult = Lists.newArrayList();
        if (groupCustom == null) {
            return mergeResult;
        }
        for (Map.Entry<String, JSONArray> entry : groupCustom.entrySet()) {
            JSONArray customArray = entry.getValue();
            if (customArray == null) continue;
            int size = customArray.size();
            JSONObject lastPageInfo = customArray.getJSONObject(size - 1);
            JSONArray items = new JSONArray();
            for (int i = 0; i < size; ++i) {
                JSONObject obj = customArray.getJSONObject(i);
                if (obj.getJSONArray("items") == null) continue;
                items.addAll((Collection)obj.getJSONArray("items"));
            }
            lastPageInfo.put("items", (Object)items);
            mergeResult.add(lastPageInfo);
        }
        return mergeResult;
    }

    private void mergeOverseaInvoice(List<JSONObject> resultList) {
        if (resultList.size() > 0) {
            List<JSONObject> overSeaList = resultList.stream().filter(f -> InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(f.getLong("invoiceType"))).collect(Collectors.toList());
            if (overSeaList.size() == 0) {
                return;
            }
            List noList = overSeaList.stream().filter(f -> StringUtils.isNotEmpty((CharSequence)f.getString("invoiceNo"))).map(m -> m.getString("invoiceNo")).collect(Collectors.toList());
            String invoiceNo = "";
            for (JSONObject overseaInvoice : overSeaList) {
                String overseaNo = overseaInvoice.getString("invoiceNo");
                if (StringUtils.isEmpty((CharSequence)overseaNo)) {
                    if (StringUtils.isEmpty((CharSequence)invoiceNo) && noList.size() > 0) {
                        invoiceNo = (String)noList.get(0);
                    }
                    overseaInvoice.put("invoiceNo", (Object)invoiceNo);
                    continue;
                }
                invoiceNo = overseaNo;
            }
            List<Integer> indexList = RecognitionCheckHelper.findIndex(overSeaList);
            if (!CollectionUtils.isEmpty(indexList)) {
                int i;
                resultList.removeAll(overSeaList);
                ArrayList subOverseaList = Lists.newArrayList();
                int subIndex = 0;
                for (i = 0; i < indexList.size(); ++i) {
                    subOverseaList.add(overSeaList.subList(subIndex, indexList.get(i) + 1));
                    subIndex = indexList.get(i) + 1;
                }
                for (i = 0; i < subOverseaList.size(); ++i) {
                    List subOverseas = (List)subOverseaList.get(i);
                    JSONObject mergeResult = this.mergeSubOversea(subOverseas);
                    if (mergeResult != null) {
                        String currencyName;
                        QFilter filter;
                        DynamicObject obj;
                        boolean isPass = ConvertFieldUtil.checkNullValidate(mergeResult, OverSeaInvoice.class);
                        if (isPass) {
                            mergeResult.put("serialNo", (Object)UUID.randomUUID());
                        }
                        if ((obj = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{filter = new QFilter("number", "=", (Object)(currencyName = mergeResult.getString("currencyName"))).or("name", "=", (Object)currencyName)})) == null) {
                            mergeResult.put("serialNo", (Object)"");
                        } else {
                            mergeResult.put("currencyName", (Object)obj.getString("name"));
                            mergeResult.put("currencyId", obj.get("id"));
                        }
                    }
                    resultList.add(mergeResult);
                }
            }
        }
    }

    private JSONObject mergeSubOversea(List<JSONObject> subOverseas) {
        List<String> fields;
        if (CollectionUtils.isEmpty(subOverseas) || subOverseas.size() == 0) {
            return null;
        }
        int size = subOverseas.size();
        if (size == 1) {
            return subOverseas.get(0);
        }
        JSONArray items = new JSONArray();
        for (JSONObject subInfo : subOverseas) {
            if (subInfo.getJSONArray("items") == null) continue;
            items.addAll((Collection)subInfo.getJSONArray("items"));
        }
        JSONObject lastObj = subOverseas.get(subOverseas.size() - 1);
        JSONObject firstObj = subOverseas.get(0);
        lastObj.put("pageNo", firstObj.get((Object)"pageNo"));
        List<Object> otherObj = Lists.newArrayList();
        if (subOverseas.size() > 2) {
            otherObj = subOverseas.subList(1, subOverseas.size() - 1);
        }
        if ((fields = this.getMergeField()).size() > 0) {
            block1: for (String field : fields) {
                Object value = lastObj.get((Object)field);
                if (value != null && StringUtils.isNotEmpty((CharSequence)value.toString())) continue;
                Object firstValue = firstObj.get((Object)field);
                if (firstValue != null && StringUtils.isNotEmpty((CharSequence)firstValue.toString())) {
                    lastObj.put(field, firstValue);
                    continue;
                }
                if (otherObj.size() == 0) continue;
                for (JSONObject jSONObject : otherObj) {
                    Object fieldVale = lastObj.get((Object)field);
                    if (fieldVale != null && StringUtils.isNotEmpty((CharSequence)fieldVale.toString())) continue block1;
                    Object otherValue = jSONObject.get((Object)field);
                    if (otherValue == null || !StringUtils.isNotEmpty((CharSequence)otherValue.toString())) continue;
                    lastObj.put(field, otherValue);
                }
            }
        }
        if (!items.isEmpty()) {
            lastObj.put("items", (Object)items);
        }
        return lastObj;
    }

    private List<String> getMergeField() {
        Field[] fields = OverSeaInvoice.class.getDeclaredFields();
        ArrayList result = Lists.newArrayList();
        for (Field f : fields) {
            OverseaMerge fieldAnnotation = f.getDeclaredAnnotation(OverseaMerge.class);
            if (fieldAnnotation == null) continue;
            result.add(f.getName());
        }
        return result;
    }

    private static List<Integer> findIndex(List<JSONObject> overSeaList) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (overSeaList.size() == 0) {
            return indices;
        }
        String previousChar = overSeaList.get(0).getString("invoiceNo");
        int lastIndex = 0;
        for (int i = 1; i < overSeaList.size(); ++i) {
            String invoiceNo = overSeaList.get(i).getString("invoiceNo");
            if (invoiceNo.equals(previousChar)) {
                lastIndex = i;
                continue;
            }
            indices.add(lastIndex);
            previousChar = invoiceNo;
            lastIndex = i;
        }
        indices.add(lastIndex);
        return indices;
    }

    private boolean getValidateFlag(Object analysisInvoiceInfo) {
        boolean resultFlag;
        block10: {
            block9: {
                if (analysisInvoiceInfo == null) {
                    return false;
                }
                resultFlag = false;
                if (!(analysisInvoiceInfo instanceof JSONObject)) break block9;
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(((JSONObject)analysisInvoiceInfo).getLong("invoiceType"))) {
                    return true;
                }
                boolean bl = resultFlag = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(((JSONObject)analysisInvoiceInfo).getLong("invoiceType")) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(((JSONObject)analysisInvoiceInfo).getLong("invoiceType"));
                if (resultFlag) break block10;
                resultFlag = this.checkParamValidate((JSONObject)analysisInvoiceInfo);
                break block10;
            }
            if (analysisInvoiceInfo instanceof JSONArray) {
                JSONArray array = (JSONArray)analysisInvoiceInfo;
                for (int i = 0; i < array.size(); ++i) {
                    if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(array.getJSONObject(i).getLong("invoiceType"))) {
                        resultFlag = true;
                        continue;
                    }
                    boolean bl = resultFlag = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(array.getJSONObject(i).getLong("invoiceType")) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(array.getJSONObject(i).getLong("invoiceType"));
                    if (resultFlag || (resultFlag = this.checkParamValidate(array.getJSONObject(i)))) continue;
                    return false;
                }
            } else if (analysisInvoiceInfo instanceof ArrayList) {
                List list = (List)analysisInvoiceInfo;
                for (Map map : list) {
                    if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(Long.parseLong(map.get("invoiceType") + ""))) {
                        resultFlag = true;
                        continue;
                    }
                    resultFlag = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(Long.parseLong(map.get("invoiceType") + "")) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(Long.parseLong(map.get("invoiceType") + ""));
                    if (resultFlag || (resultFlag = this.checkParamValidate(new JSONObject(map)))) continue;
                    return false;
                }
            }
        }
        return resultFlag;
    }

    public boolean checkParamValidate(JSONObject invoice) {
        String invoiceCode = invoice.getString("invoiceCode");
        String invoiceNo = invoice.getString("invoiceNo");
        String invoiceAmount = invoice.getString("invoiceAmount");
        String invoiceDate = invoice.getString("invoiceDate");
        boolean validate = StringUtils.isNotEmpty((CharSequence)invoiceCode) && StringUtils.isNotEmpty((CharSequence)invoiceNo) && StringUtils.isNotEmpty((CharSequence)invoiceAmount) && StringUtils.isNotEmpty((CharSequence)invoiceDate);
        Long invoiceType = invoice.getLong("invoiceType");
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType)) {
            String checkCode = invoice.getString("checkCode");
            return validate && StringUtils.isNotEmpty((CharSequence)checkCode);
        }
        return validate;
    }

    private String getOverseaAppCode(Map<String, String> configMap) {
        if (configMap == null) {
            return null;
        }
        String appCode = configMap.get("overappkey");
        String appSect = configMap.get("overappsecret");
        if (!StringUtils.isEmpty((CharSequence)appCode) && !StringUtils.isEmpty((CharSequence)appSect)) {
            String code = appCode + "@@@" + appSect;
            String retStr = Base64.encodeBase64String((byte[])code.getBytes());
            return retStr;
        }
        return null;
    }

    private void saleListRecognition(List<Object> recognitionDataList, RecognitionParam recognitionParam) {
        ArrayList resultList = Lists.newArrayList();
        recognitionDataList.stream().forEach(f -> {
            if (f instanceof OtherInvoice) {
                boolean titleCheck;
                OtherInvoice otherInvoice = (OtherInvoice)f;
                String invoiceCode = otherInvoice.getInvoiceCode();
                String invoiceNo = otherInvoice.getInvoiceNo();
                boolean emptyCheck = StringUtils.isNotEmpty((CharSequence)invoiceCode) && StringUtils.isNotEmpty((CharSequence)invoiceNo);
                boolean bl = titleCheck = StringUtils.isNotEmpty((CharSequence)otherInvoice.getTitle()) && otherInvoice.getTitle().contains("\u6e05\u5355");
                if (emptyCheck && titleCheck) {
                    try {
                        List<JSONObject> saleListRecognitionList = this.saleListPost(recognitionParam);
                        for (JSONObject saleList : saleListRecognitionList) {
                            String saleListCode = saleList.getString("invoiceCode");
                            String saleListNo = saleList.getString("invoiceNo");
                            String saleListPageNum = saleList.getString("pageNum");
                            if (!invoiceCode.equals(saleListCode) || !invoiceNo.equals(saleListNo)) continue;
                            otherInvoice.setPageNum(saleListPageNum);
                        }
                    }
                    catch (Exception e) {
                        logger.info("\u9500\u8d27\u6e05\u5355\u8bc6\u522b\u51fa\u9519\uff1a", (Object)e);
                    }
                }
            }
            resultList.add(f);
        });
    }

    private List<JSONObject> saleListPost(RecognitionParam recognitionParam) throws Exception {
        RecognitionResult recognitionResult = RecognitionFactory.getSaleListRecognitionService().recognitionInvoice(recognitionParam);
        if (recognitionResult != null && "0000".equals(recognitionResult.getErrcode())) {
            List data = recognitionResult.getData();
            return data.stream().filter(f -> {
                String invoiceCode = f.getString("invoiceCode");
                String invoiceNo = f.getString("invoiceNo");
                String pageNum = f.getString("pageNum");
                return StringUtils.isNotEmpty((CharSequence)invoiceCode) && StringUtils.isNotEmpty((CharSequence)invoiceNo) && StringUtils.isNotEmpty((CharSequence)pageNum);
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private StringBuilder getMsgExceptionInfo(RecognitionResult recognitionResult) {
        StringBuilder sb = new StringBuilder();
        String str = String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\uff0c\u8bc6\u522b\u63a5\u53e3\u8fd4\u56de\uff1a\u3010%1$s\u3011%2$s", (String)"RecognitionCheckHelper_1", (String)"imc-rim-common", (Object[])new Object[0]), recognitionResult.getErrcode(), recognitionResult.getDescription());
        sb.append(str);
        return sb;
    }

    private void supRecognitionInfo(List<Object> recognitionDataList, boolean isAwsRecognition, String fileHash, String fileName, int pageNo, List<JSONObject> resultList, Map<String, String> configMap) throws ParseException {
        if (recognitionDataList == null || recognitionDataList.size() == 0) {
            return;
        }
        String otherMust = ImcConfigUtil.getValue(configMap, "other_must", "0");
        for (Object object : recognitionDataList) {
            Long invoiceType;
            String invoiceStr;
            JSONObject recognitionInfo;
            if (object == null || (recognitionInfo = JSON.parseObject((String)(invoiceStr = JSONObject.toJSONString((Object)object)))) == null) continue;
            this.setMaxAmount(recognitionInfo);
            this.dealElectric(recognitionInfo);
            this.dealBlockChain(recognitionInfo);
            boolean isPass = false;
            if (object.getClass() != null) {
                invoiceType = recognitionInfo.getLong("invoiceType");
                if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
                    String invoiceDate = recognitionInfo.getString("invoiceDate");
                    String issueDate = recognitionInfo.getString("issueDate");
                    if (StringUtils.isNotBlank((CharSequence)issueDate)) {
                        Date date = recognitionInfo.getDate("issueDate");
                        if (StringUtils.isEmpty((CharSequence)invoiceDate) || "OPEN".equalsIgnoreCase(invoiceDate)) {
                            recognitionInfo.put("invoiceDate", (Object)DateUtils.format(date, "yyyy-MM-dd"));
                        }
                    }
                }
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                    recognitionInfo.putIfAbsent((Object)"otherTotalTaxAmount", (Object)BigDecimal.ZERO);
                    JSONArray items = recognitionInfo.getJSONArray("items");
                    if (items.size() > 0) {
                        JSONObject firstItem = items.getJSONObject(0);
                        RecognitionCheckHelper.setFirstItemValue(firstItem, recognitionInfo);
                    }
                }
                if ((isPass = ConvertFieldUtil.checkNullValidate(recognitionInfo, object.getClass())) && InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(invoiceType)) {
                    String invoiceCode = recognitionInfo.getString("invoiceCode");
                    String exit = recognitionInfo.getString("exit");
                    if (StringUtils.isEmpty((CharSequence)invoiceCode) && StringUtils.isEmpty((CharSequence)exit)) {
                        isPass = false;
                    }
                }
                if (isPass && InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
                    if ("1".equals(otherMust) && StringUtils.isEmpty((CharSequence)recognitionInfo.getString("invoiceNo"))) {
                        isPass = false;
                    }
                    if ("2".equals(otherMust) && (StringUtils.isEmpty((CharSequence)recognitionInfo.getString("invoiceNo")) || StringUtils.isEmpty((CharSequence)recognitionInfo.getString("invoiceCode")))) {
                        isPass = false;
                    }
                }
            }
            if (!isPass) {
                recognitionInfo.remove((Object)"serialNo");
            }
            if (isPass && StringUtils.isEmpty((CharSequence)recognitionInfo.getString("serialNo"))) {
                recognitionInfo.put("serialNo", (Object)UUID.randomUUID());
            }
            invoiceType = recognitionInfo.getLong("invoiceType");
            String currency_code = recognitionInfo.getString("currency_code");
            recognitionInfo.put("currency", (Object)InvoiceConvertUtils.changeCurrency(currency_code));
            if (!isAwsRecognition) {
                this.setOtherInfoByType(invoiceType, recognitionInfo);
            }
            if (!InvoiceConvertUtils.isVatInvoiceType(invoiceType)) {
                recognitionInfo.put("checkStatus", (Object)"1");
                this.recognitionInvoiceMix(recognitionInfo, invoiceType);
            }
            if (InvoiceConvertUtils.isSaleListInvoiceType(invoiceType)) {
                RecognitionCheckHelper.markSaleListInvoice(recognitionInfo);
            }
            recognitionInfo.put("fileHash", (Object)fileHash);
            recognitionInfo.put("pageNo", (Object)pageNo);
            recognitionInfo.put("fileName", (Object)fileName);
            resultList.add(recognitionInfo);
        }
    }

    public static void setFirstItemValue(JSONObject firstItem, JSONObject recognitionInfo) {
        if (firstItem == null) {
            return;
        }
        recognitionInfo.put("totalTaxAmount", recognitionInfo.get((Object)"taxAmount"));
        if (firstItem.getDate("carrierDate") != null) {
            recognitionInfo.put("carrierDate", (Object)DateUtils.format(firstItem.getDate("carrierDate"), "yyyy-MM-dd"));
        }
        if (firstItem.getString("flightNum") != null) {
            recognitionInfo.put("flightNum", (Object)firstItem.getString("flightNum"));
        }
        if (firstItem.getString("seatGrade") != null) {
            recognitionInfo.put("seatGrade", (Object)firstItem.getString("seatGrade"));
        }
        if (firstItem.getString("freeBaggageAllowance") != null) {
            recognitionInfo.put("freeBaggageAllowance", (Object)firstItem.getString("freeBaggageAllowance"));
        }
        if (firstItem.getString("airTime") != null) {
            recognitionInfo.put("airTime", (Object)firstItem.getString("airTime"));
        }
        if (firstItem.getString("carrier") != null) {
            recognitionInfo.put("carrier", (Object)firstItem.getString("carrier"));
        }
        if (firstItem.getString("fareBasis") != null) {
            recognitionInfo.put("fareBasis", (Object)firstItem.getString("fareBasis"));
        }
    }

    private void setMaxAmount(JSONObject recognitionInfo) {
        Set entries = recognitionInfo.entrySet();
        for (Map.Entry object : entries) {
            String valueObjStr;
            Object valueObj = object.getValue();
            if (!(valueObj instanceof BigDecimal) || BigDecimalUtil.transDecimal(valueObjStr = valueObj.toString().replace("-", "")).compareTo(FpzsConstant.sysMaxAmount) <= 0) continue;
            valueObj = BigDecimal.ZERO;
            logger.info("\u53d1\u7968{} \u8d85\u8fc7\u7cfb\u7edf\u91d1\u989d\u6700\u5927\u503c\uff1a{} \u7f6e\u4e3a0", object.getKey(), (Object)FpzsConstant.sysMaxAmount);
            recognitionInfo.put((String)object.getKey(), valueObj);
        }
    }

    private void dealBlockChain(JSONObject recognitionInfo) {
        String checkImplStr = RimConfigUtils.getConfig("rim_recog_check", "cimpl");
        boolean isHangxinCheck = HANGXINCHECKSERIVCESTR.equals(checkImplStr);
        boolean isBlockChainType = InvoiceConvertUtils.isBlockChainType(recognitionInfo.getString("invoiceCode"), recognitionInfo.getString("invoiceNo"));
        boolean isYunnanChainType = InvoiceConvertUtils.isYunNanBlockchain(recognitionInfo.getString("invoiceCode"), recognitionInfo.getString("invoiceNo"));
        if (isHangxinCheck && (isBlockChainType || isYunnanChainType)) {
            recognitionInfo.put("invoiceType", (Object)InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode());
        }
    }

    public static void markSaleListInvoice(JSONObject recognitionInfo) {
        String goodsName;
        JSONArray items = recognitionInfo.getJSONArray("items");
        recognitionInfo.put("isSaleListInvoice", (Object)"0");
        if (items != null && items.size() == 1 && StringUtils.isNotEmpty((CharSequence)(goodsName = items.getJSONObject(0).getString("goodsName"))) && goodsName.contains("\u8be6\u89c1") && goodsName.contains("\u6e05\u5355")) {
            recognitionInfo.put("isSaleListInvoice", (Object)"1");
        }
    }

    private void dealElectric(JSONObject recognitionInfo) {
        String invoiceNo = recognitionInfo.getString("invoiceNo");
        String invoiceCode = recognitionInfo.getString("invoiceCode");
        Long invoiceType = recognitionInfo.getLong("invoiceType");
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20 && InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) && StringUtils.isEmpty((CharSequence)invoiceCode)) {
            recognitionInfo.put("invoiceType", (Object)InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode());
            String serialNo = recognitionInfo.getString("serialNo");
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                recognitionInfo.put("serialNo", (Object)UUID.randomUUID());
            }
        }
    }

    public FormFileEntity getFormFileEntity(String url, String fileName) throws IOException {
        FormFileEntity fileEntity = new FormFileEntity(url, fileName);
        if (FileUtils.checkFileType(fileName, "pdf")) {
            return ItextPdfUtils.extractpdf(url, fileName);
        }
        if (FileUtils.checkFileType(fileName, "ofd")) {
            JSONObject result = this.ofdAnalysis(url);
            logger.info("ofd\u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)result);
            if (result != null) {
                fileEntity.setFileSize(BigDecimalUtil.transDecimal(result.getString("fileSize")).intValue());
            }
            fileEntity.setInvoiceInfo(result);
            fileEntity.setFileType("ofd");
            fileEntity.setSignatureFlag(Boolean.TRUE);
        } else {
            fileEntity.setFileType(FileUtils.getFileType(fileName));
        }
        return fileEntity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject ofdAnalysis(String fileUrl) {
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl));){
            byte[] streamByte = FileUtils.getByte(fileInputStream);
            if (streamByte == null) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject result = OfdReadUtils.readData((byte[])streamByte);
            Object invoice = result.get((Object)"invoice");
            if (invoice == null) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            result = JSON.parseObject((String)JSON.toJSONString((Object)invoice));
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(result.get((Object)"invoiceType") + "");
            result.put("invoiceType", (Object)invoiceType);
            result.put("fileSize", (Object)streamByte.length);
            JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            logger.info("ofdAnalysis exception :{}", (Object)e);
            return null;
        }
    }

    public Map<String, Object> getRecognitionCheckExtMap(JSONObject businessParam) {
        HashMap extMap = Maps.newHashMap();
        Long orgId = RequestContext.get().getOrgId();
        if (businessParam != null) {
            if (businessParam.getLong("org_id") != null) {
                orgId = businessParam.getLong("org_id");
            }
            extMap.put("recogType", businessParam.getString("recogType"));
        }
        String taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        extMap.put("eid", RequestContext.get().getUserId());
        extMap.put("orgId", orgId);
        extMap.put("taxNo", taxNo);
        return extMap;
    }

    public List<JSONObject> checkInvoiceByRecognitionInfo(List<JSONObject> recognitionResultList, Map<String, Object> extMap) {
        if (recognitionResultList == null || recognitionResultList.size() == 0) {
            return null;
        }
        ArrayList checkResultList = Lists.newArrayList();
        Iterator<JSONObject> iterator = recognitionResultList.iterator();
        while (iterator.hasNext()) {
            JSONObject invoiceInfo;
            JSONObject result = invoiceInfo = iterator.next();
            Long invoiceType = invoiceInfo.getLong("invoiceType");
            if (!InputInvoiceTypeEnum.needCheck(invoiceType).booleanValue()) {
                checkResultList.add(result);
                continue;
            }
            CheckParam checkParam = ConvertFieldUtil.getInvoiceCheckPart(invoiceInfo);
            if (checkParam == null) continue;
            try {
                Long orgId = (Long)extMap.get("orgId");
                String taxNo = (String)extMap.get("taxNo");
                CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo);
                if ("0000".equals(checkResult.getErrcode()) && checkResult.getData() != null) {
                    boolean typeFlag;
                    Object invoiceEntity = checkResult.getData();
                    String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                    JSONObject invoiceCheckInfo = JSON.parseObject((String)invoiceCheckStr);
                    this.putRecognitionInfo(invoiceCheckInfo, invoiceInfo);
                    if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                        invoiceInfo.putAll((Map)invoiceCheckInfo);
                        invoiceCheckInfo = this.mixAirEleData(invoiceInfo);
                    }
                    result = invoiceCheckInfo;
                    String originalStateDefault = (String)extMap.get("originalStateDefault");
                    boolean bl = typeFlag = InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType);
                    if ("1".equals(originalStateDefault) && typeFlag) {
                        result.put("originalState", (Object)"1");
                    }
                } else {
                    result = invoiceInfo;
                    result.put("checkStatus", (Object)"2");
                    result.put("errcode", (Object)checkResult.getErrcode());
                    result.put("description", (Object)checkResult.getDescription());
                }
            }
            catch (Exception e) {
                logger.info("\u67e5\u9a8c\u6b65\u9aa4\u62a5\u9519\uff1a", (Object)e);
                result.put("checkStatus", (Object)"2");
            }
            checkResultList.add(result);
        }
        return checkResultList;
    }

    private JSONObject mixAirEleData(JSONObject invoiceInfo) {
        if (invoiceInfo == null) {
            return new JSONObject();
        }
        invoiceInfo.put("totalTaxAmount", invoiceInfo.get((Object)"taxAmount"));
        Object issueDate = invoiceInfo.get((Object)"issueDate");
        if (issueDate instanceof Integer) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                Date date = sdf.parse(String.valueOf(issueDate));
                invoiceInfo.put("invoiceDate", (Object)date);
                invoiceInfo.put("issueDate", (Object)date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return invoiceInfo;
    }

    public static void markSaleListByCheckResult(JSONObject invoiceCheckInfo) {
        invoiceCheckInfo.put("isSaleListInvoice", (Object)"0");
        JSONArray items = invoiceCheckInfo.getJSONArray("items");
        if (items != null && items.size() > 8) {
            invoiceCheckInfo.put("isSaleListInvoice", (Object)"1");
            RecognitionCheckHelper.putSaleListSum(invoiceCheckInfo);
        }
    }

    private JSONObject putRecognitionInfo(JSONObject invoiceCheckInfo, JSONObject recognitionInfo) {
        Long invoiceType = recognitionInfo.getLong("invoiceType");
        if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
            this.compareRecognitionCheck(invoiceCheckInfo, recognitionInfo);
        }
        invoiceCheckInfo.put("continuousNo", recognitionInfo.get((Object)"continuousNo"));
        invoiceCheckInfo.put("currency", recognitionInfo.get((Object)"currency"));
        invoiceCheckInfo.put("barcode", recognitionInfo.get((Object)"barcode"));
        invoiceCheckInfo.put("qrcode", recognitionInfo.get((Object)"qrcode"));
        invoiceCheckInfo.put("companySeal", recognitionInfo.get((Object)"companySeal"));
        invoiceCheckInfo.put("region", recognitionInfo.get((Object)"region"));
        invoiceCheckInfo.put("rotationAngle", recognitionInfo.get((Object)"rotationAngle"));
        invoiceCheckInfo.put("pixel", recognitionInfo.get((Object)"pixel"));
        invoiceCheckInfo.put("pageNo", recognitionInfo.get((Object)"pageNo"));
        invoiceCheckInfo.put("fileName", recognitionInfo.get((Object)"fileName"));
        String checkStatus = invoiceCheckInfo.getString("checkStatus");
        String recognitionSaleList = recognitionInfo.getString("isSaleListInvoice");
        String checkSaleList = invoiceCheckInfo.getString("isSaleListInvoice");
        if ("1".equals(recognitionSaleList) || "1".equals(checkSaleList)) {
            invoiceCheckInfo.put("isSaleListInvoice", (Object)"1");
            if (!"1".equals(checkSaleList)) {
                RecognitionCheckHelper.putSaleListSum(invoiceCheckInfo);
            }
        }
        if (StringUtils.isEmpty((CharSequence)checkStatus)) {
            invoiceCheckInfo.put("checkStatus", (Object)"1");
            checkStatus = "1";
        }
        if ((InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType)) && "1".equals(checkStatus) && "1".equals(invoiceCheckInfo.getString("proxyMark"))) {
            invoiceCheckInfo.put("companySeal", (Object)"1");
        }
        return invoiceCheckInfo;
    }

    private void compareRecognitionCheck(JSONObject invoiceCheckInfo, JSONObject recognitionInfo) {
        JSONObject differences = new JSONObject();
        invoiceCheckInfo.forEach((key, value) -> {
            Object otherValue = recognitionInfo.get(key);
            if (!VerifyService.trimSpecialSymbols(value).equals(VerifyService.trimSpecialSymbols(otherValue))) {
                differences.put(key, otherValue);
            }
        });
        if (!differences.isEmpty()) {
            StringBuilder compareResult = new StringBuilder();
            Map<String, String> fieldMap = InputInvoiceConstant.eInvoiceCompareFields();
            for (Map.Entry<String, String> field : fieldMap.entrySet()) {
                if (!differences.containsKey((Object)field.getKey())) continue;
                compareResult.append(field.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)compareResult.toString())) {
                invoiceCheckInfo.put("compareResult", (Object)compareResult.substring(0, compareResult.length() - 1));
            }
        }
    }

    private static void putSaleListSum(JSONObject invoiceInfo) {
        int pageSum = 0;
        String attachNo = invoiceInfo.getString("invoiceCode") + "_" + invoiceInfo.getString("invoiceNo");
        QFilter qFilter = new QFilter("attach_no", "=", (Object)attachNo);
        String attachFields = MetadataUtil.getFields("rim_attach");
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach", (String)attachFields, (QFilter[])new QFilter[]{qFilter});
        if (attachCollect != null && attachCollect.length > 0) {
            for (DynamicObject attachInfo : attachCollect) {
                if (attachInfo.getInt("page_sum") == 0) continue;
                pageSum = attachInfo.getInt("page_sum");
                break;
            }
        }
        JSONArray items = invoiceInfo.getJSONArray("items");
        if (pageSum == 0) {
            double itemsNum = items.size();
            double sum = Math.ceil(itemsNum / 25.0);
            invoiceInfo.put("salelistSum", (Object)((int)sum == 0 ? 1 : (int)sum));
        } else {
            invoiceInfo.put("salelistSum", (Object)pageSum);
        }
    }

    private void setOtherInfoByType(Long invoiceType, JSONObject recognitionInfo) {
        String continuousNo = recognitionInfo.getString("continuousNo");
        String numberConfirm = recognitionInfo.getString("numberConfirm");
        String codeConfirm = recognitionInfo.getString("codeConfirm");
        if (StringUtils.isEmpty((CharSequence)continuousNo) && StringUtils.isNotEmpty((CharSequence)numberConfirm) && StringUtils.isNotEmpty((CharSequence)codeConfirm)) {
            String invoiceCode = recognitionInfo.getString("invoiceCode");
            String invoiceNo = recognitionInfo.getString("invoiceNo");
            boolean isCodeEquals = invoiceCode.equals(codeConfirm);
            boolean isNoEquals = invoiceNo.equals(numberConfirm);
            recognitionInfo.put("continuousNo", (Object)"0");
            if (!isCodeEquals || !isNoEquals) {
                recognitionInfo.put("continuousNo", (Object)"1");
            }
        }
        if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(invoiceType)) {
            boolean isEquals;
            BigDecimal surcharge = recognitionInfo.getBigDecimal("surcharge");
            BigDecimal totalAmount = recognitionInfo.getBigDecimal("totalAmount") == null ? BigDecimal.ZERO : recognitionInfo.getBigDecimal("totalAmount");
            BigDecimal fare = recognitionInfo.getBigDecimal("fare") == null ? BigDecimal.ZERO : recognitionInfo.getBigDecimal("fare");
            boolean bl = isEquals = totalAmount.compareTo(fare) == 0;
            if (isEquals && surcharge != null) {
                recognitionInfo.put("totalAmount", (Object)totalAmount.add(surcharge));
            }
        }
    }

    private void recognitionInvoiceMix(JSONObject recognitionInfo, Long invoiceType) {
        String serialNo = recognitionInfo.getString("serialNo");
        if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
            this.invoiceCollectService.convertUnVatInvoice(recognitionInfo, false);
        } else {
            this.convertFalseField(invoiceType, recognitionInfo);
        }
    }

    private void convertFalseField(Long invoiceType, JSONObject recognitionInfo) {
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            recognitionInfo.put("printingSequenceNo", (Object)recognitionInfo.getString("sequenceNo"));
            recognitionInfo.put("seat", (Object)recognitionInfo.getString("seatGrade"));
            recognitionInfo.put("customerIdentityNum", (Object)recognitionInfo.getString("customerIdNo"));
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            recognitionInfo.put("electronicTicketNum", (Object)recognitionInfo.getString("eticketNo"));
            recognitionInfo.put("customerIdentityNum", (Object)recognitionInfo.getString("customerIdNo"));
            recognitionInfo.put("otherTotalTaxAmount", (Object)recognitionInfo.getString("otherAmount"));
        }
    }

    public JSONArray bindAttachInvoice(JSONArray targetArray, JSONObject businessParam) {
        return this.bindAttachInvoice(targetArray, businessParam, new HashMap<String, Long>(0));
    }

    public JSONArray bindAttachInvoice(JSONArray targetArray, JSONObject businessParam, Map<String, Long> invoiceTypeMap) {
        JSONArray attachArray = new JSONArray();
        if (targetArray.size() == 0) {
            return attachArray;
        }
        targetArray.stream().forEach(i -> {
            boolean salerInvoiceType;
            JSONObject invoiceInfo = (JSONObject)i;
            int pageNo = invoiceInfo.getInteger("pageNo");
            boolean originalCheck = "1".equals(invoiceInfo.getString("originalState"));
            String invoiceCode = invoiceInfo.getString("invoiceCode");
            String invoiceNo = invoiceInfo.getString("invoiceNo");
            Long invoiceType = (Long)invoiceTypeMap.get(StringUtils.trimToEmpty((String)invoiceCode) + StringUtils.trimToEmpty((String)invoiceNo));
            boolean bl = salerInvoiceType = invoiceType == null || InvoiceConvertUtils.isSaleListInvoiceType(invoiceType);
            if (!originalCheck && salerInvoiceType) {
                DynamicObject attachObject = this.getAttachDynamicObject(invoiceInfo, businessParam);
                DynamicObject attachSaveObject = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachObject})[0];
                JSONObject attachInfo = new JSONObject(DynamicObjectUtil.dynamicObject2Map(attachSaveObject));
                attachInfo.put("invoiceCode", (Object)invoiceCode);
                attachInfo.put("invoiceNo", (Object)invoiceNo);
                DynamicObject attachTypeObj = BusinessDataServiceHelper.loadSingle((Object)1503642129396971520L, (String)"bdm_attach_type");
                attachInfo.put("simplify_name", (Object)attachTypeObj.getString("simplify_name"));
                attachInfo.put("attach_category_grid", (Object)attachTypeObj.getString("name"));
                attachInfo.put("serialNo", (Object)MD5.md5Hex(attachObject.get("id").toString()));
                attachInfo.put("pageNo", (Object)pageNo);
                long attachId = (Long)attachSaveObject.getPkValue();
                QFilter codeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
                QFilter noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
                Long[] vatTypes = InputInvoiceTypeEnum.getVatTypes();
                QFilter typeFilter = new QFilter("invoice_type", "in", (Object)vatTypes);
                String mainFields = MetadataUtil.getFields("rim_invoice");
                DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{codeFilter, noFilter, typeFilter});
                if (invoiceObject != null) {
                    int page_sum;
                    attachInfo.put("isVat", (Object)"1");
                    DynamicObject attachRelationObject = this.getAttachRelationDynamicObject(attachId, invoiceObject.getString("serial_no"));
                    if (attachRelationObject != null) {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachRelationObject});
                    }
                    if ((page_sum = attachInfo.getInteger("page_sum").intValue()) != 0) {
                        invoiceObject.set("salelist_sum", (Object)page_sum);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
                    }
                }
                attachArray.add((Object)attachInfo);
            }
        });
        return attachArray;
    }

    private DynamicObject getAttachRelationDynamicObject(long attachId, String serialNo) {
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_attach_relation", (String)"id", (QFilter[])new QFilter[]{new QFilter("attach_id", "=", (Object)String.valueOf(attachId))});
        if (collect.size() > 0) {
            return null;
        }
        DynamicObject relationObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
        relationObject.set("attach_id", (Object)attachId);
        relationObject.set("relation_type", (Object)3);
        relationObject.set("relation_id", (Object)serialNo);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"rim_attach_relation", (String)"expense_id", (QFilter[])new QFilter[]{new QFilter("relation_id", "=", (Object)serialNo)});
        if (dynamicObject != null) {
            relationObject.set("expense_id", (Object)dynamicObject.getString("expense_id"));
        }
        return relationObject;
    }

    private DynamicObject getAttachDynamicObject(JSONObject invoiceInfo, JSONObject businessParam) {
        String fileExtension;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        StringBuilder attachNoSb = new StringBuilder();
        attachNoSb.append(invoiceInfo.getString("invoiceCode")).append('_');
        attachNoSb.append(invoiceInfo.getString("invoiceNo"));
        String attachNo = attachNoSb.toString();
        QFilter filter1 = new QFilter("attach_no", "=", (Object)attachNo);
        QFilter filter2 = new QFilter("attach_category", "=", (Object)AttachConstant.ATTACH_LIST_CATEGORY_ID);
        QFilter filter3 = new QFilter("attach_hash_value", "=", (Object)invoiceInfo.getString("fileHash"));
        DynamicObject idObject = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        DynamicObject attachObject = null;
        boolean pdfFlag = "1".equals(invoiceInfo.getString("fileType"));
        if (idObject == null || pdfFlag) {
            attachObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
            attachObject.set("create_time", (Object)new Date());
        } else {
            attachObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"rim_attach");
        }
        attachObject.set("update_time", (Object)new Date());
        attachObject.set("user", (Object)userId);
        if (businessParam != null) {
            attachObject.set("rim_user", businessParam.get((Object)"rim_user"));
        }
        attachObject.set("attach_no", (Object)attachNo);
        attachObject.set("attach_url", (Object)invoiceInfo.getString("snapshotUrl"));
        String subFileName = invoiceInfo.getString("subFileName");
        if (StringUtils.isNotEmpty((CharSequence)subFileName)) {
            attachObject.set("attach_type", (Object)"2");
            attachObject.set("attach_name", (Object)subFileName);
            fileExtension = subFileName.substring(subFileName.lastIndexOf(46) + 1);
            attachObject.set("file_extension", (Object)fileExtension);
        } else {
            attachObject.set("attach_type", (Object)invoiceInfo.getString("fileType"));
            attachObject.set("attach_name", (Object)invoiceInfo.getString("fileName"));
            fileExtension = invoiceInfo.getString("fileName").substring(invoiceInfo.getString("fileName").lastIndexOf(46) + 1);
            attachObject.set("file_extension", (Object)fileExtension);
        }
        attachObject.set("attach_category", (Object)AttachConstant.ATTACH_LIST_CATEGORY_ID);
        attachObject.set("original_name", (Object)invoiceInfo.getString("fileName"));
        attachObject.set("snapshot_url", (Object)invoiceInfo.getString("snapshotUrl"));
        attachObject.set("icon_url", (Object)invoiceInfo.getString("snapshotUrl"));
        attachObject.set("attach_hash_value", (Object)invoiceInfo.getString("fileHash"));
        String pageNum = invoiceInfo.getString("pageNum");
        if (StringUtils.isNotEmpty((CharSequence)pageNum)) {
            try {
                String target = pageNum.replaceAll(" ", "");
                String subStr = target.substring(0, target.length() - 1);
                int index = subStr.indexOf(20849);
                int index2 = subStr.indexOf(39029);
                int index3 = subStr.indexOf(31532);
                String pageSum = target.substring(index, index2).substring(1);
                String pageNo = target.substring(index3, subStr.length()).substring(1);
                attachObject.set("page_sum", (Object)Integer.valueOf(pageSum));
                attachObject.set("page_no", (Object)Integer.valueOf(pageNo));
            }
            catch (Exception e) {
                logger.info("\u622a\u53d6\u603b\u9875\u7801\u5931\u8d25\uff1a", (Object)e);
            }
        }
        return attachObject;
    }

    public JSONArray getTargetArray(JSONArray finalResult) {
        return finalResult.stream().filter(f -> {
            JSONObject invoiceInfo = (JSONObject)f;
            return RecognitionCheckHelper.isSalePage(invoiceInfo);
        }).collect(Collectors.toCollection(JSONArray::new));
    }

    public static boolean isSalePage(JSONObject invoiceInfo) {
        boolean titleCheck;
        String invoiceCode = invoiceInfo.getString("invoiceCode");
        String invoiceNo = invoiceInfo.getString("invoiceNo");
        boolean typeCheck = InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceInfo.getLong("invoiceType"));
        boolean emptyCheck = StringUtils.isNotEmpty((CharSequence)invoiceCode) && StringUtils.isNotEmpty((CharSequence)invoiceNo);
        String title = invoiceInfo.getString("title");
        boolean bl = titleCheck = StringUtils.isNotEmpty((CharSequence)title) && (title.contains("\u6e05\u5355") || title.contains("\u660e\u7ec6"));
        return typeCheck && emptyCheck && titleCheck;
    }

    public void dealInvoiceAttachRelation(JSONObject invoiceInfo) {
        if (invoiceInfo == null) {
            return;
        }
        logger.info("\u5904\u7406\u53d1\u7968\u7ed1\u5b9a\u9644\u4ef6\u5173\u7cfb....");
        String invoiceCode = invoiceInfo.getString("invoiceCode");
        String invoiceNo = invoiceInfo.getString("invoiceNo");
        invoiceCode = StringUtils.isNotEmpty((CharSequence)invoiceCode) ? invoiceCode : invoiceInfo.getString("invoice_code");
        invoiceNo = StringUtils.isNotEmpty((CharSequence)invoiceNo) ? invoiceNo : invoiceInfo.getString("invoice_no");
        StringBuilder attachNo = new StringBuilder();
        attachNo.append(invoiceCode).append('_').append(invoiceNo);
        DynamicObjectCollection attachCollect = this.getAttachDynamicByAttachNo(attachNo.toString());
        for (DynamicObject attachInfo : attachCollect) {
            String[] codeNo;
            String targetCode = attachInfo.getString("attach_no");
            if (!StringUtils.isNotEmpty((CharSequence)targetCode) || (codeNo = targetCode.split("_")).length != 2 || !invoiceCode.equals(codeNo[0]) || !invoiceNo.equals(codeNo[1])) continue;
            DynamicObject attachRelationObject = this.getAttachRelationDynamicObject(attachInfo.getLong("id"), invoiceInfo.getString("serialNo"));
            if (attachRelationObject != null) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachRelationObject});
            }
            logger.info("\u53d1\u7968\u7ed1\u5b9a\u9644\u4ef6\u5173\u7cfb\u4fdd\u5b58\u6210\u529f....");
        }
        JSONObject numObject = this.calcSaleListComplete(invoiceCode, invoiceNo, attachNo.toString());
        invoiceInfo.put("salelistSum", (Object)numObject.getString("salelistSum"));
        invoiceInfo.put("bindNum", (Object)numObject.getString("bindNum"));
    }

    public JSONObject calcSaleListComplete(String invoiceCode, String invoiceNo, String attachNo) {
        String mainFields;
        DynamicObject mainObject;
        logger.info("\u8ba1\u7b97\u6e05\u5355\u5b8c\u6574\u6027,{},{}", (Object)invoiceCode, (Object)invoiceNo);
        JSONObject numObject = new JSONObject();
        int saleListSum = 0;
        QFilter attachNoFilter = new QFilter("attach_no", "=", (Object)attachNo);
        String attachFields = MetadataUtil.getFields("rim_attach");
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach", (String)attachFields, (QFilter[])new QFilter[]{attachNoFilter});
        int bindNum = 0;
        if (attachCollect != null && attachCollect.length > 0) {
            String url = RimConfigUtils.getConfig("rim_recog_check", "salelistposturl");
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                Set numSet = Arrays.stream(attachCollect).filter(f -> {
                    if (f.getInt("page_no") == 0) {
                        return false;
                    }
                    Long attachId = f.getLong("id");
                    boolean isBind = this.checkBind(attachId);
                    return isBind;
                }).map(m -> m.getInt("page_no")).collect(Collectors.toSet());
                bindNum = numSet.size();
            } else {
                for (DynamicObject attachObject : attachCollect) {
                    Long attachId = attachObject.getLong("id");
                    boolean isBind = this.checkBind(attachId);
                    if (!isBind) continue;
                    ++bindNum;
                }
            }
        }
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20) {
            invoiceCodeFilter = null;
        }
        if ((mainObject = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)(mainFields = MetadataUtil.getFields("rim_invoice")), (QFilter[])new QFilter[]{invoiceNoFilter, invoiceCodeFilter})) != null) {
            DynamicObject attachOne;
            int pageSum;
            saleListSum = mainObject.getInt("salelist_sum");
            if (attachCollect != null && attachCollect.length > 0 && (pageSum = (attachOne = attachCollect[0]).getInt("page_sum")) != 0 && pageSum != saleListSum) {
                mainObject.set("salelist_sum", (Object)pageSum);
                saleListSum = pageSum;
            }
            if (bindNum == 0) {
                mainObject.set("salelist_complete", (Object)"3");
            } else if (bindNum < saleListSum) {
                mainObject.set("salelist_complete", (Object)"2");
            } else {
                mainObject.set("salelist_complete", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject});
            logger.info("\u8ba1\u7b97\u6e05\u5355\u5b8c\u6574\u6027\u5b8c\u6bd5,{},{}", (Object)invoiceCode, (Object)invoiceNo);
        }
        numObject.put("salelistSum", (Object)saleListSum);
        numObject.put("bindNum", (Object)bindNum);
        return numObject;
    }

    private DynamicObjectCollection getAttachDynamicByAttachNo(String attachNo) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        QFilter attachNoFilter = new QFilter("attach_no", "=", (Object)attachNo);
        String attachFields = MetadataUtil.getFields("rim_attach");
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach", (String)attachFields, (QFilter[])new QFilter[]{attachNoFilter});
        if (attachCollect != null && attachCollect.length > 0) {
            for (DynamicObject attachObject : attachCollect) {
                Long attachId = attachObject.getLong("id");
                boolean isBind = this.checkBind(attachId);
                if (isBind) continue;
                result.add((Object)attachObject);
            }
        }
        return result;
    }

    public boolean checkBind(Long attachId) {
        QFilter attachIdFilter = new QFilter("attach_id", "=", (Object)attachId.toString());
        QFilter relationIdFilter = new QFilter("relation_id", "!=", (Object)" ");
        String attachFields = MetadataUtil.getFields("rim_attach_relation");
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach_relation", (String)attachFields, (QFilter[])new QFilter[]{attachIdFilter, relationIdFilter});
        return attachCollect != null && attachCollect.length > 0;
    }

    public int queryAttachNum(List<String> attachIdList) {
        QFilter attachIdFilter = new QFilter("attach_id", "in", attachIdList);
        QFilter relationIdFilter = new QFilter("relation_id", "!=", (Object)" ");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_attach_relation", (String)"id,attach_id", (QFilter[])new QFilter[]{attachIdFilter, relationIdFilter});
        if (collect == null || collect.isEmpty()) {
            return 0;
        }
        HashSet set = new HashSet(collect.size());
        collect.forEach(obj -> set.add(obj.getString("attach_id")));
        return set.size();
    }

    public Map<String, Integer> filterBindAttach(List<String> attachIds) {
        QFilter attachIdFilter = new QFilter("attach_id", "in", attachIds);
        QFilter relationIdFilter = new QFilter("relation_id", "!=", (Object)" ");
        String attachFields = MetadataUtil.getFields("rim_attach_relation");
        DynamicObject[] attachCollect = BusinessDataServiceHelper.load((String)"rim_attach_relation", (String)attachFields, (QFilter[])new QFilter[]{attachIdFilter, relationIdFilter});
        if (attachCollect.length == 0) {
            return Maps.newHashMap();
        }
        Map<String, List<DynamicObject>> relationGroup = Arrays.stream(attachCollect).collect(Collectors.groupingBy(attach -> attach.getString("relation_id")));
        HashMap map = Maps.newHashMapWithExpectedSize((int)relationGroup.size());
        ArrayList serialList = Lists.newArrayList();
        for (Map.Entry<String, List<DynamicObject>> entry : relationGroup.entrySet()) {
            map.put(entry.getKey(), entry.getValue().size());
            serialList.add(entry.getKey());
        }
        QFilter serialFilter = new QFilter("serial_no", "in", (Object)serialList);
        DynamicObject[] invoiceCollect = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"serial_no, invoice_code, invoice_no", (QFilter[])new QFilter[]{serialFilter});
        HashMap invoiceMap = Maps.newHashMapWithExpectedSize((int)invoiceCollect.length);
        for (DynamicObject invoice : invoiceCollect) {
            invoiceMap.put(invoice.getString("serial_no"), invoice.getString("invoice_code") + "_" + invoice.getString("invoice_no"));
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry entry : map.entrySet()) {
            result.put(invoiceMap.get(entry.getKey()), entry.getValue());
        }
        return result;
    }
}

