/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.check;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class UnCheckListCheckTask
implements Callable<JSONObject> {
    private static final Log LOGGER = LogFactory.getLog(UnCheckListCheckTask.class);
    private RequestContext ctx;
    private DynamicObject unCheckObject;

    public UnCheckListCheckTask(RequestContext ctx, DynamicObject unCheckObject) {
        this.ctx = ctx;
        this.unCheckObject = unCheckObject;
    }

    @Override
    public JSONObject call() throws Exception {
        if (null == this.unCheckObject) {
            return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a", (String)"UnCheckListCheckTask_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONObject result = new JSONObject();
        String invoiceCode = this.unCheckObject.getString("invoice_code");
        String invoiceNo = this.unCheckObject.getString("invoice_no");
        String serialNo = this.unCheckObject.getString("serial_no");
        Date invoiceDate = this.unCheckObject.getDate("invoice_date");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(this.unCheckObject.get("invoice_type"));
        BigDecimal invoiceAmount = this.unCheckObject.getBigDecimal("invoice_amount");
        BigDecimal totalAmount = this.unCheckObject.getBigDecimal("total_amount");
        String checkCode = this.unCheckObject.getString("check_code");
        String collectType = this.unCheckObject.getString("collect_type");
        String userId = RequestContext.get().getUserId();
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(this.unCheckObject.get("org"));
        if (orgId == 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        LOGGER.info("\u53d1\u7968\u53f7\u7801\uff1a{} \u53d1\u7968\u4ee3\u7801\uff1a{} \u8c03\u7528\u67e5\u9a8c\u63a5\u53e3.....", (Object)invoiceNo, (Object)invoiceCode);
        if (InputInvoiceTypeEnum.needReplaceAmountType(invoiceType)) {
            invoiceAmount = totalAmount;
        }
        CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, invoiceDate, invoiceAmount, checkCode, null);
        HashMap extMap = Maps.newHashMap();
        extMap.put("orgId", orgId);
        String taxNo = TenantUtils.getTaxNoByOrgId(RequestContext.get().getOrgId());
        extMap.put("taxNo", taxNo);
        extMap.put("eid", RequestContext.get().getUserId());
        checkParam.setExtMap(extMap);
        CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, orgId, taxNo);
        LOGGER.info("\u53d1\u7968\u53f7\u7801\uff1a{} \u53d1\u7968\u4ee3\u7801\uff1a{} \u67e5\u9a8c\u7ed3\u679c :{}", new Object[]{invoiceNo, invoiceCode, checkResult});
        String errorCode = "";
        String description = "";
        if (checkResult != null) {
            errorCode = checkResult.getErrcode();
            description = checkResult.getDescription();
            result.put("errcode", (Object)errorCode);
            result.put("description", (Object)description);
        }
        Object pk = this.unCheckObject.getPkValue();
        try (TXHandle h = TX.required();){
            try {
                if ("0000".equals(errorCode)) {
                    Object invoiceEntity = checkResult.getData();
                    String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                    JSONObject invoiceJson = JSON.parseObject((String)invoiceCheckStr);
                    String checkStatus = invoiceJson.getString("checkStatus");
                    if (StringUtils.isEmpty((CharSequence)checkStatus)) {
                        invoiceJson.put("checkStatus", (Object)"1");
                    }
                    ConvertFieldUtil.getStandardInvoice(invoiceJson);
                    invoiceJson.put("authenticateFlag", this.unCheckObject.get("authenticate_flag"));
                    invoiceJson.put("authenticateTime", this.unCheckObject.get("authenticate_time"));
                    invoiceJson.put("selectTime", this.unCheckObject.get("select_time"));
                    String taxPeriod = null;
                    if (null != this.unCheckObject.getDate("tax_period")) {
                        taxPeriod = DateUtils.format(this.unCheckObject.getDate("tax_period"), "yyyyMM");
                    }
                    invoiceJson.put("taxPeriod", taxPeriod);
                    invoiceJson.put("deductionPurpose", this.unCheckObject.get("deduction_purpose"));
                    invoiceJson.put("notDeductibleType", this.unCheckObject.get("not_deductible_type"));
                    invoiceJson.put("effectiveTaxAmount", this.unCheckObject.get("effective_tax_amount"));
                    invoiceJson.put("manageStatus", this.unCheckObject.get("manage_status"));
                    invoiceJson.put("companySeal", this.unCheckObject.get("company_seal"));
                    invoiceJson.put("resource", this.unCheckObject.get("resource"));
                    if (invoiceDate != null && !DateUtils.isTimeZero(invoiceDate)) {
                        invoiceJson.put("invoiceDate", (Object)invoiceDate);
                    }
                    invoiceJson.put("collect_type", (Object)collectType);
                    if (CollectTypeEnum.PC_SHUIPAN.getCode().equals(collectType)) {
                        invoiceJson.put("rim_user", (Object)this.getRimUser(userId));
                    }
                    invoiceJson.put("allowDeduction", (Object)"1");
                    InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceJson.getString("invoiceType"));
                    if (service != null) {
                        invoiceJson.put("override", (Object)"0");
                        invoiceJson.put("org_id", (Object)orgId);
                        String invoice_detail_tag = this.unCheckObject.getString("invoice_detail_tag");
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)invoice_detail_tag)) {
                            String originalState;
                            JSONObject detailFile = JSONObject.parseObject((String)invoice_detail_tag);
                            JSONObject fileObjectJson = detailFile.getJSONObject("file");
                            JSONObject invoiceDetail = detailFile.getJSONObject("detail");
                            if (invoiceDetail != null && "1".equals(originalState = invoiceDetail.getString("original_state"))) {
                                invoiceJson.put("originalState", (Object)originalState);
                            }
                            invoiceJson.put("snapshotUrl", (Object)fileObjectJson.getString("snapshot_url"));
                            invoiceJson.put("imageUrl", (Object)fileObjectJson.getString("image_url"));
                            invoiceJson.put("pdfUrl", (Object)fileObjectJson.getString("pdf_url"));
                            invoiceJson.put("ofdUrl", (Object)fileObjectJson.getString("ofd_url"));
                        }
                        if ("\u7a0e\u76d8".equals(this.unCheckObject.get("resource"))) {
                            invoiceJson.put("needUserRelation", (Object)"0");
                        } else {
                            boolean isCollectOwner = SysParamUtil.getSysParamByOrgId(orgId, "is_collectowner");
                            if (isCollectOwner) {
                                boolean isHit = SysParamUtil.isHitValue(orgId, "collectowner_config", "3");
                                if (!isHit) {
                                    invoiceJson.put("needUserRelation", (Object)"0");
                                } else {
                                    invoiceJson.put("oldSerialNo", (Object)serialNo);
                                    InvoiceSaveService.notSetUserRelationIfExist(invoiceJson);
                                }
                            } else {
                                invoiceJson.put("needUserRelation", (Object)"0");
                            }
                        }
                        service.save(invoiceJson);
                        String isSaleListInvoice = invoiceJson.getString("isSaleListInvoice");
                        if ("1".equals(isSaleListInvoice)) {
                            RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                            recognitionCheckHelper.dealInvoiceAttachRelation(invoiceJson);
                        }
                    }
                    result.put("data", (Object)invoiceJson);
                    String expense_status = this.unCheckObject.getString("expense_status");
                    if (pk != null && (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)expense_status) || "1".equals(expense_status))) {
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"), (Object[])new Object[]{pk});
                    } else {
                        this.unCheckObject.set("check_status", (Object)"1");
                        this.unCheckObject.set("check_time", (Object)new Date());
                        this.unCheckObject.set("check_result", (Object)result.getString("errcode"));
                        this.unCheckObject.set("update_time", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.unCheckObject});
                        LOGGER.info(invoiceCode + "_" + invoiceNo + "\u53d1\u7968\u67e5\u9a8c\u6210\u529f\u66f4\u65b0\u672a\u67e5\u9a8c\u8868\u72b6\u6001..");
                    }
                } else {
                    this.unCheckObject.set("check_time", (Object)new Date());
                    this.unCheckObject.set("check_result", (Object)String.format("[%s]%s", errorCode, description));
                    this.unCheckObject.set("update_time", (Object)new Date());
                    this.unCheckObject.set("check_times", (Object)(this.unCheckObject.getInt("check_times") + 1));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.unCheckObject});
                    LOGGER.info(invoiceCode + "_" + invoiceNo + "\u53d1\u7968\u67e5\u9a8c\u4e0d\u6210\u529f\u66f4\u65b0\u672a\u67e5\u9a8c\u8868\u72b6\u6001.." + this.unCheckObject.get("resource"));
                }
            }
            catch (Throwable e) {
                h.markRollback();
                LOGGER.info("\u53d1\u7968\u67e5\u9a8c\u5931\u8d25\uff1a{}-{},{}", new Object[]{invoiceCode, invoiceNo, e.getMessage()});
                JSONObject jSONObject = ResultContant.createJSONObject("0002", String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25\uff1a%1$s", (String)"UnCheckListCheckTask_1", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
                if (h != null) {
                    if (var21_21 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var21_21.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return jSONObject;
            }
        }
        return result;
    }

    private Long getRimUser(String userId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)userId)) {
            return 0L;
        }
        return Long.parseLong(userId);
    }
}

