/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.checknew.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.checknew.CheckService;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.CommonUtils;

public class AwsCheckService
implements CheckService {
    private static Log logger = LogFactory.getLog(AwsCheckService.class);

    @Override
    public CheckResult checkInvoice(CheckParam checkParam) {
        CheckResult finalResult = new CheckResult();
        String checkCode = checkParam.getCheckCode();
        if (StringUtils.isNotEmpty((String)checkCode) && checkCode.length() > 6) {
            checkParam.setCheckCode(checkCode.substring(checkCode.length() - 6));
        }
        boolean cache = true;
        JSONObject result = this.getReultFormDb(checkParam, "AwsCheckService");
        if (result == null) {
            cache = false;
            result = AwsFpyService.newInstance().postCheckInvoice("aws_check", checkParam);
        }
        logger.info("aws\u67e5\u9a8c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        StringBuilder description = new StringBuilder();
        if (!ResultContant.isSuccess(result).booleanValue()) {
            String msg = String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25%1$s", (String)"AwsCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]), result.getString("description"));
            description.append(msg);
        } else {
            description.append(result.getString("description"));
        }
        finalResult.setErrcode(result.getString("errcode"));
        finalResult.setDescription(description.toString());
        if (ResultContant.isSuccess(result).booleanValue() && null != result.get((Object)"data")) {
            JSONObject checkResult = result.getJSONObject("data");
            if (cache && !this.checkCache(checkParam, checkResult)) {
                finalResult.setErrcode("1005");
                finalResult.setDescription(ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u5fc5\u586b\u5b57\u6bb5\u662f\u5426\u6b63\u786e", (String)"AwsCheckService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                return finalResult;
            }
            if (!cache) {
                this.saveReultToDb(checkParam, result, "AwsCheckService");
            }
            checkResult.put("snapshotUrl", (Object)"");
            checkResult.put("kdcloudUrl", (Object)"");
            checkResult.put("downloadUrl", (Object)"");
            String awsInvoiceType = checkResult.getString("invoiceType");
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsInvoiceType);
            checkResult.put("invoiceType", (Object)invoiceType);
            if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                this.dealAirEleInfo(checkResult);
            }
            String itemsKey = "items";
            Object entity = ConvertFieldUtil.convertCheckEntityByInvoiceType(invoiceType, checkResult, itemsKey);
            finalResult.setData(entity);
        }
        return finalResult;
    }

    private void dealAirEleInfo(JSONObject checkResult) {
        JSONArray items = checkResult.getJSONArray("items");
        if (items != null) {
            JSONObject lastinfo;
            String lastdestination;
            JSONObject info = items.getJSONObject(0);
            checkResult.putAll((Map)info);
            String firstplaceOfDeparture = info.getString("placeOfDeparture");
            if (items.size() > 1 && StringUtils.isNotEmpty((String)(lastdestination = (lastinfo = items.getJSONObject(items.size() - 1)).getString("destination"))) && !lastdestination.equals(firstplaceOfDeparture)) {
                checkResult.put("destination", (Object)lastdestination);
            }
        }
        checkResult.put("carrierDate", (Object)checkResult.getDate("invoiceDate"));
    }

    private boolean checkCache(CheckParam param1, JSONObject invoiceInfo) {
        String checkCode = invoiceInfo.getString("checkCode");
        Date invoiceDate = CommonUtils.getJsonValue((Map<String, Object>)invoiceInfo, Date.class, "invoiceDate", "issueDate");
        Long type = param1.getInvoiceType();
        if (type == null) {
            return true;
        }
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(type + "");
        boolean isUsedCar = InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType);
        boolean isElectric = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType);
        BigDecimal amount = isUsedCar || isElectric ? invoiceInfo.getBigDecimal("totalAmount") : invoiceInfo.getBigDecimal("amount");
        CheckParam param2 = new CheckParam(param1.getInvoiceCode(), param1.getInvoiceNo(), param1.getInvoiceType(), invoiceDate, amount, checkCode, null);
        return this.compareParam(param1, param2);
    }
}

