/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.checknew.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.checknew.CheckService;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.file.utils.CompressHelper;

public class LqCheckService
implements CheckService {
    private static Log logger = LogFactory.getLog(LqCheckService.class);

    @Override
    public CheckResult checkInvoice(CheckParam checkParam) {
        CheckResult finalResult = new CheckResult();
        Map<String, Object> extMap = checkParam.getExtMap();
        String taxNo = (String)extMap.get("taxNo");
        if (StringUtils.isEmpty((String)taxNo)) {
            long orgId = RequestContext.get().getOrgId();
            taxNo = TenantUtils.getTaxNoByOrgId(orgId);
        }
        if (StringUtils.isEmpty((String)taxNo)) {
            finalResult.setErrcode("3301");
            finalResult.setDescription(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u672a\u914d\u7f6e\u7a0e\u53f7,\u8bf7\u5728\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406\u4e2d\u914d\u7f6e", (String)"LqCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return finalResult;
        }
        JSONObject lqCheckParam = this.convertParam(taxNo, checkParam);
        String checkCode = checkParam.getCheckCode();
        if (StringUtils.isNotEmpty((String)checkCode) && checkCode.length() > 6) {
            checkParam.setCheckCode(checkCode.substring(checkCode.length() - 6));
        }
        boolean cache = true;
        JSONObject result = this.getReultFormDb(checkParam, "LqCheckService");
        if (result == null) {
            cache = false;
            result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)"CheckApiService", (String)"send", (Object[])new Object[]{lqCheckParam});
        }
        logger.info("\u4e50\u4f01\u67e5\u9a8c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        StringBuilder description = new StringBuilder();
        boolean failFlag = false;
        if (result == null) {
            failFlag = true;
            finalResult.setErrcode("9999");
        } else {
            finalResult.setErrcode(result.getString("errcode"));
            try {
                String cyjg;
                String checkResult = result.getString("data");
                JSONObject data = JSON.parseObject((String)checkResult);
                if (data.getString("returncode").equals("00") && StringUtils.isNotEmpty((String)(cyjg = data.getString("cyjgxx")))) {
                    JSONObject cyjgObj = JSONObject.parseObject((String)CompressHelper.decodeBase64AndGZip((String)cyjg));
                    String itemsKey = "hwxx";
                    Object entity = ConvertFieldUtil.convertCheckEntityByInvoiceType(checkParam.getInvoiceType(), cyjgObj, itemsKey);
                    finalResult.setDescription(result.getString("description"));
                    finalResult.setData(entity);
                    return finalResult;
                }
            }
            catch (Exception e) {
                logger.info("\u4e50\u4f01\u67e5\u9a8c\u5931\u8d25\uff1a{}", (Object)e);
                failFlag = true;
            }
        }
        if (failFlag) {
            String msg = String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25%1$s", (String)"AwsCheckService_0", (String)"imc-rim-common", (Object[])new Object[0]), result == null ? "" : result.getString("description"));
            description.append(msg);
            finalResult.setDescription(description.toString());
        }
        return finalResult;
    }

    private JSONObject convertParam(String taxNo, CheckParam checkParam) {
        JSONObject lqCheckParam = new JSONObject();
        lqCheckParam.put("fplx", (Object)checkParam.getInvoiceType());
        lqCheckParam.put("fpdm", (Object)checkParam.getInvoiceCode());
        lqCheckParam.put("fphm", (Object)checkParam.getInvoiceNo());
        lqCheckParam.put("jym", (Object)checkParam.getCheckCode());
        lqCheckParam.put("kprq", (Object)checkParam.getInvoiceDate());
        lqCheckParam.put("kpje", (Object)checkParam.getInvoiceMoney());
        lqCheckParam.put("nsrsbh", (Object)taxNo);
        return lqCheckParam;
    }

    private boolean checkCache(CheckParam param1, JSONObject invoiceInfo) {
        String invoiceDate = invoiceInfo.getString("kprq");
        String kprq = invoiceDate.substring(0, 10);
        BigDecimal amount = BigDecimal.ZERO;
        String checkCode = param1.getCheckCode();
        boolean isUsedCar = InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(param1.getInvoiceType());
        boolean isElectric = InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(param1.getInvoiceType());
        boolean isZzs = InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(param1.getInvoiceType()) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(param1.getInvoiceType());
        boolean isCar = InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(param1.getInvoiceType());
        if (isUsedCar) {
            amount = invoiceInfo.getBigDecimal("cjhj");
        }
        if (isElectric) {
            amount = invoiceInfo.getBigDecimal("jshj");
        }
        if (isZzs) {
            amount = invoiceInfo.getBigDecimal("hjje");
        }
        if (isCar) {
            amount = invoiceInfo.getBigDecimal("cjfy");
        }
        CheckParam param2 = new CheckParam(param1.getInvoiceCode(), param1.getInvoiceNo(), param1.getInvoiceType(), kprq, amount, checkCode, null);
        return this.compareParam(param1, param2);
    }

    @Override
    public JSONObject getReultFormDb(CheckParam checkParam, String checkType) {
        return CheckService.super.getReultFormDb(checkParam, checkType);
    }

    @Override
    public void saveReultToDb(CheckParam checkParam, JSONObject result, String checkType) {
        CheckService.super.saveReultToDb(checkParam, result, checkType);
    }

    @Override
    public boolean compareParam(CheckParam checkParam, CheckParam checkResult) {
        return CheckService.super.compareParam(checkParam, checkResult);
    }
}

