/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.checknew.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;

public class CheckParam
implements Serializable {
    private String invoiceCode;
    private String invoiceNo;
    private Long invoiceType;
    private String invoiceDate;
    private BigDecimal invoiceMoney;
    private BigDecimal totalAmount;
    private String checkCode;
    private Map<String, Object> extMap;
    private int cacheDate = 0;

    public Map<String, Object> getExtMap() {
        return this.extMap;
    }

    public CheckParam(String invoiceCode, String invoiceNo, Long invoiceType, String invoiceDate, BigDecimal invoiceMoney, String checkCode, Map<String, Object> extMap) {
        if (this.isPutEmptyInvoiceCode(invoiceCode, invoiceNo, invoiceType)) {
            invoiceCode = "";
        }
        this.invoiceCode = invoiceCode;
        this.invoiceNo = invoiceNo;
        this.invoiceType = invoiceType;
        if (StringUtils.isNotEmpty((CharSequence)invoiceDate) && invoiceDate.contains("-")) {
            invoiceDate = invoiceDate.replaceAll("-", "").substring(0, 8);
        }
        this.invoiceDate = invoiceDate;
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20) {
            this.totalAmount = invoiceMoney;
        } else {
            this.invoiceMoney = invoiceMoney;
        }
        this.checkCode = checkCode;
        this.extMap = extMap;
    }

    private boolean isPutEmptyInvoiceCode(String invoiceCode, String invoiceNo, Long invoiceType) {
        return invoiceCode == null || "null".equals(invoiceCode) || StringUtils.isEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20 || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType);
    }

    public CheckParam(String invoiceCode, String invoiceNo, Long invoiceType, Date invoiceDate, BigDecimal invoiceMoney, String checkCode, Map<String, Object> extMap) {
        if (this.isPutEmptyInvoiceCode(invoiceCode, invoiceNo, invoiceType)) {
            invoiceCode = "";
        }
        this.invoiceCode = invoiceCode;
        this.invoiceNo = invoiceNo;
        this.invoiceType = invoiceType;
        this.invoiceDate = "";
        if (invoiceDate != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            String invoiceDateStr = formatter.format(invoiceDate);
            if (invoiceDateStr.contains("-")) {
                invoiceDateStr = invoiceDateStr.replaceAll("-", "").substring(0, 8);
            }
            this.invoiceDate = invoiceDateStr;
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceNo.length() == 20) {
            this.totalAmount = invoiceMoney;
        } else {
            this.invoiceMoney = invoiceMoney;
        }
        this.checkCode = checkCode;
        this.extMap = extMap;
    }

    public String getInvoiceCode() {
        return this.invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return this.invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public Long getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public BigDecimal getInvoiceMoney() {
        return this.invoiceMoney;
    }

    public void setInvoiceMoney(BigDecimal invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public void setExtMap(Map<String, Object> extMap) {
        this.extMap = extMap;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"invoiceCode\":\"").append(this.invoiceCode).append('\"');
        sb.append(",\"invoiceNo\":\"").append(this.invoiceNo).append('\"');
        sb.append(",\"invoiceType\":").append(this.invoiceType);
        sb.append(",\"invoiceDate\":\"").append(this.invoiceDate).append('\"');
        sb.append(",\"invoiceMoney\":").append(this.invoiceMoney);
        sb.append(",\"totalAmount\":").append(this.totalAmount);
        sb.append(",\"checkCode\":\"").append(this.checkCode).append('\"');
        sb.append('}');
        return sb.toString();
    }

    public int getCacheDate() {
        return this.cacheDate;
    }

    public void setCacheDate(int cacheDate) {
        this.cacheDate = cacheDate;
    }
}

