/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.utils.AisinoService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.StringUtils;

public class AisinoBlackListSyn
implements Runnable {
    private static Log logger = LogFactory.getLog(AisinoBlackListSyn.class);
    private static final String BLACK_LIST_ENTITY = "rim_black_list_data";
    private RequestContext rc;
    private List<String> aimTaxNoList;

    public AisinoBlackListSyn(RequestContext rc, List<String> aimTaxNoList) {
        this.rc = rc;
        this.aimTaxNoList = aimTaxNoList;
    }

    public void searchBlacklist(String sellerTaxNo) {
        if (StringUtils.isNotEmpty((CharSequence)sellerTaxNo)) {
            return;
        }
        ArrayList<String> salerTaxList = new ArrayList<String>(1);
        salerTaxList.add(sellerTaxNo);
        AisinoBlackListSyn aisinoBlackListSyn = new AisinoBlackListSyn(RequestContext.get(), salerTaxList);
        ThreadPools.executeOnceIncludeRequestContext((String)"ExcelInvoiceSaveService_searchBlacklist", (Runnable)aisinoBlackListSyn);
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    private void doTask() {
        logger.info("\u9ed1\u540d\u5355\u540c\u6b65\u8bf7\u6c42\u53c2\u6570:{}", this.aimTaxNoList);
        if (this.aimTaxNoList == null || this.aimTaxNoList.size() == 0) {
            return;
        }
        String taxNo = ImcConfigUtil.getValue("rim_deduction", "aisino_tax_no");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            taxNo = TenantUtils.getTaxNoByOrgId(this.rc.getOrgId());
        }
        this.clearWhite();
        for (int i = 0; i < this.aimTaxNoList.size(); ++i) {
            String aimTaxNo = this.aimTaxNoList.get(i);
            QFilter blackListTypeFilter = new QFilter("tax_payer_no", "=", (Object)aimTaxNo);
            DynamicObject pkObject = QueryServiceHelper.queryOne((String)BLACK_LIST_ENTITY, (String)"id", (QFilter[])new QFilter[]{blackListTypeFilter});
            if (pkObject != null) {
                return;
            }
            Date now = new Date();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BLACK_LIST_ENTITY);
            dynamicObject.set("create_date", (Object)now);
            dynamicObject.set("update_date", (Object)now);
            dynamicObject.set("tax_payer_no", (Object)aimTaxNo);
            HashMap<String, Object> corpParam = new HashMap<String, Object>(1);
            corpParam.put("aimId", aimTaxNo);
            JSONObject corpQuery = AisinoService.newInstance().postAppJson("jx.rz.corp.query", this.rc.getOrgId(), taxNo, corpParam);
            logger.info(aimTaxNo + "\u7a0e\u6536\u9ed1\u540d\u5355\u63a5\u53e3\u8c03\u7528\u7ed3\u679c\uff1a" + corpQuery);
            if (corpQuery != null && "0000".equals(corpQuery.getString("errcode"))) {
                dynamicObject.set("black_list_type", (Object)"1");
                JSONObject data = corpQuery.getJSONObject("data");
                JSONArray results = data.getJSONArray("result");
                if (results != null && results.size() > 0) {
                    JSONObject blackListDetail = results.getJSONObject(0);
                    dynamicObject.set("province", (Object)blackListDetail.getString("dq"));
                    dynamicObject.set("count", (Object)blackListDetail.getInteger("count"));
                    dynamicObject.set("legal_name", (Object)blackListDetail.getString("cfFr"));
                    dynamicObject.set("company_name", (Object)blackListDetail.getString("cfXdrMc"));
                    dynamicObject.set("legal_card_no", (Object)blackListDetail.getString("cfXdrSfz"));
                    dynamicObject.set("org", (Object)blackListDetail.getString("cfXdrZdm"));
                    dynamicObject.set("register_date", (Object)blackListDetail.getDate("cfJzq"));
                    dynamicObject.set("public_date", (Object)blackListDetail.getDate("cfSxq"));
                    dynamicObject.set("case_type", (Object)blackListDetail.getString("cfAjmc"));
                    dynamicObject.set("case_detail", (Object)blackListDetail.getString("cfSy"));
                    dynamicObject.set("execute_no", (Object)blackListDetail.getString("cfWsh"));
                    dynamicObject.set("execute_result", (Object)blackListDetail.getString("cfJg"));
                    dynamicObject.set("execute_department", (Object)blackListDetail.getString("cfXzjg"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    continue;
                }
            }
            HashMap<String, Object> corpAbnormalParam = new HashMap<String, Object>(3);
            corpAbnormalParam.put("nsrsbh", aimTaxNo);
            corpAbnormalParam.put("pageNum", 1);
            JSONObject corpAbnormal = AisinoService.newInstance().postAppJson("jx.rz.corp.unnormal", this.rc.getOrgId(), taxNo, corpAbnormalParam);
            logger.info(aimTaxNo + "\u7ecf\u8425\u8fdd\u6cd5\u63a5\u53e3\u8c03\u7528\u7ed3\u679c\uff1a" + corpAbnormal);
            if (corpAbnormal != null && "0000".equals(corpAbnormal.getString("errcode"))) {
                dynamicObject.set("black_list_type", (Object)"2");
                JSONObject data = corpAbnormal.getJSONObject("data");
                JSONArray abnormalResults = data.getJSONArray("unnormalResult");
                if (abnormalResults != null && abnormalResults.size() > 0) {
                    JSONObject blackListDetail = abnormalResults.getJSONObject(0);
                    dynamicObject.set("count", corpAbnormal.get((Object)"totalSize"));
                    dynamicObject.set("public_date", (Object)blackListDetail.getDate("putDate"));
                    dynamicObject.set("case_detail", blackListDetail.get((Object)"putReason"));
                    dynamicObject.set("execute_department", blackListDetail.get((Object)"putDepartment"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    continue;
                }
            }
            HashMap<String, Object> corpIllegalParam = new HashMap<String, Object>(2);
            corpIllegalParam.put("nsrsbh", aimTaxNo);
            corpIllegalParam.put("pageNum", 1);
            JSONObject corpIllegal = AisinoService.newInstance().postAppJson("jx.rz.corp.illegal", this.rc.getOrgId(), taxNo, corpIllegalParam);
            logger.info(aimTaxNo + "\u7a0e\u6536\u8fdd\u6cd5\u63a5\u53e3\u8c03\u7528\u7ed3\u679c\uff1a" + corpIllegal);
            if (corpIllegal != null && "0000".equals(corpIllegal.getString("errcode"))) {
                dynamicObject.set("black_list_type", (Object)"3");
                JSONObject data = corpIllegal.getJSONObject("data");
                JSONArray illegalResults = data.getJSONArray("illegalResult");
                if (illegalResults != null && illegalResults.size() > 0) {
                    JSONObject blackListDetail = illegalResults.getJSONObject(0);
                    dynamicObject.set("count", (Object)corpIllegal.getInteger("totalSize"));
                    dynamicObject.set("public_date", (Object)blackListDetail.getDate("publish_time"));
                    dynamicObject.set("case_nature", (Object)blackListDetail.getString("case_type"));
                    dynamicObject.set("execute_department", (Object)blackListDetail.getString("department"));
                    dynamicObject.set("company_name", (Object)blackListDetail.getString("taxpayer_name"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    continue;
                }
            }
            logger.info(aimTaxNo + "\u4fdd\u5b58\u4e3a\u767d\u540d\u5355");
            dynamicObject.set("tax_payer_no", (Object)aimTaxNo);
            if (!"4".equals(dynamicObject.get("black_list_type"))) {
                dynamicObject.set("create_date", (Object)now);
            }
            dynamicObject.set("black_list_type", (Object)"4");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void clearWhite() {
        String cache = CacheHelper.get("rim_clearWhite");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            logger.info("\u6e05\u740615\u5929\u524d\u7684\u767d\u540d\u5355");
            Date before15Date = DateUtils.addDay(new Date(), -15);
            QFilter whiteListFilter1 = new QFilter("black_list_type", "=", (Object)"4");
            QFilter whiteListFilter2 = new QFilter("create_date", "<", (Object)before15Date);
            DeleteServiceHelper.delete((String)BLACK_LIST_ENTITY, (QFilter[])new QFilter[]{whiteListFilter1, whiteListFilter2});
            CacheHelper.put("rim_clearWhite", "1", 720);
        }
    }
}

