/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionProgress;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionProgressError;
import kd.imc.rim.common.invoice.recognition.listener.IRecognitionListener;
import kd.imc.rim.common.invoice.recognition.listener.RecognitionListenerResult;
import kd.imc.rim.common.service.EInvoiceZipXmlDealService;
import kd.imc.rim.common.service.ElectAccVoucherService;
import kd.imc.rim.common.service.ExcelInvoiceUploadService;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.FileUtils;

public class InvoiceCollectTask
implements Runnable,
IRecognitionListener {
    private static Log logger = LogFactory.getLog(InvoiceCollectTask.class);
    private RequestContext rc;
    private String pageId;
    private List<Map<String, String>> fileUrls;
    private RecognitionProgress recognitionProgress;
    private JSONObject businessParam;

    public InvoiceCollectTask(RequestContext rc, String pageId, List<Map<String, String>> fileUrls, JSONObject businessParam) {
        this.rc = rc;
        this.pageId = pageId;
        this.fileUrls = fileUrls;
        this.businessParam = businessParam;
        this.recognitionProgress = new RecognitionProgress();
        Object[] urls = new Object[fileUrls.size()];
        int i = 0;
        for (Map<String, String> map : fileUrls) {
            urls[i] = map.get("url");
            ++i;
        }
        this.recognitionProgress.setUrls(urls);
        this.recognitionProgress.setProgress(1);
        this.recognitionProgress.setUnHandleSize(fileUrls.size());
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTask() {
        PageCache pageCache = new PageCache(this.pageId);
        long taskStart = System.currentTimeMillis();
        int size = this.fileUrls.size();
        for (int i = 0; i < size; ++i) {
            Map<String, String> map = this.fileUrls.get(i);
            long start = System.currentTimeMillis();
            String url = map.get("url");
            String fileName = map.get("name");
            String seqStr = map.get("seq");
            try {
                String xbrlErrCode;
                boolean isZipXmlEI;
                if (StringUtils.isEmpty((CharSequence)fileName)) {
                    fileName = url.substring(url.lastIndexOf(47) + 1);
                }
                this.recognitionProgress.setHandleUrl(url);
                pageCache.put("progress", JSONObject.toJSONString((Object)this.recognitionProgress));
                long recognitionStart = System.currentTimeMillis();
                this.businessParam.put("pageId", (Object)this.pageId);
                this.businessParam.put("uploadIndex", (Object)(start + (long)i));
                Long orgId = this.businessParam.get((Object)"orgId") == null ? Long.valueOf(RequestContext.get().getOrgId()) : (Long)this.businessParam.get((Object)"orgId");
                JSONObject invoiceResult = new JSONObject();
                boolean isNeedDeal = FileUtils.checkFileType(fileName, "zip", "ofd", "pdf");
                if (isNeedDeal) {
                    ElectAccVoucherService electAccVoucherService = new ElectAccVoucherService();
                    invoiceResult = electAccVoucherService.dealVoucher(url, fileName, orgId, this.businessParam, this);
                }
                if ((isZipXmlEI = FileUtils.checkFileType(fileName, "zip", "xml")) && !"0000".equals(invoiceResult.getString("errcode"))) {
                    invoiceResult = EInvoiceZipXmlDealService.analysisAndCheckSave(url, fileName, orgId, this.businessParam, this);
                }
                boolean dealResult = StringUtils.isEmpty((CharSequence)(xbrlErrCode = invoiceResult.getString("errcode"))) || !xbrlErrCode.equals("0000");
                boolean isZip = FileUtils.checkFileType(fileName, "zip");
                if (dealResult && !isZip) {
                    invoiceResult = FileUtils.isExcel(fileName) ? ExcelInvoiceUploadService.getInstance().uploadExcelInvoice(url, fileName, this, this.businessParam) : RecognitionCheckService.getInstance().recognitionCheckInvoice(url, fileName, this, this.businessParam);
                }
                logger.info(url + "RecognitionCheckService\u8bc6\u522b\u7ed3\u679c\uff1a" + invoiceResult);
                logger.info(String.format("\u6587\u4ef6%s\u4e2d\u53d1\u7968\u8bc6\u522b\u4e0e\u67e5\u9a8c\u5b8c\u6bd5 \u5171\u8017\u65f6%s", fileName, System.currentTimeMillis() - recognitionStart));
                if (null == this.recognitionProgress.getRecognitionProgressErrors()) {
                    this.recognitionProgress.setRecognitionProgressErrors(new ArrayList<RecognitionProgressError>());
                }
                if (!"0000".equals(invoiceResult.getString("errcode"))) {
                    String errdescription = ResManager.loadKDString((String)"\u8bc6\u522b\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5", (String)"InvoiceCollectTask_0", (String)"imc-rim-common", (Object[])new Object[0]);
                    if (StringUtils.isNotEmpty((CharSequence)invoiceResult.getString("description"))) {
                        errdescription = invoiceResult.getString("description");
                    }
                    this.recognitionProgress.getRecognitionProgressErrors().add(new RecognitionProgressError(url, errdescription));
                } else {
                    JSONObject tips;
                    JSONArray recognitionData = invoiceResult.getJSONArray("data");
                    if (recognitionData != null) {
                        for (int k = 0; k < recognitionData.size(); ++k) {
                            Object isFalse;
                            JSONObject invoiceInfo = recognitionData.getJSONObject(k);
                            if (invoiceInfo == null || (isFalse = invoiceInfo.get((Object)"isFalse")) == null) continue;
                            String snapshotUrl = invoiceInfo.getString("pageUrl");
                            String pageIndex = invoiceInfo.getString("pageIndex");
                            StringBuilder description = new StringBuilder();
                            description.append(fileName).append('\u7b2c').append(pageIndex).append(ResManager.loadKDString((String)"\u9875\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (String)"InvoiceCollectTask_1", (String)"imc-rim-common", (Object[])new Object[0]));
                            this.recognitionProgress.getRecognitionProgressErrors().add(new RecognitionProgressError(snapshotUrl, description.toString()));
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)(tips = invoiceResult.getJSONObject("tips"))) && FileUtils.isExcel(fileName)) {
                        RecognitionProgressError recognitionProgressError = new RecognitionProgressError();
                        recognitionProgressError.setUrl(url);
                        recognitionProgressError.setTipDescription(tips.getString("tipDescription"));
                        this.recognitionProgress.getRecognitionProgressErrors().add(recognitionProgressError);
                    }
                }
                BigDecimal a = new BigDecimal(i + 1);
                BigDecimal b = new BigDecimal(size);
                int progress = a.divide(b, 2, 4).multiply(new BigDecimal("100")).intValue();
                if (progress != 100) {
                    this.recognitionProgress.setProgress(progress);
                }
                this.recognitionProgress.setUnHandleSize(size - i - 1);
            }
            catch (Throwable e) {
                try {
                    if (!FileUtils.isExcel(fileName)) {
                        if (null == this.recognitionProgress.getRecognitionProgressErrors()) {
                            this.recognitionProgress.setRecognitionProgressErrors(new ArrayList<RecognitionProgressError>());
                        }
                        this.recognitionProgress.getRecognitionProgressErrors().add(new RecognitionProgressError(url, e.getMessage()));
                    }
                    this.recognitionProgress.setUnHandleSize(size - i - 1);
                }
                catch (Throwable throwable) {
                    this.recognitionProgress.setUnHandleSize(size - i - 1);
                    pageCache.put("progress", JSONObject.toJSONString((Object)this.recognitionProgress));
                    logger.info(String.format("\u6587\u4ef6%s\u7b2c%s\u9875\uff0cInvoiceCollectTask\u7edf\u8ba1\u4fe1\u606f-\u5171%s\u4e2a\uff0c\u8017\u65f6%s", fileName, i + 1, size, System.currentTimeMillis() - start));
                    throw throwable;
                }
                pageCache.put("progress", JSONObject.toJSONString((Object)this.recognitionProgress));
                logger.info(String.format("\u6587\u4ef6%s\u7b2c%s\u9875\uff0cInvoiceCollectTask\u7edf\u8ba1\u4fe1\u606f-\u5171%s\u4e2a\uff0c\u8017\u65f6%s", fileName, i + 1, size, System.currentTimeMillis() - start));
                continue;
            }
            pageCache.put("progress", JSONObject.toJSONString((Object)this.recognitionProgress));
            logger.info(String.format("\u6587\u4ef6%s\u7b2c%s\u9875\uff0cInvoiceCollectTask\u7edf\u8ba1\u4fe1\u606f-\u5171%s\u4e2a\uff0c\u8017\u65f6%s", fileName, i + 1, size, System.currentTimeMillis() - start));
            continue;
        }
        this.recognitionProgress.setProgress(100);
        PageCache pageCacheEnd = new PageCache(this.pageId);
        pageCacheEnd.put("progress", JSONObject.toJSONString((Object)this.recognitionProgress));
        logger.info(String.format("%s\u4efb\u52a1\u7edf\u8ba1\u4fe1\u606f\u603b\u8017\u65f6%s", this.rc.getTraceId(), System.currentTimeMillis() - taskStart));
    }

    @Override
    public void handle(RecognitionListenerResult recognitionListenerResult) {
        PageCache pageCache = new PageCache(this.pageId);
        String fileUrl = recognitionListenerResult.getFileUrl();
        this.recognitionProgress.setHandleUrl(fileUrl);
        if (StringUtils.isNotEmpty((CharSequence)recognitionListenerResult.getErrDescription())) {
            logger.info(fileUrl + "\u8bc6\u522b\u5931\u8d25/\u4e2d\u65ad\uff0c" + recognitionListenerResult.getErrDescription());
            this.recognitionProgress.setHandleUrlIndex(recognitionListenerResult.getRecognitionIndex());
            this.recognitionProgress.setHandleUrlErrorDescription(recognitionListenerResult.getErrDescription());
            pageCache.put("progress", JSONObject.toJSONString((Object)this.recognitionProgress));
            pageCache.put("task_" + fileUrl, "0");
        } else {
            int index = recognitionListenerResult.getRecognitionIndex();
            logger.info(fileUrl + "\u7b2c" + index + "\u9875\u8bc6\u522b\u5b8c\u6210:" + recognitionListenerResult.getRecognitionInvoice().toJSONString());
            this.recognitionProgress.setHandleUrlIndex(index);
            this.recognitionProgress.setHandleUrlSize(recognitionListenerResult.getRecognitionSize());
            pageCache.put("progress", JSONObject.toJSONString((Object)this.recognitionProgress));
            pageCache.put("task_" + fileUrl, recognitionListenerResult.getRecognitionSize() + "");
            pageCache.put("task_" + fileUrl + "_" + index, recognitionListenerResult.getRecognitionInvoice().toJSONString());
            if (!CollectionUtils.isEmpty((Collection)recognitionListenerResult.getImportFailInvoice())) {
                pageCache.put("failed_task_" + fileUrl + "_" + index, recognitionListenerResult.getImportFailInvoice().toJSONString());
            }
        }
    }
}

