/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.multitenant.service.impl.FpzsViewInvoiceServiceAdapter;
import kd.imc.rim.common.untrans.RimConstellationUntrans;

public class InvoiceSalesListService {
    private static final Log logger = LogFactory.getLog(InvoiceSalesListService.class);
    private static final Collection<Long> NEED_SHOW_SALESLIST_COLL = Collections.unmodifiableCollection(Sets.newHashSet((Object[])new Long[]{InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.ORDINARY_PAPER.getCode(), InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()}));
    private static final String[] CN_UPPER_NUMBER = RimConstellationUntrans.InvoiceSalesListService_100;
    private static final String[] CN_UPPER_MONETRAY_UNIT = RimConstellationUntrans.InvoiceSalesListService_101;
    private static final char CN_FULL = '\u6574';
    private static final char CN_NEGATIVE = '\u8d1f';
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";
    private static InvoiceSalesListService instance = new InvoiceSalesListService();

    public static InvoiceSalesListService getInstance() {
        return instance;
    }

    public static void clickChange(String key, IFormView view) {
        InvoiceSalesListService.clickChange(key, view, "");
    }

    public static void clickChange(String key, IFormView view, String perfix) {
        Boolean isShowSalesList = null;
        if (StringUtils.equals((CharSequence)"show_saleslist", (CharSequence)key)) {
            isShowSalesList = Boolean.TRUE;
        } else if (StringUtils.equals((CharSequence)"show_image", (CharSequence)key)) {
            isShowSalesList = Boolean.FALSE;
        }
        if (isShowSalesList != null) {
            view.setVisible(isShowSalesList, new String[]{"saleslist_flex"});
            view.setVisible(Boolean.valueOf(isShowSalesList == false), new String[]{"invoice_flex_show"});
            view.setVisible(Boolean.valueOf(isShowSalesList == false), new String[]{perfix + "show_saleslist"});
            view.setVisible(isShowSalesList, new String[]{perfix + "show_image"});
        }
    }

    public static void clickChange(String key, int row, CardEntry cardEntry, IFormView view) {
        Boolean isShowSalesList = null;
        if (StringUtils.equals((CharSequence)"show_saleslist", (CharSequence)key)) {
            isShowSalesList = Boolean.TRUE;
        } else if (StringUtils.equals((CharSequence)"show_image", (CharSequence)key)) {
            isShowSalesList = Boolean.FALSE;
        }
        if (isShowSalesList != null) {
            view.setVisible(isShowSalesList, new String[]{"saleslist_flex"});
            view.setVisible(Boolean.valueOf(isShowSalesList == false), new String[]{"invoice_flex_show"});
            cardEntry.setChildVisible(isShowSalesList == false, row, new String[]{"show_saleslist"});
            cardEntry.setChildVisible(isShowSalesList.booleanValue(), row, new String[]{"show_image"});
        }
    }

    private void clear(IFormView view) {
        IDataModel model = view.getModel();
        List<String> keyList = this.getInvoiceHeadKey();
        for (String key : keyList) {
            model.setValue(key, (Object)"");
        }
        model.deleteEntryData("list_entryentity");
    }

    public void initSaleslist(IFormView view) {
        this.initSaleslist(view, "");
    }

    public void initSaleslist(IFormView view, String perfix) {
        DynamicObject invoice = this.getSerialNo(view);
        Boolean showSalesList = this.isShow(invoice);
        this.initShow(showSalesList, view, perfix);
        this.initSaleslist(invoice, view);
    }

    public void initSaleslist(String serial, IFormView view) {
        this.initSaleslist(this.getInvoiceDynamicObject(serial, view.getModel(), view.getFormShowParameter().getFormId()), view);
    }

    public void initSaleslist(DynamicObject invoice, IFormView view) {
        this.clear(view);
        Boolean showSalesList = this.isShow(invoice);
        if (!showSalesList.booleanValue() || invoice == null) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("heightLimit", Boolean.FALSE);
        view.updateControlMetadata("list_entryentity", (Map)map);
        this.initListInvoiceHead(invoice, view.getModel());
        this.initListEntryEntity(invoice, view.getModel());
        this.entryShowField(invoice.getDynamicObject("invoice_type").getLong("id"), view);
    }

    public Boolean isShow(DynamicObject invoice) {
        Boolean showSalesList = Boolean.FALSE;
        if (invoice != null && invoice.getDynamicObject("invoice_type") != null) {
            showSalesList = NEED_SHOW_SALESLIST_COLL.contains(invoice.getDynamicObject("invoice_type").getLong("id"));
            logger.info("\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)invoice);
            if (invoice.getDynamicObjectType().getProperty("items") == null || invoice.getDynamicObjectCollection("items").size() <= 8) {
                showSalesList = Boolean.FALSE;
            }
        }
        return showSalesList;
    }

    public void initShow(String serial, int row, IFormView view, CardEntry cardEntry) {
        DynamicObject invoice = this.getInvoiceDynamicObject(serial, view.getModel(), view.getFormShowParameter().getFormId());
        Boolean showSalesList = this.isShow(invoice);
        cardEntry.setChildVisible(showSalesList.booleanValue(), row, new String[]{"list_btn_flex"});
        cardEntry.setChildVisible(true, row, new String[]{"show_saleslist"});
        cardEntry.setChildVisible(false, row, new String[]{"show_image"});
    }

    public void initShow(Boolean showSalesList, IFormView view, String perfix) {
        view.setVisible(Boolean.FALSE, new String[]{perfix + "saleslist_flex"});
        view.setVisible(showSalesList, new String[]{perfix + "list_btn_flex"});
        view.setVisible(showSalesList, new String[]{perfix + "show_saleslist"});
        view.setVisible(Boolean.FALSE, new String[]{perfix + "show_image"});
    }

    private DynamicObject getSerialNo(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object invoiceBody = customParams.get("invoice");
        Object editSerialNo = customParams.get("serialNo");
        if (invoiceBody != null) {
            JSONObject invoiceJson = JSONObject.parseObject((String)invoiceBody.toString());
            editSerialNo = invoiceJson.getString("serialNo");
        }
        if (StringUtils.isBlank(editSerialNo)) {
            editSerialNo = view.getPageCache().get("list_serial_no");
        }
        if (editSerialNo != null) {
            return this.getInvoiceDynamicObject(editSerialNo, view.getModel(), view.getFormShowParameter().getFormId());
        }
        return null;
    }

    public DynamicObject getInvoiceDynamicObject(Object serialNo, IDataModel model, String billFormId) {
        logger.info("\u53d1\u7968\u6d41\u6c34\u53f7\uff1a{}", serialNo);
        QFilter serialFilter = new QFilter("serial_no", "=", serialNo);
        String mainFields = "invoice_type";
        DynamicObject mainInvoice = QueryServiceHelper.queryOne((String)"rim_invoice", (String)mainFields, (QFilter[])new QFilter[]{serialFilter});
        if (mainInvoice == null) {
            return mainInvoice;
        }
        Long invoiceType = mainInvoice.getLong("invoice_type");
        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
        List<String> propList = this.getInvoiceHeadKey();
        propList.addAll(this.getInvoiceInfoKey(invoiceType));
        propList.add("serial_no");
        String selectProperties = propList.stream().map(v -> v.replace("list_", "")).collect(Collectors.joining(","));
        ArrayList fpzsList = Lists.newArrayList((Object[])new String[]{"rim_view_invoice", "rim_inv_collect_edit"});
        if (fpzsList.contains(billFormId)) {
            return new FpzsViewInvoiceServiceAdapter().getInvoiceDynamicObject(entity, serialNo, selectProperties);
        }
        return BusinessDataServiceHelper.loadSingle((String)entity, (String)selectProperties, (QFilter[])new QFilter[]{serialFilter});
    }

    private void initListInvoiceHead(DynamicObject invoice, IDataModel model) {
        List<String> keyList = this.getInvoiceHeadKey();
        for (String key : keyList) {
            Comparable<BigDecimal> tempValue;
            Object value;
            String name = key.replace("list_", "");
            if (invoice.getDynamicObjectType().getProperty(name) == null || (value = invoice.get(name)) == null) continue;
            if (model.getDataEntityType().getProperties().get((Object)key) == null) {
                return;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"list_invoice_type")) {
                DynamicObject invoiceType = invoice.getDynamicObject(name);
                value = InputInvoiceTypeEnum.getInvoiceType((Long)invoiceType.getPkValue()).getName();
            } else if (value instanceof BigDecimal) {
                tempValue = (BigDecimal)value;
                value = ((BigDecimal)tempValue).setScale(2, RoundingMode.HALF_EVEN).toPlainString();
                if (StringUtils.equals((CharSequence)"list_total_amount", (CharSequence)key) || StringUtils.equals((CharSequence)"list_total_tax_amount", (CharSequence)key) || StringUtils.equals((CharSequence)"list_invoice_amount", (CharSequence)key)) {
                    value = "\uffe5" + value;
                    if (StringUtils.equals((CharSequence)"list_total_amount", (CharSequence)key)) {
                        model.setValue("list_total_amount_m", (Object)this.number2CNMontrayUnit(((BigDecimal)tempValue).setScale(2, RoundingMode.HALF_EVEN)));
                    }
                }
            } else if (StringUtils.equals((CharSequence)"list_invoice_date", (CharSequence)key)) {
                tempValue = (Date)value;
                SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                value = df.format((Date)tempValue);
            }
            model.setValue(key, value);
        }
    }

    private List<String> getInvoiceHeadKey() {
        return Lists.newArrayList((Object[])new String[]{"list_invoice_type", "list_invoice_code", "list_invoice_no", "list_invoice_date", "list_check_code", "list_machine_no", "list_buyer_name", "list_buyer_tax_no", "list_buyer_address_phone", "list_buyer_account", "list_saler_name", "list_saler_tax_no", "list_saler_address_phone", "list_saler_account", "list_total_tax_amount", "list_total_amount", "list_invoice_amount", "list_remark"});
    }

    private List<String> getInvoiceInfoKey(IDataModel model) {
        if (model.getDataEntityType().getProperties().get((Object)"list_entryentity") == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return model.getEntryEntity("list_entryentity").getDynamicObjectType().getProperties().stream().map(IMetadata::getName).filter(v -> v.indexOf("list_") != -1).collect(Collectors.toList());
    }

    private List<String> getInvoiceInfoKey(Long code) {
        ArrayList entryKeys = Lists.newArrayList((Object[])new String[]{"list_goods_name", "list_spec_model", "list_detail_amount", "list_tax_rate", "list_tax_amount"});
        if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().compareTo(code) == 0) {
            entryKeys.add("list_veh_plate");
            entryKeys.add("list_start_date");
            entryKeys.add("list_end_date");
        } else {
            entryKeys.add("list_unit");
            entryKeys.add("list_num");
            entryKeys.add("list_unit_price");
        }
        return entryKeys;
    }

    private void entryShowField(Long code, IFormView view) {
        EntryGrid entry = (EntryGrid)view.getControl("list_entryentity");
        List<String> all = this.getInvoiceInfoKey(view.getModel());
        List<String> needShow = this.getInvoiceInfoKey(code);
        for (String key : all) {
            if (needShow.contains(key)) {
                view.setVisible(Boolean.TRUE, new String[]{key});
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{key});
        }
        List lists = entry.getItems();
        if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().compareTo(code) == 0) {
            for (Control control : lists) {
                if (control.getKey().equals("list_goods_name")) {
                    ((TextEdit)control).setCaption(new LocaleString(ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"InvoiceSalesListService_0", (String)"imc-rim-common", (Object[])new Object[0])));
                    continue;
                }
                if (!control.getKey().equals("list_spec_model")) continue;
                ((TextEdit)control).setCaption(new LocaleString(ResManager.loadKDString((String)"\u7c7b\u578b", (String)"InvoiceSalesListService_1", (String)"imc-rim-common", (Object[])new Object[0])));
            }
        }
    }

    private void initListEntryEntity(DynamicObject invoice, IDataModel model) {
        if (model.getDataEntityType().getProperties().get((Object)"list_entryentity") == null) {
            return;
        }
        List<String> listProps = this.getInvoiceInfoKey(invoice.getDynamicObject("invoice_type").getLong("id"));
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        int[] newEntryIndex = model.batchCreateNewEntryRow("list_entryentity", items.size());
        int index = 0;
        for (DynamicObject item : items) {
            for (String prop : listProps) {
                Comparable<BigDecimal> tempValue;
                String name = prop.replace("list_", "");
                Object value = item.get(name);
                if (value == null) continue;
                if (value instanceof BigDecimal) {
                    tempValue = (BigDecimal)value;
                    if (StringUtils.equals((CharSequence)"list_unit_price", (CharSequence)prop)) {
                        String valueStr = ((BigDecimal)tempValue).stripTrailingZeros().toPlainString();
                        int pointIndex = valueStr.indexOf(46);
                        value = pointIndex == -1 ? valueStr + ".00" : (valueStr.substring(pointIndex + 1).length() == 1 ? valueStr + "0" : valueStr);
                    } else if (StringUtils.equals((CharSequence)"list_tax_rate", (CharSequence)prop)) {
                        tempValue = ((BigDecimal)tempValue).multiply(BigDecimal.valueOf(100L));
                        value = ((BigDecimal)tempValue).setScale(2, RoundingMode.HALF_EVEN).stripTrailingZeros().toPlainString();
                        value = value + "%";
                    } else {
                        value = ((BigDecimal)tempValue).setScale(2, RoundingMode.HALF_EVEN).toPlainString();
                    }
                } else if (StringUtils.equals((CharSequence)"list_start_date", (CharSequence)prop) || StringUtils.equals((CharSequence)"list_end_date", (CharSequence)prop)) {
                    tempValue = (Date)value;
                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                    value = df.format((Date)tempValue);
                }
                model.setValue(prop, value, newEntryIndex[index]);
            }
            ++index;
        }
    }

    public String number2CNMontrayUnit(BigDecimal numberOfMoney) {
        StringBuilder sb = new StringBuilder();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, '\u8d1f');
        }
        if (scale <= 0L) {
            sb.append('\u6574');
        }
        return sb.toString();
    }
}

