/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceMainInfoDownService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.utils.DateUtils;

public class NewEtaxInvoiceDownService
extends InvoiceMainInfoDownService {
    public NewEtaxInvoiceDownService(Long orgId) {
        this.orgId = orgId;
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return DeductServiceFactory.newInstanceForDeduct("4", orgId);
    }

    @Override
    public JSONObject doDown(JSONObject paramJson) {
        DeductService deductService = this.getDeductServiceImpl(this.orgId);
        String billType = paramJson.getString("billType");
        if (StringUtils.isEmpty((CharSequence)billType)) {
            billType = "0";
            paramJson.put("billType", (Object)billType);
        }
        JSONObject searchOpt = paramJson.getJSONObject("searchOpt");
        String deductFlag = searchOpt.getString("deductFlag");
        Date taxPeriod = searchOpt.getDate("taxPeriod");
        if ("1".equals(deductFlag) || "2".equals(deductFlag)) {
            paramJson.put("synctype", (Object)"03");
            searchOpt.clear();
            if (taxPeriod != null) {
                searchOpt.put("taxPeriod", (Object)DateUtils.format(taxPeriod, "yyyyMM"));
            }
            if ("1".equals(billType)) {
                searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
            }
            if ("2".equals(deductFlag)) {
                paramJson.put("synctype", (Object)"09");
            }
        } else if ("0".equals(deductFlag)) {
            searchOpt.remove((Object)"taxPeriod");
            searchOpt.put("authenticateFlags", (Object)"0");
            if ("1".equals(billType) || InputInvoiceTypeEnum.HGJKS.getAwsType().equals(searchOpt.getString("invoiceType"))) {
                searchOpt.put("customDeclarationNo", (Object)searchOpt.getString("invoiceNo"));
            }
        }
        return deductService.queryInvoices(paramJson);
    }
}

