/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;

public abstract class AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(AsyncDeductSelectService.class);
    public static final String SELECT_FILEDS = "batch_no,tax_period,org,tax_no,total_num,success_num,fail_num,handle_status,create_time,update_time,bill_type,handle_num,description,task_no,async_flag,result_json,result_json_tag,operate_type,select_type,statistics_status";
    private static final String SELECT_ACCOUNT_FILEDS = "serial_no,invoice_type,invoice_code,invoice_no,handle_status,select_result,update_time,deduction_purpose,pre_authenticate_flag,select_status,invoice_date,not_deductible_type,total_tax_amount,effective_tax_amount,select_time,tax_period,description,org,invoice_amount,electronic_no,agric_partial_amount,agric_partial_taxamount,select_opera_type";

    public void queryAsyncSelectResultByBatchNo(List<String> batchNoList) {
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncSelectResultByBatchNoRun", () -> this.querySelectResultByBatchNo(batchNoList));
    }

    public static DynamicObject[] getSelectLogObjects(QFilter[] qFilters) {
        if (ObjectUtils.isEmpty((Object[])qFilters)) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)"rim_select_log", (String)SELECT_FILEDS, (QFilter[])qFilters);
    }

    public void querySelectResultByBatchNo(List<String> batchNoList) {
        QFilter batchNoFilter = new QFilter("batch_no", "in", batchNoList);
        QFilter handleStatusFilter = new QFilter("handle_status", "=", (Object)"3");
        Object[] logs = AsyncDeductSelectService.getSelectLogObjects(new QFilter[]{batchNoFilter, handleStatusFilter});
        if (!ObjectUtils.isEmpty((Object[])logs)) {
            for (Object log : logs) {
                this.querySelectResult((DynamicObject)log);
            }
        }
    }

    public abstract void querySelectResult(DynamicObject var1);

    protected void recoverMainInvoiceStatus(Map<String, String> serialNoStatusMap) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            LOGGER.info("\u6062\u590d\u52fe\u9009\u4e2d\u72b6\u6001:{}", serialNoStatusMap);
            DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
            operateService.updateMainInvoiceSelecting(serialNoStatusMap, "0");
        }
    }

    protected Map<String, DynamicObject> getSelectAccount(String batchNo) {
        return this.getSelectAccount(batchNo, "");
    }

    protected Map<String, DynamicObject> getSelectAccount(String batchNo, String billType) {
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)batchNo);
        DynamicObject[] selectAccounts = BusinessDataServiceHelper.load((String)"rim_select_account", (String)SELECT_ACCOUNT_FILEDS, (QFilter[])batchNoFilter.toArray());
        HashMap<String, DynamicObject> selectAccountMap = new HashMap<String, DynamicObject>(selectAccounts.length);
        for (DynamicObject selectAccount : selectAccounts) {
            String billNo = this.getBillNo(selectAccount.getString("invoice_code"), selectAccount.getString("invoice_no"), billType, selectAccount.getDate("invoice_date"));
            selectAccountMap.put(billNo, selectAccount);
        }
        return selectAccountMap;
    }

    protected String getBillNo(String invoiceCode, String invoiceNo) {
        return this.getBillNo(invoiceCode, invoiceNo, "", null);
    }

    protected String getBillNo(String invoiceCode, String invoiceNo, String billType, Date invoiceDate) {
        if ("2".equals(billType)) {
            return CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo) + DateUtils.format(invoiceDate);
        }
        return CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
    }

    protected DynamicObject getAccountByElectronicNo(Map<String, DynamicObject> selectAccountMap, String electronicNo) {
        if (ObjectUtils.isEmpty(selectAccountMap) || StringUtils.isEmpty((CharSequence)electronicNo)) {
            return null;
        }
        for (DynamicObject dynamicObject : selectAccountMap.values()) {
            if (!StringUtils.equals((CharSequence)electronicNo, (CharSequence)dynamicObject.getString("electronic_no"))) continue;
            return dynamicObject;
        }
        return null;
    }

    protected void save(DynamicObject selectLog, List<DynamicObject> updateAccountList, Map<String, String> serialNoStatusMap) {
        try (TXHandle h = TX.required();){
            try {
                this.recoverMainInvoiceStatus(serialNoStatusMap);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    public Map<String, String> getFailStatusMap(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description, String billType) {
        HashMap serialNoStatusMap;
        block3: {
            block2: {
                serialNoStatusMap = Maps.newHashMap();
                if (CollectionUtils.isEmpty((Collection)failArray)) break block2;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = this.getBillNo(fail.getString("invoiceCode"), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("select_result", (Object)fail.getString("selectResult"));
                    updateAccount.set("description", (Object)this.getSelectMsg(fail));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                    this.setFailInvoiceStatus(serialNoStatusMap, updateAccount);
                }
                break block3;
            }
            if (!updateAccountList.isEmpty()) break block3;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("select_result", (Object)"31");
                failAccount.set("description", (Object)description);
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
                this.setFailInvoiceStatus(serialNoStatusMap, failAccount);
            }
        }
        return serialNoStatusMap;
    }

    public void updateMainSaveLog(Map<String, String> serialNoStatusMap, DynamicObject selectLog, List<DynamicObject> updateAccountList) {
        try (TXHandle h = TX.required();){
            try {
                this.recoverMainInvoiceStatus(serialNoStatusMap);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    protected String getSelectMsg(JSONObject fail) {
        if (fail == null) {
            return "";
        }
        String msg = fail.getString("description");
        if (StringUtils.isEmpty((CharSequence)msg)) {
            msg = MetadataUtil.getComboItemName("rim_select_account", "select_result", fail.getString("selectResult"));
        }
        return msg;
    }

    public void queryRecordedCommitResult(DynamicObject selectLog) {
        LOGGER.info("\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u6682\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c");
    }

    public void setUpdateInvoiceData(JSONObject example, DynamicObject updateAccount, JSONObject successJson, String deductibleMode) {
    }

    public void updateInvoiceData(String taxNo, JSONArray updateInvoiceArray, String deductibleMode) {
        DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
        deductInvoiceOperateService.updateBatchSelectedInvoice(updateInvoiceArray, deductibleMode, taxNo);
    }

    public void setFailInvoiceStatus(Map<String, String> serialNoStatusMap, DynamicObject failAccount) {
        if (StringUtils.isNotEmpty((CharSequence)failAccount.getString("serial_no"))) {
            String preAuthenticateFlag = failAccount.getString("pre_authenticate_flag");
            if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag)) {
                preAuthenticateFlag = "1".equals(failAccount.getString("select_result")) ? "0" : "1";
            }
            serialNoStatusMap.put(failAccount.getString("serial_no"), preAuthenticateFlag);
        }
    }

    protected JSONObject doSelect(Long orgId, JSONObject param) {
        return null;
    }
}

